/*
 * Decompiled with CFR 0.152.
 */
package org.apache.royale.compiler.internal.targets;

import com.google.common.base.Strings;
import java.util.Map;
import org.apache.royale.compiler.internal.targets.TargetAttributeBase;
import org.apache.royale.compiler.tree.metadata.IMetaTagNode;

public class TargetAttributesMetadata
extends TargetAttributeBase {
    private final IMetaTagNode metaTagNode;

    public TargetAttributesMetadata(IMetaTagNode metaTagNode) {
        assert (metaTagNode != null) : "meta tag node can't be null";
        this.metaTagNode = metaTagNode;
    }

    @Override
    Float parseFloat(String key) {
        String value = this.metaTagNode.getAttributeValue(key);
        if (Strings.isNullOrEmpty((String)value)) {
            return null;
        }
        return Float.valueOf(Float.parseFloat(value));
    }

    @Override
    Integer parseInteger(String key) {
        String value = this.metaTagNode.getAttributeValue(key);
        if (Strings.isNullOrEmpty((String)value)) {
            return null;
        }
        return Integer.parseInt(value);
    }

    @Override
    Boolean parseBoolean(String key) {
        String value = this.metaTagNode.getAttributeValue(key);
        if (Strings.isNullOrEmpty((String)value)) {
            return null;
        }
        return Boolean.parseBoolean(value);
    }

    @Override
    String parseString(String key) {
        return this.metaTagNode.getAttributeValue(key);
    }

    @Override
    Double parsePercentage(String key) {
        String value = this.metaTagNode.getAttributeValue(key);
        if (value == null) {
            return null;
        }
        return super.parsePercentageValue(value);
    }

    @Override
    boolean isPercentage(String key) {
        String value = this.metaTagNode.getAttributeValue(key);
        if (value == null) {
            return false;
        }
        return super.isPercentageValue(value);
    }

    @Override
    public Map<String, String> getRootInfoAttributes() {
        throw new UnsupportedOperationException();
    }
}

