/*
 * Decompiled with CFR 0.152.
 */
package org.apache.royale.compiler.clients;

import com.google.common.collect.ImmutableList;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.apache.royale.compiler.clients.MXMLJSC;
import org.apache.royale.compiler.config.Configuration;
import org.apache.royale.compiler.config.ConfigurationValue;
import org.apache.royale.compiler.exceptions.ConfigurationException;
import org.apache.royale.compiler.internal.config.annotations.Arguments;
import org.apache.royale.compiler.internal.config.annotations.Config;
import org.apache.royale.compiler.internal.config.annotations.InfiniteArguments;
import org.apache.royale.compiler.internal.config.annotations.Mapping;
import org.apache.royale.compiler.internal.config.annotations.RoyaleOnly;
import org.apache.royale.compiler.internal.config.annotations.SoftPrerequisites;
import org.apache.royale.compiler.internal.mxml.MXMLNamespaceMapping;

public class JSConfiguration
extends Configuration {
    protected final List<String> targets = new ArrayList<String>();
    private boolean sourceMap = false;
    private String sourceMapSourceRoot = null;
    private boolean jsDefaultInitializers = true;
    private boolean jsDynamicAccessUnknownMembers = false;
    private final List<String> jsexternalLibraryPath = new ArrayList<String>();
    private final List<String> jslibraryPath = new ArrayList<String>();
    private Map<String, String> jsconfigVars;
    private String jsoutput;
    private String moduleoutput;
    private List<MXMLNamespaceMapping> jsmanifestMappings;
    private String jsVectorEmulationClass = null;
    private boolean jsComplexImplicitCoercions = true;
    private boolean jsResolveUncertain = true;
    private boolean jsVectorIndexChecks = true;
    private String jsxFactory = "React.createElement";

    public JSConfiguration() {
        this.setCompilerAllowAbstractClasses(null, true);
        this.setCompilerAllowPrivateConstructors(null, true);
        this.setCompilerAllowImportAliases(null, true);
        this.setCompilerStrictIdentifierNames(null, false);
    }

    public List<String> getCompilerTargets() {
        if (this.targets.size() == 0) {
            this.targets.add(MXMLJSC.JSTargetType.JS_ROYALE.getText());
        }
        return this.targets;
    }

    @Config(allowMultiple=true, isPath=false)
    @Mapping(value={"compiler", "targets"})
    @Arguments(value={"target"})
    @InfiniteArguments
    public void setCompilerTargets(ConfigurationValue cv, String[] targetlist) {
        this.targets.clear();
        for (String target : targetlist) {
            this.targets.add(target);
        }
    }

    @Config
    @Mapping(value={"js-output-type"})
    public void setJSOutputType(ConfigurationValue cv, String value) throws ConfigurationException {
        if (this.targets.size() > 0) {
            return;
        }
        this.targets.clear();
        this.targets.add(value);
    }

    public boolean getSourceMap() {
        return this.sourceMap;
    }

    @Config
    @Mapping(value={"source-map"})
    public void setSourceMap(ConfigurationValue cv, boolean value) throws ConfigurationException {
        this.sourceMap = value;
    }

    public String getSourceMapSourceRoot() {
        return this.sourceMapSourceRoot;
    }

    @Config
    @Mapping(value={"source-map-source-root"})
    public void setSourceMapSourceRoot(ConfigurationValue cv, String value) throws ConfigurationException {
        this.sourceMapSourceRoot = value;
    }

    public boolean getJsDefaultInitializers() {
        return this.jsDefaultInitializers;
    }

    @Config
    @Mapping(value={"js-default-initializers"})
    public void setJsDefaultInitializers(ConfigurationValue cv, boolean value) throws ConfigurationException {
        this.jsDefaultInitializers = value;
    }

    public boolean getJsDynamicAccessUnknownMembers() {
        return this.jsDynamicAccessUnknownMembers;
    }

    @Config
    @Mapping(value={"js-dynamic-access-unknown-members"})
    public void setJsDynamicAccessUnknownMembers(ConfigurationValue cv, boolean value) throws ConfigurationException {
        this.jsDynamicAccessUnknownMembers = value;
    }

    public List<String> getCompilerJsExternalLibraryPath() {
        return this.jsexternalLibraryPath;
    }

    @Config(allowMultiple=true, isPath=true)
    @Mapping(value={"compiler", "js-external-library-path"})
    @Arguments(value={"path-element"})
    @InfiniteArguments
    public void setCompilerJsExternalLibraryPath(ConfigurationValue cv, String[] pathlist) throws ConfigurationException {
        ImmutableList<String> pathElements = ImmutableList.copyOf(pathlist);
        ImmutableList resolvedPaths = this.expandTokens(pathElements, this.locales, cv, !this.reportMissingCompilerLibraries);
        this.jsexternalLibraryPath.addAll(resolvedPaths);
    }

    public List<String> getCompilerJsLibraryPath() {
        return this.jslibraryPath;
    }

    @Config(allowMultiple=true, isPath=true)
    @Mapping(value={"compiler", "js-library-path"})
    @Arguments(value={"path-element"})
    @InfiniteArguments
    @SoftPrerequisites(value={"locale", "target-player", "exclude-native-js-libraries"})
    public void setCompilerJsLibraryPath(ConfigurationValue cv, String[] pathlist) throws ConfigurationException.CannotOpen {
        ImmutableList resolvedPaths = this.expandTokens(Arrays.asList(pathlist), this.locales, cv, !this.reportMissingCompilerLibraries);
        this.jslibraryPath.addAll(resolvedPaths);
    }

    public Map<String, String> getJsCompilerDefine() {
        if (this.jsconfigVars != null) {
            return this.jsconfigVars;
        }
        return super.getCompilerDefine();
    }

    @Config(advanced=true, allowMultiple=true)
    @Arguments(value={"name", "value"})
    public void setJsCompilerDefine(ConfigurationValue cv, String name, String value) throws ConfigurationException {
        if (this.jsconfigVars == null) {
            this.jsconfigVars = new LinkedHashMap<String, String>();
        }
        this.jsconfigVars.put(name, value);
    }

    public String getOutput() {
        if (this.jsoutput != null) {
            return this.jsoutput;
        }
        return super.getOutput();
    }

    public String getJsOutput() {
        return this.jsoutput;
    }

    @Config
    @Arguments(value={"filename"})
    public void setJsOutput(ConfigurationValue val, String output) throws ConfigurationException {
        this.jsoutput = this.getOutputPath(val, output);
    }

    public String getJsLoadConfig() {
        return null;
    }

    public String getModuleOutput() {
        if (this.moduleoutput != null && this.moduleoutput.equals("/")) {
            return null;
        }
        return this.moduleoutput == null ? null : this.moduleoutput.replace("/", File.separator);
    }

    @Config
    @Arguments(value={"filename"})
    public void setModuleOutput(ConfigurationValue val, String output) throws ConfigurationException {
        this.moduleoutput = output;
    }

    @Config(allowMultiple=true)
    @Arguments(value={"filename"})
    public void setJsLoadConfig(ConfigurationValue cv, String filename) throws ConfigurationException {
    }

    public List<MXMLNamespaceMapping> getCompilerJsNamespacesManifestMappings() {
        return this.jsmanifestMappings;
    }

    @Config(allowMultiple=true)
    @Mapping(value={"compiler", "js-namespaces", "namespace"})
    @Arguments(value={"uri", "manifest"})
    @InfiniteArguments
    @RoyaleOnly
    public void setCompilerJsNamespacesNamespace(ConfigurationValue cfgval, List<String> args) throws ConfigurationException {
        if (args == null) {
            throw new ConfigurationException.CannotOpen(null, cfgval.getVar(), cfgval.getSource(), cfgval.getLine());
        }
        if (args.isEmpty()) {
            return;
        }
        if (args.size() < 2) {
            throw new ConfigurationException.NamespaceMissingManifest("namespace", cfgval.getSource(), cfgval.getLine());
        }
        if (args.size() % 2 != 0) {
            throw new ConfigurationException.IncorrectArgumentCount(args.size() + 1, args.size(), cfgval.getVar(), cfgval.getSource(), cfgval.getLine());
        }
        if (this.jsmanifestMappings == null) {
            this.jsmanifestMappings = new ArrayList<MXMLNamespaceMapping>();
        }
        for (int i = 0; i < args.size() - 1; i += 2) {
            String uri = args.get(i);
            String manifestFile = args.get(i + 1);
            String path = this.resolvePathStrict(manifestFile, cfgval);
            this.jsmanifestMappings.add(new MXMLNamespaceMapping(uri, path));
        }
    }

    public String getJsVectorEmulationClass() {
        return this.jsVectorEmulationClass;
    }

    @Config(advanced=true)
    public void setJsVectorEmulationClass(ConfigurationValue cv, String b) {
        this.jsVectorEmulationClass = b;
    }

    public boolean getJsComplexImplicitCoercions() {
        return this.jsComplexImplicitCoercions;
    }

    @Config(advanced=true)
    @Mapping(value={"js-complex-implicit-coercions"})
    public void setJsComplexImplicitCoercions(ConfigurationValue cv, boolean value) throws ConfigurationException {
        this.jsComplexImplicitCoercions = value;
    }

    public boolean getJsResolveUncertain() {
        return this.jsResolveUncertain;
    }

    @Config(advanced=true)
    @Mapping(value={"js-resolve-uncertain"})
    public void setJsResolveUncertain(ConfigurationValue cv, boolean value) throws ConfigurationException {
        this.jsResolveUncertain = value;
    }

    public boolean getJsVectorIndexChecks() {
        return this.jsVectorIndexChecks;
    }

    @Config(advanced=true)
    @Mapping(value={"js-vector-index-checks"})
    public void setJsVectorIndexChecks(ConfigurationValue cv, boolean value) throws ConfigurationException {
        this.jsVectorIndexChecks = value;
    }

    public String getJsxFactory() {
        return this.jsxFactory;
    }

    @Config(advanced=true)
    @Mapping(value={"jsx-factory"})
    public void setJsxFactory(ConfigurationValue cv, String value) throws ConfigurationException {
        this.jsxFactory = value;
    }
}

