/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.sofa.jraft.storage.snapshot.local;

import com.alipay.sofa.jraft.error.RaftError;
import com.alipay.sofa.jraft.option.RaftOptions;
import com.alipay.sofa.jraft.option.SnapshotCopierOptions;
import com.alipay.sofa.jraft.storage.SnapshotStorage;
import com.alipay.sofa.jraft.storage.SnapshotThrottle;
import com.alipay.sofa.jraft.storage.snapshot.SnapshotCopier;
import com.alipay.sofa.jraft.storage.snapshot.SnapshotReader;
import com.alipay.sofa.jraft.storage.snapshot.SnapshotWriter;
import com.alipay.sofa.jraft.storage.snapshot.local.LocalSnapshotCopier;
import com.alipay.sofa.jraft.storage.snapshot.local.LocalSnapshotReader;
import com.alipay.sofa.jraft.storage.snapshot.local.LocalSnapshotWriter;
import com.alipay.sofa.jraft.util.Endpoint;
import com.alipay.sofa.jraft.util.Requires;
import com.alipay.sofa.jraft.util.Utils;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.apache.commons.io.FileUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LocalSnapshotStorage
implements SnapshotStorage {
    private static final Logger LOG = LoggerFactory.getLogger(LocalSnapshotStorage.class);
    private static final String TEMP_PATH = "temp";
    private final ConcurrentMap<Long, AtomicInteger> refMap = new ConcurrentHashMap<Long, AtomicInteger>();
    private final String path;
    private Endpoint addr;
    private boolean filterBeforeCopyRemote;
    private long lastSnapshotIndex;
    private final Lock lock;
    private final RaftOptions raftOptions;
    private SnapshotThrottle snapshotThrottle;

    @Override
    public void setSnapshotThrottle(SnapshotThrottle snapshotThrottle) {
        this.snapshotThrottle = snapshotThrottle;
    }

    public boolean hasServerAddr() {
        return this.addr != null;
    }

    public void setServerAddr(Endpoint addr) {
        this.addr = addr;
    }

    public LocalSnapshotStorage(String path, RaftOptions raftOptions) {
        this.path = path;
        this.lastSnapshotIndex = 0L;
        this.raftOptions = raftOptions;
        this.lock = new ReentrantLock();
    }

    public long getLastSnapshotIndex() {
        this.lock.lock();
        try {
            long l = this.lastSnapshotIndex;
            return l;
        }
        finally {
            this.lock.unlock();
        }
    }

    @Override
    public boolean init(Void v) {
        String tempSnapshotPath;
        File tempFile;
        File dir = new File(this.path);
        try {
            FileUtils.forceMkdir((File)dir);
        }
        catch (IOException e) {
            LOG.error("Fail to create directory {}.", (Object)this.path, (Object)e);
            return false;
        }
        if (!this.filterBeforeCopyRemote && (tempFile = new File(tempSnapshotPath = this.path + File.separator + TEMP_PATH)).exists()) {
            try {
                FileUtils.forceDelete((File)tempFile);
            }
            catch (IOException e) {
                LOG.error("Fail to delete temp snapshot path {}.", (Object)tempSnapshotPath, (Object)e);
                return false;
            }
        }
        ArrayList<Long> snapshots = new ArrayList<Long>();
        File[] oldFiles = dir.listFiles();
        if (oldFiles != null) {
            for (File sFile : oldFiles) {
                String name = sFile.getName();
                if (!name.startsWith("snapshot_")) continue;
                long index = Long.parseLong(name.substring("snapshot_".length()));
                snapshots.add(index);
            }
        }
        if (!snapshots.isEmpty()) {
            Collections.sort(snapshots);
            int snapshotCount = snapshots.size();
            for (int i = 0; i < snapshotCount - 1; ++i) {
                long index = (Long)snapshots.get(i);
                String snapshotPath = this.getSnapshotPath(index);
                if (this.destroySnapshot(snapshotPath)) continue;
                return false;
            }
            this.lastSnapshotIndex = (Long)snapshots.get(snapshotCount - 1);
            this.ref(this.lastSnapshotIndex);
        }
        return true;
    }

    private String getSnapshotPath(long index) {
        return this.path + File.separator + "snapshot_" + index;
    }

    void ref(long index) {
        AtomicInteger refs = this.getRefs(index);
        refs.incrementAndGet();
    }

    private boolean destroySnapshot(String path) {
        LOG.info("Deleting snapshot {}.", (Object)path);
        File file = new File(path);
        try {
            FileUtils.deleteDirectory((File)file);
            return true;
        }
        catch (IOException e) {
            LOG.error("Fail to destroy snapshot {}.", (Object)path, (Object)e);
            return false;
        }
    }

    void unref(long index) {
        AtomicInteger refs = this.getRefs(index);
        if (refs.decrementAndGet() == 0 && this.refMap.remove(index, refs)) {
            this.destroySnapshot(this.getSnapshotPath(index));
        }
    }

    AtomicInteger getRefs(long index) {
        AtomicInteger refs = (AtomicInteger)this.refMap.get(index);
        if (refs == null) {
            refs = new AtomicInteger(0);
            AtomicInteger eRefs = this.refMap.putIfAbsent(index, refs);
            if (eRefs != null) {
                refs = eRefs;
            }
        }
        return refs;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void close(LocalSnapshotWriter writer, boolean keepDataOnError) throws IOException {
        IOException ioe;
        int ret;
        block18: {
            ret = writer.getCode();
            ioe = null;
            if (ret == 0) {
                long newIndex;
                block16: {
                    try {
                        if (!writer.sync()) {
                            ret = RaftError.EIO.getNumber();
                        }
                        break block16;
                    }
                    catch (IOException e) {
                        LOG.error("Fail to sync writer {}.", (Object)writer.getPath(), (Object)e);
                        ret = RaftError.EIO.getNumber();
                        ioe = e;
                    }
                    break block18;
                }
                long oldIndex = this.getLastSnapshotIndex();
                if (oldIndex == (newIndex = writer.getSnapshotIndex())) {
                    ret = RaftError.EEXISTS.getNumber();
                } else {
                    String tempPath = this.path + File.separator + TEMP_PATH;
                    String newPath = this.getSnapshotPath(newIndex);
                    if (!this.destroySnapshot(newPath)) {
                        LOG.warn("Delete new snapshot path failed, path is {}.", (Object)newPath);
                        ret = RaftError.EIO.getNumber();
                        ioe = new IOException("Fail to delete new snapshot path: " + newPath);
                    } else {
                        LOG.info("Renaming {} to {}.", (Object)tempPath, (Object)newPath);
                        if (!Utils.atomicMoveFile(new File(tempPath), new File(newPath), true)) {
                            LOG.error("Renamed temp snapshot failed, from path {} to path {}.", (Object)tempPath, (Object)newPath);
                            ret = RaftError.EIO.getNumber();
                            ioe = new IOException("Fail to rename temp snapshot from: " + tempPath + " to: " + newPath);
                        } else {
                            this.ref(newIndex);
                            this.lock.lock();
                            try {
                                Requires.requireTrue(oldIndex == this.lastSnapshotIndex);
                                this.lastSnapshotIndex = newIndex;
                            }
                            finally {
                                this.lock.unlock();
                            }
                            this.unref(oldIndex);
                        }
                    }
                }
            }
        }
        if (ret != 0) {
            LOG.warn("Close snapshot writer {} with exit code: {}.", (Object)writer.getPath(), (Object)ret);
            if (!keepDataOnError) {
                this.destroySnapshot(writer.getPath());
            }
        }
        if (ioe != null) {
            throw ioe;
        }
    }

    @Override
    public void shutdown() {
    }

    @Override
    public boolean setFilterBeforeCopyRemote() {
        this.filterBeforeCopyRemote = true;
        return true;
    }

    @Override
    public SnapshotWriter create() {
        return this.create(true);
    }

    public SnapshotWriter create(boolean fromEmpty) {
        LocalSnapshotWriter writer;
        block0: {
            writer = null;
            String snapshotPath = this.path + File.separator + TEMP_PATH;
            if (new File(snapshotPath).exists() && fromEmpty && !this.destroySnapshot(snapshotPath) || (writer = new LocalSnapshotWriter(snapshotPath, this, this.raftOptions)).init(null)) break block0;
            LOG.error("Fail to init snapshot writer.");
            writer = null;
        }
        return writer;
    }

    @Override
    public SnapshotReader open() {
        long lsIndex = 0L;
        this.lock.lock();
        try {
            if (this.lastSnapshotIndex != 0L) {
                lsIndex = this.lastSnapshotIndex;
                this.ref(lsIndex);
            }
        }
        finally {
            this.lock.unlock();
        }
        if (lsIndex == 0L) {
            LOG.warn("No data for snapshot reader {}.", (Object)this.path);
            return null;
        }
        String snapshotPath = this.getSnapshotPath(lsIndex);
        LocalSnapshotReader reader = new LocalSnapshotReader(this, this.snapshotThrottle, this.addr, this.raftOptions, snapshotPath);
        if (!reader.init(null)) {
            LOG.error("Fail to init reader for path {}.", (Object)snapshotPath);
            this.unref(lsIndex);
            return null;
        }
        return reader;
    }

    @Override
    public SnapshotReader copyFrom(String uri, SnapshotCopierOptions opts) {
        SnapshotCopier copier = this.startToCopyFrom(uri, opts);
        if (copier == null) {
            return null;
        }
        try {
            copier.join();
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            LOG.error("Join on snapshot copier was interrupted.");
            return null;
        }
        SnapshotReader reader = copier.getReader();
        Utils.closeQuietly(copier);
        return reader;
    }

    @Override
    public SnapshotCopier startToCopyFrom(String uri, SnapshotCopierOptions opts) {
        LocalSnapshotCopier copier = new LocalSnapshotCopier();
        copier.setStorage(this);
        copier.setSnapshotThrottle(this.snapshotThrottle);
        copier.setFilterBeforeCopyRemote(this.filterBeforeCopyRemote);
        if (!copier.init(uri, opts)) {
            LOG.error("Fail to init copier to {}.", (Object)uri);
            return null;
        }
        copier.start();
        return copier;
    }
}

