/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.sofa.jraft.rhea.util.concurrent;

import com.alipay.sofa.jraft.rhea.util.concurrent.AbstractRejectedExecutionHandler;
import com.alipay.sofa.jraft.rhea.util.concurrent.RejectedRunnable;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.ThreadPoolExecutor;

public class RejectedTaskPolicyWithReport
extends AbstractRejectedExecutionHandler {
    public RejectedTaskPolicyWithReport(String threadPoolName) {
        super(threadPoolName, false, "");
    }

    public RejectedTaskPolicyWithReport(String threadPoolName, String dumpPrefixName) {
        super(threadPoolName, true, dumpPrefixName);
    }

    @Override
    public void rejectedExecution(Runnable r, ThreadPoolExecutor e) {
        LOG.error("Thread pool [{}] is exhausted! {}.", (Object)this.threadPoolName, (Object)e.toString());
        this.dumpJvmInfoIfNeeded();
        if (r instanceof RejectedRunnable) {
            ((RejectedRunnable)r).rejected();
        } else if (!e.isShutdown()) {
            BlockingQueue<Runnable> queue = e.getQueue();
            int discardSize = queue.size() >> 1;
            for (int i = 0; i < discardSize; ++i) {
                queue.poll();
            }
            try {
                queue.put(r);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
    }
}

