/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.sofa.jraft.rhea.serialization.impl.protostuff.io;

import com.alipay.sofa.jraft.rhea.serialization.impl.protostuff.io.ProtocolException;
import com.alipay.sofa.jraft.rhea.serialization.io.OutputBuf;
import com.alipay.sofa.jraft.rhea.util.VarInts;
import com.alipay.sofa.jraft.util.BufferUtils;
import com.alipay.sofa.jraft.util.internal.ReferenceFieldUpdater;
import com.alipay.sofa.jraft.util.internal.UnsafeUtf8Util;
import com.alipay.sofa.jraft.util.internal.Updaters;
import io.protostuff.ByteString;
import io.protostuff.IntSerializer;
import io.protostuff.Output;
import io.protostuff.ProtobufOutput;
import io.protostuff.Schema;
import io.protostuff.WireFormat;
import java.io.IOException;
import java.nio.Buffer;
import java.nio.ByteBuffer;

class NioBufOutput
implements Output {
    private static final ReferenceFieldUpdater<ByteString, byte[]> byteStringBytesGetter = Updaters.newReferenceFieldUpdater(ByteString.class, (String)"bytes");
    protected final OutputBuf outputBuf;
    protected final int maxCapacity;
    protected ByteBuffer nioBuffer;
    protected int capacity;

    NioBufOutput(OutputBuf outputBuf, int minWritableBytes, int maxCapacity) {
        this.outputBuf = outputBuf;
        this.maxCapacity = maxCapacity;
        this.nioBuffer = outputBuf.nioByteBuffer(minWritableBytes);
        this.capacity = this.nioBuffer.remaining();
    }

    public void writeInt32(int fieldNumber, int value, boolean repeated) throws IOException {
        if (value < 0) {
            this.writeVarInt32(WireFormat.makeTag((int)fieldNumber, (int)0));
            this.writeVarInt64(value);
        } else {
            this.writeVarInt32(WireFormat.makeTag((int)fieldNumber, (int)0));
            this.writeVarInt32(value);
        }
    }

    public void writeUInt32(int fieldNumber, int value, boolean repeated) throws IOException {
        this.writeVarInt32(WireFormat.makeTag((int)fieldNumber, (int)0));
        this.writeVarInt32(value);
    }

    public void writeSInt32(int fieldNumber, int value, boolean repeated) throws IOException {
        this.writeVarInt32(WireFormat.makeTag((int)fieldNumber, (int)0));
        this.writeVarInt32(ProtobufOutput.encodeZigZag32((int)value));
    }

    public void writeFixed32(int fieldNumber, int value, boolean repeated) throws IOException {
        this.writeVarInt32(WireFormat.makeTag((int)fieldNumber, (int)5));
        this.writeInt32LE(value);
    }

    public void writeSFixed32(int fieldNumber, int value, boolean repeated) throws IOException {
        this.writeVarInt32(WireFormat.makeTag((int)fieldNumber, (int)5));
        this.writeInt32LE(value);
    }

    public void writeInt64(int fieldNumber, long value, boolean repeated) throws IOException {
        this.writeVarInt32(WireFormat.makeTag((int)fieldNumber, (int)0));
        this.writeVarInt64(value);
    }

    public void writeUInt64(int fieldNumber, long value, boolean repeated) throws IOException {
        this.writeVarInt32(WireFormat.makeTag((int)fieldNumber, (int)0));
        this.writeVarInt64(value);
    }

    public void writeSInt64(int fieldNumber, long value, boolean repeated) throws IOException {
        this.writeVarInt32(WireFormat.makeTag((int)fieldNumber, (int)0));
        this.writeVarInt64(ProtobufOutput.encodeZigZag64((long)value));
    }

    public void writeFixed64(int fieldNumber, long value, boolean repeated) throws IOException {
        this.writeVarInt32(WireFormat.makeTag((int)fieldNumber, (int)1));
        this.writeInt64LE(value);
    }

    public void writeSFixed64(int fieldNumber, long value, boolean repeated) throws IOException {
        this.writeVarInt32(WireFormat.makeTag((int)fieldNumber, (int)1));
        this.writeInt64LE(value);
    }

    public void writeFloat(int fieldNumber, float value, boolean repeated) throws IOException {
        this.writeVarInt32(WireFormat.makeTag((int)fieldNumber, (int)5));
        this.writeInt32LE(Float.floatToRawIntBits(value));
    }

    public void writeDouble(int fieldNumber, double value, boolean repeated) throws IOException {
        this.writeVarInt32(WireFormat.makeTag((int)fieldNumber, (int)1));
        this.writeInt64LE(Double.doubleToRawLongBits(value));
    }

    public void writeBool(int fieldNumber, boolean value, boolean repeated) throws IOException {
        this.writeVarInt32(WireFormat.makeTag((int)fieldNumber, (int)0));
        this.writeByte(value ? (byte)1 : 0);
    }

    public void writeEnum(int fieldNumber, int value, boolean repeated) throws IOException {
        this.writeInt32(fieldNumber, value, repeated);
    }

    public void writeString(int fieldNumber, CharSequence value, boolean repeated) throws IOException {
        this.writeVarInt32(WireFormat.makeTag((int)fieldNumber, (int)2));
        int minLength = value.length();
        int maxLength = minLength * 3;
        int minLengthVarIntSize = VarInts.computeRawVarInt32Size(minLength);
        int maxLengthVarIntSize = VarInts.computeRawVarInt32Size(maxLength);
        if (minLengthVarIntSize == maxLengthVarIntSize) {
            int length;
            int position = this.nioBuffer.position();
            this.ensureCapacity(maxLengthVarIntSize + maxLength);
            int stringStartPos = position + maxLengthVarIntSize;
            BufferUtils.position((Buffer)this.nioBuffer, (int)stringStartPos);
            if (this.nioBuffer.isDirect()) {
                UnsafeUtf8Util.encodeUtf8Direct((CharSequence)value, (ByteBuffer)this.nioBuffer);
                length = this.nioBuffer.position() - stringStartPos;
            } else {
                int offset = this.nioBuffer.arrayOffset() + stringStartPos;
                int outIndex = UnsafeUtf8Util.encodeUtf8((CharSequence)value, (byte[])this.nioBuffer.array(), (int)offset, (int)this.nioBuffer.remaining());
                length = outIndex - offset;
            }
            BufferUtils.position((Buffer)this.nioBuffer, (int)position);
            this.writeVarInt32(length);
            BufferUtils.position((Buffer)this.nioBuffer, (int)(stringStartPos + length));
        } else {
            int length = UnsafeUtf8Util.encodedLength((CharSequence)value);
            this.writeVarInt32(length);
            this.ensureCapacity(length);
            if (this.nioBuffer.isDirect()) {
                UnsafeUtf8Util.encodeUtf8Direct((CharSequence)value, (ByteBuffer)this.nioBuffer);
            } else {
                int pos = this.nioBuffer.position();
                UnsafeUtf8Util.encodeUtf8((CharSequence)value, (byte[])this.nioBuffer.array(), (int)(this.nioBuffer.arrayOffset() + pos), (int)this.nioBuffer.remaining());
                BufferUtils.position((Buffer)this.nioBuffer, (int)(pos + length));
            }
        }
    }

    public void writeBytes(int fieldNumber, ByteString value, boolean repeated) throws IOException {
        this.writeByteArray(fieldNumber, (byte[])byteStringBytesGetter.get((Object)value), repeated);
    }

    public void writeByteArray(int fieldNumber, byte[] value, boolean repeated) throws IOException {
        this.writeByteRange(false, fieldNumber, value, 0, value.length, repeated);
    }

    public void writeByteRange(boolean utf8String, int fieldNumber, byte[] value, int offset, int length, boolean repeated) throws IOException {
        this.writeVarInt32(WireFormat.makeTag((int)fieldNumber, (int)2));
        this.writeVarInt32(length);
        this.writeByteArray(value, offset, length);
    }

    public <T> void writeObject(int fieldNumber, T value, Schema<T> schema, boolean repeated) throws IOException {
        this.writeVarInt32(WireFormat.makeTag((int)fieldNumber, (int)3));
        schema.writeTo((Output)this, value);
        this.writeVarInt32(WireFormat.makeTag((int)fieldNumber, (int)4));
    }

    public void writeBytes(int fieldNumber, ByteBuffer value, boolean repeated) throws IOException {
        this.writeByteRange(false, fieldNumber, value.array(), value.arrayOffset() + value.position(), value.remaining(), repeated);
    }

    protected void writeVarInt32(int value) throws IOException {
        this.ensureCapacity(5);
        while (true) {
            if ((value & 0xFFFFFF80) == 0) {
                this.nioBuffer.put((byte)value);
                return;
            }
            this.nioBuffer.put((byte)(value & 0x7F | 0x80));
            value >>>= 7;
        }
    }

    protected void writeVarInt64(long value) throws IOException {
        this.ensureCapacity(10);
        while (true) {
            if ((value & 0xFFFFFFFFFFFFFF80L) == 0L) {
                this.nioBuffer.put((byte)value);
                return;
            }
            this.nioBuffer.put((byte)((int)value & 0x7F | 0x80));
            value >>>= 7;
        }
    }

    protected void writeInt32LE(int value) throws IOException {
        this.ensureCapacity(4);
        IntSerializer.writeInt32LE((int)value, (ByteBuffer)this.nioBuffer);
    }

    protected void writeInt64LE(long value) throws IOException {
        this.ensureCapacity(8);
        IntSerializer.writeInt64LE((long)value, (ByteBuffer)this.nioBuffer);
    }

    protected void writeByte(byte value) throws IOException {
        this.ensureCapacity(1);
        this.nioBuffer.put(value);
    }

    protected void writeByteArray(byte[] value, int offset, int length) throws IOException {
        this.ensureCapacity(length);
        this.nioBuffer.put(value, offset, length);
    }

    protected void ensureCapacity(int required) throws ProtocolException {
        if (this.nioBuffer.remaining() < required) {
            int position = this.nioBuffer.position();
            while (this.capacity - position < required) {
                if (this.capacity == this.maxCapacity) {
                    throw new ProtocolException("Buffer overflow. Available: " + (this.capacity - position) + ", required: " + required);
                }
                this.capacity = Math.min(this.capacity << 1, this.maxCapacity);
                if (this.capacity >= 0) continue;
                this.capacity = this.maxCapacity;
            }
            this.nioBuffer = this.outputBuf.nioByteBuffer(this.capacity - position);
            this.capacity = this.nioBuffer.limit();
        }
    }
}

