/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.sofa.jraft.rhea.client.pd;

import com.alipay.sofa.jraft.rhea.client.pd.AbstractPlacementDriverClient;
import com.alipay.sofa.jraft.rhea.metadata.Region;
import com.alipay.sofa.jraft.rhea.metadata.Store;
import com.alipay.sofa.jraft.rhea.options.PlacementDriverOptions;
import com.alipay.sofa.jraft.rhea.options.RegionEngineOptions;
import com.alipay.sofa.jraft.rhea.options.StoreEngineOptions;
import com.alipay.sofa.jraft.rhea.util.Lists;
import com.alipay.sofa.jraft.util.Endpoint;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FakePlacementDriverClient
extends AbstractPlacementDriverClient {
    private static final Logger LOG = LoggerFactory.getLogger(FakePlacementDriverClient.class);
    private boolean started;

    public FakePlacementDriverClient(long clusterId, String clusterName) {
        super(clusterId, clusterName);
    }

    @Override
    public synchronized boolean init(PlacementDriverOptions opts) {
        if (this.started) {
            LOG.info("[FakePlacementDriverClient] already started.");
            return true;
        }
        super.init(opts);
        LOG.info("[FakePlacementDriverClient] start successfully, options: {}.", (Object)opts);
        this.started = true;
        return true;
    }

    @Override
    public synchronized void shutdown() {
        super.shutdown();
        LOG.info("[FakePlacementDriverClient] shutdown successfully.");
    }

    @Override
    protected void refreshRouteTable() {
    }

    @Override
    public Store getStoreMetadata(StoreEngineOptions opts) {
        Store store = new Store();
        List<RegionEngineOptions> rOptsList = opts.getRegionEngineOptionsList();
        ArrayList<Region> regionList = Lists.newArrayListWithCapacity(rOptsList.size());
        store.setId(-1L);
        store.setEndpoint(opts.getServerAddress());
        for (RegionEngineOptions rOpts : rOptsList) {
            regionList.add(this.getLocalRegionMetadata(rOpts));
        }
        store.setRegions(regionList);
        return store;
    }

    @Override
    public Endpoint getPdLeader(boolean forceRefresh, long timeoutMillis) {
        throw new UnsupportedOperationException();
    }
}

