/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.sofa.jraft.rhea.client;

import com.alipay.sofa.jraft.RouteTable;
import com.alipay.sofa.jraft.Status;
import com.alipay.sofa.jraft.entity.PeerId;
import com.alipay.sofa.jraft.rhea.DescriberManager;
import com.alipay.sofa.jraft.rhea.FollowerStateListener;
import com.alipay.sofa.jraft.rhea.JRaftHelper;
import com.alipay.sofa.jraft.rhea.LeaderStateListener;
import com.alipay.sofa.jraft.rhea.RegionEngine;
import com.alipay.sofa.jraft.rhea.StateListener;
import com.alipay.sofa.jraft.rhea.StateListenerContainer;
import com.alipay.sofa.jraft.rhea.StoreEngine;
import com.alipay.sofa.jraft.rhea.client.DefaultDistributedLock;
import com.alipay.sofa.jraft.rhea.client.DefaultRheaIterator;
import com.alipay.sofa.jraft.rhea.client.DefaultRheaKVRpcService;
import com.alipay.sofa.jraft.rhea.client.FutureGroup;
import com.alipay.sofa.jraft.rhea.client.FutureHelper;
import com.alipay.sofa.jraft.rhea.client.RheaIterator;
import com.alipay.sofa.jraft.rhea.client.RheaKVRpcService;
import com.alipay.sofa.jraft.rhea.client.RheaKVStore;
import com.alipay.sofa.jraft.rhea.client.failover.ListRetryCallable;
import com.alipay.sofa.jraft.rhea.client.failover.RetryCallable;
import com.alipay.sofa.jraft.rhea.client.failover.RetryRunner;
import com.alipay.sofa.jraft.rhea.client.failover.impl.BoolFailoverFuture;
import com.alipay.sofa.jraft.rhea.client.failover.impl.FailoverClosureImpl;
import com.alipay.sofa.jraft.rhea.client.failover.impl.ListFailoverFuture;
import com.alipay.sofa.jraft.rhea.client.failover.impl.MapFailoverFuture;
import com.alipay.sofa.jraft.rhea.client.pd.FakePlacementDriverClient;
import com.alipay.sofa.jraft.rhea.client.pd.PlacementDriverClient;
import com.alipay.sofa.jraft.rhea.client.pd.RemotePlacementDriverClient;
import com.alipay.sofa.jraft.rhea.cmd.store.BatchDeleteRequest;
import com.alipay.sofa.jraft.rhea.cmd.store.BatchPutRequest;
import com.alipay.sofa.jraft.rhea.cmd.store.CASAllRequest;
import com.alipay.sofa.jraft.rhea.cmd.store.CompareAndPutRequest;
import com.alipay.sofa.jraft.rhea.cmd.store.ContainsKeyRequest;
import com.alipay.sofa.jraft.rhea.cmd.store.DeleteRangeRequest;
import com.alipay.sofa.jraft.rhea.cmd.store.DeleteRequest;
import com.alipay.sofa.jraft.rhea.cmd.store.GetAndPutRequest;
import com.alipay.sofa.jraft.rhea.cmd.store.GetRequest;
import com.alipay.sofa.jraft.rhea.cmd.store.GetSequenceRequest;
import com.alipay.sofa.jraft.rhea.cmd.store.KeyLockRequest;
import com.alipay.sofa.jraft.rhea.cmd.store.KeyUnlockRequest;
import com.alipay.sofa.jraft.rhea.cmd.store.MergeRequest;
import com.alipay.sofa.jraft.rhea.cmd.store.MultiGetRequest;
import com.alipay.sofa.jraft.rhea.cmd.store.NodeExecuteRequest;
import com.alipay.sofa.jraft.rhea.cmd.store.PutIfAbsentRequest;
import com.alipay.sofa.jraft.rhea.cmd.store.PutRequest;
import com.alipay.sofa.jraft.rhea.cmd.store.ResetSequenceRequest;
import com.alipay.sofa.jraft.rhea.cmd.store.ScanRequest;
import com.alipay.sofa.jraft.rhea.errors.ApiExceptionHelper;
import com.alipay.sofa.jraft.rhea.errors.Errors;
import com.alipay.sofa.jraft.rhea.errors.ErrorsHelper;
import com.alipay.sofa.jraft.rhea.errors.RheaRuntimeException;
import com.alipay.sofa.jraft.rhea.metadata.Region;
import com.alipay.sofa.jraft.rhea.metrics.KVMetrics;
import com.alipay.sofa.jraft.rhea.options.BatchingOptions;
import com.alipay.sofa.jraft.rhea.options.PlacementDriverOptions;
import com.alipay.sofa.jraft.rhea.options.RheaKVStoreOptions;
import com.alipay.sofa.jraft.rhea.options.RpcOptions;
import com.alipay.sofa.jraft.rhea.options.StoreEngineOptions;
import com.alipay.sofa.jraft.rhea.rpc.ExtSerializerSupports;
import com.alipay.sofa.jraft.rhea.storage.CASEntry;
import com.alipay.sofa.jraft.rhea.storage.KVEntry;
import com.alipay.sofa.jraft.rhea.storage.KVIterator;
import com.alipay.sofa.jraft.rhea.storage.KVStoreClosure;
import com.alipay.sofa.jraft.rhea.storage.NodeExecutor;
import com.alipay.sofa.jraft.rhea.storage.RawKVStore;
import com.alipay.sofa.jraft.rhea.storage.Sequence;
import com.alipay.sofa.jraft.rhea.storage.zip.ZipStrategyManager;
import com.alipay.sofa.jraft.rhea.util.ByteArray;
import com.alipay.sofa.jraft.rhea.util.Constants;
import com.alipay.sofa.jraft.rhea.util.Lists;
import com.alipay.sofa.jraft.rhea.util.StackTraceUtil;
import com.alipay.sofa.jraft.rhea.util.Strings;
import com.alipay.sofa.jraft.rhea.util.concurrent.AffinityNamedThreadFactory;
import com.alipay.sofa.jraft.rhea.util.concurrent.DistributedLock;
import com.alipay.sofa.jraft.rhea.util.concurrent.NamedThreadFactory;
import com.alipay.sofa.jraft.rhea.util.concurrent.disruptor.Dispatcher;
import com.alipay.sofa.jraft.rhea.util.concurrent.disruptor.TaskDispatcher;
import com.alipay.sofa.jraft.rhea.util.concurrent.disruptor.WaitStrategyType;
import com.alipay.sofa.jraft.util.BytesUtil;
import com.alipay.sofa.jraft.util.Describer;
import com.alipay.sofa.jraft.util.Endpoint;
import com.alipay.sofa.jraft.util.LogExceptionHandler;
import com.alipay.sofa.jraft.util.Requires;
import com.alipay.sofa.jraft.util.Utils;
import com.codahale.metrics.Histogram;
import com.lmax.disruptor.EventFactory;
import com.lmax.disruptor.EventHandler;
import com.lmax.disruptor.ExceptionHandler;
import com.lmax.disruptor.RingBuffer;
import com.lmax.disruptor.dsl.Disruptor;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import net.openhft.affinity.AffinityStrategy;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultRheaKVStore
implements RheaKVStore {
    private static final Logger LOG = LoggerFactory.getLogger(DefaultRheaKVStore.class);
    private final StateListenerContainer<Long> stateListenerContainer = new StateListenerContainer();
    private StoreEngine storeEngine;
    private PlacementDriverClient pdClient;
    private RheaKVRpcService rheaKVRpcService;
    private RheaKVStoreOptions opts;
    private int failoverRetries;
    private long futureTimeoutMillis;
    private boolean onlyLeaderRead;
    private Dispatcher kvDispatcher;
    private BatchingOptions batchingOpts;
    private GetBatching getBatching;
    private GetBatching getBatchingOnlySafe;
    private PutBatching putBatching;
    private volatile boolean started;

    public synchronized boolean init(RheaKVStoreOptions opts) {
        if (this.started) {
            LOG.info("[DefaultRheaKVStore] already started.");
            return true;
        }
        DescriberManager.getInstance().addDescriber((Describer)RouteTable.getInstance());
        this.opts = opts;
        PlacementDriverOptions pdOpts = opts.getPlacementDriverOptions();
        String clusterName = opts.getClusterName();
        Requires.requireNonNull((Object)pdOpts, (String)"opts.placementDriverOptions");
        Requires.requireNonNull((Object)clusterName, (String)"opts.clusterName");
        if (Strings.isBlank(pdOpts.getInitialServerList())) {
            pdOpts.setInitialServerList(opts.getInitialServerList());
        }
        this.pdClient = pdOpts.isFake() ? new FakePlacementDriverClient(opts.getClusterId(), clusterName) : new RemotePlacementDriverClient(opts.getClusterId(), clusterName);
        if (!this.pdClient.init(pdOpts)) {
            LOG.error("Fail to init [PlacementDriverClient].");
            return false;
        }
        ZipStrategyManager.init(opts);
        StoreEngineOptions stOpts = opts.getStoreEngineOptions();
        if (stOpts != null) {
            stOpts.setInitialServerList(opts.getInitialServerList());
            this.storeEngine = new StoreEngine(this.pdClient, this.stateListenerContainer);
            if (!this.storeEngine.init(stOpts)) {
                LOG.error("Fail to init [StoreEngine].");
                return false;
            }
        }
        Endpoint selfEndpoint = this.storeEngine == null ? null : this.storeEngine.getSelfEndpoint();
        RpcOptions rpcOpts = opts.getRpcOptions();
        Requires.requireNonNull((Object)rpcOpts, (String)"opts.rpcOptions");
        this.rheaKVRpcService = new DefaultRheaKVRpcService(this.pdClient, selfEndpoint){

            @Override
            public Endpoint getLeader(long regionId, boolean forceRefresh, long timeoutMillis) {
                Endpoint leader = DefaultRheaKVStore.this.getLeaderByRegionEngine(regionId);
                if (leader != null) {
                    return leader;
                }
                return super.getLeader(regionId, forceRefresh, timeoutMillis);
            }
        };
        if (!this.rheaKVRpcService.init(rpcOpts)) {
            LOG.error("Fail to init [RheaKVRpcService].");
            return false;
        }
        this.failoverRetries = opts.getFailoverRetries();
        this.futureTimeoutMillis = opts.getFutureTimeoutMillis();
        this.onlyLeaderRead = opts.isOnlyLeaderRead();
        if (opts.isUseParallelKVExecutor()) {
            int numWorkers = Utils.cpus();
            int bufSize = numWorkers << 4;
            String name = "parallel-kv-executor";
            ThreadFactory threadFactory = Constants.THREAD_AFFINITY_ENABLED ? new AffinityNamedThreadFactory("parallel-kv-executor", true, new AffinityStrategy[0]) : new NamedThreadFactory("parallel-kv-executor", true);
            this.kvDispatcher = new TaskDispatcher(bufSize, numWorkers, WaitStrategyType.LITE_BLOCKING_WAIT, threadFactory);
        }
        this.batchingOpts = opts.getBatchingOptions();
        if (this.batchingOpts.isAllowBatching()) {
            this.getBatching = new GetBatching((EventFactory<KeyEvent>)((EventFactory)() -> new KeyEvent()), "get_batching", new GetBatchingHandler("get", false));
            this.getBatchingOnlySafe = new GetBatching((EventFactory<KeyEvent>)((EventFactory)() -> new KeyEvent()), "get_batching_only_safe", new GetBatchingHandler("get_only_safe", true));
            this.putBatching = new PutBatching((EventFactory<KVEvent>)((EventFactory)() -> new KVEvent()), "put_batching", new PutBatchingHandler("put"));
        }
        LOG.info("[DefaultRheaKVStore] start successfully, options: {}.", (Object)opts);
        this.started = true;
        return true;
    }

    public synchronized void shutdown() {
        if (!this.started) {
            return;
        }
        this.started = false;
        if (this.pdClient != null) {
            this.pdClient.shutdown();
        }
        if (this.storeEngine != null) {
            this.storeEngine.shutdown();
        }
        if (this.rheaKVRpcService != null) {
            this.rheaKVRpcService.shutdown();
        }
        if (this.kvDispatcher != null) {
            this.kvDispatcher.shutdown();
        }
        if (this.getBatching != null) {
            this.getBatching.shutdown();
        }
        if (this.getBatchingOnlySafe != null) {
            this.getBatchingOnlySafe.shutdown();
        }
        if (this.putBatching != null) {
            this.putBatching.shutdown();
        }
        this.stateListenerContainer.clear();
        LOG.info("[DefaultRheaKVStore] shutdown successfully.");
    }

    public KVIterator unsafeLocalIterator() {
        this.checkState();
        if (this.pdClient instanceof RemotePlacementDriverClient) {
            throw new UnsupportedOperationException("unsupported operation on multi-region");
        }
        if (this.storeEngine == null) {
            throw new IllegalStateException("current node do not have store engine");
        }
        return this.storeEngine.getRawKVStore().localIterator();
    }

    @Override
    public CompletableFuture<byte[]> get(byte[] key) {
        return this.get(key, true);
    }

    @Override
    public CompletableFuture<byte[]> get(String key) {
        return this.get(BytesUtil.writeUtf8((String)key));
    }

    @Override
    public CompletableFuture<byte[]> get(byte[] key, boolean readOnlySafe) {
        Requires.requireNonNull((Object)key, (String)"key");
        return this.get(key, readOnlySafe, new CompletableFuture<byte[]>(), true);
    }

    @Override
    public CompletableFuture<byte[]> get(String key, boolean readOnlySafe) {
        return this.get(BytesUtil.writeUtf8((String)key), readOnlySafe);
    }

    @Override
    public byte[] bGet(byte[] key) {
        return FutureHelper.get(this.get(key), this.futureTimeoutMillis);
    }

    @Override
    public byte[] bGet(String key) {
        return FutureHelper.get(this.get(key), this.futureTimeoutMillis);
    }

    @Override
    public byte[] bGet(byte[] key, boolean readOnlySafe) {
        return FutureHelper.get(this.get(key, readOnlySafe), this.futureTimeoutMillis);
    }

    @Override
    public byte[] bGet(String key, boolean readOnlySafe) {
        return FutureHelper.get(this.get(key, readOnlySafe), this.futureTimeoutMillis);
    }

    private CompletableFuture<byte[]> get(byte[] key, boolean readOnlySafe, CompletableFuture<byte[]> future, boolean tryBatching) {
        this.checkState();
        Requires.requireNonNull((Object)key, (String)"key");
        if (tryBatching) {
            GetBatching getBatching;
            GetBatching getBatching2 = getBatching = readOnlySafe ? this.getBatchingOnlySafe : this.getBatching;
            if (getBatching != null && getBatching.apply(key, future)) {
                return future;
            }
        }
        this.internalGet(key, readOnlySafe, future, this.failoverRetries, null, this.onlyLeaderRead);
        return future;
    }

    private void internalGet(byte[] key, boolean readOnlySafe, CompletableFuture<byte[]> future, int retriesLeft, Errors lastCause, boolean requireLeader) {
        Region region = this.pdClient.findRegionByKey(key, ErrorsHelper.isInvalidEpoch(lastCause));
        RegionEngine regionEngine = this.getRegionEngine(region.getId(), requireLeader);
        RetryRunner retryRunner = retryCause -> this.internalGet(key, readOnlySafe, future, retriesLeft - 1, retryCause, true);
        FailoverClosureImpl<byte[]> closure = new FailoverClosureImpl<byte[]>(future, retriesLeft, retryRunner);
        if (regionEngine != null) {
            if (DefaultRheaKVStore.ensureOnValidEpoch(region, regionEngine, closure)) {
                this.getRawKVStore(regionEngine).get(key, readOnlySafe, closure);
            }
        } else {
            GetRequest request = new GetRequest();
            request.setKey(key);
            request.setReadOnlySafe(readOnlySafe);
            request.setRegionId(region.getId());
            request.setRegionEpoch(region.getRegionEpoch());
            this.rheaKVRpcService.callAsyncWithRpc(request, closure, lastCause, requireLeader);
        }
    }

    @Override
    public CompletableFuture<Map<ByteArray, byte[]>> multiGet(List<byte[]> keys) {
        return this.multiGet(keys, true);
    }

    @Override
    public CompletableFuture<Map<ByteArray, byte[]>> multiGet(List<byte[]> keys, boolean readOnlySafe) {
        this.checkState();
        Requires.requireNonNull(keys, (String)"keys");
        FutureGroup futureGroup = this.internalMultiGet(keys, readOnlySafe, this.failoverRetries, null);
        return FutureHelper.joinMap(futureGroup, keys.size());
    }

    @Override
    public Map<ByteArray, byte[]> bMultiGet(List<byte[]> keys) {
        return FutureHelper.get(this.multiGet(keys), this.futureTimeoutMillis);
    }

    @Override
    public Map<ByteArray, byte[]> bMultiGet(List<byte[]> keys, boolean readOnlySafe) {
        return FutureHelper.get(this.multiGet(keys, readOnlySafe), this.futureTimeoutMillis);
    }

    private FutureGroup<Map<ByteArray, byte[]>> internalMultiGet(List<byte[]> keys, boolean readOnlySafe, int retriesLeft, Throwable lastCause) {
        Map<Region, List<byte[]>> regionMap = this.pdClient.findRegionsByKeys(keys, ApiExceptionHelper.isInvalidEpoch(lastCause));
        ArrayList futures = Lists.newArrayListWithCapacity(regionMap.size());
        Errors lastError = lastCause == null ? null : Errors.forException(lastCause);
        for (Map.Entry<Region, List<byte[]>> entry : regionMap.entrySet()) {
            Region region = entry.getKey();
            List<byte[]> subKeys = entry.getValue();
            RetryCallable retryCallable = retryCause -> this.internalMultiGet(subKeys, readOnlySafe, retriesLeft - 1, retryCause);
            MapFailoverFuture<ByteArray, byte[]> future = new MapFailoverFuture<ByteArray, byte[]>(retriesLeft, retryCallable);
            this.internalRegionMultiGet(region, subKeys, readOnlySafe, future, retriesLeft, lastError, this.onlyLeaderRead);
            futures.add(future);
        }
        return new FutureGroup<Map<ByteArray, byte[]>>(futures);
    }

    private void internalRegionMultiGet(Region region, List<byte[]> subKeys, boolean readOnlySafe, CompletableFuture<Map<ByteArray, byte[]>> future, int retriesLeft, Errors lastCause, boolean requireLeader) {
        RegionEngine regionEngine = this.getRegionEngine(region.getId(), requireLeader);
        RetryRunner retryRunner = retryCause -> this.internalRegionMultiGet(region, subKeys, readOnlySafe, future, retriesLeft - 1, retryCause, true);
        FailoverClosureImpl<Map<ByteArray, byte[]>> closure = new FailoverClosureImpl<Map<ByteArray, byte[]>>(future, false, retriesLeft, retryRunner);
        if (regionEngine != null) {
            if (DefaultRheaKVStore.ensureOnValidEpoch(region, regionEngine, closure)) {
                RawKVStore rawKVStore = this.getRawKVStore(regionEngine);
                if (this.kvDispatcher == null) {
                    rawKVStore.multiGet(subKeys, readOnlySafe, closure);
                } else {
                    this.kvDispatcher.execute(() -> rawKVStore.multiGet(subKeys, readOnlySafe, closure));
                }
            }
        } else {
            MultiGetRequest request = new MultiGetRequest();
            request.setKeys(subKeys);
            request.setReadOnlySafe(readOnlySafe);
            request.setRegionId(region.getId());
            request.setRegionEpoch(region.getRegionEpoch());
            this.rheaKVRpcService.callAsyncWithRpc(request, closure, lastCause, requireLeader);
        }
    }

    @Override
    public CompletableFuture<Boolean> containsKey(byte[] key) {
        this.checkState();
        Requires.requireNonNull((Object)key, (String)"key");
        CompletableFuture<Boolean> future = new CompletableFuture<Boolean>();
        this.internalContainsKey(key, future, this.failoverRetries, null);
        return future;
    }

    @Override
    public CompletableFuture<Boolean> containsKey(String key) {
        return this.containsKey(BytesUtil.writeUtf8((String)key));
    }

    @Override
    public Boolean bContainsKey(byte[] key) {
        return FutureHelper.get(this.containsKey(key), this.futureTimeoutMillis);
    }

    @Override
    public Boolean bContainsKey(String key) {
        return FutureHelper.get(this.containsKey(key), this.futureTimeoutMillis);
    }

    private void internalContainsKey(byte[] key, CompletableFuture<Boolean> future, int retriesLeft, Errors lastCause) {
        Region region = this.pdClient.findRegionByKey(key, ErrorsHelper.isInvalidEpoch(lastCause));
        RegionEngine regionEngine = this.getRegionEngine(region.getId(), true);
        RetryRunner retryRunner = retryCause -> this.internalContainsKey(key, future, retriesLeft - 1, retryCause);
        FailoverClosureImpl<Boolean> closure = new FailoverClosureImpl<Boolean>(future, retriesLeft, retryRunner);
        if (regionEngine != null) {
            if (DefaultRheaKVStore.ensureOnValidEpoch(region, regionEngine, closure)) {
                this.getRawKVStore(regionEngine).containsKey(key, closure);
            }
        } else {
            ContainsKeyRequest request = new ContainsKeyRequest();
            request.setKey(key);
            request.setRegionId(region.getId());
            request.setRegionEpoch(region.getRegionEpoch());
            this.rheaKVRpcService.callAsyncWithRpc(request, closure, lastCause);
        }
    }

    @Override
    public CompletableFuture<List<KVEntry>> scan(byte[] startKey, byte[] endKey) {
        return this.scan(startKey, endKey, true);
    }

    @Override
    public CompletableFuture<List<KVEntry>> scan(String startKey, String endKey) {
        return this.scan(BytesUtil.writeUtf8((String)startKey), BytesUtil.writeUtf8((String)endKey));
    }

    @Override
    public CompletableFuture<List<KVEntry>> scan(byte[] startKey, byte[] endKey, boolean readOnlySafe) {
        return this.scan(startKey, endKey, readOnlySafe, true);
    }

    @Override
    public CompletableFuture<List<KVEntry>> scan(String startKey, String endKey, boolean readOnlySafe) {
        return this.scan(BytesUtil.writeUtf8((String)startKey), BytesUtil.writeUtf8((String)endKey), readOnlySafe);
    }

    @Override
    public CompletableFuture<List<KVEntry>> scan(byte[] startKey, byte[] endKey, boolean readOnlySafe, boolean returnValue) {
        this.checkState();
        byte[] realStartKey = BytesUtil.nullToEmpty((byte[])startKey);
        if (endKey != null) {
            Requires.requireTrue((BytesUtil.compare((byte[])realStartKey, (byte[])endKey) < 0 ? 1 : 0) != 0, (Object)"startKey must < endKey");
        }
        FutureGroup futureGroup = this.internalScan(realStartKey, endKey, readOnlySafe, returnValue, this.failoverRetries, null);
        return FutureHelper.joinList(futureGroup);
    }

    @Override
    public CompletableFuture<List<KVEntry>> scan(String startKey, String endKey, boolean readOnlySafe, boolean returnValue) {
        return this.scan(BytesUtil.writeUtf8((String)startKey), BytesUtil.writeUtf8((String)endKey), readOnlySafe, returnValue);
    }

    @Override
    public List<KVEntry> bScan(byte[] startKey, byte[] endKey) {
        return FutureHelper.get(this.scan(startKey, endKey), this.futureTimeoutMillis);
    }

    @Override
    public List<KVEntry> bScan(String startKey, String endKey) {
        return FutureHelper.get(this.scan(startKey, endKey), this.futureTimeoutMillis);
    }

    @Override
    public List<KVEntry> bScan(byte[] startKey, byte[] endKey, boolean readOnlySafe) {
        return FutureHelper.get(this.scan(startKey, endKey, readOnlySafe), this.futureTimeoutMillis);
    }

    @Override
    public List<KVEntry> bScan(String startKey, String endKey, boolean readOnlySafe) {
        return FutureHelper.get(this.scan(startKey, endKey, readOnlySafe), this.futureTimeoutMillis);
    }

    @Override
    public List<KVEntry> bScan(byte[] startKey, byte[] endKey, boolean readOnlySafe, boolean returnValue) {
        return FutureHelper.get(this.scan(startKey, endKey, readOnlySafe, returnValue), this.futureTimeoutMillis);
    }

    @Override
    public List<KVEntry> bScan(String startKey, String endKey, boolean readOnlySafe, boolean returnValue) {
        return FutureHelper.get(this.scan(startKey, endKey, readOnlySafe, returnValue), this.futureTimeoutMillis);
    }

    private FutureGroup<List<KVEntry>> internalScan(byte[] startKey, byte[] endKey, boolean readOnlySafe, boolean returnValue, int retriesLeft, Throwable lastCause) {
        Requires.requireNonNull((Object)startKey, (String)"startKey");
        List<Region> regionList = this.pdClient.findRegionsByKeyRange(startKey, endKey, ApiExceptionHelper.isInvalidEpoch(lastCause));
        ArrayList futures = Lists.newArrayListWithCapacity(regionList.size());
        Errors lastError = lastCause == null ? null : Errors.forException(lastCause);
        for (Region region : regionList) {
            byte[] subStartKey;
            byte[] regionStartKey = region.getStartKey();
            byte[] regionEndKey = region.getEndKey();
            byte[] byArray = subStartKey = regionStartKey == null ? startKey : BytesUtil.max((byte[])regionStartKey, (byte[])startKey);
            byte[] subEndKey = regionEndKey == null ? endKey : (endKey == null ? regionEndKey : BytesUtil.min((byte[])regionEndKey, (byte[])endKey));
            ListRetryCallable retryCallable = retryCause -> this.internalScan(subStartKey, subEndKey, readOnlySafe, returnValue, retriesLeft - 1, retryCause);
            ListFailoverFuture<KVEntry> future = new ListFailoverFuture<KVEntry>(retriesLeft, retryCallable);
            this.internalRegionScan(region, subStartKey, subEndKey, false, readOnlySafe, returnValue, future, retriesLeft, lastError, this.onlyLeaderRead);
            futures.add(future);
        }
        return new FutureGroup<List<KVEntry>>(futures);
    }

    private void internalRegionScan(Region region, byte[] subStartKey, byte[] subEndKey, boolean reverse, boolean readOnlySafe, boolean returnValue, CompletableFuture<List<KVEntry>> future, int retriesLeft, Errors lastCause, boolean requireLeader) {
        RegionEngine regionEngine = this.getRegionEngine(region.getId(), requireLeader);
        RetryRunner retryRunner = retryCause -> this.internalRegionScan(region, subStartKey, subEndKey, reverse, readOnlySafe, returnValue, future, retriesLeft - 1, retryCause, true);
        FailoverClosureImpl<List<KVEntry>> closure = new FailoverClosureImpl<List<KVEntry>>(future, false, retriesLeft, retryRunner);
        if (regionEngine != null) {
            if (DefaultRheaKVStore.ensureOnValidEpoch(region, regionEngine, closure)) {
                RawKVStore rawKVStore = this.getRawKVStore(regionEngine);
                if (reverse) {
                    if (this.kvDispatcher == null) {
                        rawKVStore.reverseScan(subStartKey, subEndKey, readOnlySafe, returnValue, closure);
                    } else {
                        this.kvDispatcher.execute(() -> rawKVStore.reverseScan(subStartKey, subEndKey, readOnlySafe, returnValue, (KVStoreClosure)closure));
                    }
                } else if (this.kvDispatcher == null) {
                    rawKVStore.scan(subStartKey, subEndKey, readOnlySafe, returnValue, closure);
                } else {
                    this.kvDispatcher.execute(() -> rawKVStore.scan(subStartKey, subEndKey, readOnlySafe, returnValue, (KVStoreClosure)closure));
                }
            }
        } else {
            ScanRequest request = new ScanRequest();
            request.setStartKey(subStartKey);
            request.setEndKey(subEndKey);
            request.setReadOnlySafe(readOnlySafe);
            request.setReturnValue(returnValue);
            request.setRegionId(region.getId());
            request.setRegionEpoch(region.getRegionEpoch());
            request.setReverse(reverse);
            this.rheaKVRpcService.callAsyncWithRpc(request, closure, lastCause, requireLeader);
        }
    }

    @Override
    public CompletableFuture<List<KVEntry>> reverseScan(byte[] startKey, byte[] endKey) {
        return this.reverseScan(startKey, endKey, true);
    }

    @Override
    public CompletableFuture<List<KVEntry>> reverseScan(String startKey, String endKey) {
        return this.reverseScan(BytesUtil.writeUtf8((String)startKey), BytesUtil.writeUtf8((String)endKey));
    }

    @Override
    public CompletableFuture<List<KVEntry>> reverseScan(byte[] startKey, byte[] endKey, boolean readOnlySafe) {
        return this.reverseScan(startKey, endKey, readOnlySafe, true);
    }

    @Override
    public CompletableFuture<List<KVEntry>> reverseScan(String startKey, String endKey, boolean readOnlySafe) {
        return this.reverseScan(BytesUtil.writeUtf8((String)startKey), BytesUtil.writeUtf8((String)endKey), readOnlySafe);
    }

    @Override
    public CompletableFuture<List<KVEntry>> reverseScan(byte[] startKey, byte[] endKey, boolean readOnlySafe, boolean returnValue) {
        this.checkState();
        byte[] realEndKey = BytesUtil.nullToEmpty((byte[])endKey);
        if (startKey != null) {
            Requires.requireTrue((BytesUtil.compare((byte[])startKey, (byte[])realEndKey) > 0 ? 1 : 0) != 0, (Object)"startKey must > endKey");
        }
        FutureGroup futureGroup = this.internalReverseScan(startKey, realEndKey, readOnlySafe, returnValue, this.failoverRetries, null);
        return FutureHelper.joinList(futureGroup);
    }

    @Override
    public CompletableFuture<List<KVEntry>> reverseScan(String startKey, String endKey, boolean readOnlySafe, boolean returnValue) {
        return this.reverseScan(BytesUtil.writeUtf8((String)startKey), BytesUtil.writeUtf8((String)endKey), readOnlySafe, returnValue);
    }

    @Override
    public List<KVEntry> bReverseScan(byte[] startKey, byte[] endKey) {
        return FutureHelper.get(this.reverseScan(startKey, endKey), this.futureTimeoutMillis);
    }

    @Override
    public List<KVEntry> bReverseScan(String startKey, String endKey) {
        return FutureHelper.get(this.reverseScan(startKey, endKey), this.futureTimeoutMillis);
    }

    @Override
    public List<KVEntry> bReverseScan(byte[] startKey, byte[] endKey, boolean readOnlySafe) {
        return FutureHelper.get(this.reverseScan(startKey, endKey, readOnlySafe), this.futureTimeoutMillis);
    }

    @Override
    public List<KVEntry> bReverseScan(String startKey, String endKey, boolean readOnlySafe) {
        return FutureHelper.get(this.reverseScan(startKey, endKey, readOnlySafe), this.futureTimeoutMillis);
    }

    @Override
    public List<KVEntry> bReverseScan(byte[] startKey, byte[] endKey, boolean readOnlySafe, boolean returnValue) {
        return FutureHelper.get(this.reverseScan(startKey, endKey, readOnlySafe, returnValue), this.futureTimeoutMillis);
    }

    @Override
    public List<KVEntry> bReverseScan(String startKey, String endKey, boolean readOnlySafe, boolean returnValue) {
        return FutureHelper.get(this.reverseScan(startKey, endKey, readOnlySafe, returnValue), this.futureTimeoutMillis);
    }

    private FutureGroup<List<KVEntry>> internalReverseScan(byte[] startKey, byte[] endKey, boolean readOnlySafe, boolean returnValue, int retriesLeft, Throwable lastCause) {
        Requires.requireNonNull((Object)endKey, (String)"endKey");
        List<Region> regionList = this.pdClient.findRegionsByKeyRange(endKey, startKey, ApiExceptionHelper.isInvalidEpoch(lastCause));
        Collections.reverse(regionList);
        ArrayList futures = Lists.newArrayListWithCapacity(regionList.size());
        Errors lastError = lastCause == null ? null : Errors.forException(lastCause);
        for (Region region : regionList) {
            byte[] regionEndKey = region.getEndKey();
            byte[] regionStartKey = region.getStartKey();
            byte[] subStartKey = regionEndKey == null ? startKey : (startKey == null ? regionEndKey : BytesUtil.min((byte[])regionEndKey, (byte[])startKey));
            byte[] subEndKey = regionStartKey == null ? endKey : BytesUtil.max((byte[])regionStartKey, (byte[])endKey);
            ListRetryCallable retryCallable = retryCause -> this.internalReverseScan(subStartKey, subEndKey, readOnlySafe, returnValue, retriesLeft - 1, retryCause);
            ListFailoverFuture<KVEntry> future = new ListFailoverFuture<KVEntry>(retriesLeft, retryCallable);
            this.internalRegionScan(region, subStartKey, subEndKey, true, readOnlySafe, returnValue, future, retriesLeft, lastError, this.onlyLeaderRead);
            futures.add(future);
        }
        return new FutureGroup<List<KVEntry>>(futures);
    }

    public List<KVEntry> singleRegionScan(byte[] startKey, byte[] endKey, int limit, boolean readOnlySafe, boolean returnValue) {
        this.checkState();
        byte[] realStartKey = BytesUtil.nullToEmpty((byte[])startKey);
        if (endKey != null) {
            Requires.requireTrue((BytesUtil.compare((byte[])realStartKey, (byte[])endKey) < 0 ? 1 : 0) != 0, (Object)"startKey must < endKey");
        }
        Requires.requireTrue((limit > 0 ? 1 : 0) != 0, (Object)"limit must > 0");
        CompletableFuture<List<KVEntry>> future = new CompletableFuture<List<KVEntry>>();
        this.internalSingleRegionScan(realStartKey, endKey, limit, readOnlySafe, returnValue, future, this.failoverRetries, null, this.onlyLeaderRead);
        return FutureHelper.get(future, this.futureTimeoutMillis);
    }

    private void internalSingleRegionScan(byte[] startKey, byte[] endKey, int limit, boolean readOnlySafe, boolean returnValue, CompletableFuture<List<KVEntry>> future, int retriesLeft, Errors lastCause, boolean requireLeader) {
        Requires.requireNonNull((Object)startKey, (String)"startKey");
        Region region = this.pdClient.findRegionByKey(startKey, ErrorsHelper.isInvalidEpoch(lastCause));
        byte[] regionEndKey = region.getEndKey();
        byte[] realEndKey = regionEndKey == null ? endKey : (endKey == null ? regionEndKey : BytesUtil.min((byte[])regionEndKey, (byte[])endKey));
        RegionEngine regionEngine = this.getRegionEngine(region.getId(), requireLeader);
        RetryRunner retryRunner = retryCause -> this.internalSingleRegionScan(startKey, endKey, limit, readOnlySafe, returnValue, future, retriesLeft - 1, retryCause, true);
        FailoverClosureImpl<List<KVEntry>> closure = new FailoverClosureImpl<List<KVEntry>>(future, retriesLeft, retryRunner);
        if (regionEngine != null) {
            if (DefaultRheaKVStore.ensureOnValidEpoch(region, regionEngine, closure)) {
                this.getRawKVStore(regionEngine).scan(startKey, realEndKey, limit, readOnlySafe, returnValue, closure);
            }
        } else {
            ScanRequest request = new ScanRequest();
            request.setStartKey(startKey);
            request.setEndKey(realEndKey);
            request.setLimit(limit);
            request.setReadOnlySafe(readOnlySafe);
            request.setReturnValue(returnValue);
            request.setRegionId(region.getId());
            request.setRegionEpoch(region.getRegionEpoch());
            this.rheaKVRpcService.callAsyncWithRpc(request, closure, lastCause, requireLeader);
        }
    }

    @Override
    public RheaIterator<KVEntry> iterator(byte[] startKey, byte[] endKey, int bufSize) {
        return this.iterator(startKey, endKey, bufSize, true);
    }

    @Override
    public RheaIterator<KVEntry> iterator(String startKey, String endKey, int bufSize) {
        return this.iterator(startKey, endKey, bufSize, true);
    }

    @Override
    public RheaIterator<KVEntry> iterator(byte[] startKey, byte[] endKey, int bufSize, boolean readOnlySafe) {
        return this.iterator(startKey, endKey, bufSize, readOnlySafe, true);
    }

    @Override
    public RheaIterator<KVEntry> iterator(String startKey, String endKey, int bufSize, boolean readOnlySafe) {
        return this.iterator(BytesUtil.writeUtf8((String)startKey), BytesUtil.writeUtf8((String)endKey), bufSize, readOnlySafe);
    }

    @Override
    public RheaIterator<KVEntry> iterator(byte[] startKey, byte[] endKey, int bufSize, boolean readOnlySafe, boolean returnValue) {
        return new DefaultRheaIterator(this, startKey, endKey, bufSize, readOnlySafe, returnValue);
    }

    @Override
    public RheaIterator<KVEntry> iterator(String startKey, String endKey, int bufSize, boolean readOnlySafe, boolean returnValue) {
        return this.iterator(BytesUtil.writeUtf8((String)startKey), BytesUtil.writeUtf8((String)endKey), bufSize, readOnlySafe, returnValue);
    }

    @Override
    public CompletableFuture<Sequence> getSequence(byte[] seqKey, int step) {
        this.checkState();
        Requires.requireNonNull((Object)seqKey, (String)"seqKey");
        Requires.requireTrue((step >= 0 ? 1 : 0) != 0, (Object)"step must >= 0");
        CompletableFuture<Sequence> future = new CompletableFuture<Sequence>();
        this.internalGetSequence(seqKey, step, future, this.failoverRetries, null);
        return future;
    }

    @Override
    public CompletableFuture<Sequence> getSequence(String seqKey, int step) {
        return this.getSequence(BytesUtil.writeUtf8((String)seqKey), step);
    }

    @Override
    public Sequence bGetSequence(byte[] seqKey, int step) {
        return FutureHelper.get(this.getSequence(seqKey, step), this.futureTimeoutMillis);
    }

    @Override
    public Sequence bGetSequence(String seqKey, int step) {
        return FutureHelper.get(this.getSequence(seqKey, step), this.futureTimeoutMillis);
    }

    @Override
    public CompletableFuture<Long> getLatestSequence(byte[] seqKey) {
        CompletableFuture<Long> cf = new CompletableFuture<Long>();
        this.getSequence(seqKey, 0).whenComplete((sequence, throwable) -> {
            if (throwable == null) {
                cf.complete(sequence.getStartValue());
            } else {
                cf.completeExceptionally((Throwable)throwable);
            }
        });
        return cf;
    }

    @Override
    public CompletableFuture<Long> getLatestSequence(String seqKey) {
        return this.getLatestSequence(BytesUtil.writeUtf8((String)seqKey));
    }

    @Override
    public Long bGetLatestSequence(byte[] seqKey) {
        return FutureHelper.get(this.getLatestSequence(seqKey), this.futureTimeoutMillis);
    }

    @Override
    public Long bGetLatestSequence(String seqKey) {
        return FutureHelper.get(this.getLatestSequence(seqKey), this.futureTimeoutMillis);
    }

    private void internalGetSequence(byte[] seqKey, int step, CompletableFuture<Sequence> future, int retriesLeft, Errors lastCause) {
        Region region = this.pdClient.findRegionByKey(seqKey, ErrorsHelper.isInvalidEpoch(lastCause));
        RegionEngine regionEngine = this.getRegionEngine(region.getId(), true);
        RetryRunner retryRunner = retryCause -> this.internalGetSequence(seqKey, step, future, retriesLeft - 1, retryCause);
        FailoverClosureImpl<Sequence> closure = new FailoverClosureImpl<Sequence>(future, retriesLeft, retryRunner);
        if (regionEngine != null) {
            if (DefaultRheaKVStore.ensureOnValidEpoch(region, regionEngine, closure)) {
                this.getRawKVStore(regionEngine).getSequence(seqKey, step, closure);
            }
        } else {
            GetSequenceRequest request = new GetSequenceRequest();
            request.setSeqKey(seqKey);
            request.setStep(step);
            request.setRegionId(region.getId());
            request.setRegionEpoch(region.getRegionEpoch());
            this.rheaKVRpcService.callAsyncWithRpc(request, closure, lastCause);
        }
    }

    @Override
    public CompletableFuture<Boolean> resetSequence(byte[] seqKey) {
        this.checkState();
        Requires.requireNonNull((Object)seqKey, (String)"seqKey");
        CompletableFuture<Boolean> future = new CompletableFuture<Boolean>();
        this.internalResetSequence(seqKey, future, this.failoverRetries, null);
        return future;
    }

    @Override
    public CompletableFuture<Boolean> resetSequence(String seqKey) {
        return this.resetSequence(BytesUtil.writeUtf8((String)seqKey));
    }

    @Override
    public Boolean bResetSequence(byte[] seqKey) {
        return FutureHelper.get(this.resetSequence(seqKey), this.futureTimeoutMillis);
    }

    @Override
    public Boolean bResetSequence(String seqKey) {
        return FutureHelper.get(this.resetSequence(seqKey), this.futureTimeoutMillis);
    }

    private void internalResetSequence(byte[] seqKey, CompletableFuture<Boolean> future, int retriesLeft, Errors lastCause) {
        Region region = this.pdClient.findRegionByKey(seqKey, ErrorsHelper.isInvalidEpoch(lastCause));
        RegionEngine regionEngine = this.getRegionEngine(region.getId(), true);
        RetryRunner retryRunner = retryCause -> this.internalResetSequence(seqKey, future, retriesLeft - 1, retryCause);
        FailoverClosureImpl<Boolean> closure = new FailoverClosureImpl<Boolean>(future, retriesLeft, retryRunner);
        if (regionEngine != null) {
            if (DefaultRheaKVStore.ensureOnValidEpoch(region, regionEngine, closure)) {
                this.getRawKVStore(regionEngine).resetSequence(seqKey, closure);
            }
        } else {
            ResetSequenceRequest request = new ResetSequenceRequest();
            request.setSeqKey(seqKey);
            request.setRegionId(region.getId());
            request.setRegionEpoch(region.getRegionEpoch());
            this.rheaKVRpcService.callAsyncWithRpc(request, closure, lastCause);
        }
    }

    @Override
    public CompletableFuture<Boolean> put(byte[] key, byte[] value) {
        Requires.requireNonNull((Object)key, (String)"key");
        Requires.requireNonNull((Object)value, (String)"value");
        return this.put(key, value, new CompletableFuture<Boolean>(), true);
    }

    @Override
    public CompletableFuture<Boolean> put(String key, byte[] value) {
        return this.put(BytesUtil.writeUtf8((String)key), value);
    }

    @Override
    public Boolean bPut(byte[] key, byte[] value) {
        return FutureHelper.get(this.put(key, value), this.futureTimeoutMillis);
    }

    @Override
    public Boolean bPut(String key, byte[] value) {
        return FutureHelper.get(this.put(key, value), this.futureTimeoutMillis);
    }

    private CompletableFuture<Boolean> put(byte[] key, byte[] value, CompletableFuture<Boolean> future, boolean tryBatching) {
        PutBatching putBatching;
        this.checkState();
        if (tryBatching && (putBatching = this.putBatching) != null && putBatching.apply(new KVEntry(key, value), future)) {
            return future;
        }
        this.internalPut(key, value, future, this.failoverRetries, null);
        return future;
    }

    private void internalPut(byte[] key, byte[] value, CompletableFuture<Boolean> future, int retriesLeft, Errors lastCause) {
        Region region = this.pdClient.findRegionByKey(key, ErrorsHelper.isInvalidEpoch(lastCause));
        RegionEngine regionEngine = this.getRegionEngine(region.getId(), true);
        RetryRunner retryRunner = retryCause -> this.internalPut(key, value, future, retriesLeft - 1, retryCause);
        FailoverClosureImpl<Boolean> closure = new FailoverClosureImpl<Boolean>(future, retriesLeft, retryRunner);
        if (regionEngine != null) {
            if (DefaultRheaKVStore.ensureOnValidEpoch(region, regionEngine, closure)) {
                this.getRawKVStore(regionEngine).put(key, value, closure);
            }
        } else {
            PutRequest request = new PutRequest();
            request.setKey(key);
            request.setValue(value);
            request.setRegionId(region.getId());
            request.setRegionEpoch(region.getRegionEpoch());
            this.rheaKVRpcService.callAsyncWithRpc(request, closure, lastCause);
        }
    }

    @Override
    public CompletableFuture<byte[]> getAndPut(byte[] key, byte[] value) {
        this.checkState();
        Requires.requireNonNull((Object)key, (String)"key");
        Requires.requireNonNull((Object)value, (String)"value");
        CompletableFuture<byte[]> future = new CompletableFuture<byte[]>();
        this.internalGetAndPut(key, value, future, this.failoverRetries, null);
        return future;
    }

    @Override
    public CompletableFuture<byte[]> getAndPut(String key, byte[] value) {
        return this.getAndPut(BytesUtil.writeUtf8((String)key), value);
    }

    @Override
    public byte[] bGetAndPut(byte[] key, byte[] value) {
        return FutureHelper.get(this.getAndPut(key, value), this.futureTimeoutMillis);
    }

    @Override
    public byte[] bGetAndPut(String key, byte[] value) {
        return FutureHelper.get(this.getAndPut(key, value), this.futureTimeoutMillis);
    }

    private void internalGetAndPut(byte[] key, byte[] value, CompletableFuture<byte[]> future, int retriesLeft, Errors lastCause) {
        Region region = this.pdClient.findRegionByKey(key, ErrorsHelper.isInvalidEpoch(lastCause));
        RegionEngine regionEngine = this.getRegionEngine(region.getId(), true);
        RetryRunner retryRunner = retryCause -> this.internalGetAndPut(key, value, future, retriesLeft - 1, retryCause);
        FailoverClosureImpl<byte[]> closure = new FailoverClosureImpl<byte[]>(future, retriesLeft, retryRunner);
        if (regionEngine != null) {
            if (DefaultRheaKVStore.ensureOnValidEpoch(region, regionEngine, closure)) {
                this.getRawKVStore(regionEngine).getAndPut(key, value, closure);
            }
        } else {
            GetAndPutRequest request = new GetAndPutRequest();
            request.setKey(key);
            request.setValue(value);
            request.setRegionId(region.getId());
            request.setRegionEpoch(region.getRegionEpoch());
            this.rheaKVRpcService.callAsyncWithRpc(request, closure, lastCause);
        }
    }

    @Override
    public CompletableFuture<Boolean> compareAndPut(byte[] key, byte[] expect, byte[] update) {
        this.checkState();
        Requires.requireNonNull((Object)key, (String)"key");
        Requires.requireNonNull((Object)expect, (String)"expect");
        Requires.requireNonNull((Object)update, (String)"update");
        CompletableFuture<Boolean> future = new CompletableFuture<Boolean>();
        this.internalCompareAndPut(key, expect, update, future, this.failoverRetries, null);
        return future;
    }

    @Override
    public CompletableFuture<Boolean> compareAndPut(String key, byte[] expect, byte[] update) {
        return this.compareAndPut(BytesUtil.writeUtf8((String)key), expect, update);
    }

    @Override
    public Boolean bCompareAndPut(byte[] key, byte[] expect, byte[] update) {
        return FutureHelper.get(this.compareAndPut(key, expect, update), this.futureTimeoutMillis);
    }

    @Override
    public Boolean bCompareAndPut(String key, byte[] expect, byte[] update) {
        return FutureHelper.get(this.compareAndPut(key, expect, update), this.futureTimeoutMillis);
    }

    private void internalCompareAndPut(byte[] key, byte[] expect, byte[] update, CompletableFuture<Boolean> future, int retriesLeft, Errors lastCause) {
        Region region = this.pdClient.findRegionByKey(key, ErrorsHelper.isInvalidEpoch(lastCause));
        RegionEngine regionEngine = this.getRegionEngine(region.getId(), true);
        RetryRunner retryRunner = retryCause -> this.internalCompareAndPut(key, expect, update, future, retriesLeft - 1, retryCause);
        FailoverClosureImpl<Boolean> closure = new FailoverClosureImpl<Boolean>(future, retriesLeft, retryRunner);
        if (regionEngine != null) {
            if (DefaultRheaKVStore.ensureOnValidEpoch(region, regionEngine, closure)) {
                this.getRawKVStore(regionEngine).compareAndPut(key, expect, update, closure);
            }
        } else {
            CompareAndPutRequest request = new CompareAndPutRequest();
            request.setKey(key);
            request.setExpect(expect);
            request.setUpdate(update);
            request.setRegionId(region.getId());
            request.setRegionEpoch(region.getRegionEpoch());
            this.rheaKVRpcService.callAsyncWithRpc(request, closure, lastCause);
        }
    }

    @Override
    public CompletableFuture<Boolean> merge(String key, String value) {
        this.checkState();
        Requires.requireNonNull((Object)key, (String)"key");
        Requires.requireNonNull((Object)value, (String)"value");
        CompletableFuture<Boolean> future = new CompletableFuture<Boolean>();
        this.internalMerge(BytesUtil.writeUtf8((String)key), BytesUtil.writeUtf8((String)value), future, this.failoverRetries, null);
        return future;
    }

    @Override
    public Boolean bMerge(String key, String value) {
        return FutureHelper.get(this.merge(key, value), this.futureTimeoutMillis);
    }

    private void internalMerge(byte[] key, byte[] value, CompletableFuture<Boolean> future, int retriesLeft, Errors lastCause) {
        Region region = this.pdClient.findRegionByKey(key, ErrorsHelper.isInvalidEpoch(lastCause));
        RegionEngine regionEngine = this.getRegionEngine(region.getId(), true);
        RetryRunner retryRunner = retryCause -> this.internalMerge(key, value, future, retriesLeft - 1, retryCause);
        FailoverClosureImpl<Boolean> closure = new FailoverClosureImpl<Boolean>(future, retriesLeft, retryRunner);
        if (regionEngine != null) {
            if (DefaultRheaKVStore.ensureOnValidEpoch(region, regionEngine, closure)) {
                this.getRawKVStore(regionEngine).merge(key, value, closure);
            }
        } else {
            MergeRequest request = new MergeRequest();
            request.setKey(key);
            request.setValue(value);
            request.setRegionId(region.getId());
            request.setRegionEpoch(region.getRegionEpoch());
            this.rheaKVRpcService.callAsyncWithRpc(request, closure, lastCause);
        }
    }

    @Override
    public CompletableFuture<Boolean> put(List<KVEntry> entries) {
        this.checkState();
        Requires.requireNonNull(entries, (String)"entries");
        Requires.requireTrue((!entries.isEmpty() ? 1 : 0) != 0, (Object)"entries empty");
        FutureGroup<Boolean> futureGroup = this.internalPut(entries, this.failoverRetries, null);
        return FutureHelper.joinBooleans(futureGroup);
    }

    @Override
    public Boolean bPut(List<KVEntry> entries) {
        return FutureHelper.get(this.put(entries), this.futureTimeoutMillis);
    }

    private FutureGroup<Boolean> internalPut(List<KVEntry> entries, int retriesLeft, Throwable lastCause) {
        Map<Region, List<KVEntry>> regionMap = this.pdClient.findRegionsByKvEntries(entries, ApiExceptionHelper.isInvalidEpoch(lastCause));
        ArrayList futures = Lists.newArrayListWithCapacity(regionMap.size());
        Errors lastError = lastCause == null ? null : Errors.forException(lastCause);
        for (Map.Entry<Region, List<KVEntry>> entry : regionMap.entrySet()) {
            Region region = entry.getKey();
            List<KVEntry> subEntries = entry.getValue();
            RetryCallable<Boolean> retryCallable = retryCause -> this.internalPut(subEntries, retriesLeft - 1, retryCause);
            BoolFailoverFuture future = new BoolFailoverFuture(retriesLeft, retryCallable);
            this.internalRegionPut(region, subEntries, future, retriesLeft, lastError);
            futures.add(future);
        }
        return new FutureGroup<Boolean>(futures);
    }

    private void internalRegionPut(Region region, List<KVEntry> subEntries, CompletableFuture<Boolean> future, int retriesLeft, Errors lastCause) {
        RegionEngine regionEngine = this.getRegionEngine(region.getId(), true);
        RetryRunner retryRunner = retryCause -> this.internalRegionPut(region, subEntries, future, retriesLeft - 1, retryCause);
        FailoverClosureImpl<Boolean> closure = new FailoverClosureImpl<Boolean>(future, false, retriesLeft, retryRunner);
        if (regionEngine != null) {
            if (DefaultRheaKVStore.ensureOnValidEpoch(region, regionEngine, closure)) {
                RawKVStore rawKVStore = this.getRawKVStore(regionEngine);
                if (this.kvDispatcher == null) {
                    rawKVStore.put(subEntries, closure);
                } else {
                    this.kvDispatcher.execute(() -> rawKVStore.put(subEntries, closure));
                }
            }
        } else {
            BatchPutRequest request = new BatchPutRequest();
            request.setKvEntries(subEntries);
            request.setRegionId(region.getId());
            request.setRegionEpoch(region.getRegionEpoch());
            this.rheaKVRpcService.callAsyncWithRpc(request, closure, lastCause);
        }
    }

    @Override
    public CompletableFuture<Boolean> compareAndPutAll(List<CASEntry> entries) {
        this.checkState();
        Requires.requireNonNull(entries, (String)"entries");
        Requires.requireTrue((!entries.isEmpty() ? 1 : 0) != 0, (Object)"entries empty");
        FutureGroup<Boolean> futureGroup = this.internalCompareAndPutAll(entries, this.failoverRetries, null);
        return FutureHelper.joinBooleans(futureGroup);
    }

    @Override
    public Boolean bCompareAndPutAll(List<CASEntry> entries) {
        return FutureHelper.get(this.compareAndPutAll(entries), this.futureTimeoutMillis);
    }

    private FutureGroup<Boolean> internalCompareAndPutAll(List<CASEntry> entries, int retriesLeft, Throwable lastCause) {
        Map<Region, List<CASEntry>> regionMap = this.pdClient.findRegionsByCASEntries(entries, ApiExceptionHelper.isInvalidEpoch(lastCause));
        ArrayList futures = Lists.newArrayListWithCapacity(regionMap.size());
        Errors lastError = lastCause == null ? null : Errors.forException(lastCause);
        for (Map.Entry<Region, List<CASEntry>> entry : regionMap.entrySet()) {
            Region region = entry.getKey();
            List<CASEntry> subEntries = entry.getValue();
            RetryCallable<Boolean> retryCallable = retryCause -> this.internalCompareAndPutAll(subEntries, retriesLeft - 1, retryCause);
            BoolFailoverFuture future = new BoolFailoverFuture(retriesLeft, retryCallable);
            this.internalRegionCompareAndPutAll(region, subEntries, future, retriesLeft, lastError);
            futures.add(future);
        }
        return new FutureGroup<Boolean>(futures);
    }

    private void internalRegionCompareAndPutAll(Region region, List<CASEntry> subEntries, CompletableFuture<Boolean> future, int retriesLeft, Errors lastCause) {
        RegionEngine regionEngine = this.getRegionEngine(region.getId(), true);
        RetryRunner retryRunner = retryCause -> this.internalRegionCompareAndPutAll(region, subEntries, future, retriesLeft - 1, retryCause);
        FailoverClosureImpl<Boolean> closure = new FailoverClosureImpl<Boolean>(future, false, retriesLeft, retryRunner);
        if (regionEngine != null) {
            if (DefaultRheaKVStore.ensureOnValidEpoch(region, regionEngine, closure)) {
                RawKVStore rawKVStore = this.getRawKVStore(regionEngine);
                if (this.kvDispatcher == null) {
                    rawKVStore.compareAndPutAll(subEntries, closure);
                } else {
                    this.kvDispatcher.execute(() -> rawKVStore.compareAndPutAll(subEntries, closure));
                }
            }
        } else {
            CASAllRequest request = new CASAllRequest();
            request.setCasEntries(subEntries);
            request.setRegionId(region.getId());
            request.setRegionEpoch(region.getRegionEpoch());
            this.rheaKVRpcService.callAsyncWithRpc(request, closure, lastCause);
        }
    }

    @Override
    public CompletableFuture<byte[]> putIfAbsent(byte[] key, byte[] value) {
        Requires.requireNonNull((Object)key, (String)"key");
        Requires.requireNonNull((Object)value, (String)"value");
        CompletableFuture<byte[]> future = new CompletableFuture<byte[]>();
        this.internalPutIfAbsent(key, value, future, this.failoverRetries, null);
        return future;
    }

    @Override
    public CompletableFuture<byte[]> putIfAbsent(String key, byte[] value) {
        return this.putIfAbsent(BytesUtil.writeUtf8((String)key), value);
    }

    @Override
    public byte[] bPutIfAbsent(byte[] key, byte[] value) {
        return FutureHelper.get(this.putIfAbsent(key, value), this.futureTimeoutMillis);
    }

    @Override
    public byte[] bPutIfAbsent(String key, byte[] value) {
        return FutureHelper.get(this.putIfAbsent(key, value), this.futureTimeoutMillis);
    }

    private void internalPutIfAbsent(byte[] key, byte[] value, CompletableFuture<byte[]> future, int retriesLeft, Errors lastCause) {
        Region region = this.pdClient.findRegionByKey(key, ErrorsHelper.isInvalidEpoch(lastCause));
        RegionEngine regionEngine = this.getRegionEngine(region.getId(), true);
        RetryRunner retryRunner = retryCause -> this.internalPutIfAbsent(key, value, future, retriesLeft - 1, retryCause);
        FailoverClosureImpl<byte[]> closure = new FailoverClosureImpl<byte[]>(future, retriesLeft, retryRunner);
        if (regionEngine != null) {
            if (DefaultRheaKVStore.ensureOnValidEpoch(region, regionEngine, closure)) {
                this.getRawKVStore(regionEngine).putIfAbsent(key, value, closure);
            }
        } else {
            PutIfAbsentRequest request = new PutIfAbsentRequest();
            request.setKey(key);
            request.setValue(value);
            request.setRegionId(region.getId());
            request.setRegionEpoch(region.getRegionEpoch());
            this.rheaKVRpcService.callAsyncWithRpc(request, closure, lastCause);
        }
    }

    @Override
    public CompletableFuture<Boolean> delete(byte[] key) {
        this.checkState();
        Requires.requireNonNull((Object)key, (String)"key");
        CompletableFuture<Boolean> future = new CompletableFuture<Boolean>();
        this.internalDelete(key, future, this.failoverRetries, null);
        return future;
    }

    @Override
    public CompletableFuture<Boolean> delete(String key) {
        return this.delete(BytesUtil.writeUtf8((String)key));
    }

    @Override
    public Boolean bDelete(byte[] key) {
        return FutureHelper.get(this.delete(key), this.futureTimeoutMillis);
    }

    @Override
    public Boolean bDelete(String key) {
        return FutureHelper.get(this.delete(key), this.futureTimeoutMillis);
    }

    private void internalDelete(byte[] key, CompletableFuture<Boolean> future, int retriesLeft, Errors lastCause) {
        Region region = this.pdClient.findRegionByKey(key, ErrorsHelper.isInvalidEpoch(lastCause));
        RegionEngine regionEngine = this.getRegionEngine(region.getId(), true);
        RetryRunner retryRunner = retryCause -> this.internalDelete(key, future, retriesLeft - 1, retryCause);
        FailoverClosureImpl<Boolean> closure = new FailoverClosureImpl<Boolean>(future, retriesLeft, retryRunner);
        if (regionEngine != null) {
            if (DefaultRheaKVStore.ensureOnValidEpoch(region, regionEngine, closure)) {
                this.getRawKVStore(regionEngine).delete(key, closure);
            }
        } else {
            DeleteRequest request = new DeleteRequest();
            request.setKey(key);
            request.setRegionId(region.getId());
            request.setRegionEpoch(region.getRegionEpoch());
            this.rheaKVRpcService.callAsyncWithRpc(request, closure, lastCause);
        }
    }

    @Override
    public CompletableFuture<Boolean> deleteRange(byte[] startKey, byte[] endKey) {
        this.checkState();
        Requires.requireNonNull((Object)startKey, (String)"startKey");
        Requires.requireNonNull((Object)endKey, (String)"endKey");
        Requires.requireTrue((BytesUtil.compare((byte[])startKey, (byte[])endKey) < 0 ? 1 : 0) != 0, (Object)"startKey must < endKey");
        FutureGroup<Boolean> futureGroup = this.internalDeleteRange(startKey, endKey, this.failoverRetries, null);
        return FutureHelper.joinBooleans(futureGroup);
    }

    private FutureGroup<Boolean> internalDeleteRange(byte[] startKey, byte[] endKey, int retriesLeft, Throwable lastCause) {
        List<Region> regionList = this.pdClient.findRegionsByKeyRange(startKey, endKey, ApiExceptionHelper.isInvalidEpoch(lastCause));
        ArrayList futures = Lists.newArrayListWithCapacity(regionList.size());
        Errors lastError = lastCause == null ? null : Errors.forException(lastCause);
        for (Region region : regionList) {
            byte[] regionStartKey = region.getStartKey();
            byte[] regionEndKey = region.getEndKey();
            byte[] subStartKey = regionStartKey == null ? startKey : BytesUtil.max((byte[])regionStartKey, (byte[])startKey);
            byte[] subEndKey = regionEndKey == null ? endKey : BytesUtil.min((byte[])regionEndKey, (byte[])endKey);
            RetryCallable<Boolean> retryCallable = retryCause -> this.internalDeleteRange(subStartKey, subEndKey, retriesLeft - 1, retryCause);
            BoolFailoverFuture future = new BoolFailoverFuture(retriesLeft, retryCallable);
            this.internalRegionDeleteRange(region, subStartKey, subEndKey, future, retriesLeft, lastError);
            futures.add(future);
        }
        return new FutureGroup<Boolean>(futures);
    }

    @Override
    public CompletableFuture<Boolean> deleteRange(String startKey, String endKey) {
        return this.deleteRange(BytesUtil.writeUtf8((String)startKey), BytesUtil.writeUtf8((String)endKey));
    }

    @Override
    public Boolean bDeleteRange(byte[] startKey, byte[] endKey) {
        return FutureHelper.get(this.deleteRange(startKey, endKey), this.futureTimeoutMillis);
    }

    @Override
    public Boolean bDeleteRange(String startKey, String endKey) {
        return FutureHelper.get(this.deleteRange(startKey, endKey), this.futureTimeoutMillis);
    }

    @Override
    public CompletableFuture<Boolean> delete(List<byte[]> keys) {
        this.checkState();
        Requires.requireNonNull(keys, (String)"keys");
        Requires.requireTrue((!keys.isEmpty() ? 1 : 0) != 0, (Object)"keys empty");
        FutureGroup<Boolean> futureGroup = this.internalDelete(keys, this.failoverRetries, null);
        return FutureHelper.joinBooleans(futureGroup);
    }

    @Override
    public Boolean bDelete(List<byte[]> keys) {
        return FutureHelper.get(this.delete(keys), this.futureTimeoutMillis);
    }

    private FutureGroup<Boolean> internalDelete(List<byte[]> keys, int retriesLeft, Throwable lastCause) {
        Map<Region, List<byte[]>> regionMap = this.pdClient.findRegionsByKeys(keys, ApiExceptionHelper.isInvalidEpoch(lastCause));
        ArrayList futures = Lists.newArrayListWithCapacity(regionMap.size());
        Errors lastError = lastCause == null ? null : Errors.forException(lastCause);
        for (Map.Entry<Region, List<byte[]>> entry : regionMap.entrySet()) {
            Region region = entry.getKey();
            List<byte[]> subKeys = entry.getValue();
            RetryCallable<Boolean> retryCallable = retryCause -> this.internalDelete(subKeys, retriesLeft - 1, retryCause);
            BoolFailoverFuture future = new BoolFailoverFuture(retriesLeft, retryCallable);
            this.internalRegionDelete(region, subKeys, future, retriesLeft, lastError);
            futures.add(future);
        }
        return new FutureGroup<Boolean>(futures);
    }

    private void internalRegionDelete(Region region, List<byte[]> subKeys, CompletableFuture<Boolean> future, int retriesLeft, Errors lastCause) {
        RegionEngine regionEngine = this.getRegionEngine(region.getId(), true);
        RetryRunner retryRunner = retryCause -> this.internalRegionDelete(region, subKeys, future, retriesLeft - 1, retryCause);
        FailoverClosureImpl<Boolean> closure = new FailoverClosureImpl<Boolean>(future, false, retriesLeft, retryRunner);
        if (regionEngine != null) {
            if (DefaultRheaKVStore.ensureOnValidEpoch(region, regionEngine, closure)) {
                RawKVStore rawKVStore = this.getRawKVStore(regionEngine);
                if (this.kvDispatcher == null) {
                    rawKVStore.delete(subKeys, closure);
                } else {
                    this.kvDispatcher.execute(() -> rawKVStore.delete(subKeys, (KVStoreClosure)closure));
                }
            }
        } else {
            BatchDeleteRequest request = new BatchDeleteRequest();
            request.setKeys(subKeys);
            request.setRegionId(region.getId());
            request.setRegionEpoch(region.getRegionEpoch());
            this.rheaKVRpcService.callAsyncWithRpc(request, closure, lastCause);
        }
    }

    private void internalRegionDeleteRange(Region region, byte[] subStartKey, byte[] subEndKey, CompletableFuture<Boolean> future, int retriesLeft, Errors lastCause) {
        RegionEngine regionEngine = this.getRegionEngine(region.getId(), true);
        RetryRunner retryRunner = retryCause -> this.internalRegionDeleteRange(region, subStartKey, subEndKey, future, retriesLeft - 1, retryCause);
        FailoverClosureImpl<Boolean> closure = new FailoverClosureImpl<Boolean>(future, false, retriesLeft, retryRunner);
        if (regionEngine != null) {
            if (DefaultRheaKVStore.ensureOnValidEpoch(region, regionEngine, closure)) {
                this.getRawKVStore(regionEngine).deleteRange(subStartKey, subEndKey, closure);
            }
        } else {
            DeleteRangeRequest request = new DeleteRangeRequest();
            request.setStartKey(subStartKey);
            request.setEndKey(subEndKey);
            request.setRegionId(region.getId());
            request.setRegionEpoch(region.getRegionEpoch());
            this.rheaKVRpcService.callAsyncWithRpc(request, closure, lastCause);
        }
    }

    public CompletableFuture<Boolean> execute(long regionId, NodeExecutor executor) {
        this.checkState();
        Requires.requireNonNull((Object)executor, (String)"executor");
        CompletableFuture<Boolean> future = new CompletableFuture<Boolean>();
        this.internalExecute(regionId, executor, future, this.failoverRetries, null);
        return future;
    }

    public Boolean bExecute(long regionId, NodeExecutor executor) {
        return FutureHelper.get(this.execute(regionId, executor), this.futureTimeoutMillis);
    }

    private void internalExecute(long regionId, NodeExecutor executor, CompletableFuture<Boolean> future, int retriesLeft, Errors lastCause) {
        Region region = this.pdClient.getRegionById(regionId);
        RegionEngine regionEngine = this.getRegionEngine(region.getId(), true);
        RetryRunner retryRunner = retryCause -> this.internalExecute(regionId, executor, future, retriesLeft - 1, retryCause);
        FailoverClosureImpl<Boolean> closure = new FailoverClosureImpl<Boolean>(future, retriesLeft, retryRunner);
        if (regionEngine != null) {
            if (DefaultRheaKVStore.ensureOnValidEpoch(region, regionEngine, closure)) {
                this.getRawKVStore(regionEngine).execute(executor, true, closure);
            }
        } else {
            NodeExecuteRequest request = new NodeExecuteRequest();
            request.setNodeExecutor(executor);
            request.setRegionId(region.getId());
            request.setRegionEpoch(region.getRegionEpoch());
            this.rheaKVRpcService.callAsyncWithRpc(request, closure, lastCause);
        }
    }

    @Override
    public DistributedLock<byte[]> getDistributedLock(byte[] target, long lease, TimeUnit unit) {
        return this.getDistributedLock(target, lease, unit, null);
    }

    @Override
    public DistributedLock<byte[]> getDistributedLock(String target, long lease, TimeUnit unit) {
        return this.getDistributedLock(target, lease, unit, null);
    }

    @Override
    public DistributedLock<byte[]> getDistributedLock(byte[] target, long lease, TimeUnit unit, ScheduledExecutorService watchdog) {
        return new DefaultDistributedLock(target, lease, unit, watchdog, this);
    }

    @Override
    public DistributedLock<byte[]> getDistributedLock(String target, long lease, TimeUnit unit, ScheduledExecutorService watchdog) {
        return this.getDistributedLock(BytesUtil.writeUtf8((String)target), lease, unit, watchdog);
    }

    public CompletableFuture<DistributedLock.Owner> tryLockWith(byte[] key, boolean keepLease, DistributedLock.Acquirer acquirer) {
        this.checkState();
        Requires.requireNonNull((Object)key, (String)"key");
        CompletableFuture<DistributedLock.Owner> future = new CompletableFuture<DistributedLock.Owner>();
        this.internalTryLockWith(key, keepLease, acquirer, future, this.failoverRetries, null);
        return future;
    }

    private void internalTryLockWith(byte[] key, boolean keepLease, DistributedLock.Acquirer acquirer, CompletableFuture<DistributedLock.Owner> future, int retriesLeft, Errors lastCause) {
        Region region = this.pdClient.findRegionByKey(key, ErrorsHelper.isInvalidEpoch(lastCause));
        RegionEngine regionEngine = this.getRegionEngine(region.getId(), true);
        RetryRunner retryRunner = retryCause -> this.internalTryLockWith(key, keepLease, acquirer, future, retriesLeft - 1, retryCause);
        FailoverClosureImpl<DistributedLock.Owner> closure = new FailoverClosureImpl<DistributedLock.Owner>(future, retriesLeft, retryRunner);
        if (regionEngine != null) {
            if (DefaultRheaKVStore.ensureOnValidEpoch(region, regionEngine, closure)) {
                this.getRawKVStore(regionEngine).tryLockWith(key, region.getStartKey(), keepLease, acquirer, closure);
            }
        } else {
            KeyLockRequest request = new KeyLockRequest();
            request.setKey(key);
            request.setKeepLease(keepLease);
            request.setAcquirer(acquirer);
            request.setRegionId(region.getId());
            request.setRegionEpoch(region.getRegionEpoch());
            this.rheaKVRpcService.callAsyncWithRpc(request, closure, lastCause);
        }
    }

    public CompletableFuture<DistributedLock.Owner> releaseLockWith(byte[] key, DistributedLock.Acquirer acquirer) {
        this.checkState();
        Requires.requireNonNull((Object)key, (String)"key");
        CompletableFuture<DistributedLock.Owner> future = new CompletableFuture<DistributedLock.Owner>();
        this.internalReleaseLockWith(key, acquirer, future, this.failoverRetries, null);
        return future;
    }

    private void internalReleaseLockWith(byte[] key, DistributedLock.Acquirer acquirer, CompletableFuture<DistributedLock.Owner> future, int retriesLeft, Errors lastCause) {
        Region region = this.pdClient.findRegionByKey(key, ErrorsHelper.isInvalidEpoch(lastCause));
        RegionEngine regionEngine = this.getRegionEngine(region.getId(), true);
        RetryRunner retryRunner = retryCause -> this.internalReleaseLockWith(key, acquirer, future, retriesLeft - 1, retryCause);
        FailoverClosureImpl<DistributedLock.Owner> closure = new FailoverClosureImpl<DistributedLock.Owner>(future, retriesLeft, retryRunner);
        if (regionEngine != null) {
            if (DefaultRheaKVStore.ensureOnValidEpoch(region, regionEngine, closure)) {
                this.getRawKVStore(regionEngine).releaseLockWith(key, acquirer, closure);
            }
        } else {
            KeyUnlockRequest request = new KeyUnlockRequest();
            request.setKey(key);
            request.setAcquirer(acquirer);
            request.setRegionId(region.getId());
            request.setRegionEpoch(region.getRegionEpoch());
            this.rheaKVRpcService.callAsyncWithRpc(request, closure, lastCause);
        }
    }

    @Override
    public PlacementDriverClient getPlacementDriverClient() {
        return this.pdClient;
    }

    @Override
    public void addLeaderStateListener(long regionId, LeaderStateListener listener) {
        this.addStateListener(regionId, listener);
    }

    @Override
    public void addFollowerStateListener(long regionId, FollowerStateListener listener) {
        this.addStateListener(regionId, listener);
    }

    @Override
    public void addStateListener(long regionId, StateListener listener) {
        this.stateListenerContainer.addStateListener(regionId, listener);
    }

    public long getClusterId() {
        return this.opts.getClusterId();
    }

    public StoreEngine getStoreEngine() {
        return this.storeEngine;
    }

    public boolean isOnlyLeaderRead() {
        return this.onlyLeaderRead;
    }

    public boolean isLeader(long regionId) {
        this.checkState();
        RegionEngine regionEngine = this.getRegionEngine(regionId);
        return regionEngine != null && regionEngine.isLeader();
    }

    private void checkState() {
        if (!this.started) {
            throw new RheaRuntimeException("rhea kv is not started or shutdown");
        }
    }

    private RegionEngine getRegionEngine(long regionId) {
        if (this.storeEngine == null) {
            return null;
        }
        return this.storeEngine.getRegionEngine(regionId);
    }

    private RegionEngine getRegionEngine(long regionId, boolean requireLeader) {
        RegionEngine engine = this.getRegionEngine(regionId);
        if (engine == null) {
            return null;
        }
        if (requireLeader && !engine.isLeader()) {
            return null;
        }
        return engine;
    }

    private Endpoint getLeaderByRegionEngine(long regionId) {
        PeerId leader;
        RegionEngine regionEngine = this.getRegionEngine(regionId);
        if (regionEngine != null && (leader = regionEngine.getLeaderId()) != null) {
            String raftGroupId = JRaftHelper.getJRaftGroupId(this.pdClient.getClusterName(), regionId);
            RouteTable.getInstance().updateLeader(raftGroupId, leader);
            return leader.getEndpoint();
        }
        return null;
    }

    private RawKVStore getRawKVStore(RegionEngine engine) {
        return engine.getMetricsRawKVStore();
    }

    private static boolean ensureOnValidEpoch(Region region, RegionEngine engine, KVStoreClosure closure) {
        if (DefaultRheaKVStore.isValidEpoch(region, engine)) {
            return true;
        }
        closure.setError(Errors.INVALID_REGION_EPOCH);
        closure.run(new Status(-1, "Invalid region epoch: %s", new Object[]{region}));
        return false;
    }

    private static boolean isValidEpoch(Region region, RegionEngine engine) {
        return region.getRegionEpoch().equals(engine.getRegion().getRegionEpoch());
    }

    static {
        ExtSerializerSupports.init();
    }

    private static abstract class Batching<T, E, F> {
        protected final String name;
        protected final Disruptor<T> disruptor;
        protected final RingBuffer<T> ringBuffer;

        public Batching(EventFactory<T> factory, int bufSize, String name, EventHandler<T> handler) {
            this.name = name;
            this.disruptor = new Disruptor(factory, bufSize, (ThreadFactory)new NamedThreadFactory(name, true));
            this.disruptor.handleEventsWith(new EventHandler[]{handler});
            this.disruptor.setDefaultExceptionHandler((ExceptionHandler)new LogExceptionHandler(name));
            this.ringBuffer = this.disruptor.start();
        }

        public abstract boolean apply(E var1, CompletableFuture<F> var2);

        public void shutdown() {
            try {
                this.disruptor.shutdown(3L, TimeUnit.SECONDS);
            }
            catch (Exception e) {
                LOG.error("Fail to shutdown {}, {}.", (Object)this.toString(), (Object)StackTraceUtil.stackTrace(e));
            }
        }

        public String toString() {
            return "Batching{name='" + this.name + '\'' + ", disruptor=" + this.disruptor + '}';
        }
    }

    private static class KVEvent
    implements Event {
        private KVEntry kvEntry;
        private CompletableFuture<Boolean> future;

        private KVEvent() {
        }

        @Override
        public void reset() {
            this.kvEntry = null;
            this.future = null;
        }
    }

    private static class KeyEvent
    implements Event {
        private byte[] key;
        private CompletableFuture<byte[]> future;

        private KeyEvent() {
        }

        @Override
        public void reset() {
            this.key = null;
            this.future = null;
        }

        static /* synthetic */ byte[] access$302(KeyEvent x0, byte[] x1) {
            x0.key = x1;
            return x1;
        }
    }

    private static interface Event {
        public void reset();
    }

    private abstract class AbstractBatchingHandler<T extends Event>
    implements EventHandler<T> {
        protected final Histogram histogramWithKeys;
        protected final Histogram histogramWithBytes;
        protected final List<T> events;
        protected int cachedBytes;

        public AbstractBatchingHandler(String metricsName) {
            this.events = Lists.newArrayListWithCapacity(DefaultRheaKVStore.this.batchingOpts.getBatchSize());
            this.cachedBytes = 0;
            this.histogramWithKeys = KVMetrics.histogram("send_batching", metricsName + "_keys");
            this.histogramWithBytes = KVMetrics.histogram("send_batching", metricsName + "_bytes");
        }

        public void exceptionally(Throwable t, CompletableFuture<?> ... futures) {
            for (int i = 0; i < futures.length; ++i) {
                futures[i].completeExceptionally(t);
            }
        }

        public void reset() {
            this.histogramWithKeys.update(this.events.size());
            this.histogramWithBytes.update(this.cachedBytes);
            for (Event event : this.events) {
                event.reset();
            }
            this.events.clear();
            this.cachedBytes = 0;
        }
    }

    private class PutBatchingHandler
    extends AbstractBatchingHandler<KVEvent> {
        public PutBatchingHandler(String metricsName) {
            super(metricsName);
        }

        public void onEvent(KVEvent event, long sequence, boolean endOfBatch) throws Exception {
            this.events.add(event);
            this.cachedBytes += event.kvEntry.length();
            int size = this.events.size();
            if (!endOfBatch && size < DefaultRheaKVStore.this.batchingOpts.getBatchSize() && this.cachedBytes < DefaultRheaKVStore.this.batchingOpts.getMaxWriteBytes()) {
                return;
            }
            if (size == 1) {
                KVEntry kv = event.kvEntry;
                try {
                    DefaultRheaKVStore.this.put(kv.getKey(), kv.getValue(), event.future, false);
                }
                catch (Throwable t) {
                    this.exceptionally(t, event.future);
                }
                this.reset();
            } else {
                ArrayList<KVEntry> entries = Lists.newArrayListWithCapacity(size);
                CompletableFuture[] futures = new CompletableFuture[size];
                for (int i = 0; i < size; ++i) {
                    KVEvent e = (KVEvent)this.events.get(i);
                    entries.add(e.kvEntry);
                    futures[i] = e.future;
                }
                this.reset();
                try {
                    DefaultRheaKVStore.this.put(entries).whenComplete((result, throwable) -> {
                        if (throwable == null) {
                            for (int i = 0; i < futures.length; ++i) {
                                futures[i].complete(result);
                            }
                            return;
                        }
                        this.exceptionally((Throwable)throwable, futures);
                    });
                }
                catch (Throwable t) {
                    this.exceptionally(t, futures);
                }
            }
        }
    }

    private class GetBatchingHandler
    extends AbstractBatchingHandler<KeyEvent> {
        private final boolean readOnlySafe;

        private GetBatchingHandler(String metricsName, boolean readOnlySafe) {
            super(metricsName);
            this.readOnlySafe = readOnlySafe;
        }

        public void onEvent(KeyEvent event, long sequence, boolean endOfBatch) throws Exception {
            this.events.add(event);
            this.cachedBytes += event.key.length;
            int size = this.events.size();
            if (!endOfBatch && size < DefaultRheaKVStore.this.batchingOpts.getBatchSize() && this.cachedBytes < DefaultRheaKVStore.this.batchingOpts.getMaxReadBytes()) {
                return;
            }
            if (size == 1) {
                try {
                    DefaultRheaKVStore.this.get(event.key, this.readOnlySafe, event.future, false);
                }
                catch (Throwable t) {
                    this.exceptionally(t, event.future);
                }
                this.reset();
            } else {
                ArrayList<byte[]> keys = Lists.newArrayListWithCapacity(size);
                CompletableFuture[] futures = new CompletableFuture[size];
                for (int i = 0; i < size; ++i) {
                    KeyEvent e = (KeyEvent)this.events.get(i);
                    keys.add(e.key);
                    futures[i] = e.future;
                }
                this.reset();
                try {
                    DefaultRheaKVStore.this.multiGet(keys, this.readOnlySafe).whenComplete((result, throwable) -> {
                        if (throwable == null) {
                            for (int i = 0; i < futures.length; ++i) {
                                ByteArray realKey = ByteArray.wrap((byte[])keys.get(i));
                                futures[i].complete(result.get(realKey));
                            }
                            return;
                        }
                        this.exceptionally((Throwable)throwable, futures);
                    });
                }
                catch (Throwable t) {
                    this.exceptionally(t, futures);
                }
            }
        }
    }

    private class PutBatching
    extends Batching<KVEvent, KVEntry, Boolean> {
        public PutBatching(EventFactory<KVEvent> factory, String name, PutBatchingHandler handler) {
            super(factory, DefaultRheaKVStore.this.batchingOpts.getBufSize(), name, handler);
        }

        @Override
        public boolean apply(KVEntry message, CompletableFuture<Boolean> future) {
            return this.ringBuffer.tryPublishEvent((event, sequence) -> {
                event.reset();
                ((KVEvent)event).kvEntry = message;
                ((KVEvent)event).future = future;
            });
        }
    }

    private class GetBatching
    extends Batching<KeyEvent, byte[], byte[]> {
        public GetBatching(EventFactory<KeyEvent> factory, String name, EventHandler<KeyEvent> handler) {
            super(factory, DefaultRheaKVStore.this.batchingOpts.getBufSize(), name, handler);
        }

        @Override
        public boolean apply(byte[] message, CompletableFuture<byte[]> future) {
            return this.ringBuffer.tryPublishEvent((event, sequence) -> {
                event.reset();
                KeyEvent.access$302(event, message);
                ((KeyEvent)event).future = future;
            });
        }
    }
}

