/*
 * Decompiled with CFR 0.152.
 */
package org.apache.rocketmq.mqtt.cs.session.infly;

import io.netty.channel.Channel;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelFutureListener;
import io.netty.handler.codec.mqtt.MqttPublishMessage;
import io.netty.util.concurrent.GenericFutureListener;
import java.util.List;
import javax.annotation.Resource;
import org.apache.commons.lang3.StringUtils;
import org.apache.rocketmq.mqtt.common.model.Message;
import org.apache.rocketmq.mqtt.common.model.Queue;
import org.apache.rocketmq.mqtt.common.model.Subscription;
import org.apache.rocketmq.mqtt.common.util.TopicUtils;
import org.apache.rocketmq.mqtt.cs.channel.ChannelInfo;
import org.apache.rocketmq.mqtt.cs.config.ConnectConf;
import org.apache.rocketmq.mqtt.cs.protocol.mqtt.facotry.MqttMessageFactory;
import org.apache.rocketmq.mqtt.cs.session.Session;
import org.apache.rocketmq.mqtt.cs.session.infly.InFlyCache;
import org.apache.rocketmq.mqtt.cs.session.infly.MqttMsgId;
import org.apache.rocketmq.mqtt.cs.session.infly.RetryDriver;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class PushAction {
    private static Logger logger = LoggerFactory.getLogger(PushAction.class);
    @Resource
    private MqttMsgId mqttMsgId;
    @Resource
    private RetryDriver retryDriver;
    @Resource
    private InFlyCache inFlyCache;
    @Resource
    private ConnectConf connectConf;

    public void messageArrive(Session session, Subscription subscription, Queue queue) {
        if (session == null) {
            return;
        }
        if (!this.connectConf.isOrder()) {
            List<Message> list = session.pendMessageList(subscription, queue);
            if (list != null && !list.isEmpty()) {
                for (Message message : list) {
                    message.setAck(0);
                    this.push(message, subscription, session, queue);
                }
            }
            return;
        }
        if (this.retryDriver.needRetryBefore(subscription, queue, session)) {
            return;
        }
        Message message = session.nextSendMessageByOrder(subscription, queue);
        if (message != null) {
            this.push(message, subscription, session, queue);
        }
    }

    public void push(Message message, Subscription subscription, Session session, Queue queue) {
        String clientId = session.getClientId();
        int mqttId = this.mqttMsgId.nextId(clientId);
        this.inFlyCache.getPendingDownCache().put(session.getChannelId(), mqttId, subscription, queue, message);
        try {
            if (session.isClean() && message.getStoreTimestamp() > 0L && message.getStoreTimestamp() < session.getStartTime()) {
                logger.warn("old msg:{},{},{},{}", new Object[]{session.getClientId(), message.getMsgId(), message.getStoreTimestamp(), session.getStartTime()});
                this.rollNext(session, mqttId);
                return;
            }
        }
        catch (Exception e) {
            logger.error("", (Throwable)e);
        }
        String msgPayLoad = new String(message.getPayload());
        if (msgPayLoad.equals("\u2605\r\n\t\u2600") && message.isEmpty()) {
            message.setPayload("".getBytes());
        }
        int qos = subscription.getQos();
        if (subscription.isP2p() && message.qos() != null) {
            qos = message.qos();
        }
        if (qos == 0) {
            this.write(session, message, mqttId, 0, subscription);
            this.rollNextByAck(session, mqttId);
        } else {
            this.retryDriver.mountPublish(mqttId, message, subscription.getQos(), ChannelInfo.getId(session.getChannel()), subscription);
            this.write(session, message, mqttId, qos, subscription);
        }
    }

    public void _sendMessage(Session session, String clientId, Subscription subscription, Message message) {
        String payLoad = new String(message.getPayload());
        if (payLoad.equals("\u2605\r\n\t\u2600") && message.isEmpty()) {
            return;
        }
        int mqttId = this.mqttMsgId.nextId(clientId);
        int qos = Math.min(subscription.getQos(), message.qos());
        if (qos == 0) {
            this.write(session, message, mqttId, 0, subscription);
            this.rollNextByAck(session, mqttId);
        } else {
            this.retryDriver.mountPublish(mqttId, message, subscription.getQos(), ChannelInfo.getId(session.getChannel()), subscription);
            this.write(session, message, mqttId, qos, subscription);
        }
    }

    public void write(Session session, Message message, int mqttId, int qos, Subscription subscription) {
        Channel channel = session.getChannel();
        String owner = ChannelInfo.getOwner(channel);
        String clientId = session.getClientId();
        String topicName = message.getOriginTopic();
        String mqttRealTopic = message.getUserProperty(Message.extPropertyMqttRealTopic);
        boolean retained = message.isRetained();
        if (StringUtils.isNotBlank((CharSequence)mqttRealTopic)) {
            topicName = mqttRealTopic;
        }
        if (StringUtils.isBlank((CharSequence)topicName)) {
            topicName = message.getFirstTopic();
        }
        boolean isP2P = TopicUtils.isP2P((String)TopicUtils.decode((String)topicName).getSecondTopic());
        if (!channel.isWritable()) {
            logger.error("UnWritable:{}", (Object)clientId);
            return;
        }
        MqttPublishMessage data = MqttMessageFactory.buildPublishMessage(topicName, message.getPayload(), qos, mqttId);
        ChannelFuture writeFuture = session.getChannel().writeAndFlush((Object)data);
        int bodySize = message.getPayload() != null ? message.getPayload().length : 0;
        writeFuture.addListener((GenericFutureListener)((ChannelFutureListener)future -> {
            if (subscription.isRetry()) {
                message.setRetry(message.getRetry() + 1);
                logger.warn("retryPush:{},{},{}", new Object[]{session.getClientId(), message.getMsgId(), message.getRetry()});
            }
        }));
    }

    public void rollNextByAck(Session session, int mqttId) {
        if (session == null) {
            return;
        }
        this.mqttMsgId.releaseId(mqttId, session.getClientId());
        InFlyCache.PendingDown pendingDown = this.inFlyCache.getPendingDownCache().get(session.getChannelId(), mqttId);
        if (pendingDown == null) {
            return;
        }
        this.rollNext(session, mqttId);
    }

    public void rollNext(Session session, int mqttId) {
        if (session == null) {
            return;
        }
        this.mqttMsgId.releaseId(mqttId, session.getClientId());
        InFlyCache.PendingDown pendingDown = this.inFlyCache.getPendingDownCache().remove(session.getChannelId(), mqttId);
        if (pendingDown == null) {
            return;
        }
        this._rollNext(session, pendingDown);
    }

    public void rollNextNoWaitRetry(Session session, int mqttId) {
        if (session == null || session.isDestroyed()) {
            return;
        }
        InFlyCache.PendingDown pendingDown = this.inFlyCache.getPendingDownCache().get(session.getChannelId(), mqttId);
        if (pendingDown == null) {
            return;
        }
        this._rollNext(session, pendingDown);
    }

    public void _rollNext(Session session, InFlyCache.PendingDown pendingDown) {
        Subscription subscription = pendingDown.getSubscription();
        Queue pendingQueue = pendingDown.getQueue();
        long pendingDownSeqId = pendingDown.getSeqId();
        if (!this.connectConf.isOrder()) {
            session.ack(subscription, pendingQueue, pendingDownSeqId);
            return;
        }
        Message nextSendOne = session.rollNext(subscription, pendingQueue, pendingDownSeqId);
        if (nextSendOne != null) {
            this.push(nextSendOne, subscription, session, pendingQueue);
        }
    }
}

