/*
 * Decompiled with CFR 0.152.
 */
package org.apache.rocketmq.mqtt.cs.session.infly;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import javax.annotation.PostConstruct;
import org.apache.commons.lang3.StringUtils;
import org.springframework.stereotype.Component;

@Component
public class MqttMsgId {
    private static final int MAX_MSG_ID = 65535;
    private static final int MIN_MSG_ID = 1;
    private static final int ID_POOL_SIZE = 8192;
    private static final List<MsgIdEntry> ID_POOL = new ArrayList<MsgIdEntry>(8192);

    @PostConstruct
    public void init() {
        for (int i = 0; i < 8192; ++i) {
            ID_POOL.add(new MsgIdEntry());
        }
    }

    private MsgIdEntry hashMsgID(String clientId) {
        int hashCode = clientId.hashCode();
        if (hashCode < 0) {
            hashCode *= -1;
        }
        return ID_POOL.get(hashCode % 8192);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int nextId(String clientId) {
        MsgIdEntry msgIdEntry;
        MsgIdEntry msgIdEntry2 = msgIdEntry = this.hashMsgID(clientId);
        synchronized (msgIdEntry2) {
            int startingMessageId = msgIdEntry.nextMsgId;
            do {
                msgIdEntry.nextMsgId++;
                if (msgIdEntry.nextMsgId > 65535) {
                    msgIdEntry.nextMsgId = 1;
                }
                if (msgIdEntry.nextMsgId != startingMessageId) continue;
                msgIdEntry.inUseMsgIds.clear();
                break;
            } while (msgIdEntry.inUseMsgIds.containsKey(msgIdEntry.nextMsgId));
            Integer id = msgIdEntry.nextMsgId;
            msgIdEntry.inUseMsgIds.put(id, id);
            return msgIdEntry.nextMsgId;
        }
    }

    public void releaseId(int msgId, String clientId) {
        if (StringUtils.isBlank((CharSequence)clientId)) {
            return;
        }
        MsgIdEntry msgIdEntry = this.hashMsgID(clientId);
        msgIdEntry.inUseMsgIds.remove(msgId);
    }

    class MsgIdEntry {
        private int nextMsgId = 0;
        private Map<Integer, Integer> inUseMsgIds = new ConcurrentHashMap<Integer, Integer>();

        MsgIdEntry() {
        }
    }
}

