/*
 * Decompiled with CFR 0.152.
 */
package org.apache.rocketmq.mqtt.cs.config;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.Properties;
import org.apache.rocketmq.common.MixAll;
import org.springframework.core.io.ClassPathResource;
import org.springframework.stereotype.Component;

@Component
public class ConnectConf {
    private static final String CONF_FILE_NAME = "connect.conf";
    private File confFile;
    private int nettySelectorThreadNum = 1;
    private int nettyWorkerThreadNum = Runtime.getRuntime().availableProcessors() * 2;
    private int mqttPort = 1883;
    private int mqttTlsPort = 8883;
    private int mqttWsPort = 8888;
    private boolean enableTlsSever = false;
    private boolean needClientAuth = false;
    private int maxPacketSizeInByte = 65536;
    private int highWater = 262144;
    private int lowWater = 16384;
    private int maxConn = 100000;
    private boolean order;
    private int maxRetryTime = 15;
    private int sizeOfNotRollWhenAckSlow = 32;
    private int queueCacheSize = 128;
    private int pullBatchSize = 32;
    private int rpcListenPort = 7001;
    private int retryIntervalSeconds = 3;
    private int exporterPort = 9090;
    private boolean enablePrometheus = false;
    private boolean exportJvmInfo = true;

    public ConnectConf() throws IOException {
        ClassPathResource classPathResource = new ClassPathResource(CONF_FILE_NAME);
        InputStream in = classPathResource.getInputStream();
        Properties properties = new Properties();
        properties.load(in);
        in.close();
        MixAll.properties2Object((Properties)properties, (Object)this);
        this.confFile = new File(classPathResource.getURL().getFile());
    }

    public File getConfFile() {
        return this.confFile;
    }

    public int getNettySelectorThreadNum() {
        return this.nettySelectorThreadNum;
    }

    public void setNettySelectorThreadNum(int nettySelectorThreadNum) {
        this.nettySelectorThreadNum = nettySelectorThreadNum;
    }

    public int getNettyWorkerThreadNum() {
        return this.nettyWorkerThreadNum;
    }

    public void setNettyWorkerThreadNum(int nettyWorkerThreadNum) {
        this.nettyWorkerThreadNum = nettyWorkerThreadNum;
    }

    public int getMqttPort() {
        return this.mqttPort;
    }

    public int getMqttTlsPort() {
        return this.mqttTlsPort;
    }

    public void setMqttPort(int mqttPort) {
        this.mqttPort = mqttPort;
    }

    public int getMqttWsPort() {
        return this.mqttWsPort;
    }

    public boolean isEnableTlsSever() {
        return this.enableTlsSever;
    }

    public boolean isNeedClientAuth() {
        return this.needClientAuth;
    }

    public void setMqttWsPort(int mqttWsPort) {
        this.mqttWsPort = mqttWsPort;
    }

    public int getMaxPacketSizeInByte() {
        return this.maxPacketSizeInByte;
    }

    public void setMaxPacketSizeInByte(int maxPacketSizeInByte) {
        this.maxPacketSizeInByte = maxPacketSizeInByte;
    }

    public int getHighWater() {
        return this.highWater;
    }

    public void setHighWater(int highWater) {
        this.highWater = highWater;
    }

    public int getLowWater() {
        return this.lowWater;
    }

    public void setLowWater(int lowWater) {
        this.lowWater = lowWater;
    }

    public int getMaxConn() {
        return this.maxConn;
    }

    public void setMaxConn(int maxConn) {
        this.maxConn = maxConn;
    }

    public boolean isOrder() {
        return this.order;
    }

    public void setOrder(boolean order) {
        this.order = order;
    }

    public int getMaxRetryTime() {
        return this.maxRetryTime;
    }

    public void setMaxRetryTime(int maxRetryTime) {
        this.maxRetryTime = maxRetryTime;
    }

    public int getSizeOfNotRollWhenAckSlow() {
        return this.sizeOfNotRollWhenAckSlow;
    }

    public void setSizeOfNotRollWhenAckSlow(int sizeOfNotRollWhenAckSlow) {
        this.sizeOfNotRollWhenAckSlow = sizeOfNotRollWhenAckSlow;
    }

    public int getPullBatchSize() {
        return this.pullBatchSize;
    }

    public void setPullBatchSize(int pullBatchSize) {
        this.pullBatchSize = pullBatchSize;
    }

    public int getQueueCacheSize() {
        return this.queueCacheSize;
    }

    public void setQueueCacheSize(int queueCacheSize) {
        this.queueCacheSize = queueCacheSize;
    }

    public int getRpcListenPort() {
        return this.rpcListenPort;
    }

    public void setRpcListenPort(int rpcListenPort) {
        this.rpcListenPort = rpcListenPort;
    }

    public int getRetryIntervalSeconds() {
        return this.retryIntervalSeconds;
    }

    public void setRetryIntervalSeconds(int retryIntervalSeconds) {
        this.retryIntervalSeconds = retryIntervalSeconds;
    }

    public int getExporterPort() {
        return this.exporterPort;
    }

    public void setExporterPort(int exporterPort) {
        this.exporterPort = exporterPort;
    }

    public boolean isEnablePrometheus() {
        return this.enablePrometheus;
    }

    public void setEnablePrometheus(boolean enablePrometheus) {
        this.enablePrometheus = enablePrometheus;
    }

    public boolean isExportJvmInfo() {
        return this.exportJvmInfo;
    }

    public void setExportJvmInfo(boolean exportJvmInfo) {
        this.exportJvmInfo = exportJvmInfo;
    }
}

