/*
 * Decompiled with CFR 0.152.
 */
package org.apache.rocketmq.mqtt.cs.channel;

import com.alibaba.fastjson.JSON;
import io.netty.channel.Channel;
import io.netty.util.Attribute;
import io.netty.util.AttributeKey;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.apache.commons.lang3.StringUtils;

public class ChannelInfo {
    private static final String CHANNEL_ID_KEY = "0";
    private static final String CHANNEL_CLIENT_ID_KEY = "1";
    private static final String CHANNEL_TIMESTAMP_KEY = "2";
    private static final String CHANNEL_KEEPLIVE_KEY = "3";
    private static final String CHANNEL_OWNER_KEY = "4";
    private static final String CHANNEL_NAMESPACE_KEY = "5";
    private static final String CHANNEL_EXT_CHANGE_KEY = "6";
    private static final String CHANNEL_STORE_NAMESPACE_KEY = "7";
    private static final String CHANNEL_CLEAN_SESSION_KEY = "8";
    private static final String CHANNEL_SUB_NUM_KEY = "9";
    private static final String CHANNEL_FUTRUE_KEY = "10";
    private static final String CHANNEL_LIFE_CYCLE = "11";
    private static final String CHANNEL_LAST_ACTIVE_TIMESTAMP_KEY = "12";
    private static final String CHANNEL_IS_FLUSHING = "13";
    private static final String CHANNEL_REMOTE_IP = "14";
    private static final String CHANNEL_TUNNEL_ID = "15";
    public static final String FUTURE_CONNECT = "connect";
    public static final String FUTURE_SUBSCRIBE = "subscribe";
    public static final AttributeKey<Map<String, Object>> CHANNEL_INFO_ATTRIBUTE_KEY = AttributeKey.valueOf((String)"I");
    public static final AttributeKey<ConcurrentMap<String, String>> CHANNEL_EXTDATA_ATTRIBUTE_KEY = AttributeKey.valueOf((String)"E");
    public static final AttributeKey<String> CHANNEL_GA_ATTRIBUTE_KEY = AttributeKey.valueOf((String)"GA");

    public static Map<String, String> getExtData(Channel channel) {
        Attribute extAttribute = channel.attr(CHANNEL_EXTDATA_ATTRIBUTE_KEY);
        if (extAttribute.get() == null) {
            extAttribute.setIfAbsent(new ConcurrentHashMap());
        }
        return (Map)extAttribute.get();
    }

    public static String encodeExtData(Channel channel) {
        Map<String, String> extData = ChannelInfo.getExtData(channel);
        return JSON.toJSONString(extData);
    }

    public static boolean updateExtData(Channel channel, String extDataStr) {
        if (StringUtils.isBlank((CharSequence)extDataStr)) {
            return false;
        }
        ChannelInfo.updateExtData(channel, (Map)JSON.parseObject((String)extDataStr, Map.class));
        return true;
    }

    private static void updateExtData(Channel channel, Map<String, String> extData) {
        Map<String, String> currentExt = ChannelInfo.getExtData(channel);
        currentExt.putAll(extData);
        ChannelInfo.setExtDataChange(channel, true);
    }

    public static void setExtDataChange(Channel channel, boolean flag) {
        ChannelInfo.getInfo(channel).put(CHANNEL_EXT_CHANGE_KEY, flag);
    }

    public static boolean checkExtDataChange(Channel channel) {
        Object obj;
        if (!ChannelInfo.getInfo(channel).containsKey(CHANNEL_EXT_CHANGE_KEY)) {
            ChannelInfo.getInfo(channel).put(CHANNEL_EXT_CHANGE_KEY, false);
        }
        if ((obj = ChannelInfo.getInfo(channel).get(CHANNEL_EXT_CHANGE_KEY)) == null) {
            return false;
        }
        return (Boolean)obj;
    }

    public static String getId(Channel channel) {
        Map<String, Object> info = ChannelInfo.getInfo(channel);
        if (info.containsKey(CHANNEL_ID_KEY)) {
            return (String)info.get(CHANNEL_ID_KEY);
        }
        String channelIdStr = UUID.randomUUID().toString().replaceAll("-", "").toLowerCase();
        info.put(CHANNEL_ID_KEY, channelIdStr);
        return channelIdStr;
    }

    public static Boolean getCleanSessionFlag(Channel channel) {
        Object obj;
        if (!ChannelInfo.getInfo(channel).containsKey(CHANNEL_CLEAN_SESSION_KEY)) {
            ChannelInfo.getInfo(channel).put(CHANNEL_CLEAN_SESSION_KEY, true);
        }
        if ((obj = ChannelInfo.getInfo(channel).get(CHANNEL_CLEAN_SESSION_KEY)) == null) {
            return true;
        }
        return (Boolean)obj;
    }

    public static void setCleanSessionFlag(Channel channel, Boolean cleanSessionFalg) {
        ChannelInfo.getInfo(channel).put(CHANNEL_CLEAN_SESSION_KEY, cleanSessionFalg);
    }

    public static String getClientId(Channel channel) {
        return (String)ChannelInfo.getInfo(channel).get(CHANNEL_CLIENT_ID_KEY);
    }

    public static long getChannelLifeCycle(Channel channel) {
        Long expireTime = (Long)ChannelInfo.getInfo(channel).get(CHANNEL_LIFE_CYCLE);
        if (expireTime == null) {
            return Long.MAX_VALUE;
        }
        return expireTime;
    }

    public static void setChannelLifeCycle(Channel channel, Long expireTime) {
        ChannelInfo.getInfo(channel).put(CHANNEL_LIFE_CYCLE, expireTime == null ? Long.MAX_VALUE : expireTime);
    }

    public static void setFuture(Channel channel, String futureKey, CompletableFuture<Void> future) {
        ChannelInfo.getInfo(channel).put(CHANNEL_FUTRUE_KEY + futureKey, future);
    }

    public static CompletableFuture<Void> getFuture(Channel channel, String futureKey) {
        Object future = ChannelInfo.getInfo(channel).get(CHANNEL_FUTRUE_KEY + futureKey);
        if (future != null) {
            return (CompletableFuture)future;
        }
        return null;
    }

    public static void removeFuture(Channel channel, String futureKey) {
        ChannelInfo.getInfo(channel).remove(CHANNEL_FUTRUE_KEY + futureKey);
    }

    public static void setClientId(Channel channel, String clientId) {
        ChannelInfo.getInfo(channel).put(CHANNEL_CLIENT_ID_KEY, clientId);
    }

    public static void touch(Channel channel) {
        ChannelInfo.getInfo(channel).put(CHANNEL_TIMESTAMP_KEY, System.currentTimeMillis());
    }

    public static long getLastTouch(Channel channel) {
        Object t = ChannelInfo.getInfo(channel).get(CHANNEL_TIMESTAMP_KEY);
        return t != null ? (Long)t : 0L;
    }

    public static void lastActive(Channel channel, long timeStamp) {
        ChannelInfo.getInfo(channel).put(CHANNEL_LAST_ACTIVE_TIMESTAMP_KEY, timeStamp);
    }

    public static long getLastActive(Channel channel) {
        Object t = ChannelInfo.getInfo(channel).get(CHANNEL_LAST_ACTIVE_TIMESTAMP_KEY);
        return t != null ? (Long)t : 0L;
    }

    public static void setRemoteIP(Channel channel, String ip) {
        ChannelInfo.getInfo(channel).put(CHANNEL_REMOTE_IP, ip);
    }

    public static String getRemoteIP(Channel channel) {
        Object t = ChannelInfo.getInfo(channel).get(CHANNEL_REMOTE_IP);
        return t == null ? "" : (String)t;
    }

    public static void setKeepLive(Channel channel, int seconds) {
        ChannelInfo.getInfo(channel).put(CHANNEL_KEEPLIVE_KEY, seconds);
    }

    public static Integer getKeepLive(Channel channel) {
        return (Integer)ChannelInfo.getInfo(channel).get(CHANNEL_KEEPLIVE_KEY);
    }

    public static boolean isExpired(Channel channel) {
        Long timestamp = (Long)ChannelInfo.getInfo(channel).get(CHANNEL_TIMESTAMP_KEY);
        if (timestamp == null) {
            return true;
        }
        Integer keepLiveT = ChannelInfo.getKeepLive(channel);
        if (keepLiveT == null) {
            return true;
        }
        return (double)(System.currentTimeMillis() - timestamp) > (double)((long)keepLiveT.intValue() * 1000L) * 1.5;
    }

    public static void setOwner(Channel channel, String owner) {
        ChannelInfo.getInfo(channel).put(CHANNEL_OWNER_KEY, owner);
    }

    public static String getOwner(Channel channel) {
        return (String)ChannelInfo.getInfo(channel).get(CHANNEL_OWNER_KEY);
    }

    public static void setNamespace(Channel channel, String namespace) {
        ChannelInfo.getInfo(channel).put(CHANNEL_NAMESPACE_KEY, namespace);
    }

    public static String getNamespace(Channel channel) {
        return (String)ChannelInfo.getInfo(channel).get(CHANNEL_NAMESPACE_KEY);
    }

    public static void clear(Channel channel) {
        String channelId = ChannelInfo.getId(channel);
        String namespace = ChannelInfo.getNamespace(channel);
        ConcurrentHashMap<String, String> newInfoAttribute = new ConcurrentHashMap<String, String>(8);
        newInfoAttribute.put(CHANNEL_ID_KEY, channelId);
        if (namespace != null) {
            newInfoAttribute.put(CHANNEL_NAMESPACE_KEY, namespace);
        }
        channel.attr(CHANNEL_INFO_ATTRIBUTE_KEY).set(newInfoAttribute);
        channel.attr(CHANNEL_EXTDATA_ATTRIBUTE_KEY).set(null);
    }

    public static Map<String, Object> getInfo(Channel channel) {
        Attribute infoAttribute = channel.attr(CHANNEL_INFO_ATTRIBUTE_KEY);
        if (infoAttribute.get() == null) {
            infoAttribute.setIfAbsent(new ConcurrentHashMap(8));
        }
        return (Map)infoAttribute.get();
    }
}

