/*
 * Decompiled with CFR 0.152.
 */
package org.apache.rocketmq.mqtt.meta.raft.processor;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.serializer.SerializerFeature;
import com.google.protobuf.ByteString;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.rocketmq.mqtt.common.model.Trie;
import org.apache.rocketmq.mqtt.common.model.consistency.ReadRequest;
import org.apache.rocketmq.mqtt.common.model.consistency.Response;
import org.apache.rocketmq.mqtt.common.model.consistency.WriteRequest;
import org.apache.rocketmq.mqtt.common.util.TopicUtils;
import org.apache.rocketmq.mqtt.meta.raft.MqttRaftServer;
import org.apache.rocketmq.mqtt.meta.raft.MqttStateMachine;
import org.apache.rocketmq.mqtt.meta.raft.processor.StateProcessor;
import org.apache.rocketmq.mqtt.meta.rocksdb.RocksDBEngine;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RetainedMsgStateProcessor
extends StateProcessor {
    private static Logger logger = LoggerFactory.getLogger(RetainedMsgStateProcessor.class);
    private final ConcurrentHashMap<String, Trie<String, String>> retainedMsgTopicTrie = new ConcurrentHashMap();
    private MqttRaftServer server;
    private int maxRetainedTopicNum;

    public RetainedMsgStateProcessor(MqttRaftServer server, int maxRetainedTopicNum) {
        this.server = server;
        this.maxRetainedTopicNum = maxRetainedTopicNum;
    }

    @Override
    public Response onReadRequest(ReadRequest request) {
        try {
            MqttStateMachine sm = this.server.getMqttStateMachine(request.getGroup());
            if (sm == null) {
                logger.error("Fail to process RetainedMsg ReadRequest , Not Found SM for {}", (Object)request.getGroup());
                return null;
            }
            String topic = (String)request.getExtDataMap().get("topic");
            String firstTopic = (String)request.getExtDataMap().get("firstTopic");
            String operation = request.getOperation();
            logger.info("FirstTopic:{} Topic:{} Operation:{}", new Object[]{firstTopic, topic, operation});
            if (operation.equals("topic")) {
                return this.get(sm.getRocksDBEngine(), topic.getBytes(StandardCharsets.UTF_8));
            }
            String wrapTrieFirstTopic = this.wrapTrieFirstTopic(firstTopic);
            if (!this.retainedMsgTopicTrie.containsKey(wrapTrieFirstTopic)) {
                Trie newTrie = new Trie();
                byte[] value = this.getRdb(sm.getRocksDBEngine(), wrapTrieFirstTopic.getBytes(StandardCharsets.UTF_8));
                if (value != null) {
                    newTrie = (Trie)JSON.parseObject((String)new String(value, StandardCharsets.UTF_8), Trie.class);
                }
                this.retainedMsgTopicTrie.put(wrapTrieFirstTopic, (Trie<String, String>)newTrie);
                return Response.newBuilder().setSuccess(true).setData(ByteString.copyFrom((byte[])JSON.toJSONBytes(new ArrayList(), (SerializerFeature[])new SerializerFeature[0]))).build();
            }
            Trie<String, String> tmpTrie = this.retainedMsgTopicTrie.get(wrapTrieFirstTopic);
            Set matchTopics = tmpTrie.getAllPath(topic);
            ArrayList<ByteString> msgResults = new ArrayList<ByteString>();
            for (String tmpTopic : matchTopics) {
                byte[] value = this.getRdb(sm.getRocksDBEngine(), tmpTopic.getBytes(StandardCharsets.UTF_8));
                if (value == null) continue;
                msgResults.add(ByteString.copyFrom((byte[])value));
            }
            return Response.newBuilder().setSuccess(true).addAllDatalist(msgResults).build();
        }
        catch (Exception e) {
            logger.error("", (Throwable)e);
            return Response.newBuilder().setSuccess(false).setErrMsg(e.getMessage()).build();
        }
    }

    boolean setRetainedMsg(RocksDBEngine rocksDBEngine, String firstTopic, String topic, boolean isEmpty, byte[] msg) throws Exception {
        Trie<String, String> trie;
        String wrapTrieFirstTopic = this.wrapTrieFirstTopic(firstTopic);
        if (!this.retainedMsgTopicTrie.containsKey(wrapTrieFirstTopic)) {
            this.retainedMsgTopicTrie.put(wrapTrieFirstTopic, (Trie<String, String>)new Trie());
        }
        if (isEmpty) {
            logger.info("Delete the topic {} retained message", (Object)topic);
            this.delete(rocksDBEngine, topic.getBytes(StandardCharsets.UTF_8));
            trie = this.retainedMsgTopicTrie.get(wrapTrieFirstTopic);
            if (trie != null) {
                trie.deleteTrieNode(topic, (Object)"");
            }
        } else {
            Trie<String, String> trie2 = this.retainedMsgTopicTrie.get(wrapTrieFirstTopic);
            if (trie2.getNodePath().size() < this.maxRetainedTopicNum) {
                this.put(rocksDBEngine, topic.getBytes(StandardCharsets.UTF_8), msg);
                trie2.addNode(topic, (Object)"", (Object)"");
                this.put(rocksDBEngine, wrapTrieFirstTopic.getBytes(StandardCharsets.UTF_8), JSON.toJSONBytes(trie2, (SerializerFeature[])new SerializerFeature[0]));
                return true;
            }
            return false;
        }
        this.put(rocksDBEngine, wrapTrieFirstTopic.getBytes(StandardCharsets.UTF_8), JSON.toJSONBytes(trie, (SerializerFeature[])new SerializerFeature[0]));
        return true;
    }

    private String wrapTrieFirstTopic(String firstTopic) {
        return "$" + firstTopic + "$";
    }

    @Override
    public Response onWriteRequest(WriteRequest writeRequest) {
        try {
            MqttStateMachine sm = this.server.getMqttStateMachine(writeRequest.getGroup());
            if (sm == null) {
                logger.error("Fail to process RetainedMsg WriteRequest , Not Found SM for {}", (Object)writeRequest.getGroup());
                return null;
            }
            String firstTopic = TopicUtils.normalizeTopic((String)((String)writeRequest.getExtDataMap().get("firstTopic")));
            String topic = TopicUtils.normalizeTopic((String)((String)writeRequest.getExtDataMap().get("topic")));
            boolean isEmpty = Boolean.parseBoolean((String)writeRequest.getExtDataMap().get("isEmpty"));
            byte[] message = writeRequest.getData().toByteArray();
            boolean res = this.setRetainedMsg(sm.getRocksDBEngine(), firstTopic, topic, isEmpty, message);
            if (!res) {
                logger.warn("Put the topic {} retained message failed! Exceeded maximum number of reserved topics limit.", (Object)topic);
                return Response.newBuilder().setSuccess(false).setErrMsg("Exceeded maximum number of reserved topics limit.").build();
            }
            logger.info("Put the topic {} retained message success!", (Object)topic);
            return Response.newBuilder().setSuccess(true).setData(ByteString.copyFrom((byte[])JSON.toJSONBytes((Object)topic, (SerializerFeature[])new SerializerFeature[0]))).build();
        }
        catch (Exception e) {
            logger.error("Put the retained message error!", (Throwable)e);
            return Response.newBuilder().setSuccess(false).setErrMsg(e.getMessage()).build();
        }
    }

    @Override
    public String groupCategory() {
        return "retainedMsg";
    }
}

