/*
 * Decompiled with CFR 0.152.
 */
package org.apache.rocketmq.mqtt.meta.raft;

import com.alipay.sofa.jraft.Closure;
import com.alipay.sofa.jraft.Iterator;
import com.alipay.sofa.jraft.Node;
import com.alipay.sofa.jraft.Status;
import com.alipay.sofa.jraft.core.StateMachineAdapter;
import com.alipay.sofa.jraft.error.RaftError;
import com.alipay.sofa.jraft.storage.snapshot.SnapshotReader;
import com.alipay.sofa.jraft.storage.snapshot.SnapshotWriter;
import com.google.protobuf.Message;
import java.nio.ByteBuffer;
import java.util.Objects;
import java.util.Optional;
import org.apache.rocketmq.mqtt.common.model.consistency.ReadRequest;
import org.apache.rocketmq.mqtt.common.model.consistency.Response;
import org.apache.rocketmq.mqtt.common.model.consistency.WriteRequest;
import org.apache.rocketmq.mqtt.meta.raft.MqttClosure;
import org.apache.rocketmq.mqtt.meta.raft.MqttRaftServer;
import org.apache.rocketmq.mqtt.meta.raft.processor.StateProcessor;
import org.apache.rocketmq.mqtt.meta.rocksdb.RocksDBEngine;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MqttStateMachine
extends StateMachineAdapter {
    private static final Logger LOGGER = LoggerFactory.getLogger(MqttRaftServer.class);
    protected Node node;
    protected RocksDBEngine rocksDBEngine;
    protected final MqttRaftServer server;

    public MqttStateMachine(MqttRaftServer server) {
        this.server = server;
    }

    public void onApply(Iterator iterator) {
        int index = 0;
        int applied = 0;
        MqttClosure closure = null;
        try {
            while (iterator.hasNext()) {
                Status status = Status.OK();
                try {
                    Response response;
                    StateProcessor processor;
                    Message message;
                    if (iterator.done() != null) {
                        closure = (MqttClosure)iterator.done();
                        message = closure.getMessage();
                    } else {
                        ByteBuffer data = iterator.getData();
                        message = this.parseMessage(data.array());
                    }
                    LOGGER.debug("get message:{} and apply to state machine", (Object)message);
                    if (message instanceof WriteRequest) {
                        WriteRequest writeRequest = (WriteRequest)message;
                        processor = this.server.getProcessor(writeRequest.getCategory());
                        response = processor.onWriteRequest((WriteRequest)message);
                        if (Objects.nonNull(closure)) {
                            closure.setResponse(response);
                        }
                    }
                    if (message instanceof ReadRequest) {
                        ReadRequest request = (ReadRequest)message;
                        processor = this.server.getProcessor(request.getCategory());
                        response = processor.onReadRequest((ReadRequest)message);
                        if (Objects.nonNull(closure)) {
                            closure.setResponse(response);
                        }
                    }
                }
                catch (Throwable e) {
                    ++index;
                    status.setError(RaftError.UNKNOWN, e.toString(), new Object[0]);
                    Optional.ofNullable(closure).ifPresent(closure1 -> closure1.setThrowable(e));
                    throw e;
                }
                finally {
                    Optional.ofNullable(closure).ifPresent(closure1 -> closure1.run(status));
                }
                ++applied;
                ++index;
                iterator.next();
            }
        }
        catch (Throwable t) {
            LOGGER.error("stateMachine meet critical error", t);
        }
    }

    public void onSnapshotSave(SnapshotWriter writer, Closure done) {
        this.rocksDBEngine.getRocksDBSnapshot().onSnapshotSave(writer, done);
    }

    public boolean onSnapshotLoad(SnapshotReader reader) {
        return this.rocksDBEngine.getRocksDBSnapshot().onSnapshotLoad(reader);
    }

    public Message parseMessage(byte[] bytes) throws Exception {
        try {
            WriteRequest result = WriteRequest.parseFrom((byte[])bytes);
            return result;
        }
        catch (Throwable throwable) {
            try {
                ReadRequest result = ReadRequest.parseFrom((byte[])bytes);
                return result;
            }
            catch (Throwable throwable2) {
                throw new Exception("parse message from bytes error");
            }
        }
    }

    public void setNode(Node node) {
        this.node = node;
    }

    public Node getNode() {
        return this.node;
    }

    public void setRocksDBEngine(RocksDBEngine rocksDBEngine) {
        this.rocksDBEngine = rocksDBEngine;
    }

    public RocksDBEngine getRocksDBEngine() {
        return this.rocksDBEngine;
    }
}

