/*
 * Decompiled with CFR 0.152.
 */
package org.apache.rocketmq.mqtt.common.model;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.rocketmq.mqtt.common.model.TrieException;
import org.apache.rocketmq.mqtt.common.model.TrieMethod;
import org.apache.rocketmq.mqtt.common.util.TopicUtils;

public class Trie<K, V> {
    private TrieNode<K, V> rootNode = new TrieNode(null);
    private Set<String> nodePath = new HashSet<String>();

    public synchronized V addNode(String key, V nodeValue, K nodeKey) {
        try {
            String[] keyArray = key.split("/");
            TrieNode<K, V> currentNode = this.rootNode;
            for (int level = 0; level < keyArray.length; ++level) {
                TrieNode oldNode;
                TrieNode trieNode = currentNode.children.get(keyArray[level]);
                if (trieNode == null && (oldNode = currentNode.children.putIfAbsent(keyArray[level], trieNode = new TrieNode<K, V>(currentNode))) != null) {
                    trieNode = oldNode;
                }
                currentNode = trieNode;
            }
            currentNode.end = true;
            Object old = currentNode.valueSet.put(nodeKey, nodeValue);
            this.nodePath.add(key);
            return old;
        }
        catch (Throwable e) {
            throw new TrieException(e);
        }
    }

    public synchronized V deleteNode(String key, K valueKey) {
        try {
            TrieNode trieNode;
            int level;
            String[] keyArray = key.split("/");
            TrieNode<K, V> currentNode = this.rootNode;
            for (level = 0; level < keyArray.length && (trieNode = currentNode.children.get(keyArray[level])) != null; ++level) {
                currentNode = trieNode;
            }
            Object oldValue = currentNode.valueSet.remove(valueKey);
            while (currentNode.children.isEmpty() && currentNode.valueSet.isEmpty() && currentNode.parentNode != null) {
                currentNode.parentNode.children.remove(keyArray[--level]);
                currentNode = currentNode.parentNode;
            }
            return oldValue;
        }
        catch (Throwable e) {
            throw new TrieException(e);
        }
    }

    public synchronized boolean deleteTrieNode(String key, K valueKey) {
        try {
            TrieNode trieNode;
            int level;
            if (!this.nodePath.contains(key)) {
                return false;
            }
            String[] keyArray = key.split("/");
            TrieNode<K, V> currentNode = this.rootNode;
            for (level = 0; level < keyArray.length && (trieNode = currentNode.children.get(keyArray[level])) != null; ++level) {
                currentNode = trieNode;
            }
            Object oldValue = currentNode.valueSet.remove(valueKey);
            currentNode.end = false;
            while (currentNode.children.isEmpty() && currentNode.valueSet.isEmpty() && currentNode.parentNode != null) {
                currentNode.parentNode.children.remove(keyArray[--level]);
                currentNode = currentNode.parentNode;
            }
            this.nodePath.remove(key);
            return true;
        }
        catch (Throwable e) {
            throw new TrieException(e);
        }
    }

    public long countSubRecords() {
        return this.countLevelRecords(this.rootNode);
    }

    private long countLevelRecords(TrieNode<K, V> currentNode) {
        if (currentNode == null) {
            return 0L;
        }
        if (currentNode.children.isEmpty()) {
            return currentNode.valueSet.size();
        }
        long childrenCount = 0L;
        for (Map.Entry entry : currentNode.children.entrySet()) {
            childrenCount += this.countLevelRecords(entry.getValue());
        }
        return childrenCount + (long)currentNode.valueSet.size();
    }

    public Map<K, V> getNode(String key) {
        try {
            String[] keyArray = key.split("/");
            Map<K, V> result = this.findValueSet(this.rootNode, keyArray, 0, keyArray.length, false);
            return result;
        }
        catch (Throwable e) {
            throw new TrieException(e);
        }
    }

    public void traverseAll(TrieMethod<K, V> method) {
        StringBuilder builder = new StringBuilder(128);
        this.traverse(this.rootNode, method, builder);
    }

    public Set<String> getNodePath(String key) {
        try {
            String[] keyArray = key.split("/");
            StringBuilder builder = new StringBuilder(key.length());
            Set<String> result = this.findValuePath(this.rootNode, keyArray, 0, keyArray.length, builder, false);
            return result;
        }
        catch (Throwable e) {
            throw new TrieException(e);
        }
    }

    private Set<String> findValuePath(TrieNode<K, V> currentNode, String[] topicArray, int level, int maxLevel, StringBuilder builder, boolean isNumberSign) {
        TrieNode numberMatch;
        boolean isPathEnd;
        HashSet<String> result = new HashSet<String>();
        boolean bl = isPathEnd = (level == maxLevel || isNumberSign) && !currentNode.valueSet.isEmpty() && builder.length() > 0;
        if (isPathEnd) {
            result.add(TopicUtils.normalizeTopic(builder.toString().substring(0, builder.length() - 1)));
        }
        if ((numberMatch = currentNode.children.get("#")) != null) {
            int start = builder.length();
            builder.append("#").append("/");
            result.addAll(this.findValuePath(numberMatch, topicArray, level + 1, maxLevel, builder, true));
            builder.delete(start, builder.length());
        }
        if (level < maxLevel && !currentNode.children.isEmpty()) {
            TrieNode plusMatch;
            TrieNode trieNode = currentNode.children.get(topicArray[level]);
            if (trieNode != null) {
                int start = builder.length();
                builder.append(topicArray[level]).append("/");
                result.addAll(this.findValuePath(trieNode, topicArray, level + 1, maxLevel, builder, false));
                builder.delete(start, builder.length());
            }
            if ((plusMatch = currentNode.children.get("+")) != null) {
                int start = builder.length();
                builder.append("+").append("/");
                result.addAll(this.findValuePath(plusMatch, topicArray, level + 1, maxLevel, builder, false));
                builder.delete(start, builder.length());
            }
        }
        return result;
    }

    private void traverse(TrieNode<K, V> currentNode, TrieMethod<K, V> method, StringBuilder builder) {
        for (Map.Entry entry : currentNode.children.entrySet()) {
            int start = builder.length();
            builder.append(entry.getKey()).append("/");
            this.traverse(entry.getValue(), method, builder);
            builder.delete(start, builder.length());
        }
        for (Map.Entry entry : currentNode.valueSet.entrySet()) {
            try {
                method.doMethod(builder.toString(), (String)entry.getKey());
            }
            catch (Throwable throwable) {}
        }
    }

    private Map<K, V> findValueSet(TrieNode<K, V> currentNode, String[] topicArray, int level, int maxLevel, boolean isNumberSign) {
        TrieNode numberMatch;
        HashMap result = new HashMap(16);
        if (level == maxLevel || isNumberSign) {
            result.putAll(currentNode.valueSet);
        }
        if ((numberMatch = currentNode.children.get("#")) != null) {
            result.putAll(this.findValueSet(numberMatch, topicArray, level + 1, maxLevel, true));
        }
        if (level < maxLevel && !currentNode.children.isEmpty()) {
            TrieNode plusMatch;
            TrieNode trieNode = currentNode.children.get(topicArray[level]);
            if (trieNode != null) {
                result.putAll(this.findValueSet(trieNode, topicArray, level + 1, maxLevel, false));
            }
            if ((plusMatch = currentNode.children.get("+")) != null) {
                result.putAll(this.findValueSet(plusMatch, topicArray, level + 1, maxLevel, false));
            }
        }
        return result;
    }

    public Set<String> getAllPath(String key) {
        try {
            String[] keyArray = key.split("/");
            HashSet<String> result = new HashSet<String>();
            this._getAllPath(this.rootNode, keyArray, 0, keyArray.length, false, result, "");
            return result;
        }
        catch (Throwable e) {
            throw new TrieException(e);
        }
    }

    private void _getAllPath(TrieNode<K, V> currentNode, String[] topicArray, int level, int maxLevel, boolean findAll, Set<String> result, String path) {
        if (level >= maxLevel && !findAll) {
            if (currentNode.end) {
                result.add(path);
            }
            return;
        }
        if (findAll && currentNode.end) {
            result.add(path);
        }
        if (currentNode.end && level + 1 < maxLevel && topicArray[level + 1].equals("#")) {
            result.add(path);
        }
        if (findAll) {
            for (String key : currentNode.children.keySet()) {
                this._getAllPath(currentNode.children.get(key), topicArray, level + 1, maxLevel, true, result, path + key + "/");
            }
            return;
        }
        if (topicArray[level].equals("+")) {
            for (String key : currentNode.children.keySet()) {
                this._getAllPath(currentNode.children.get(key), topicArray, level + 1, maxLevel, false, result, path + key + "/");
            }
        } else if (topicArray[level].equals("#")) {
            for (String key : currentNode.children.keySet()) {
                this._getAllPath(currentNode.children.get(key), topicArray, level + 1, maxLevel, true, result, path + key + "/");
            }
        } else if (currentNode.children.get(topicArray[level]) != null) {
            String key = topicArray[level];
            this._getAllPath(currentNode.children.get(topicArray[level]), topicArray, level + 1, maxLevel, false, result, path + key + "/");
        }
    }

    public boolean isExistNodePath(String topic) {
        return this.nodePath.contains(topic);
    }

    public Set<String> getNodePath() {
        return this.nodePath;
    }

    public String toString() {
        StringBuilder result = new StringBuilder();
        for (String topic : this.nodePath) {
            result.append(topic).append(" ");
        }
        return result.toString();
    }

    class TrieNode<K, V> {
        public TrieNode<K, V> parentNode;
        public boolean end;
        public Map<String, TrieNode<K, V>> children = new ConcurrentHashMap<String, TrieNode<K, V>>();
        public Map<K, V> valueSet = new ConcurrentHashMap();

        public TrieNode(TrieNode<K, V> parentNode) {
            this.parentNode = parentNode;
        }
    }
}

