/*
 * Decompiled with CFR 0.152.
 */
package org.apache.rocketmq.mqtt.common.meta;

import java.lang.management.ManagementFactory;
import java.net.Inet6Address;
import java.net.InetAddress;
import java.net.NetworkInterface;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Set;
import javax.management.MBeanServer;
import javax.management.ObjectName;

public class IpUtil {
    private static String candidatesHost;

    public static String getLocalAddressCompatible() {
        try {
            if (candidatesHost != null) {
                return candidatesHost;
            }
            return IpUtil.getLocalAddress();
        }
        catch (Exception e) {
            throw new RuntimeException("InetAddress java.net.InetAddress.getLocalHost() throws UnknownHostException", e);
        }
    }

    private static String getLocalAddress() throws Exception {
        Enumeration<NetworkInterface> enumeration = NetworkInterface.getNetworkInterfaces();
        ArrayList<String> ipv4Result = new ArrayList<String>();
        ArrayList<String> ipv6Result = new ArrayList<String>();
        while (enumeration.hasMoreElements()) {
            NetworkInterface networkInterface = enumeration.nextElement();
            Enumeration<InetAddress> en = networkInterface.getInetAddresses();
            while (en.hasMoreElements()) {
                InetAddress address = en.nextElement();
                if (address.isLoopbackAddress()) continue;
                if (address instanceof Inet6Address) {
                    ipv6Result.add(IpUtil.normalizeHostAddress(address));
                    continue;
                }
                ipv4Result.add(IpUtil.normalizeHostAddress(address));
            }
        }
        if (!ipv4Result.isEmpty()) {
            for (String ip : ipv4Result) {
                if (ip.startsWith("127.0") || ip.startsWith("192.168")) continue;
                return ip;
            }
            return (String)ipv4Result.get(ipv4Result.size() - 1);
        }
        if (!ipv6Result.isEmpty()) {
            return (String)ipv6Result.get(0);
        }
        InetAddress localHost = InetAddress.getLocalHost();
        return IpUtil.normalizeHostAddress(localHost);
    }

    public static String getLocalPort() throws Exception {
        MBeanServer mBeanServer = ManagementFactory.getPlatformMBeanServer();
        Set<ObjectName> objectNames = mBeanServer.queryNames(new ObjectName("*:type=Connector,*"), null);
        if (objectNames == null || objectNames.size() <= 0) {
            throw new IllegalStateException("Cannot get the names of MBeans controlled by the MBean server.");
        }
        for (ObjectName objectName : objectNames) {
            String protocol = String.valueOf(mBeanServer.getAttribute(objectName, "protocol"));
            String port = String.valueOf(mBeanServer.getAttribute(objectName, "port"));
            if (!protocol.equals("HTTP/1.1") && !protocol.equals("org.apache.coyote.http11.Http11NioProtocol")) continue;
            return port;
        }
        throw new IllegalStateException("Failed to get the HTTP port of the current server");
    }

    public static String normalizeHostAddress(InetAddress localHost) {
        if (localHost instanceof Inet6Address) {
            return "[" + localHost.getHostAddress() + "]";
        }
        return localHost.getHostAddress();
    }

    public static String convertAllNodeAddress(String ipList, int port) {
        StringBuilder allNodeAddress = new StringBuilder();
        String[] ips = ipList.split(",");
        for (int i = 0; i < ips.length - 1; ++i) {
            allNodeAddress.append(ips[i]).append(":").append(port).append(",");
        }
        allNodeAddress.append(ips[ips.length - 1]).append(":").append(port);
        return allNodeAddress.toString();
    }
}

