/*
 * Decompiled with CFR 0.152.
 */
package org.apache.rocketmq.mqtt.exporter.collector;

import io.prometheus.client.Collector;
import java.util.Arrays;
import org.apache.rocketmq.mqtt.exporter.collector.SubSystem;

public enum MqttMetricsInfo {
    DEMO_TPS(Collector.Type.COUNTER, SubSystem.CS, "tps_total", "demo tps.", null, "hostName", "hostIp"),
    DEMO_GAUGE(Collector.Type.GAUGE, SubSystem.DS, "demo_gauge", "demo gauge status.", null, "hostName", "hostIp"),
    DEMO_LATENCY(Collector.Type.HISTOGRAM, SubSystem.DS, "demo_latency", "latency in microsecond.", new double[]{100.0, 300.0, 500.0, 1000.0, 3000.0, 5000.0, 10000.0, 50000.0}, "hostName", "hostIp"),
    PULL_STATUS_TPS(Collector.Type.COUNTER, SubSystem.DS, "pull_status_tps_total", "ds pull msg status tps.", null, "hostName", "hostIp", "pullStatus"),
    PULL_CACHE_STATUS_TPS(Collector.Type.COUNTER, SubSystem.CS, "pull_cache_status_tps_total", "ds pull cache status tps.", null, "hostName", "hostIp", "pullCacheStatus"),
    READ_WRITE_MATCH_ACTION_RT(Collector.Type.GAUGE, SubSystem.DS, "read_write_match_action_rt", "lmq read write match action rt.", null, "hostName", "hostIp", "action", "status");

    private final Collector.Type type;
    private final SubSystem subSystem;
    private final String name;
    private final String help;
    private final double[] buckets;
    private final String[] labelNames;

    private MqttMetricsInfo(Collector.Type type, SubSystem subSystem, String name, String help, double[] buckets, String ... labelNames) {
        this.type = type;
        this.subSystem = subSystem;
        this.name = name;
        this.help = help;
        this.buckets = buckets;
        this.labelNames = labelNames;
    }

    public Collector.Type getType() {
        return this.type;
    }

    public String getName() {
        return this.name;
    }

    public String getHelp() {
        return this.help;
    }

    public double[] getBuckets() {
        return this.buckets;
    }

    public String[] getLabelNames() {
        return this.labelNames;
    }

    public SubSystem getSubSystem() {
        return this.subSystem;
    }

    public String toString() {
        return "MqttMetricsInfo{type=" + this.type + ", subSystem=" + (Object)((Object)this.subSystem) + ", name='" + this.name + '\'' + ", help='" + this.help + '\'' + ", buckets=" + Arrays.toString(this.buckets) + ", labelNames=" + Arrays.toString(this.labelNames) + '}';
    }
}

