/*
 * Decompiled with CFR 0.152.
 */
package org.apache.rocketmq.mqtt.exporter;

import io.prometheus.client.hotspot.DefaultExports;
import org.apache.rocketmq.mqtt.exporter.collector.MqttMetricsCollector;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MqttExporter {
    protected static final Logger LOG = LoggerFactory.getLogger(MqttExporter.class);
    private final String nameSpace;
    private final String hostName;
    private final String hostIp;
    private final int exporterPort;
    private final boolean exportJvmInfo;

    public MqttExporter(String nameSpace, String hostName, String hostIp, int exporterPort, boolean exportJvmInfo) {
        this.nameSpace = nameSpace;
        this.hostName = hostName;
        this.hostIp = hostIp;
        this.exporterPort = exporterPort;
        this.exportJvmInfo = exportJvmInfo;
    }

    public void start() throws Exception {
        if (this.exportJvmInfo) {
            DefaultExports.initialize();
        }
        MqttMetricsCollector.initialize(this.nameSpace, this.hostName, this.hostIp, this.exporterPort);
        LOG.info("metrics exporter start success");
    }

    public void shutdown() {
        MqttMetricsCollector.shutdown();
    }
}

