/*
 * Decompiled with CFR 0.152.
 */
package io.openmessaging.connector.api.data;

import io.openmessaging.connector.api.data.Field;
import io.openmessaging.connector.api.data.FieldType;
import io.openmessaging.connector.api.data.Schema;
import io.openmessaging.connector.api.errors.ConnectException;
import java.util.ArrayList;
import java.util.List;

public class SchemaBuilder {
    private String name;
    private FieldType type;
    private List<Field> fields;

    public SchemaBuilder(FieldType type) {
        if (null == type) {
            throw new ConnectException("type cannot be null");
        }
        this.type = type;
        if (type == FieldType.STRUCT) {
            this.fields = new ArrayList<Field>();
        }
    }

    public static SchemaBuilder int8() {
        return new SchemaBuilder(FieldType.INT8);
    }

    public static SchemaBuilder int32() {
        return new SchemaBuilder(FieldType.INT32);
    }

    public static SchemaBuilder int64() {
        return new SchemaBuilder(FieldType.INT64);
    }

    public static SchemaBuilder float32() {
        return new SchemaBuilder(FieldType.FLOAT32);
    }

    public static SchemaBuilder float64() {
        return new SchemaBuilder(FieldType.FLOAT64);
    }

    public static SchemaBuilder bool() {
        return new SchemaBuilder(FieldType.BOOLEAN);
    }

    public static SchemaBuilder string() {
        return new SchemaBuilder(FieldType.STRING);
    }

    public static SchemaBuilder bytes() {
        return new SchemaBuilder(FieldType.BYTES);
    }

    public static SchemaBuilder struct() {
        return new SchemaBuilder(FieldType.STRUCT);
    }

    public SchemaBuilder name(String name) {
        this.name = name;
        return this;
    }

    public Schema build() {
        return new Schema(this.name, this.type, this.fields);
    }
}

