/*
 * Decompiled with CFR 0.152.
 */
package org.apache.rocketmq.client.java.example;

import java.io.IOException;
import java.nio.charset.StandardCharsets;
import org.apache.rocketmq.client.apis.ClientConfiguration;
import org.apache.rocketmq.client.apis.ClientException;
import org.apache.rocketmq.client.apis.ClientServiceProvider;
import org.apache.rocketmq.client.apis.SessionCredentialsProvider;
import org.apache.rocketmq.client.apis.StaticSessionCredentialsProvider;
import org.apache.rocketmq.client.apis.message.Message;
import org.apache.rocketmq.client.apis.producer.Producer;
import org.apache.rocketmq.client.apis.producer.SendReceipt;
import org.apache.rocketmq.client.apis.producer.Transaction;
import org.apache.rocketmq.client.apis.producer.TransactionChecker;
import org.apache.rocketmq.client.apis.producer.TransactionResolution;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ProducerTransactionMessageExample {
    private static final Logger LOGGER = LoggerFactory.getLogger(ProducerTransactionMessageExample.class);

    private ProducerTransactionMessageExample() {
    }

    public static void main(String[] args) throws ClientException, IOException {
        ClientServiceProvider provider = ClientServiceProvider.loadService();
        String accessKey = "yourAccessKey";
        String secretKey = "yourSecretKey";
        StaticSessionCredentialsProvider sessionCredentialsProvider = new StaticSessionCredentialsProvider(accessKey, secretKey);
        String endpoints = "foobar.com:8080";
        ClientConfiguration clientConfiguration = ClientConfiguration.newBuilder().setEndpoints(endpoints).setCredentialProvider((SessionCredentialsProvider)sessionCredentialsProvider).build();
        String topic = "yourTransactionTopic";
        TransactionChecker checker = messageView -> {
            LOGGER.info("Receive transactional message check, message={}", (Object)messageView);
            return TransactionResolution.COMMIT;
        };
        Producer producer = provider.newProducerBuilder().setClientConfiguration(clientConfiguration).setTopics(new String[]{topic}).setTransactionChecker(checker).build();
        Transaction transaction = producer.beginTransaction();
        byte[] body = "This is a transaction message for Apache RocketMQ".getBytes(StandardCharsets.UTF_8);
        String tag = "yourMessageTagA";
        Message message = provider.newMessageBuilder().setTopic(topic).setTag(tag).setKeys(new String[]{"yourMessageKey-565ef26f5727"}).setBody(body).build();
        try {
            SendReceipt sendReceipt = producer.send(message, transaction);
            LOGGER.info("Send transaction message successfully, messageId={}", (Object)sendReceipt.getMessageId());
        }
        catch (Throwable t) {
            LOGGER.error("Failed to send message", t);
            return;
        }
        transaction.commit();
        producer.close();
    }
}

