// Copyright 2018, OpenCensus Authors
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

#include <functional>

#include "benchmark/benchmark.h"
#include "opencensus/context/context.h"

namespace opencensus {
namespace context {
namespace {

void BM_ContextCurrent(benchmark::State& state) {
  benchmark::DoNotOptimize(Context::Current());  // Force TLS initialization.
  for (auto _ : state) {
    benchmark::DoNotOptimize(Context::Current());
  }
}
BENCHMARK(BM_ContextCurrent);

void BM_CopyDefaultContext(benchmark::State& state) {
  Context ctx = Context::Current();
  for (auto _ : state) {
    Context copy = ctx;
    benchmark::DoNotOptimize(copy);
  }
}
BENCHMARK(BM_CopyDefaultContext);

void BM_WrapDefaultContext(benchmark::State& state) {
  Context ctx = Context::Current();
  std::function<void()> fn = []() {};
  for (auto _ : state) {
    benchmark::DoNotOptimize(ctx.Wrap(fn));
  }
}
BENCHMARK(BM_WrapDefaultContext);

}  // namespace
}  // namespace context
}  // namespace opencensus

BENCHMARK_MAIN();
