## RocketMQ Client Go 
[![Build Status](https://app.travis-ci.com/apache/rocketmq-client-go.svg?branch=master)](https://app.travis-ci.com/apache/rocketmq-client-go) 
[![License](https://img.shields.io/badge/license-Apache%202-4EB1BA.svg)](https://www.apache.org/licenses/LICENSE-2.0.html)
[![Code Scanning](https://github.com/apache/rocketmq-client-go/actions/workflows/codeql-analysis.yml/badge.svg)](https://github.com/apache/rocketmq-client-go/actions/workflows/codeql-analysis.yml)
[![Tests](https://github.com/apache/rocketmq-client-go/actions/workflows/tests.yaml/badge.svg)](https://github.com/apache/rocketmq-client-go/actions/workflows/tests.yaml)
[![CodeCov](https://codecov.io/gh/apache/rocketmq-client-go/branch/master/graph/badge.svg)](https://codecov.io/gh/apache/rocketmq-client-go)
[![Go Report Card](https://goreportcard.com/badge/github.com/apache/rocketmq-client-go)](https://goreportcard.com/report/github.com/apache/rocketmq-client-go)
[![GoDoc](https://img.shields.io/badge/Godoc-reference-blue.svg)](https://godoc.org/github.com/apache/rocketmq-client-go)
[![GitHub release](https://img.shields.io/github/release-date-pre/apache/rocketmq-client-go)](https://github.com/apache/rocketmq-client-go/releases)
[![Average time to resolve an issue](http://isitmaintained.com/badge/resolution/apache/rocketmq-client-go.svg)](http://isitmaintained.com/project/apache/rocketmq-client-go "Average time to resolve an issue")
[![Percentage of issues still open](http://isitmaintained.com/badge/open/apache/rocketmq-client-go.svg)](http://isitmaintained.com/project/apache/rocketmq-client-go "Percentage of issues still open")
[![Twitter Follow](https://img.shields.io/twitter/follow/ApacheRocketMQ?style=social)](https://twitter.com/intent/follow?screen_name=ApacheRocketMQ)

A product ready RocketMQ Client in pure go, which supports almost the full features of Apache RocketMQ, such as pub and sub messages, ACL, tracing and so on.

----------
## [Due Diligence](https://github.com/apache/rocketmq-client-go/issues/423)
[Here](https://github.com/apache/rocketmq-client-go/issues/423), we sincerely invite you to take a minute to feedback on your usage scenario. 

----------
## Features
For 2.X version, it supports:
* sending message in synchronous mode
* sending message in asynchronous mode
* sending message in oneway mode
* sending message in batch mode
* sending orderly messages
* sending delay messages
* sending transaction messages
* consuming message using push model
* consuming message using pull model
* consuming message using broadcast model
* message tracing for pub and sub messages
* ACL for producers and consumers
* request-reply model

----------
## How to use
* Step-by-step instruction are provided in [RocketMQ Go Client Introduction](docs/Introduction.md)
* Consult [RocketMQ Quick Start](https://rocketmq.apache.org/docs/quick-start/) to setup rocketmq broker and nameserver.

----------
## Apache RocketMQ Community
* [RocketMQ Community Projects](https://github.com/apache/rocketmq-externals)

----------
## Contact us
* Mailing Lists: <https://rocketmq.apache.org/about/contact/>
* Home: <https://rocketmq.apache.org>
* Docs: <https://rocketmq.apache.org/docs/quick-start/>
* Issues: <https://github.com/apache/rocketmq-client-go/issues>
* Ask: <https://stackoverflow.com/questions/tagged/rocketmq>
* Slack: <https://rocketmq-community.slack.com/>
 
---------- 
## How to Contribute
  Contributions are warmly welcome! Be it trivial cleanup, major new feature or other suggestion. Read this [how to contribute](http://rocketmq.apache.org/docs/how-to-contribute/) guide for more details. 
   
   
----------
## License
  [Apache License, Version 2.0](http://www.apache.org/licenses/LICENSE-2.0.html) Copyright (C) Apache Software Foundation
