/*
 * Decompiled with CFR 0.152.
 */
package org.apache.rocketmq.store.transaction;

import java.net.SocketAddress;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingDeque;
import java.util.concurrent.TimeUnit;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.rocketmq.common.ServiceThread;
import org.apache.rocketmq.common.message.Message;
import org.apache.rocketmq.common.message.MessageAccessor;
import org.apache.rocketmq.common.message.MessageClientIDSetter;
import org.apache.rocketmq.common.message.MessageDecoder;
import org.apache.rocketmq.common.message.MessageExt;
import org.apache.rocketmq.common.message.MessageExtBrokerInner;
import org.apache.rocketmq.logging.org.slf4j.Logger;
import org.apache.rocketmq.logging.org.slf4j.LoggerFactory;
import org.apache.rocketmq.store.DefaultMessageStore;
import org.apache.rocketmq.store.DispatchRequest;
import org.apache.rocketmq.store.MessageStore;
import org.apache.rocketmq.store.PutMessageResult;
import org.apache.rocketmq.store.PutMessageStatus;
import org.apache.rocketmq.store.StoreUtil;
import org.apache.rocketmq.store.config.MessageStoreConfig;
import org.apache.rocketmq.store.rocksdb.MessageRocksDBStorage;
import org.apache.rocketmq.store.stats.BrokerStatsManager;
import org.apache.rocketmq.store.transaction.TransRocksDBRecord;

public class TransMessageRocksDBStore {
    private static final Logger log = LoggerFactory.getLogger((String)"RocketmqStore");
    private static final Logger logError = LoggerFactory.getLogger((String)"RocketmqStoreError");
    private static final String REMOVE_TAG = "d";
    private static final byte[] FILL_BYTE = new byte[]{0};
    private static final int DEFAULT_CAPACITY = 100000;
    private static final int BATCH_SIZE = 1000;
    private static final int MAX_GET_MSG_TIMES = 3;
    private static final int INITIAL = 0;
    private static final int RUNNING = 1;
    private static final int SHUTDOWN = 2;
    private volatile int state = 0;
    private final MessageStore messageStore;
    private final MessageStoreConfig storeConfig;
    private final MessageRocksDBStorage messageRocksDBStorage;
    private final BrokerStatsManager brokerStatsManager;
    private final SocketAddress storeHost;
    private ThreadLocal<ByteBuffer> bufferLocal = null;
    private TransIndexBuildService transIndexBuildService;
    protected BlockingQueue<TransRocksDBRecord> originTransMsgQueue;

    public TransMessageRocksDBStore(MessageStore messageStore, BrokerStatsManager brokerStatsManager, SocketAddress storeHost) {
        this.messageStore = messageStore;
        this.storeConfig = messageStore.getMessageStoreConfig();
        this.messageRocksDBStorage = messageStore.getMessageRocksDBStorage();
        this.brokerStatsManager = brokerStatsManager;
        this.storeHost = storeHost;
        this.bufferLocal = ThreadLocal.withInitial(() -> ByteBuffer.allocate(this.storeConfig.getMaxMessageSize()));
        if (this.storeConfig.isTransRocksDBEnable()) {
            this.init();
        }
    }

    private void init() {
        if (this.state == 1) {
            return;
        }
        this.transIndexBuildService = new TransIndexBuildService();
        this.originTransMsgQueue = new LinkedBlockingDeque<TransRocksDBRecord>(100000);
        this.transIndexBuildService.start();
        this.state = 1;
        Long lastOffsetPy = this.messageRocksDBStorage.getLastOffsetPy(MessageRocksDBStorage.TRANS_COLUMN_FAMILY);
        log.info("TransMessageRocksDBStore start success, lastOffsetPy: {}", (Object)lastOffsetPy);
    }

    public void shutdown() {
        if (this.state != 1 || this.state == 2) {
            return;
        }
        if (null != this.transIndexBuildService) {
            this.transIndexBuildService.shutdown();
        }
        this.state = 2;
        log.info("TransMessageRocksDBStore shutdown success");
    }

    public void buildTransIndex(DispatchRequest dispatchRequest) {
        long endOffsetPy;
        if (null == dispatchRequest || dispatchRequest.getCommitLogOffset() < 0L || dispatchRequest.getMsgSize() <= 0 || this.state != 1 || null == this.originTransMsgQueue) {
            logError.error("TransMessageRocksDBStore buildTransIndex error, dispatchRequest: {}, state: {}, originTransMsgQueue: {}", new Object[]{dispatchRequest, this.state, this.originTransMsgQueue});
            return;
        }
        long reqOffsetPy = dispatchRequest.getCommitLogOffset();
        if (reqOffsetPy < (endOffsetPy = this.messageRocksDBStorage.getLastOffsetPy(MessageRocksDBStorage.TRANS_COLUMN_FAMILY).longValue())) {
            if (System.currentTimeMillis() % 1000L == 0L) {
                log.warn("TransMessageRocksDBStore buildTransIndex recover, but ignore, reqOffsetPy: {}, endOffsetPy: {}", (Object)reqOffsetPy, (Object)endOffsetPy);
            }
            return;
        }
        int reqMsgSize = dispatchRequest.getMsgSize();
        try {
            MessageExt msgInner = this.getMessage(reqOffsetPy, reqMsgSize);
            if (null == msgInner) {
                logError.error("TransMessageRocksDBStore buildTransIndex error, msgInner is not found, reqOffsetPy: {}, reqMsgSize: {}", (Object)reqOffsetPy, (Object)reqMsgSize);
                return;
            }
            String topic = msgInner.getUserProperty("REAL_TOPIC");
            String uniqKey = msgInner.getUserProperty("__transactionId__");
            if (StringUtils.isEmpty((CharSequence)topic) || StringUtils.isEmpty((CharSequence)uniqKey)) {
                logError.error("TransMessageRocksDBStore buildTransIndex error, uniqKey: {}, topic: {}", (Object)uniqKey, (Object)topic);
                return;
            }
            TransRocksDBRecord transRocksDBRecord = null;
            String reqTopic = dispatchRequest.getTopic();
            if ("RMQ_SYS_ROCKSDB_TRANS_HALF_TOPIC".equals(reqTopic)) {
                transRocksDBRecord = new TransRocksDBRecord(reqOffsetPy, topic, uniqKey, reqMsgSize, 0);
            } else if ("RMQ_SYS_ROCKSDB_TRANS_OP_HALF_TOPIC".equals(reqTopic)) {
                long offsetPy = -1L;
                String transOffsetPy = null;
                try {
                    transOffsetPy = msgInner.getUserProperty("TRANS_OFFSET");
                    if (!StringUtils.isEmpty((CharSequence)transOffsetPy)) {
                        offsetPy = Long.parseLong(transOffsetPy);
                    }
                    if (offsetPy >= 0L) {
                        transRocksDBRecord = new TransRocksDBRecord(offsetPy, topic, uniqKey, true);
                    }
                }
                catch (Exception e) {
                    logError.error("TransMessageRocksDBStore buildTransIndex error, transOffsetPy: {}, error: {}", (Object)transOffsetPy, (Object)e.getMessage());
                }
            }
            if (null != transRocksDBRecord) {
                while (!this.originTransMsgQueue.offer(transRocksDBRecord, 3L, TimeUnit.SECONDS)) {
                    if (System.currentTimeMillis() % 1000L != 0L) continue;
                    logError.error("TransMessageRocksDBStore buildTransStatus offer transRocksDBRecord error, topic: {}, uniqKey: {}, reqOffsetPy: {}", new Object[]{topic, uniqKey, reqOffsetPy});
                }
            }
        }
        catch (Exception e) {
            logError.error("TransMessageRocksDBStore buildTransStatus error: {}", (Object)e.getMessage());
        }
    }

    public void deletePrepareMessage(MessageExt messageExt) {
        if (null == messageExt) {
            logError.error("TransMessageRocksDBStore deletePrepareMessage error, messageExt is null");
            return;
        }
        try {
            MessageExtBrokerInner msgInner = this.makeOpMessageInner(messageExt);
            if (null == msgInner) {
                logError.error("TransMessageRocksDBStore deletePrepareMessage msgInner is null");
                return;
            }
            PutMessageResult result = this.messageStore.putMessage(msgInner);
            if (result != null && result.getPutMessageStatus() == PutMessageStatus.PUT_OK) {
                this.brokerStatsManager.incTopicPutNums(msgInner.getTopic());
                this.brokerStatsManager.incTopicPutSize(msgInner.getTopic(), result.getAppendMessageResult().getWroteBytes());
                this.brokerStatsManager.incBrokerPutNums();
                return;
            }
            logError.error("TransMessageRocksDBStore deletePrepareMessage put op msg failed, result: {}", (Object)result);
        }
        catch (Exception e) {
            logError.error("TransMessageRocksDBStore deletePrepareMessage error: {}", (Object)e.getMessage());
        }
    }

    public MessageExt getMessage(long offsetPy, int sizePy) {
        if (offsetPy < 0L || sizePy <= 0 || sizePy > this.storeConfig.getMaxMessageSize()) {
            logError.error("TransMessageRocksDBStore getMessage param error, offsetPy: {}, sizePy: {}, maxMsgSizeConfig: {}", new Object[]{offsetPy, sizePy, this.storeConfig.getMaxMessageSize()});
            return null;
        }
        ByteBuffer byteBuffer = this.bufferLocal.get();
        if (sizePy > byteBuffer.limit()) {
            this.bufferLocal.remove();
            byteBuffer = ByteBuffer.allocate(sizePy);
            this.bufferLocal.set(byteBuffer);
        }
        for (int i = 0; i < 3; ++i) {
            try {
                MessageExt msgExt = StoreUtil.getMessage(offsetPy, sizePy, this.messageStore, this.bufferLocal.get());
                if (null != msgExt) {
                    return msgExt;
                }
                log.warn("Fail to read msg from commitLog offsetPy:{} sizePy:{}", (Object)offsetPy, (Object)sizePy);
                continue;
            }
            catch (Exception e) {
                logError.error("TransMessageRocksDBStore getMessage error, offsetPy: {}, sizePy: {}, error: {}", new Object[]{offsetPy, sizePy, e.getMessage()});
            }
        }
        return null;
    }

    public MessageRocksDBStorage getMessageRocksDBStorage() {
        return this.messageRocksDBStorage;
    }

    private MessageExtBrokerInner makeOpMessageInner(MessageExt messageExt) {
        if (null == messageExt) {
            logError.error("TransMessageRocksDBStore makeOpMessageInner messageExt is null");
            return null;
        }
        try {
            MessageExtBrokerInner msgInner = new MessageExtBrokerInner();
            msgInner.setTopic("RMQ_SYS_ROCKSDB_TRANS_OP_HALF_TOPIC");
            msgInner.setBody(FILL_BYTE);
            msgInner.setQueueId(0);
            msgInner.setTags(REMOVE_TAG);
            msgInner.setTagsCode(MessageExtBrokerInner.tagsString2tagsCode((String)msgInner.getTags()));
            msgInner.setSysFlag(0);
            msgInner.setBornTimestamp(System.currentTimeMillis());
            msgInner.setBornHost(this.storeHost);
            msgInner.setStoreHost(this.storeHost);
            msgInner.setWaitStoreMsgOK(false);
            MessageClientIDSetter.setUniqID((Message)msgInner);
            String uniqKey = MessageClientIDSetter.getUniqID((Message)messageExt);
            if (!StringUtils.isEmpty((CharSequence)uniqKey)) {
                MessageAccessor.putProperty((Message)msgInner, (String)"__transactionId__", (String)uniqKey);
            }
            MessageAccessor.putProperty((Message)msgInner, (String)"TRANS_OFFSET", (String)String.valueOf(messageExt.getCommitLogOffset()));
            MessageAccessor.putProperty((Message)msgInner, (String)"REAL_TOPIC", (String)messageExt.getUserProperty("REAL_TOPIC"));
            msgInner.setPropertiesString(MessageDecoder.messageProperties2String((Map)msgInner.getProperties()));
            return msgInner;
        }
        catch (Exception e) {
            logError.error("TransMessageRocksDBStore makeOpMessageInner error: {}", (Object)e.getMessage());
            return null;
        }
    }

    public Integer getCheckTimes(String topic, String uniqKey, Long offsetPy) {
        if (StringUtils.isEmpty((CharSequence)topic) || StringUtils.isEmpty((CharSequence)uniqKey) || null == offsetPy || offsetPy < 0L) {
            return null;
        }
        try {
            TransRocksDBRecord record = this.messageRocksDBStorage.getRecordForTrans(MessageRocksDBStorage.TRANS_COLUMN_FAMILY, new TransRocksDBRecord(offsetPy, topic, uniqKey, false));
            if (null == record) {
                return null;
            }
            return record.getCheckTimes();
        }
        catch (Exception e) {
            logError.error("TransMessageRocksDBStore getCheckTimes error, topic: {}, uniqKey: {}, offsetPy: {}, error: {}", new Object[]{topic, uniqKey, offsetPy, e.getMessage()});
            return null;
        }
    }

    public boolean isMappedFileMatchedRecover(long phyOffset) {
        if (!this.storeConfig.isTransRocksDBEnable()) {
            return true;
        }
        Long lastOffsetPy = this.messageRocksDBStorage.getLastOffsetPy(MessageRocksDBStorage.TRANS_COLUMN_FAMILY);
        log.info("trans isMappedFileMatchedRecover lastOffsetPy: {}", (Object)lastOffsetPy);
        if (null != lastOffsetPy && phyOffset <= lastOffsetPy) {
            log.info("isMappedFileMatchedRecover TransMessageRocksDBStore recover form this offset, phyOffset: {}, lastOffsetPy: {}", (Object)phyOffset, (Object)lastOffsetPy);
            return true;
        }
        return false;
    }

    private String getServiceThreadName() {
        DefaultMessageStore messageStore;
        String brokerIdentifier = "";
        if (this.messageStore instanceof DefaultMessageStore && (messageStore = (DefaultMessageStore)this.messageStore).getBrokerConfig().isInBrokerContainer()) {
            brokerIdentifier = messageStore.getBrokerConfig().getIdentifier();
        }
        return brokerIdentifier;
    }

    static /* synthetic */ Logger access$000() {
        return log;
    }

    public class TransIndexBuildService
    extends ServiceThread {
        private final Logger log = TransMessageRocksDBStore.access$000();
        private List<TransRocksDBRecord> trs;

        public String getServiceName() {
            return TransMessageRocksDBStore.this.getServiceThreadName() + ((Object)((Object)this)).getClass().getSimpleName();
        }

        public void run() {
            this.log.info(this.getServiceName() + "service start");
            this.trs = new ArrayList<TransRocksDBRecord>(1000);
            while (!this.isStopped() || !TransMessageRocksDBStore.this.originTransMsgQueue.isEmpty()) {
                try {
                    this.buildTransIndex();
                }
                catch (Exception e) {
                    this.trs.clear();
                    logError.error("TransMessageRocksDBStore error occurred in: {}, error: {}", (Object)this.getServiceName(), (Object)e.getMessage());
                }
            }
            this.log.info(this.getServiceName() + " service end");
        }

        protected void buildTransIndex() {
            this.pollTransMessageRecords();
            if (CollectionUtils.isEmpty(this.trs)) {
                return;
            }
            try {
                TransMessageRocksDBStore.this.messageRocksDBStorage.writeRecordsForTrans(MessageRocksDBStorage.TRANS_COLUMN_FAMILY, this.trs);
            }
            catch (Exception e) {
                logError.error("TransMessageRocksDBStore pollAndPutTransRequest writeRecords error: {}", (Object)e.getMessage());
            }
            this.trs.clear();
        }

        protected void pollTransMessageRecords() {
            block3: {
                try {
                    TransRocksDBRecord tmpReq;
                    TransRocksDBRecord firstReq = TransMessageRocksDBStore.this.originTransMsgQueue.poll(100L, TimeUnit.MILLISECONDS);
                    if (null == firstReq) break block3;
                    this.trs.add(firstReq);
                    while (null != (tmpReq = TransMessageRocksDBStore.this.originTransMsgQueue.poll(100L, TimeUnit.MILLISECONDS))) {
                        this.trs.add(tmpReq);
                        if (this.trs.size() < 1000) continue;
                        break;
                    }
                }
                catch (Exception e) {
                    logError.error("TransMessageRocksDBStore fetchTransMessageRecord error: {}", (Object)e.getMessage());
                }
            }
        }
    }
}

