/*
 * Decompiled with CFR 0.152.
 */
package org.apache.rocketmq.proxy.grpc.v2.producer;

import apache.rocketmq.v2.ForwardMessageToDeadLetterQueueRequest;
import apache.rocketmq.v2.ForwardMessageToDeadLetterQueueResponse;
import io.netty.channel.Channel;
import java.util.concurrent.CompletableFuture;
import org.apache.rocketmq.common.consumer.ReceiptHandle;
import org.apache.rocketmq.proxy.common.MessageReceiptHandle;
import org.apache.rocketmq.proxy.common.ProxyContext;
import org.apache.rocketmq.proxy.grpc.v2.AbstractMessingActivity;
import org.apache.rocketmq.proxy.grpc.v2.channel.GrpcChannelManager;
import org.apache.rocketmq.proxy.grpc.v2.common.GrpcClientSettingsManager;
import org.apache.rocketmq.proxy.grpc.v2.common.ResponseBuilder;
import org.apache.rocketmq.proxy.processor.MessagingProcessor;
import org.apache.rocketmq.remoting.protocol.RemotingCommand;

public class ForwardMessageToDLQActivity
extends AbstractMessingActivity {
    public ForwardMessageToDLQActivity(MessagingProcessor messagingProcessor, GrpcClientSettingsManager grpcClientSettingsManager, GrpcChannelManager grpcChannelManager) {
        super(messagingProcessor, grpcClientSettingsManager, grpcChannelManager);
    }

    public CompletableFuture<ForwardMessageToDeadLetterQueueResponse> forwardMessageToDeadLetterQueue(ProxyContext ctx, ForwardMessageToDeadLetterQueueRequest request) {
        CompletableFuture<ForwardMessageToDeadLetterQueueResponse> future = new CompletableFuture<ForwardMessageToDeadLetterQueueResponse>();
        try {
            this.validateTopicAndConsumerGroup(request.getTopic(), request.getGroup());
            String group = request.getGroup().getName();
            String handleString = request.getReceiptHandle();
            MessageReceiptHandle messageReceiptHandle = this.messagingProcessor.removeReceiptHandle(ctx, (Channel)this.grpcChannelManager.getChannel(ctx.getClientID()), group, request.getMessageId(), request.getReceiptHandle());
            if (messageReceiptHandle != null) {
                handleString = messageReceiptHandle.getReceiptHandleStr();
            }
            ReceiptHandle receiptHandle = ReceiptHandle.decode((String)handleString);
            return this.messagingProcessor.forwardMessageToDeadLetterQueue(ctx, receiptHandle, request.getMessageId(), request.getGroup().getName(), request.getTopic().getName()).thenApply(result -> this.convertToForwardMessageToDeadLetterQueueResponse(ctx, (RemotingCommand)result));
        }
        catch (Throwable t) {
            future.completeExceptionally(t);
            return future;
        }
    }

    protected ForwardMessageToDeadLetterQueueResponse convertToForwardMessageToDeadLetterQueueResponse(ProxyContext ctx, RemotingCommand result) {
        return ForwardMessageToDeadLetterQueueResponse.newBuilder().setStatus(ResponseBuilder.getInstance().buildStatus(result.getCode(), result.getRemark())).build();
    }
}

