/*
 * Decompiled with CFR 0.152.
 */
package org.apache.rocketmq.store.queue;

import java.nio.ByteBuffer;
import java.util.List;
import java.util.concurrent.ConcurrentMap;
import org.apache.rocketmq.common.BoundaryType;
import org.apache.rocketmq.common.message.MessageExtBrokerInner;
import org.apache.rocketmq.store.DispatchRequest;
import org.apache.rocketmq.store.exception.ConsumeQueueException;
import org.apache.rocketmq.store.exception.StoreException;
import org.apache.rocketmq.store.queue.ConsumeQueueInterface;
import org.apache.rocketmq.store.queue.CqUnit;
import org.rocksdb.RocksDBException;

public interface ConsumeQueueStoreInterface {
    public void start();

    public boolean load();

    public boolean loadAfterDestroy();

    public void recover();

    public boolean recoverConcurrently();

    public boolean shutdown();

    public void destroy();

    public void destroy(ConsumeQueueInterface var1) throws RocksDBException;

    public boolean flush(ConsumeQueueInterface var1, int var2);

    public void flush() throws StoreException;

    public void cleanExpired(long var1);

    public void checkSelf();

    public int deleteExpiredFile(ConsumeQueueInterface var1, long var2);

    public boolean isFirstFileAvailable(ConsumeQueueInterface var1);

    public boolean isFirstFileExist(ConsumeQueueInterface var1);

    public long rollNextFile(ConsumeQueueInterface var1, long var2);

    public void truncateDirty(long var1) throws RocksDBException;

    public void putMessagePositionInfoWrapper(ConsumeQueueInterface var1, DispatchRequest var2);

    public void putMessagePositionInfoWrapper(DispatchRequest var1) throws RocksDBException;

    public List<ByteBuffer> rangeQuery(String var1, int var2, long var3, int var5) throws RocksDBException;

    public ByteBuffer get(String var1, int var2, long var3) throws RocksDBException;

    public ConcurrentMap<String, ConcurrentMap<Integer, ConsumeQueueInterface>> getConsumeQueueTable();

    public void assignQueueOffset(MessageExtBrokerInner var1) throws RocksDBException;

    public void increaseQueueOffset(MessageExtBrokerInner var1, short var2);

    public void increaseLmqOffset(String var1, int var2, short var3) throws ConsumeQueueException;

    public long getLmqQueueOffset(String var1, int var2) throws ConsumeQueueException;

    public void recoverOffsetTable(long var1);

    public void setTopicQueueTable(ConcurrentMap<String, Long> var1);

    public void removeTopicQueueTable(String var1, Integer var2);

    public ConcurrentMap getTopicQueueTable();

    public Long getMaxPhyOffsetInConsumeQueue(String var1, int var2);

    public Long getMaxOffset(String var1, int var2) throws ConsumeQueueException;

    public long getMaxPhyOffsetInConsumeQueue() throws RocksDBException;

    public long getMinOffsetInQueue(String var1, int var2) throws RocksDBException;

    public long getMaxOffsetInQueue(String var1, int var2) throws RocksDBException;

    public long getOffsetInQueueByTime(String var1, int var2, long var3, BoundaryType var5) throws RocksDBException;

    public ConsumeQueueInterface findOrCreateConsumeQueue(String var1, int var2);

    public ConcurrentMap<Integer, ConsumeQueueInterface> findConsumeQueueMap(String var1);

    public long getTotalSize();

    public long getStoreTime(CqUnit var1);
}

