/*
 * Decompiled with CFR 0.152.
 */
package org.apache.rocketmq.store.ha.autoswitch;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.SelectionKey;
import java.nio.channels.Selector;
import java.nio.channels.SocketChannel;
import java.util.List;
import org.apache.rocketmq.common.ServiceThread;
import org.apache.rocketmq.common.utils.NetworkUtil;
import org.apache.rocketmq.logging.org.slf4j.Logger;
import org.apache.rocketmq.logging.org.slf4j.LoggerFactory;
import org.apache.rocketmq.remoting.netty.NettySystemConfig;
import org.apache.rocketmq.remoting.protocol.EpochEntry;
import org.apache.rocketmq.store.SelectMappedBufferResult;
import org.apache.rocketmq.store.config.MessageStoreConfig;
import org.apache.rocketmq.store.ha.FlowMonitor;
import org.apache.rocketmq.store.ha.HAConnection;
import org.apache.rocketmq.store.ha.HAConnectionState;
import org.apache.rocketmq.store.ha.autoswitch.AutoSwitchHAClient;
import org.apache.rocketmq.store.ha.autoswitch.AutoSwitchHAService;
import org.apache.rocketmq.store.ha.autoswitch.EpochFileCache;
import org.apache.rocketmq.store.ha.io.AbstractHAReader;
import org.apache.rocketmq.store.ha.io.HAWriter;

public class AutoSwitchHAConnection
implements HAConnection {
    public static final int HANDSHAKE_HEADER_SIZE = 20;
    public static final int TRANSFER_HEADER_SIZE = 36;
    public static final int EPOCH_ENTRY_SIZE = 12;
    private static final Logger LOGGER = LoggerFactory.getLogger((String)"RocketmqStore");
    private final AutoSwitchHAService haService;
    private final SocketChannel socketChannel;
    private final String clientAddress;
    private final EpochFileCache epochCache;
    private final AbstractWriteSocketService writeSocketService;
    private final ReadSocketService readSocketService;
    private final FlowMonitor flowMonitor;
    private volatile HAConnectionState currentState = HAConnectionState.HANDSHAKE;
    private volatile long slaveRequestOffset = -1L;
    private volatile long slaveAckOffset = -1L;
    private volatile boolean isSlaveSendHandshake = false;
    private volatile int currentTransferEpoch = -1;
    private volatile long currentTransferEpochEndOffset = 0L;
    private volatile boolean isSyncFromLastFile = false;
    private volatile boolean isAsyncLearner = false;
    private volatile long slaveId = -1L;
    private volatile long lastMasterMaxOffset = -1L;
    private volatile long lastTransferTimeMs = 0L;

    public AutoSwitchHAConnection(AutoSwitchHAService haService, SocketChannel socketChannel, EpochFileCache epochCache) throws IOException {
        this.haService = haService;
        this.socketChannel = socketChannel;
        this.epochCache = epochCache;
        this.clientAddress = this.socketChannel.socket().getRemoteSocketAddress().toString();
        this.socketChannel.configureBlocking(false);
        this.socketChannel.socket().setSoLinger(false, -1);
        this.socketChannel.socket().setTcpNoDelay(true);
        if (NettySystemConfig.socketSndbufSize > 0) {
            this.socketChannel.socket().setReceiveBufferSize(NettySystemConfig.socketSndbufSize);
        }
        if (NettySystemConfig.socketRcvbufSize > 0) {
            this.socketChannel.socket().setSendBufferSize(NettySystemConfig.socketRcvbufSize);
        }
        this.writeSocketService = new WriteSocketService(this.socketChannel);
        this.readSocketService = new ReadSocketService(this.socketChannel);
        this.haService.getConnectionCount().incrementAndGet();
        this.flowMonitor = new FlowMonitor(haService.getDefaultMessageStore().getMessageStoreConfig());
    }

    @Override
    public void start() {
        this.changeCurrentState(HAConnectionState.HANDSHAKE);
        this.flowMonitor.start();
        this.readSocketService.start();
        this.writeSocketService.start();
    }

    @Override
    public void shutdown() {
        this.changeCurrentState(HAConnectionState.SHUTDOWN);
        this.flowMonitor.shutdown(true);
        this.writeSocketService.shutdown(true);
        this.readSocketService.shutdown(true);
        this.close();
    }

    @Override
    public void close() {
        if (this.socketChannel != null) {
            try {
                this.socketChannel.close();
            }
            catch (IOException e) {
                LOGGER.error("", (Throwable)e);
            }
        }
    }

    public void changeCurrentState(HAConnectionState connectionState) {
        LOGGER.info("change state to {}", (Object)connectionState);
        this.currentState = connectionState;
    }

    public long getSlaveId() {
        return this.slaveId;
    }

    @Override
    public HAConnectionState getCurrentState() {
        return this.currentState;
    }

    @Override
    public SocketChannel getSocketChannel() {
        return this.socketChannel;
    }

    @Override
    public String getClientAddress() {
        return this.clientAddress;
    }

    @Override
    public long getSlaveAckOffset() {
        return this.slaveAckOffset;
    }

    @Override
    public long getTransferredByteInSecond() {
        return this.flowMonitor.getTransferredByteInSecond();
    }

    @Override
    public long getTransferFromWhere() {
        return this.writeSocketService.getNextTransferFromWhere();
    }

    private void changeTransferEpochToNext(EpochEntry entry) {
        this.currentTransferEpoch = entry.getEpoch();
        this.currentTransferEpochEndOffset = entry.getEndOffset();
        if (entry.getEpoch() == this.epochCache.lastEpoch()) {
            this.currentTransferEpochEndOffset = -1L;
        }
    }

    public boolean isAsyncLearner() {
        return this.isAsyncLearner;
    }

    public boolean isSyncFromLastFile() {
        return this.isSyncFromLastFile;
    }

    private synchronized void updateLastTransferInfo() {
        this.lastMasterMaxOffset = this.haService.getDefaultMessageStore().getMaxPhyOffset();
        this.lastTransferTimeMs = System.currentTimeMillis();
    }

    private synchronized void maybeExpandInSyncStateSet(long slaveMaxOffset) {
        if (!this.isAsyncLearner && slaveMaxOffset >= this.lastMasterMaxOffset) {
            long caughtUpTimeMs = this.haService.getDefaultMessageStore().getMaxPhyOffset() == slaveMaxOffset ? System.currentTimeMillis() : this.lastTransferTimeMs;
            this.haService.updateConnectionLastCaughtUpTime(this.slaveId, caughtUpTimeMs);
            this.haService.maybeExpandInSyncStateSet(this.slaveId, slaveMaxOffset);
        }
    }

    abstract class AbstractWriteSocketService
    extends ServiceThread {
        protected final Selector selector;
        protected final SocketChannel socketChannel;
        protected final HAWriter haWriter;
        protected final ByteBuffer byteBufferHeader = ByteBuffer.allocate(36);
        private final ByteBuffer handShakeBuffer = ByteBuffer.allocate(12000);
        protected long nextTransferFromWhere = -1L;
        protected boolean lastWriteOver = true;
        protected long lastWriteTimestamp = System.currentTimeMillis();
        protected long lastPrintTimestamp = System.currentTimeMillis();
        protected long transferOffset = 0L;

        public AbstractWriteSocketService(SocketChannel socketChannel) throws IOException {
            this.selector = NetworkUtil.openSelector();
            this.socketChannel = socketChannel;
            this.socketChannel.register(this.selector, 4);
            this.setDaemon(true);
            this.haWriter = new HAWriter();
            this.haWriter.registerHook(writeSize -> {
                AutoSwitchHAConnection.this.flowMonitor.addByteCountTransferred(writeSize);
                if (writeSize > 0) {
                    this.lastWriteTimestamp = AutoSwitchHAConnection.this.haService.getDefaultMessageStore().getSystemClock().now();
                }
            });
        }

        public long getNextTransferFromWhere() {
            return this.nextTransferFromWhere;
        }

        private boolean buildHandshakeBuffer() {
            List<EpochEntry> epochEntries = AutoSwitchHAConnection.this.epochCache.getAllEntries();
            int lastEpoch = AutoSwitchHAConnection.this.epochCache.lastEpoch();
            long maxPhyOffset = AutoSwitchHAConnection.this.haService.getDefaultMessageStore().getMaxPhyOffset();
            this.byteBufferHeader.position(0);
            this.byteBufferHeader.limit(20);
            this.byteBufferHeader.putInt(AutoSwitchHAConnection.this.currentState.ordinal());
            this.byteBufferHeader.putInt(epochEntries.size() * 12);
            this.byteBufferHeader.putLong(maxPhyOffset);
            this.byteBufferHeader.putInt(lastEpoch);
            this.byteBufferHeader.flip();
            this.handShakeBuffer.position(0);
            this.handShakeBuffer.limit(12 * epochEntries.size());
            for (EpochEntry entry : epochEntries) {
                if (entry == null) continue;
                this.handShakeBuffer.putInt(entry.getEpoch());
                this.handShakeBuffer.putLong(entry.getStartOffset());
            }
            this.handShakeBuffer.flip();
            LOGGER.info("Master build handshake header: maxEpoch:{}, maxOffset:{}, epochEntries:{}", new Object[]{lastEpoch, maxPhyOffset, epochEntries});
            return true;
        }

        private boolean handshakeWithSlave() throws IOException {
            boolean result = this.haWriter.write(this.socketChannel, this.byteBufferHeader);
            if (!result) {
                return false;
            }
            return this.haWriter.write(this.socketChannel, this.handShakeBuffer);
        }

        private void buildTransferHeaderBuffer(long nextOffset, int bodySize) {
            EpochEntry entry = AutoSwitchHAConnection.this.epochCache.getEntry(AutoSwitchHAConnection.this.currentTransferEpoch);
            if (entry == null) {
                if (nextOffset != -1L || AutoSwitchHAConnection.this.currentTransferEpoch != -1 || bodySize > 0) {
                    LOGGER.error("Failed to find epochEntry with epoch {} when build msg header", (Object)AutoSwitchHAConnection.this.currentTransferEpoch);
                }
                if (bodySize > 0) {
                    return;
                }
                entry = AutoSwitchHAConnection.this.epochCache.firstEntry();
            }
            this.byteBufferHeader.position(0);
            this.byteBufferHeader.limit(36);
            this.byteBufferHeader.putInt(AutoSwitchHAConnection.this.currentState.ordinal());
            this.byteBufferHeader.putInt(bodySize);
            this.byteBufferHeader.putLong(nextOffset);
            this.byteBufferHeader.putInt(entry.getEpoch());
            this.byteBufferHeader.putLong(entry.getStartOffset());
            long confirmOffset = AutoSwitchHAConnection.this.haService.getDefaultMessageStore().getConfirmOffset();
            this.byteBufferHeader.putLong(confirmOffset);
            this.byteBufferHeader.flip();
        }

        private boolean sendHeartbeatIfNeeded() throws Exception {
            long interval = AutoSwitchHAConnection.this.haService.getDefaultMessageStore().getSystemClock().now() - this.lastWriteTimestamp;
            if (interval > (long)AutoSwitchHAConnection.this.haService.getDefaultMessageStore().getMessageStoreConfig().getHaSendHeartbeatInterval()) {
                this.buildTransferHeaderBuffer(this.nextTransferFromWhere, 0);
                return this.transferData(0);
            }
            return true;
        }

        private void transferToSlave() throws Exception {
            this.lastWriteOver = this.lastWriteOver ? this.sendHeartbeatIfNeeded() : this.transferData(-1);
            if (!this.lastWriteOver) {
                return;
            }
            int size = this.getNextTransferDataSize();
            if (size > 0) {
                int canTransferMaxBytes;
                if (size > AutoSwitchHAConnection.this.haService.getDefaultMessageStore().getMessageStoreConfig().getHaTransferBatchSize()) {
                    size = AutoSwitchHAConnection.this.haService.getDefaultMessageStore().getMessageStoreConfig().getHaTransferBatchSize();
                }
                if (size > (canTransferMaxBytes = AutoSwitchHAConnection.this.flowMonitor.canTransferMaxByteNum())) {
                    if (System.currentTimeMillis() - this.lastPrintTimestamp > 1000L) {
                        LOGGER.warn("Trigger HA flow control, max transfer speed {}KB/s, current speed: {}KB/s", (Object)String.format("%.2f", (double)AutoSwitchHAConnection.this.flowMonitor.maxTransferByteInSecond() / 1024.0), (Object)String.format("%.2f", (double)AutoSwitchHAConnection.this.flowMonitor.getTransferredByteInSecond() / 1024.0));
                        this.lastPrintTimestamp = System.currentTimeMillis();
                    }
                    size = canTransferMaxBytes;
                }
                if (size <= 0) {
                    this.releaseData();
                    this.waitForRunning(100L);
                    return;
                }
                long currentEpochEndOffset = AutoSwitchHAConnection.this.currentTransferEpochEndOffset;
                if (currentEpochEndOffset != -1L && this.nextTransferFromWhere + (long)size > currentEpochEndOffset) {
                    EpochEntry epochEntry = AutoSwitchHAConnection.this.epochCache.nextEntry(AutoSwitchHAConnection.this.currentTransferEpoch);
                    if (epochEntry == null) {
                        LOGGER.error("Can't find a bigger epochEntry than epoch {}", (Object)AutoSwitchHAConnection.this.currentTransferEpoch);
                        this.waitForRunning(100L);
                        return;
                    }
                    size = (int)(currentEpochEndOffset - this.nextTransferFromWhere);
                    AutoSwitchHAConnection.this.changeTransferEpochToNext(epochEntry);
                }
                this.transferOffset = this.nextTransferFromWhere;
                this.nextTransferFromWhere += (long)size;
                AutoSwitchHAConnection.this.updateLastTransferInfo();
                this.buildTransferHeaderBuffer(this.transferOffset, size);
                this.lastWriteOver = this.transferData(size);
            } else {
                AutoSwitchHAConnection.this.haService.updateConnectionLastCaughtUpTime(AutoSwitchHAConnection.this.slaveId, System.currentTimeMillis());
                AutoSwitchHAConnection.this.haService.getWaitNotifyObject().allWaitForRunning(100L);
            }
        }

        public void run() {
            LOGGER.info(this.getServiceName() + " service started");
            block8: while (!this.isStopped()) {
                try {
                    this.selector.select(1000L);
                    switch (AutoSwitchHAConnection.this.currentState) {
                        case HANDSHAKE: {
                            if (!AutoSwitchHAConnection.this.isSlaveSendHandshake) {
                                this.waitForRunning(10L);
                                continue block8;
                            }
                            if (this.lastWriteOver && !this.buildHandshakeBuffer()) {
                                LOGGER.error("AutoSwitchHAConnection build handshake buffer failed");
                                this.waitForRunning(5000L);
                                continue block8;
                            }
                            this.lastWriteOver = this.handshakeWithSlave();
                            if (!this.lastWriteOver) continue block8;
                            AutoSwitchHAConnection.this.isSlaveSendHandshake = false;
                            continue block8;
                        }
                        case TRANSFER: {
                            if (-1L == AutoSwitchHAConnection.this.slaveRequestOffset) {
                                this.waitForRunning(10L);
                                continue block8;
                            }
                            if (-1L == this.nextTransferFromWhere) {
                                if (0L == AutoSwitchHAConnection.this.slaveRequestOffset) {
                                    MessageStoreConfig config = AutoSwitchHAConnection.this.haService.getDefaultMessageStore().getMessageStoreConfig();
                                    if (AutoSwitchHAConnection.this.isSyncFromLastFile) {
                                        long masterOffset = AutoSwitchHAConnection.this.haService.getDefaultMessageStore().getCommitLog().getMaxOffset();
                                        if ((masterOffset -= masterOffset % (long)config.getMappedFileSizeCommitLog()) < 0L) {
                                            masterOffset = 0L;
                                        }
                                        this.nextTransferFromWhere = masterOffset;
                                    } else {
                                        this.nextTransferFromWhere = AutoSwitchHAConnection.this.haService.getDefaultMessageStore().getCommitLog().getMinOffset();
                                    }
                                } else {
                                    this.nextTransferFromWhere = AutoSwitchHAConnection.this.slaveRequestOffset;
                                }
                                if (this.nextTransferFromWhere == -1L) {
                                    this.sendHeartbeatIfNeeded();
                                    this.waitForRunning(500L);
                                    continue block8;
                                }
                                EpochEntry epochEntry = AutoSwitchHAConnection.this.epochCache.findEpochEntryByOffset(this.nextTransferFromWhere);
                                if (epochEntry == null) {
                                    LOGGER.error("Failed to find an epochEntry to match nextTransferFromWhere {}", (Object)this.nextTransferFromWhere);
                                    this.sendHeartbeatIfNeeded();
                                    this.waitForRunning(500L);
                                    continue block8;
                                }
                                AutoSwitchHAConnection.this.changeTransferEpochToNext(epochEntry);
                                LOGGER.info("Master transfer data to slave {}, from offset:{}, currentEpoch:{}", new Object[]{AutoSwitchHAConnection.this.clientAddress, this.nextTransferFromWhere, epochEntry});
                            }
                            this.transferToSlave();
                            continue block8;
                        }
                    }
                    throw new Exception("unexpected state " + (Object)((Object)AutoSwitchHAConnection.this.currentState));
                }
                catch (Exception e) {
                    LOGGER.error(this.getServiceName() + " service has exception.", (Throwable)e);
                    break;
                }
            }
            this.onStop();
            AutoSwitchHAConnection.this.changeCurrentState(HAConnectionState.SHUTDOWN);
            this.makeStop();
            AutoSwitchHAConnection.this.readSocketService.makeStop();
            AutoSwitchHAConnection.this.haService.removeConnection(AutoSwitchHAConnection.this);
            SelectionKey sk = this.socketChannel.keyFor(this.selector);
            if (sk != null) {
                sk.cancel();
            }
            try {
                this.selector.close();
                this.socketChannel.close();
            }
            catch (IOException e) {
                LOGGER.error("", (Throwable)e);
            }
            AutoSwitchHAConnection.this.flowMonitor.shutdown(true);
            LOGGER.info(this.getServiceName() + " service end");
        }

        protected abstract int getNextTransferDataSize();

        protected abstract void releaseData();

        protected abstract boolean transferData(int var1) throws Exception;

        protected abstract void onStop();
    }

    class WriteSocketService
    extends AbstractWriteSocketService {
        private SelectMappedBufferResult selectMappedBufferResult;

        public WriteSocketService(SocketChannel socketChannel) throws IOException {
            super(socketChannel);
        }

        @Override
        protected int getNextTransferDataSize() {
            SelectMappedBufferResult selectResult = AutoSwitchHAConnection.this.haService.getDefaultMessageStore().getCommitLogData(this.nextTransferFromWhere);
            if (selectResult == null || selectResult.getSize() <= 0) {
                return 0;
            }
            this.selectMappedBufferResult = selectResult;
            return selectResult.getSize();
        }

        @Override
        protected void releaseData() {
            this.selectMappedBufferResult.release();
            this.selectMappedBufferResult = null;
        }

        @Override
        protected boolean transferData(int maxTransferSize) throws Exception {
            boolean result;
            if (null != this.selectMappedBufferResult && maxTransferSize >= 0) {
                this.selectMappedBufferResult.getByteBuffer().limit(maxTransferSize);
            }
            if (!(result = this.haWriter.write(this.socketChannel, this.byteBufferHeader))) {
                return false;
            }
            if (null == this.selectMappedBufferResult) {
                return true;
            }
            result = this.haWriter.write(this.socketChannel, this.selectMappedBufferResult.getByteBuffer());
            if (result) {
                this.releaseData();
            }
            return result;
        }

        @Override
        protected void onStop() {
            if (this.selectMappedBufferResult != null) {
                this.selectMappedBufferResult.release();
            }
        }

        public String getServiceName() {
            if (AutoSwitchHAConnection.this.haService.getDefaultMessageStore().getBrokerConfig().isInBrokerContainer()) {
                return AutoSwitchHAConnection.this.haService.getDefaultMessageStore().getBrokerIdentity().getIdentifier() + WriteSocketService.class.getSimpleName();
            }
            return WriteSocketService.class.getSimpleName();
        }
    }

    class ReadSocketService
    extends ServiceThread {
        private static final int READ_MAX_BUFFER_SIZE = 0x100000;
        private final Selector selector;
        private final SocketChannel socketChannel;
        private final ByteBuffer byteBufferRead = ByteBuffer.allocate(0x100000);
        private final AbstractHAReader haReader;
        private int processPosition = 0;
        private volatile long lastReadTimestamp = System.currentTimeMillis();

        public ReadSocketService(SocketChannel socketChannel) throws IOException {
            this.selector = NetworkUtil.openSelector();
            this.socketChannel = socketChannel;
            this.socketChannel.register(this.selector, 1);
            this.setDaemon(true);
            this.haReader = new HAServerReader();
            this.haReader.registerHook(readSize -> {
                if (readSize > 0) {
                    this.lastReadTimestamp = AutoSwitchHAConnection.this.haService.getDefaultMessageStore().getSystemClock().now();
                }
            });
        }

        public void run() {
            LOGGER.info(this.getServiceName() + " service started");
            while (!this.isStopped()) {
                try {
                    this.selector.select(1000L);
                    boolean ok = this.haReader.read(this.socketChannel, this.byteBufferRead);
                    if (!ok) {
                        LOGGER.error("processReadEvent error");
                        break;
                    }
                    long interval = AutoSwitchHAConnection.this.haService.getDefaultMessageStore().getSystemClock().now() - this.lastReadTimestamp;
                    if (interval <= (long)AutoSwitchHAConnection.this.haService.getDefaultMessageStore().getMessageStoreConfig().getHaHousekeepingInterval()) continue;
                    LOGGER.warn("ha housekeeping, found this connection[" + AutoSwitchHAConnection.this.clientAddress + "] expired, " + interval);
                    break;
                }
                catch (Exception e) {
                    LOGGER.error(this.getServiceName() + " service has exception.", (Throwable)e);
                    break;
                }
            }
            this.makeStop();
            AutoSwitchHAConnection.this.changeCurrentState(HAConnectionState.SHUTDOWN);
            AutoSwitchHAConnection.this.writeSocketService.makeStop();
            AutoSwitchHAConnection.this.haService.removeConnection(AutoSwitchHAConnection.this);
            AutoSwitchHAConnection.this.haService.getConnectionCount().decrementAndGet();
            SelectionKey sk = this.socketChannel.keyFor(this.selector);
            if (sk != null) {
                sk.cancel();
            }
            try {
                this.selector.close();
                this.socketChannel.close();
            }
            catch (IOException e) {
                LOGGER.error("", (Throwable)e);
            }
            AutoSwitchHAConnection.this.flowMonitor.shutdown(true);
            LOGGER.info(this.getServiceName() + " service end");
        }

        public String getServiceName() {
            if (AutoSwitchHAConnection.this.haService.getDefaultMessageStore().getBrokerConfig().isInBrokerContainer()) {
                return AutoSwitchHAConnection.this.haService.getDefaultMessageStore().getBrokerIdentity().getIdentifier() + ReadSocketService.class.getSimpleName();
            }
            return ReadSocketService.class.getSimpleName();
        }

        class HAServerReader
        extends AbstractHAReader {
            HAServerReader() {
            }

            @Override
            protected boolean processReadResult(ByteBuffer byteBufferRead) {
                block8: {
                    boolean processSuccess;
                    do {
                        processSuccess = true;
                        int readSocketPos = byteBufferRead.position();
                        int diff = byteBufferRead.position() - ReadSocketService.this.processPosition;
                        if (diff < AutoSwitchHAClient.MIN_HEADER_SIZE) break;
                        int readPosition = ReadSocketService.this.processPosition;
                        HAConnectionState slaveState = HAConnectionState.values()[byteBufferRead.getInt(readPosition)];
                        switch (slaveState) {
                            case HANDSHAKE: {
                                short isAsyncLearner;
                                Long slaveBrokerId = byteBufferRead.getLong(readPosition + 16 - 8);
                                AutoSwitchHAConnection.this.slaveId = slaveBrokerId;
                                short syncFromLastFileFlag = byteBufferRead.getShort(readPosition + 16 - 12);
                                if (syncFromLastFileFlag == 1) {
                                    AutoSwitchHAConnection.this.isSyncFromLastFile = true;
                                }
                                if ((isAsyncLearner = byteBufferRead.getShort(readPosition + 16 - 10)) == 1) {
                                    AutoSwitchHAConnection.this.isAsyncLearner = true;
                                }
                                AutoSwitchHAConnection.this.isSlaveSendHandshake = true;
                                byteBufferRead.position(readSocketPos);
                                ReadSocketService readSocketService = ReadSocketService.this;
                                readSocketService.processPosition = readSocketService.processPosition + 16;
                                LOGGER.info("Receive slave handshake, slaveBrokerId:{}, isSyncFromLastFile:{}, isAsyncLearner:{}", new Object[]{AutoSwitchHAConnection.this.slaveId, AutoSwitchHAConnection.this.isSyncFromLastFile, AutoSwitchHAConnection.this.isAsyncLearner});
                                break;
                            }
                            case TRANSFER: {
                                long slaveMaxOffset = byteBufferRead.getLong(readPosition + 4);
                                ReadSocketService readSocketService = ReadSocketService.this;
                                readSocketService.processPosition = readSocketService.processPosition + 12;
                                AutoSwitchHAConnection.this.slaveAckOffset = slaveMaxOffset;
                                if (AutoSwitchHAConnection.this.slaveRequestOffset < 0L) {
                                    AutoSwitchHAConnection.this.slaveRequestOffset = slaveMaxOffset;
                                }
                                byteBufferRead.position(readSocketPos);
                                AutoSwitchHAConnection.this.maybeExpandInSyncStateSet(slaveMaxOffset);
                                AutoSwitchHAConnection.this.haService.updateConfirmOffsetWhenSlaveAck(AutoSwitchHAConnection.this.slaveId);
                                AutoSwitchHAConnection.this.haService.notifyTransferSome(AutoSwitchHAConnection.this.slaveAckOffset);
                                break;
                            }
                            default: {
                                LOGGER.error("Current state illegal {}", (Object)AutoSwitchHAConnection.this.currentState);
                                return false;
                            }
                        }
                        if (slaveState.equals((Object)AutoSwitchHAConnection.this.currentState)) continue;
                        LOGGER.warn("Master change state from {} to {}", (Object)AutoSwitchHAConnection.this.currentState, (Object)slaveState);
                        AutoSwitchHAConnection.this.changeCurrentState(slaveState);
                    } while (processSuccess);
                    if (byteBufferRead.hasRemaining()) break block8;
                    byteBufferRead.position(ReadSocketService.this.processPosition);
                    byteBufferRead.compact();
                    ReadSocketService.this.processPosition = 0;
                }
                return true;
            }
        }
    }
}

