/*
 * Decompiled with CFR 0.152.
 */
package com.conversantmedia.util.concurrent;

import com.conversantmedia.util.concurrent.ContendedAtomicLong;
import com.conversantmedia.util.concurrent.ContendedLong;
import java.util.concurrent.atomic.AtomicLong;

public final class AtomicSequence {
    private final AtomicLong cursor = new ContendedAtomicLong(0L);
    private final AtomicLong sequence = new ContendedAtomicLong(0L);
    private final ContendedLong sequenceCache = new ContendedLong(0L);

    public long get() {
        return this.sequenceCache.value;
    }

    public long getAtomic() {
        this.sequenceCache.value = this.sequence.get();
        return this.sequenceCache.value;
    }

    public boolean update(long sequence) {
        if (this.cursor.compareAndSet(sequence, sequence + 1L)) {
            return true;
        }
        this.sequenceCache.value = this.sequence.get();
        return false;
    }

    public void commit() {
        this.sequence.set(this.cursor.get());
        this.sequenceCache.value = this.sequence.get();
    }
}

