/*
 * Decompiled with CFR 0.152.
 */
package org.apache.rocketmq.common;

import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.rocketmq.common.CountDownLatch2;
import org.apache.rocketmq.logging.org.slf4j.Logger;
import org.apache.rocketmq.logging.org.slf4j.LoggerFactory;

public abstract class ServiceThread
implements Runnable {
    private static final Logger log = LoggerFactory.getLogger((String)"RocketmqCommon");
    private static final long JOIN_TIME = 90000L;
    protected Thread thread;
    protected final CountDownLatch2 waitPoint = new CountDownLatch2(1);
    protected volatile AtomicBoolean hasNotified = new AtomicBoolean(false);
    protected volatile boolean stopped = false;
    protected boolean isDaemon = false;
    private final AtomicBoolean started = new AtomicBoolean(false);

    public abstract String getServiceName();

    public void start() {
        log.info("Try to start service thread:{} started:{} lastThread:{}", new Object[]{this.getServiceName(), this.started.get(), this.thread});
        if (!this.started.compareAndSet(false, true)) {
            return;
        }
        this.stopped = false;
        this.thread = new Thread((Runnable)this, this.getServiceName());
        this.thread.setDaemon(this.isDaemon);
        this.thread.start();
        log.info("Start service thread:{} started:{} lastThread:{}", new Object[]{this.getServiceName(), this.started.get(), this.thread});
    }

    public void shutdown() {
        this.shutdown(false);
    }

    public void shutdown(boolean interrupt) {
        log.info("Try to shutdown service thread:{} started:{} lastThread:{}", new Object[]{this.getServiceName(), this.started.get(), this.thread});
        if (!this.started.compareAndSet(true, false)) {
            return;
        }
        this.stopped = true;
        log.info("shutdown thread[{}] interrupt={} ", (Object)this.getServiceName(), (Object)interrupt);
        this.wakeup();
        try {
            if (interrupt) {
                this.thread.interrupt();
            }
            long beginTime = System.currentTimeMillis();
            if (!this.thread.isDaemon()) {
                this.thread.join(this.getJoinTime());
            }
            long elapsedTime = System.currentTimeMillis() - beginTime;
            log.info("join thread[{}], elapsed time: {}ms, join time:{}ms", new Object[]{this.getServiceName(), elapsedTime, this.getJoinTime()});
        }
        catch (InterruptedException e) {
            log.error("Interrupted", (Throwable)e);
        }
    }

    public long getJoinTime() {
        return 90000L;
    }

    public void makeStop() {
        if (!this.started.get()) {
            return;
        }
        this.stopped = true;
        log.info("makestop thread[{}] ", (Object)this.getServiceName());
    }

    public void wakeup() {
        if (this.hasNotified.compareAndSet(false, true)) {
            this.waitPoint.countDown();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void waitForRunning(long interval) {
        if (this.hasNotified.compareAndSet(true, false)) {
            this.onWaitEnd();
            return;
        }
        this.waitPoint.reset();
        try {
            this.waitPoint.await(interval, TimeUnit.MILLISECONDS);
        }
        catch (InterruptedException e) {
            log.error("Interrupted", (Throwable)e);
        }
        finally {
            this.hasNotified.set(false);
            this.onWaitEnd();
        }
    }

    protected void onWaitEnd() {
    }

    public boolean isStopped() {
        return this.stopped;
    }

    public boolean isDaemon() {
        return this.isDaemon;
    }

    public void setDaemon(boolean daemon) {
        this.isDaemon = daemon;
    }
}

