/*
 * Decompiled with CFR 0.152.
 */
package org.apache.rocketmq.store.queue;

import java.io.File;
import java.nio.ByteBuffer;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentSkipListMap;
import java.util.function.Function;
import org.apache.commons.lang3.StringUtils;
import org.apache.rocketmq.common.BoundaryType;
import org.apache.rocketmq.common.attribute.CQType;
import org.apache.rocketmq.common.message.Message;
import org.apache.rocketmq.common.message.MessageAccessor;
import org.apache.rocketmq.common.message.MessageDecoder;
import org.apache.rocketmq.common.message.MessageExtBrokerInner;
import org.apache.rocketmq.common.sysflag.MessageSysFlag;
import org.apache.rocketmq.logging.org.slf4j.Logger;
import org.apache.rocketmq.logging.org.slf4j.LoggerFactory;
import org.apache.rocketmq.store.DispatchRequest;
import org.apache.rocketmq.store.MappedFileQueue;
import org.apache.rocketmq.store.MessageFilter;
import org.apache.rocketmq.store.MessageStore;
import org.apache.rocketmq.store.SelectMappedBufferResult;
import org.apache.rocketmq.store.config.BrokerRole;
import org.apache.rocketmq.store.logfile.MappedFile;
import org.apache.rocketmq.store.queue.BatchOffsetIndex;
import org.apache.rocketmq.store.queue.ConsumeQueueInterface;
import org.apache.rocketmq.store.queue.CqUnit;
import org.apache.rocketmq.store.queue.QueueOffsetOperator;
import org.apache.rocketmq.store.queue.ReferredIterator;

public class BatchConsumeQueue
implements ConsumeQueueInterface {
    protected static final Logger log = LoggerFactory.getLogger((String)"RocketmqStore");
    public static final int CQ_STORE_UNIT_SIZE = 46;
    public static final int MSG_TAG_OFFSET_INDEX = 12;
    public static final int MSG_STORE_TIME_OFFSET_INDEX = 20;
    public static final int MSG_BASE_OFFSET_INDEX = 28;
    public static final int MSG_BATCH_SIZE_INDEX = 36;
    public static final int MSG_COMPACT_OFFSET_INDEX = 38;
    private static final int MSG_COMPACT_OFFSET_LENGTH = 4;
    public static final int INVALID_POS = -1;
    protected final MappedFileQueue mappedFileQueue;
    protected MessageStore messageStore;
    protected final String topic;
    protected final int queueId;
    protected final ByteBuffer byteBufferItem;
    protected final String storePath;
    protected final int mappedFileSize;
    protected volatile long maxMsgPhyOffsetInCommitLog = -1L;
    protected volatile long minLogicOffset = 0L;
    protected volatile long maxOffsetInQueue = 0L;
    protected volatile long minOffsetInQueue = -1L;
    protected final int commitLogSize;
    protected ConcurrentSkipListMap<Long, MappedFile> offsetCache = new ConcurrentSkipListMap();
    protected ConcurrentSkipListMap<Long, MappedFile> timeCache = new ConcurrentSkipListMap();

    public BatchConsumeQueue(String topic, int queueId, String storePath, int mappedFileSize, MessageStore messageStore, String subfolder) {
        this.storePath = storePath;
        this.mappedFileSize = mappedFileSize;
        this.messageStore = messageStore;
        this.commitLogSize = messageStore.getCommitLog().getCommitLogSize();
        this.topic = topic;
        this.queueId = queueId;
        if (StringUtils.isBlank((CharSequence)subfolder)) {
            String queueDir = this.storePath + File.separator + topic + File.separator + queueId;
            this.mappedFileQueue = new MappedFileQueue(queueDir, mappedFileSize, null);
        } else {
            String queueDir = this.storePath + File.separator + topic + File.separator + queueId + File.separator + subfolder;
            this.mappedFileQueue = new MappedFileQueue(queueDir, mappedFileSize, null);
        }
        this.byteBufferItem = ByteBuffer.allocate(46);
    }

    public BatchConsumeQueue(String topic, int queueId, String storePath, int mappedFileSize, MessageStore defaultMessageStore) {
        this(topic, queueId, storePath, mappedFileSize, defaultMessageStore, "");
    }

    @Override
    public boolean load() {
        boolean result = this.mappedFileQueue.load();
        log.info("Load batch consume queue {}-{} {} {}", new Object[]{this.topic, this.queueId, result ? "OK" : "Failed", this.mappedFileQueue.getMappedFiles().size()});
        return result;
    }

    protected void doRefreshCache(Function<MappedFile, BatchOffsetIndex> offsetFunction) {
        if (!this.messageStore.getMessageStoreConfig().isSearchBcqByCacheEnable()) {
            return;
        }
        ConcurrentSkipListMap<Long, MappedFile> newOffsetCache = new ConcurrentSkipListMap<Long, MappedFile>();
        ConcurrentSkipListMap<Long, MappedFile> newTimeCache = new ConcurrentSkipListMap<Long, MappedFile>();
        List<MappedFile> mappedFiles = this.mappedFileQueue.getMappedFiles();
        for (int i = 0; i < mappedFiles.size(); ++i) {
            BatchOffsetIndex offset;
            MappedFile bcq = mappedFiles.get(i);
            if (this.isNewFile(bcq) || (offset = offsetFunction.apply(bcq)) == null) continue;
            newOffsetCache.put(offset.getMsgOffset(), offset.getMappedFile());
            newTimeCache.put(offset.getStoreTimestamp(), offset.getMappedFile());
        }
        this.offsetCache = newOffsetCache;
        this.timeCache = newTimeCache;
        log.info("refreshCache for BCQ [Topic: {}, QueueId: {}].offsetCacheSize: {}, minCachedMsgOffset: {}, maxCachedMsgOffset: {}, timeCacheSize: {}, minCachedTime: {}, maxCachedTime: {}", new Object[]{this.topic, this.queueId, this.offsetCache.size(), this.offsetCache.firstEntry(), this.offsetCache.lastEntry(), this.timeCache.size(), this.timeCache.firstEntry(), this.timeCache.lastEntry()});
    }

    protected void refreshCache() {
        this.doRefreshCache(m -> this.getMinMsgOffset((MappedFile)m, false, true));
    }

    private void destroyCache() {
        this.offsetCache.clear();
        this.timeCache.clear();
        log.info("BCQ [Topic: {}, QueueId: {}]. Cache destroyed", (Object)this.topic, (Object)this.queueId);
    }

    protected void cacheBcq(MappedFile bcq) {
        try {
            BatchOffsetIndex min = this.getMinMsgOffset(bcq, false, true);
            this.offsetCache.put(min.getMsgOffset(), min.getMappedFile());
            this.timeCache.put(min.getStoreTimestamp(), min.getMappedFile());
        }
        catch (Exception e) {
            log.error("Failed caching offset and time on BCQ [Topic: {}, QueueId: {}, File: {}]", new Object[]{this.topic, this.queueId, bcq});
        }
    }

    protected boolean isNewFile(MappedFile mappedFile) {
        return mappedFile.getReadPosition() < 46;
    }

    protected MappedFile searchOffsetFromCache(long msgOffset) {
        Map.Entry<Long, MappedFile> floorEntry = this.offsetCache.floorEntry(msgOffset);
        if (floorEntry == null) {
            return null;
        }
        return floorEntry.getValue();
    }

    private MappedFile searchTimeFromCache(long time) {
        Map.Entry<Long, MappedFile> floorEntry = this.timeCache.floorEntry(time);
        if (floorEntry == null) {
            return this.mappedFileQueue.getFirstMappedFile();
        }
        return floorEntry.getValue();
    }

    @Override
    public void recover() {
        List<MappedFile> mappedFiles = this.mappedFileQueue.getMappedFiles();
        if (!mappedFiles.isEmpty()) {
            long mappedFileOffset;
            long processOffset;
            block6: {
                int index = mappedFiles.size() - 3;
                if (index < 0) {
                    index = 0;
                }
                int mappedFileSizeLogics = this.mappedFileSize;
                MappedFile mappedFile = mappedFiles.get(index);
                ByteBuffer byteBuffer = mappedFile.sliceByteBuffer();
                processOffset = mappedFile.getFileFromOffset();
                mappedFileOffset = 0L;
                while (true) {
                    for (int i = 0; i < mappedFileSizeLogics; i += 46) {
                        byteBuffer.position(i);
                        long offset = byteBuffer.getLong();
                        int size = byteBuffer.getInt();
                        byteBuffer.getLong();
                        byteBuffer.getLong();
                        long msgBaseOffset = byteBuffer.getLong();
                        short batchSize = byteBuffer.getShort();
                        if (offset < 0L || size <= 0 || msgBaseOffset < 0L || batchSize <= 0) {
                            log.info("Recover current batch consume queue file over, file:{} offset:{} size:{} msgBaseOffset:{} batchSize:{} mappedFileOffset:{}", new Object[]{mappedFile.getFileName(), offset, size, msgBaseOffset, batchSize, mappedFileOffset});
                            break;
                        }
                        mappedFileOffset = i + 46;
                        this.maxMsgPhyOffsetInCommitLog = offset;
                    }
                    if (mappedFileOffset != (long)mappedFileSizeLogics) break;
                    if (++index >= mappedFiles.size()) {
                        log.info("Recover last batch consume queue file over, last mapped file:{} ", (Object)mappedFile.getFileName());
                        break block6;
                    }
                    mappedFile = mappedFiles.get(index);
                    byteBuffer = mappedFile.sliceByteBuffer();
                    processOffset = mappedFile.getFileFromOffset();
                    mappedFileOffset = 0L;
                    log.info("Recover next batch consume queue file: " + mappedFile.getFileName());
                }
                log.info("Recover current batch consume queue file over:{} processOffset:{}", (Object)mappedFile.getFileName(), (Object)(processOffset + mappedFileOffset));
            }
            this.mappedFileQueue.setFlushedWhere(processOffset += mappedFileOffset);
            this.mappedFileQueue.setCommittedWhere(processOffset);
            this.mappedFileQueue.truncateDirtyFiles(processOffset);
            this.reviseMaxAndMinOffsetInQueue();
        }
    }

    void reviseMinOffsetInQueue() {
        MappedFile firstMappedFile = this.mappedFileQueue.getFirstMappedFile();
        if (null == firstMappedFile) {
            this.maxOffsetInQueue = 0L;
            this.minOffsetInQueue = -1L;
            this.minLogicOffset = -1L;
            log.info("reviseMinOffsetInQueue found firstMappedFile null, topic:{} queue:{}", (Object)this.topic, (Object)this.queueId);
            return;
        }
        this.minLogicOffset = firstMappedFile.getFileFromOffset();
        BatchOffsetIndex min = this.getMinMsgOffset(firstMappedFile, false, false);
        this.minOffsetInQueue = null == min ? -1L : min.getMsgOffset();
    }

    void reviseMaxOffsetInQueue() {
        MappedFile lastMappedFile = this.mappedFileQueue.getLastMappedFile();
        BatchOffsetIndex max = this.getMaxMsgOffset(lastMappedFile, true, false);
        if (null == max && this.mappedFileQueue.getMappedFiles().size() >= 2) {
            MappedFile lastTwoMappedFile = this.mappedFileQueue.getMappedFiles().get(this.mappedFileQueue.getMappedFiles().size() - 2);
            max = this.getMaxMsgOffset(lastTwoMappedFile, true, false);
        }
        this.maxOffsetInQueue = null == max ? 0L : max.getMsgOffset() + (long)max.getBatchSize();
    }

    void reviseMaxAndMinOffsetInQueue() {
        this.reviseMinOffsetInQueue();
        this.reviseMaxOffsetInQueue();
    }

    @Override
    public long getMaxPhysicOffset() {
        return this.maxMsgPhyOffsetInCommitLog;
    }

    @Override
    public long getMinLogicOffset() {
        return this.minLogicOffset;
    }

    @Override
    public ReferredIterator<CqUnit> iterateFrom(long startOffset) {
        SelectMappedBufferResult sbr = this.getBatchMsgIndexBuffer(startOffset);
        if (sbr == null) {
            return null;
        }
        return new BatchConsumeQueueIterator(sbr);
    }

    @Override
    public CqUnit get(long offset) {
        ReferredIterator<CqUnit> it = this.iterateFrom(offset);
        if (it == null) {
            return null;
        }
        return it.nextAndRelease();
    }

    @Override
    public CqUnit getEarliestUnit() {
        return this.get(this.minOffsetInQueue);
    }

    @Override
    public CqUnit getLatestUnit() {
        return this.get(this.maxOffsetInQueue - 1L);
    }

    @Override
    public long getLastOffset() {
        CqUnit latestUnit = this.getLatestUnit();
        return latestUnit.getPos() + (long)latestUnit.getSize();
    }

    @Override
    public boolean isFirstFileAvailable() {
        MappedFile mappedFile = this.mappedFileQueue.getFirstMappedFile();
        if (mappedFile != null) {
            return mappedFile.isAvailable();
        }
        return false;
    }

    @Override
    public boolean isFirstFileExist() {
        MappedFile mappedFile = this.mappedFileQueue.getFirstMappedFile();
        return mappedFile != null;
    }

    @Override
    public void truncateDirtyLogicFiles(long phyOffset) {
        MappedFile mappedFile;
        long oldMinOffset = this.minOffsetInQueue;
        long oldMaxOffset = this.maxOffsetInQueue;
        int logicFileSize = this.mappedFileSize;
        this.maxMsgPhyOffsetInCommitLog = phyOffset - 1L;
        boolean stop = false;
        block0: while (!stop && (mappedFile = this.mappedFileQueue.getLastMappedFile()) != null) {
            ByteBuffer byteBuffer = mappedFile.sliceByteBuffer();
            mappedFile.setWrotePosition(0);
            mappedFile.setCommittedPosition(0);
            mappedFile.setFlushedPosition(0);
            for (int i = 0; i < logicFileSize; i += 46) {
                int pos;
                byteBuffer.position(i);
                long offset = byteBuffer.getLong();
                int size = byteBuffer.getInt();
                byteBuffer.getLong();
                byteBuffer.getLong();
                long msgBaseOffset = byteBuffer.getLong();
                short batchSize = byteBuffer.getShort();
                if (0 == i) {
                    if (offset >= phyOffset) {
                        this.mappedFileQueue.deleteLastMappedFile();
                        continue block0;
                    }
                    pos = i + 46;
                    mappedFile.setWrotePosition(pos);
                    mappedFile.setCommittedPosition(pos);
                    mappedFile.setFlushedPosition(pos);
                    this.maxMsgPhyOffsetInCommitLog = offset;
                    continue;
                }
                if (offset >= 0L && size > 0 && msgBaseOffset >= 0L && batchSize > 0) {
                    if (offset >= phyOffset) {
                        stop = true;
                        continue block0;
                    }
                    pos = i + 46;
                    mappedFile.setWrotePosition(pos);
                    mappedFile.setCommittedPosition(pos);
                    mappedFile.setFlushedPosition(pos);
                    this.maxMsgPhyOffsetInCommitLog = offset;
                    if (pos != logicFileSize) continue;
                    stop = true;
                    continue block0;
                }
                stop = true;
                continue block0;
            }
        }
        this.reviseMaxAndMinOffsetInQueue();
        log.info("Truncate batch logic file topic={} queue={} oldMinOffset={} oldMaxOffset={} minOffset={} maxOffset={} maxPhyOffsetHere={} maxPhyOffsetThere={}", new Object[]{this.topic, this.queueId, oldMinOffset, oldMaxOffset, this.minOffsetInQueue, this.maxOffsetInQueue, this.maxMsgPhyOffsetInCommitLog, phyOffset});
    }

    @Override
    public boolean flush(int flushLeastPages) {
        boolean result = this.mappedFileQueue.flush(flushLeastPages);
        return result;
    }

    @Override
    public int deleteExpiredFile(long minCommitLogPos) {
        int cnt = this.mappedFileQueue.deleteExpiredFileByOffset(minCommitLogPos, 46);
        this.correctMinOffset(minCommitLogPos);
        return cnt;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void correctMinOffset(long phyMinOffset) {
        this.reviseMinOffsetInQueue();
        this.refreshCache();
        long oldMinOffset = this.minOffsetInQueue;
        MappedFile mappedFile = this.mappedFileQueue.getFirstMappedFile();
        if (mappedFile != null) {
            SelectMappedBufferResult result = mappedFile.selectMappedBuffer(0);
            if (result != null) {
                try {
                    int startPos = result.getByteBuffer().position();
                    for (int i = 0; i < result.getSize(); i += 46) {
                        result.getByteBuffer().position(startPos + i);
                        long offsetPy = result.getByteBuffer().getLong();
                        result.getByteBuffer().getInt();
                        result.getByteBuffer().getLong();
                        result.getByteBuffer().getLong();
                        long msgBaseOffset = result.getByteBuffer().getLong();
                        short batchSize = result.getByteBuffer().getShort();
                        if (offsetPy >= phyMinOffset) break;
                        this.minOffsetInQueue = msgBaseOffset + (long)batchSize;
                    }
                }
                catch (Exception e) {
                    log.error("Exception thrown when correctMinOffset", (Throwable)e);
                }
                finally {
                    result.release();
                }
            } else {
                log.warn("Correct min offset found null cq file topic:{} queue:{} files:{} minOffset:{} maxOffset:{}", new Object[]{this.topic, this.queueId, this.mappedFileQueue.getMappedFiles().size(), this.minOffsetInQueue, this.maxOffsetInQueue});
            }
        }
        if (oldMinOffset != this.minOffsetInQueue) {
            log.info("BatchCQ Compute new minOffset:{} oldMinOffset{} topic:{} queue:{}", new Object[]{this.minOffsetInQueue, oldMinOffset, this.topic, this.queueId});
        }
    }

    @Override
    public void putMessagePositionInfoWrapper(DispatchRequest request) {
        int maxRetries = 30;
        boolean canWrite = this.messageStore.getRunningFlags().isCQWriteable();
        if (request.getMsgBaseOffset() < 0L || request.getBatchSize() < 0) {
            log.warn("[NOTIFYME]unexpected dispatch request in batch consume queue topic:{} queue:{} offset:{}", new Object[]{this.topic, this.queueId, request.getCommitLogOffset()});
            return;
        }
        for (int i = 0; i < 30 && canWrite; ++i) {
            boolean result = this.putBatchMessagePositionInfo(request.getCommitLogOffset(), request.getMsgSize(), request.getTagsCode(), request.getStoreTimestamp(), request.getMsgBaseOffset(), request.getBatchSize());
            if (result) {
                if (BrokerRole.SLAVE == this.messageStore.getMessageStoreConfig().getBrokerRole()) {
                    this.messageStore.getStoreCheckpoint().setPhysicMsgTimestamp(request.getStoreTimestamp());
                }
                this.messageStore.getStoreCheckpoint().setLogicsMsgTimestamp(request.getStoreTimestamp());
                return;
            }
            log.warn("[NOTIFYME]put commit log position info to batch consume queue " + this.topic + ":" + this.queueId + " " + request.getCommitLogOffset() + " failed, retry " + i + " times");
            try {
                Thread.sleep(1000L);
                continue;
            }
            catch (InterruptedException e) {
                log.warn("", (Throwable)e);
            }
        }
        log.error("[NOTIFYME]batch consume queue can not write, {} {}", (Object)this.topic, (Object)this.queueId);
        this.messageStore.getRunningFlags().makeLogicsQueueError();
    }

    @Override
    public void assignQueueOffset(QueueOffsetOperator queueOffsetOperator, MessageExtBrokerInner msg) {
        String topicQueueKey = this.getTopic() + "-" + this.getQueueId();
        long queueOffset = queueOffsetOperator.getBatchQueueOffset(topicQueueKey);
        if (MessageSysFlag.check((int)msg.getSysFlag(), (int)128)) {
            MessageAccessor.putProperty((Message)msg, (String)"INNER_BASE", (String)String.valueOf(queueOffset));
            msg.setPropertiesString(MessageDecoder.messageProperties2String((Map)msg.getProperties()));
        }
        msg.setQueueOffset(queueOffset);
    }

    @Override
    public void increaseQueueOffset(QueueOffsetOperator queueOffsetOperator, MessageExtBrokerInner msg, short messageNum) {
        String topicQueueKey = this.getTopic() + "-" + this.getQueueId();
        queueOffsetOperator.increaseBatchQueueOffset(topicQueueKey, messageNum);
    }

    public boolean putBatchMessagePositionInfo(long offset, int size, long tagsCode, long storeTime, long msgBaseOffset, short batchSize) {
        if (offset <= this.maxMsgPhyOffsetInCommitLog) {
            if (System.currentTimeMillis() % 1000L == 0L) {
                log.warn("Build batch consume queue repeatedly, maxMsgPhyOffsetInCommitLog:{} offset:{} Topic: {} QID: {}", new Object[]{this.maxMsgPhyOffsetInCommitLog, offset, this.topic, this.queueId});
            }
            return true;
        }
        long behind = System.currentTimeMillis() - storeTime;
        if (behind > 10000L && System.currentTimeMillis() % 10000L == 0L) {
            String flag = "LEVEL" + behind / 10000L;
            log.warn("Reput behind {} topic:{} queue:{} offset:{} behind:{}", new Object[]{flag, this.topic, this.queueId, offset, behind});
        }
        this.byteBufferItem.flip();
        this.byteBufferItem.limit(46);
        this.byteBufferItem.putLong(offset);
        this.byteBufferItem.putInt(size);
        this.byteBufferItem.putLong(tagsCode);
        this.byteBufferItem.putLong(storeTime);
        this.byteBufferItem.putLong(msgBaseOffset);
        this.byteBufferItem.putShort(batchSize);
        this.byteBufferItem.putInt(-1);
        this.byteBufferItem.putInt(0);
        MappedFile mappedFile = this.mappedFileQueue.getLastMappedFile(this.mappedFileQueue.getMaxOffset());
        if (mappedFile != null) {
            boolean isNewFile = this.isNewFile(mappedFile);
            boolean appendRes = mappedFile.appendMessage(this.byteBufferItem.array());
            if (appendRes) {
                this.maxMsgPhyOffsetInCommitLog = offset;
                this.maxOffsetInQueue = msgBaseOffset + (long)batchSize;
                if (mappedFile.isFirstCreateInQueue() && this.minOffsetInQueue == -1L) {
                    this.reviseMinOffsetInQueue();
                }
                if (isNewFile) {
                    this.cacheBcq(mappedFile);
                }
            }
            return appendRes;
        }
        return false;
    }

    protected BatchOffsetIndex getMinMsgOffset(MappedFile mappedFile, boolean getBatchSize, boolean getStoreTime) {
        if (mappedFile.getReadPosition() < 46) {
            return null;
        }
        return this.getBatchOffsetIndexByPos(mappedFile, 0, getBatchSize, getStoreTime);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected BatchOffsetIndex getBatchOffsetIndexByPos(MappedFile mappedFile, int pos, boolean getBatchSize, boolean getStoreTime) {
        SelectMappedBufferResult sbr = mappedFile.selectMappedBuffer(pos);
        try {
            BatchOffsetIndex batchOffsetIndex = new BatchOffsetIndex(mappedFile, pos, sbr.getByteBuffer().getLong(28), getBatchSize ? sbr.getByteBuffer().getShort(36) : (short)0, getStoreTime ? sbr.getByteBuffer().getLong(20) : 0L);
            return batchOffsetIndex;
        }
        finally {
            if (sbr != null) {
                sbr.release();
            }
        }
    }

    protected BatchOffsetIndex getMaxMsgOffset(MappedFile mappedFile, boolean getBatchSize, boolean getStoreTime) {
        if (mappedFile == null || mappedFile.getReadPosition() < 46) {
            return null;
        }
        int pos = mappedFile.getReadPosition() - 46;
        return this.getBatchOffsetIndexByPos(mappedFile, pos, getBatchSize, getStoreTime);
    }

    private static int ceil(int pos) {
        return pos / 46 * 46;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SelectMappedBufferResult getBatchMsgIndexBuffer(long msgOffset) {
        BatchOffsetIndex targetMinOffset;
        MappedFile targetBcq;
        if (msgOffset >= this.maxOffsetInQueue) {
            return null;
        }
        MappedFile lastBcq = this.mappedFileQueue.getLastMappedFile();
        BatchOffsetIndex minForLastBcq = this.getMinMsgOffset(lastBcq, false, false);
        if (null != minForLastBcq && minForLastBcq.getMsgOffset() <= msgOffset) {
            targetBcq = lastBcq;
            targetMinOffset = minForLastBcq;
        } else {
            boolean searchBcqByCacheEnable = this.messageStore.getMessageStoreConfig().isSearchBcqByCacheEnable();
            if (searchBcqByCacheEnable) {
                targetBcq = this.searchOffsetFromCache(msgOffset);
                if (targetBcq == null) {
                    MappedFile firstBcq = this.mappedFileQueue.getFirstMappedFile();
                    BatchOffsetIndex minForFirstBcq = this.getMinMsgOffset(firstBcq, false, false);
                    if (minForFirstBcq != null && minForFirstBcq.getMsgOffset() <= msgOffset && msgOffset < minForLastBcq.getMsgOffset()) {
                        targetBcq = this.searchOffsetFromFiles(msgOffset);
                    }
                    log.warn("cache is not working on BCQ [Topic: {}, QueueId: {}] for msgOffset: {}, targetBcq: {}", new Object[]{this.topic, this.queueId, msgOffset, targetBcq});
                }
            } else {
                targetBcq = this.searchOffsetFromFiles(msgOffset);
            }
            if (targetBcq == null) {
                return null;
            }
            targetMinOffset = this.getMinMsgOffset(targetBcq, false, false);
        }
        BatchOffsetIndex targetMaxOffset = this.getMaxMsgOffset(targetBcq, false, false);
        if (null == targetMinOffset || null == targetMaxOffset) {
            return null;
        }
        SelectMappedBufferResult sbr = targetMinOffset.getMappedFile().selectMappedBuffer(0);
        try {
            ByteBuffer byteBuffer = sbr.getByteBuffer();
            int left = targetMinOffset.getIndexPos();
            int right = targetMaxOffset.getIndexPos();
            int mid = this.binarySearch(byteBuffer, left, right, 46, 28, msgOffset);
            if (mid != -1) {
                SelectMappedBufferResult selectMappedBufferResult = targetMinOffset.getMappedFile().selectMappedBuffer(mid);
                return selectMappedBufferResult;
            }
        }
        finally {
            sbr.release();
        }
        return null;
    }

    public MappedFile searchOffsetFromFiles(long msgOffset) {
        MappedFile targetBcq = null;
        int mappedFileNum = this.mappedFileQueue.getMappedFiles().size();
        for (int i = mappedFileNum - 1; i >= 0; --i) {
            MappedFile mappedFile = this.mappedFileQueue.getMappedFiles().get(i);
            BatchOffsetIndex tmpMinMsgOffset = this.getMinMsgOffset(mappedFile, false, false);
            if (null == tmpMinMsgOffset || tmpMinMsgOffset.getMsgOffset() > msgOffset) continue;
            targetBcq = mappedFile;
            break;
        }
        return targetBcq;
    }

    @Override
    @Deprecated
    public long getOffsetInQueueByTime(long timestamp) {
        return this.getOffsetInQueueByTime(timestamp, BoundaryType.LOWER);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long getOffsetInQueueByTime(long timestamp, BoundaryType boundaryType) {
        BatchOffsetIndex targetMinOffset;
        MappedFile targetBcq;
        MappedFile lastBcq = this.mappedFileQueue.getLastMappedFile();
        BatchOffsetIndex minForLastBcq = this.getMinMsgOffset(lastBcq, false, true);
        if (null != minForLastBcq && minForLastBcq.getStoreTimestamp() <= timestamp) {
            targetBcq = lastBcq;
            targetMinOffset = minForLastBcq;
        } else {
            boolean searchBcqByCacheEnable = this.messageStore.getMessageStoreConfig().isSearchBcqByCacheEnable();
            if (searchBcqByCacheEnable) {
                targetBcq = this.searchTimeFromCache(timestamp);
                if (targetBcq == null) {
                    MappedFile firstBcq = this.mappedFileQueue.getFirstMappedFile();
                    BatchOffsetIndex minForFirstBcq = this.getMinMsgOffset(firstBcq, false, true);
                    if (minForFirstBcq != null && minForFirstBcq.getStoreTimestamp() <= timestamp && timestamp < minForLastBcq.getStoreTimestamp()) {
                        targetBcq = this.searchTimeFromFiles(timestamp);
                    }
                    log.warn("cache is not working on BCQ [Topic: {}, QueueId: {}] for timestamp: {}, targetBcq: {}", new Object[]{this.topic, this.queueId, timestamp, targetBcq});
                }
            } else {
                targetBcq = this.searchTimeFromFiles(timestamp);
            }
            if (targetBcq == null) {
                return -1L;
            }
            targetMinOffset = this.getMinMsgOffset(targetBcq, false, true);
        }
        BatchOffsetIndex targetMaxOffset = this.getMaxMsgOffset(targetBcq, false, true);
        if (null == targetMinOffset || null == targetMaxOffset) {
            return -1L;
        }
        SelectMappedBufferResult sbr = targetMinOffset.getMappedFile().selectMappedBuffer(0);
        try {
            ByteBuffer byteBuffer = sbr.getByteBuffer();
            int left = targetMinOffset.getIndexPos();
            int right = targetMaxOffset.getIndexPos();
            long maxQueueTimestamp = byteBuffer.getLong(right + 20);
            if (timestamp >= maxQueueTimestamp) {
                long l = byteBuffer.getLong(right + 28);
                return l;
            }
            int mid = BatchConsumeQueue.binarySearchRight(byteBuffer, left, right, 46, 20, timestamp, boundaryType);
            if (mid != -1) {
                long l = byteBuffer.getLong(mid + 28);
                return l;
            }
        }
        finally {
            sbr.release();
        }
        return -1L;
    }

    private MappedFile searchTimeFromFiles(long timestamp) {
        MappedFile targetBcq = null;
        int mappedFileNum = this.mappedFileQueue.getMappedFiles().size();
        for (int i = mappedFileNum - 1; i >= 0; --i) {
            MappedFile mappedFile = this.mappedFileQueue.getMappedFiles().get(i);
            BatchOffsetIndex tmpMinMsgOffset = this.getMinMsgOffset(mappedFile, false, true);
            if (tmpMinMsgOffset == null) continue;
            BatchOffsetIndex tmpMaxMsgOffset = this.getMaxMsgOffset(mappedFile, false, true);
            if (tmpMaxMsgOffset == null) break;
            if (tmpMaxMsgOffset.getStoreTimestamp() >= timestamp) {
                if (tmpMinMsgOffset.getStoreTimestamp() <= timestamp) {
                    targetBcq = mappedFile;
                    break;
                }
                if (i - 1 >= 0) continue;
                targetBcq = mappedFile;
                break;
            }
            if (i + 1 > mappedFileNum - 1) break;
            targetBcq = mappedFile = this.mappedFileQueue.getMappedFiles().get(i + 1);
            break;
        }
        return targetBcq;
    }

    public static int binarySearchRight(ByteBuffer byteBuffer, int left, int right, int unitSize, int unitShift, long targetValue, BoundaryType boundaryType) {
        int mid = -1;
        block4: while (left <= right) {
            mid = BatchConsumeQueue.ceil((left + right) / 2);
            long tmpValue = byteBuffer.getLong(mid + unitShift);
            if (mid == right) {
                if (tmpValue >= targetValue) {
                    return mid;
                }
                return -1;
            }
            if (mid == left) {
                if (tmpValue >= targetValue) {
                    return mid;
                }
                left = mid + unitSize;
                continue;
            }
            switch (boundaryType) {
                case LOWER: {
                    if (tmpValue < targetValue) {
                        left = mid + unitSize;
                        continue block4;
                    }
                    right = mid;
                    continue block4;
                }
                case UPPER: {
                    if (tmpValue <= targetValue) {
                        left = mid;
                        continue block4;
                    }
                    right = mid - unitSize;
                    continue block4;
                }
            }
            log.warn("Unknown boundary type");
            return -1;
        }
        return -1;
    }

    protected int binarySearch(ByteBuffer byteBuffer, int left, int right, int unitSize, int unitShift, long targetValue) {
        int maxRight = right;
        int mid = -1;
        while (left <= right) {
            mid = BatchConsumeQueue.ceil((left + right) / 2);
            long tmpValue = byteBuffer.getLong(mid + unitShift);
            if (tmpValue == targetValue) {
                return mid;
            }
            if (tmpValue > targetValue) {
                right = mid - unitSize;
                continue;
            }
            if (mid == left) {
                if (mid + unitSize <= maxRight && byteBuffer.getLong(mid + unitSize + unitShift) <= targetValue) {
                    return mid + unitSize;
                }
                return mid;
            }
            left = mid;
        }
        return -1;
    }

    @Override
    public String getTopic() {
        return this.topic;
    }

    @Override
    public int getQueueId() {
        return this.queueId;
    }

    @Override
    public CQType getCQType() {
        return CQType.BatchCQ;
    }

    @Override
    public long getTotalSize() {
        return this.mappedFileQueue.getTotalFileSize();
    }

    @Override
    public int getUnitSize() {
        return 46;
    }

    @Override
    public void destroy() {
        this.maxMsgPhyOffsetInCommitLog = -1L;
        this.minOffsetInQueue = -1L;
        this.maxOffsetInQueue = 0L;
        this.mappedFileQueue.destroy();
        this.destroyCache();
    }

    @Override
    public long getMessageTotalInQueue() {
        return this.getMaxOffsetInQueue() - this.getMinOffsetInQueue();
    }

    @Override
    public long rollNextFile(long nextBeginOffset) {
        return 0L;
    }

    @Override
    public long getMaxOffsetInQueue() {
        return this.maxOffsetInQueue;
    }

    @Override
    public long getMinOffsetInQueue() {
        return this.minOffsetInQueue;
    }

    @Override
    public void checkSelf() {
        this.mappedFileQueue.checkSelf();
    }

    @Override
    public void swapMap(int reserveNum, long forceSwapIntervalMs, long normalSwapIntervalMs) {
        this.mappedFileQueue.swapMap(reserveNum, forceSwapIntervalMs, normalSwapIntervalMs);
    }

    @Override
    public void cleanSwappedMap(long forceCleanSwapIntervalMs) {
        this.mappedFileQueue.cleanSwappedMap(forceCleanSwapIntervalMs);
    }

    public MappedFileQueue getMappedFileQueue() {
        return this.mappedFileQueue;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long estimateMessageCount(long from, long to, MessageFilter filter) {
        SelectMappedBufferResult firstMappedFileBuffer = this.getBatchMsgIndexBuffer(from);
        if (firstMappedFileBuffer == null) {
            return -1L;
        }
        long physicalOffsetFrom = firstMappedFileBuffer.getStartOffset();
        SelectMappedBufferResult lastMappedFileBuffer = this.getBatchMsgIndexBuffer(to);
        if (lastMappedFileBuffer == null) {
            return -1L;
        }
        long physicalOffsetTo = lastMappedFileBuffer.getStartOffset();
        List<MappedFile> mappedFiles = this.mappedFileQueue.range(physicalOffsetFrom, physicalOffsetTo);
        if (mappedFiles.isEmpty()) {
            return -1L;
        }
        boolean sample = false;
        long match = 0L;
        long matchCqUnitCount = 0L;
        long raw = 0L;
        long scanCqUnitCount = 0L;
        for (MappedFile mappedFile : mappedFiles) {
            SelectMappedBufferResult slice;
            int start = 0;
            int len = mappedFile.getFileSize();
            if (mappedFile.getFileFromOffset() <= physicalOffsetFrom) {
                start = (int)(physicalOffsetFrom - mappedFile.getFileFromOffset());
                len = mappedFile.getFileFromOffset() + (long)mappedFile.getFileSize() >= physicalOffsetTo ? (int)(physicalOffsetTo - physicalOffsetFrom) : mappedFile.getFileSize() - start;
            }
            if (0 == start && mappedFile.getFileFromOffset() + (long)mappedFile.getFileSize() > physicalOffsetTo) {
                len = (int)(physicalOffsetTo - mappedFile.getFileFromOffset());
            }
            if (null != (slice = mappedFile.selectMappedBuffer(start, len))) {
                try {
                    ByteBuffer buffer = slice.getByteBuffer();
                    for (int current = 0; current < len; current += 46) {
                        buffer.position(current + 12);
                        long tagCode = buffer.getLong();
                        buffer.position(current + 36);
                        long batchSize = buffer.getShort();
                        if (filter.isMatchedByConsumeQueue(tagCode, null)) {
                            match += batchSize;
                            ++matchCqUnitCount;
                        }
                        raw += batchSize;
                        if (++scanCqUnitCount < (long)this.messageStore.getMessageStoreConfig().getMaxConsumeQueueScan()) continue;
                        sample = true;
                        break;
                    }
                }
                finally {
                    slice.release();
                }
            }
            if (!sample) continue;
            break;
        }
        long result = match;
        if (sample) {
            if (0L == raw) {
                log.error("[BUG]. Raw should NOT be 0");
                return 0L;
            }
            result = (long)((double)(match * (to - from)) * 1.0 / (double)raw);
        }
        log.debug("Result={}, raw={}, match={}, sample={}", new Object[]{result, raw, match, sample});
        return result;
    }

    static class BatchConsumeQueueIterator
    implements ReferredIterator<CqUnit> {
        private SelectMappedBufferResult sbr;
        private int relativePos = 0;

        public BatchConsumeQueueIterator(SelectMappedBufferResult sbr) {
            this.sbr = sbr;
            if (sbr != null && sbr.getByteBuffer() != null) {
                this.relativePos = sbr.getByteBuffer().position();
            }
        }

        @Override
        public boolean hasNext() {
            if (this.sbr == null || this.sbr.getByteBuffer() == null) {
                return false;
            }
            return this.sbr.getByteBuffer().hasRemaining();
        }

        @Override
        public CqUnit next() {
            if (!this.hasNext()) {
                return null;
            }
            ByteBuffer tmpBuffer = this.sbr.getByteBuffer().slice();
            tmpBuffer.position(38);
            ByteBuffer compactOffsetStoreBuffer = tmpBuffer.slice();
            compactOffsetStoreBuffer.limit(4);
            int relativePos = this.sbr.getByteBuffer().position();
            long offsetPy = this.sbr.getByteBuffer().getLong();
            int sizePy = this.sbr.getByteBuffer().getInt();
            long tagsCode = this.sbr.getByteBuffer().getLong();
            this.sbr.getByteBuffer().getLong();
            long msgBaseOffset = this.sbr.getByteBuffer().getLong();
            short batchSize = this.sbr.getByteBuffer().getShort();
            int compactedOffset = this.sbr.getByteBuffer().getInt();
            this.sbr.getByteBuffer().position(relativePos + 46);
            return new CqUnit(msgBaseOffset, offsetPy, sizePy, tagsCode, batchSize, compactedOffset, compactOffsetStoreBuffer);
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException("remove");
        }

        @Override
        public void release() {
            if (this.sbr != null) {
                this.sbr.release();
                this.sbr = null;
            }
        }

        @Override
        public CqUnit nextAndRelease() {
            try {
                CqUnit cqUnit = this.next();
                return cqUnit;
            }
            finally {
                this.release();
            }
        }
    }
}

