/*
 * Decompiled with CFR 0.152.
 */
package io.grpc.protobuf.services;

import com.google.common.base.Preconditions;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.protobuf.Any;
import com.google.protobuf.ByteString;
import com.google.protobuf.Int64Value;
import com.google.protobuf.Message;
import com.google.protobuf.util.Durations;
import com.google.protobuf.util.Timestamps;
import io.grpc.ConnectivityState;
import io.grpc.InternalChannelz;
import io.grpc.InternalInstrumented;
import io.grpc.InternalWithLogId;
import io.grpc.Status;
import io.grpc.channelz.v1.Address;
import io.grpc.channelz.v1.Channel;
import io.grpc.channelz.v1.ChannelConnectivityState;
import io.grpc.channelz.v1.ChannelData;
import io.grpc.channelz.v1.ChannelRef;
import io.grpc.channelz.v1.ChannelTrace;
import io.grpc.channelz.v1.ChannelTraceEvent;
import io.grpc.channelz.v1.GetServerSocketsResponse;
import io.grpc.channelz.v1.GetServersResponse;
import io.grpc.channelz.v1.GetTopChannelsResponse;
import io.grpc.channelz.v1.Security;
import io.grpc.channelz.v1.Server;
import io.grpc.channelz.v1.ServerData;
import io.grpc.channelz.v1.ServerRef;
import io.grpc.channelz.v1.Socket;
import io.grpc.channelz.v1.SocketData;
import io.grpc.channelz.v1.SocketOption;
import io.grpc.channelz.v1.SocketOptionLinger;
import io.grpc.channelz.v1.SocketOptionTcpInfo;
import io.grpc.channelz.v1.SocketOptionTimeout;
import io.grpc.channelz.v1.SocketRef;
import io.grpc.channelz.v1.Subchannel;
import io.grpc.channelz.v1.SubchannelRef;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.security.cert.CertificateEncodingException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutionException;
import java.util.logging.Level;
import java.util.logging.Logger;

final class ChannelzProtoUtil {
    private static final Logger logger = Logger.getLogger(ChannelzProtoUtil.class.getName());
    public static final String SO_LINGER = "SO_LINGER";
    public static final String SO_TIMEOUT = "SO_TIMEOUT";
    public static final String TCP_INFO = "TCP_INFO";

    private ChannelzProtoUtil() {
    }

    static ChannelRef toChannelRef(InternalWithLogId obj) {
        return ChannelRef.newBuilder().setChannelId(obj.getLogId().getId()).setName(obj.toString()).build();
    }

    static SubchannelRef toSubchannelRef(InternalWithLogId obj) {
        return SubchannelRef.newBuilder().setSubchannelId(obj.getLogId().getId()).setName(obj.toString()).build();
    }

    static ServerRef toServerRef(InternalWithLogId obj) {
        return ServerRef.newBuilder().setServerId(obj.getLogId().getId()).setName(obj.toString()).build();
    }

    static SocketRef toSocketRef(InternalWithLogId obj) {
        return SocketRef.newBuilder().setSocketId(obj.getLogId().getId()).setName(obj.toString()).build();
    }

    static Server toServer(InternalInstrumented<InternalChannelz.ServerStats> obj) {
        InternalChannelz.ServerStats stats = (InternalChannelz.ServerStats)ChannelzProtoUtil.getFuture(obj.getStats());
        Server.Builder builder = Server.newBuilder().setRef(ChannelzProtoUtil.toServerRef(obj)).setData(ChannelzProtoUtil.toServerData(stats));
        for (InternalInstrumented listenSocket : stats.listenSockets) {
            builder.addListenSocket(ChannelzProtoUtil.toSocketRef((InternalWithLogId)listenSocket));
        }
        return builder.build();
    }

    static ServerData toServerData(InternalChannelz.ServerStats stats) {
        return ServerData.newBuilder().setCallsStarted(stats.callsStarted).setCallsSucceeded(stats.callsSucceeded).setCallsFailed(stats.callsFailed).setLastCallStartedTimestamp(Timestamps.fromNanos((long)stats.lastCallStartedNanos)).build();
    }

    static Security toSecurity(InternalChannelz.Security security) {
        Preconditions.checkNotNull((Object)security);
        Preconditions.checkState((boolean)(security.tls != null ^ security.other != null), (Object)"one of tls or othersecurity must be non null");
        if (security.tls != null) {
            Security.Tls.Builder tlsBuilder = Security.Tls.newBuilder().setStandardName(security.tls.cipherSuiteStandardName);
            try {
                if (security.tls.localCert != null) {
                    tlsBuilder.setLocalCertificate(ByteString.copyFrom((byte[])security.tls.localCert.getEncoded()));
                }
                if (security.tls.remoteCert != null) {
                    tlsBuilder.setRemoteCertificate(ByteString.copyFrom((byte[])security.tls.remoteCert.getEncoded()));
                }
            }
            catch (CertificateEncodingException e) {
                logger.log(Level.FINE, "Caught exception", e);
            }
            return Security.newBuilder().setTls(tlsBuilder).build();
        }
        Security.OtherSecurity.Builder builder = Security.OtherSecurity.newBuilder().setName(security.other.name);
        if (security.other.any != null) {
            builder.setValue((Any)security.other.any);
        }
        return Security.newBuilder().setOther(builder).build();
    }

    static Socket toSocket(InternalInstrumented<InternalChannelz.SocketStats> obj) {
        InternalChannelz.SocketStats socketStats = (InternalChannelz.SocketStats)ChannelzProtoUtil.getFuture(obj.getStats());
        Socket.Builder builder = Socket.newBuilder().setRef(ChannelzProtoUtil.toSocketRef(obj)).setLocal(ChannelzProtoUtil.toAddress(socketStats.local));
        if (socketStats.security != null) {
            builder.setSecurity(ChannelzProtoUtil.toSecurity(socketStats.security));
        }
        if (socketStats.remote != null) {
            builder.setRemote(ChannelzProtoUtil.toAddress(socketStats.remote));
        }
        builder.setData(ChannelzProtoUtil.extractSocketData(socketStats));
        return builder.build();
    }

    static Address toAddress(SocketAddress address) {
        Preconditions.checkNotNull((Object)address);
        Address.Builder builder = Address.newBuilder();
        if (address instanceof InetSocketAddress) {
            InetSocketAddress inetAddress = (InetSocketAddress)address;
            builder.setTcpipAddress(Address.TcpIpAddress.newBuilder().setIpAddress(ByteString.copyFrom((byte[])inetAddress.getAddress().getAddress())).setPort(inetAddress.getPort()).build());
        } else if (address.getClass().getName().endsWith("io.netty.channel.unix.DomainSocketAddress")) {
            builder.setUdsAddress(Address.UdsAddress.newBuilder().setFilename(address.toString()).build());
        } else {
            builder.setOtherAddress(Address.OtherAddress.newBuilder().setName(address.toString()).build());
        }
        return builder.build();
    }

    static SocketData extractSocketData(InternalChannelz.SocketStats socketStats) {
        SocketData.Builder builder = SocketData.newBuilder();
        if (socketStats.data != null) {
            InternalChannelz.TransportStats s = socketStats.data;
            builder.setStreamsStarted(s.streamsStarted).setStreamsSucceeded(s.streamsSucceeded).setStreamsFailed(s.streamsFailed).setMessagesSent(s.messagesSent).setMessagesReceived(s.messagesReceived).setKeepAlivesSent(s.keepAlivesSent).setLastLocalStreamCreatedTimestamp(Timestamps.fromNanos((long)s.lastLocalStreamCreatedTimeNanos)).setLastRemoteStreamCreatedTimestamp(Timestamps.fromNanos((long)s.lastRemoteStreamCreatedTimeNanos)).setLastMessageSentTimestamp(Timestamps.fromNanos((long)s.lastMessageSentTimeNanos)).setLastMessageReceivedTimestamp(Timestamps.fromNanos((long)s.lastMessageReceivedTimeNanos)).setLocalFlowControlWindow(Int64Value.of((long)s.localFlowControlWindow)).setRemoteFlowControlWindow(Int64Value.of((long)s.remoteFlowControlWindow));
        }
        builder.addAllOption(ChannelzProtoUtil.toSocketOptionsList(socketStats.socketOptions));
        return builder.build();
    }

    static SocketOption toSocketOptionLinger(int lingerSeconds) {
        SocketOptionLinger lingerOpt = lingerSeconds >= 0 ? SocketOptionLinger.newBuilder().setActive(true).setDuration(Durations.fromSeconds((long)lingerSeconds)).build() : SocketOptionLinger.getDefaultInstance();
        return SocketOption.newBuilder().setName(SO_LINGER).setAdditional(Any.pack((Message)lingerOpt)).build();
    }

    static SocketOption toSocketOptionTimeout(String name, int timeoutMillis) {
        Preconditions.checkNotNull((Object)name);
        return SocketOption.newBuilder().setName(name).setAdditional(Any.pack((Message)SocketOptionTimeout.newBuilder().setDuration(Durations.fromMillis((long)timeoutMillis)).build())).build();
    }

    static SocketOption toSocketOptionTcpInfo(InternalChannelz.TcpInfo i) {
        SocketOptionTcpInfo tcpInfo = SocketOptionTcpInfo.newBuilder().setTcpiState(i.state).setTcpiCaState(i.caState).setTcpiRetransmits(i.retransmits).setTcpiProbes(i.probes).setTcpiBackoff(i.backoff).setTcpiOptions(i.options).setTcpiSndWscale(i.sndWscale).setTcpiRcvWscale(i.rcvWscale).setTcpiRto(i.rto).setTcpiAto(i.ato).setTcpiSndMss(i.sndMss).setTcpiRcvMss(i.rcvMss).setTcpiUnacked(i.unacked).setTcpiSacked(i.sacked).setTcpiLost(i.lost).setTcpiRetrans(i.retrans).setTcpiFackets(i.fackets).setTcpiLastDataSent(i.lastDataSent).setTcpiLastAckSent(i.lastAckSent).setTcpiLastDataRecv(i.lastDataRecv).setTcpiLastAckRecv(i.lastAckRecv).setTcpiPmtu(i.pmtu).setTcpiRcvSsthresh(i.rcvSsthresh).setTcpiRtt(i.rtt).setTcpiRttvar(i.rttvar).setTcpiSndSsthresh(i.sndSsthresh).setTcpiSndCwnd(i.sndCwnd).setTcpiAdvmss(i.advmss).setTcpiReordering(i.reordering).build();
        return SocketOption.newBuilder().setName(TCP_INFO).setAdditional(Any.pack((Message)tcpInfo)).build();
    }

    static SocketOption toSocketOptionAdditional(String name, String value) {
        Preconditions.checkNotNull((Object)name);
        Preconditions.checkNotNull((Object)value);
        return SocketOption.newBuilder().setName(name).setValue(value).build();
    }

    static List<SocketOption> toSocketOptionsList(InternalChannelz.SocketOptions options) {
        Preconditions.checkNotNull((Object)options);
        ArrayList<SocketOption> ret = new ArrayList<SocketOption>();
        if (options.lingerSeconds != null) {
            ret.add(ChannelzProtoUtil.toSocketOptionLinger(options.lingerSeconds));
        }
        if (options.soTimeoutMillis != null) {
            ret.add(ChannelzProtoUtil.toSocketOptionTimeout(SO_TIMEOUT, options.soTimeoutMillis));
        }
        if (options.tcpInfo != null) {
            ret.add(ChannelzProtoUtil.toSocketOptionTcpInfo(options.tcpInfo));
        }
        for (Map.Entry entry : options.others.entrySet()) {
            ret.add(ChannelzProtoUtil.toSocketOptionAdditional((String)entry.getKey(), (String)entry.getValue()));
        }
        return ret;
    }

    static Channel toChannel(InternalInstrumented<InternalChannelz.ChannelStats> channel) {
        InternalChannelz.ChannelStats stats = (InternalChannelz.ChannelStats)ChannelzProtoUtil.getFuture(channel.getStats());
        Channel.Builder channelBuilder = Channel.newBuilder().setRef(ChannelzProtoUtil.toChannelRef(channel)).setData(ChannelzProtoUtil.extractChannelData(stats));
        for (InternalWithLogId subchannel : stats.subchannels) {
            channelBuilder.addSubchannelRef(ChannelzProtoUtil.toSubchannelRef(subchannel));
        }
        return channelBuilder.build();
    }

    static ChannelData extractChannelData(InternalChannelz.ChannelStats stats) {
        ChannelData.Builder builder = ChannelData.newBuilder();
        builder.setTarget(stats.target).setState(ChannelzProtoUtil.toChannelConnectivityState(stats.state)).setCallsStarted(stats.callsStarted).setCallsSucceeded(stats.callsSucceeded).setCallsFailed(stats.callsFailed).setLastCallStartedTimestamp(Timestamps.fromNanos((long)stats.lastCallStartedNanos));
        if (stats.channelTrace != null) {
            builder.setTrace(ChannelzProtoUtil.toChannelTrace(stats.channelTrace));
        }
        return builder.build();
    }

    static ChannelConnectivityState toChannelConnectivityState(ConnectivityState s) {
        return ChannelConnectivityState.newBuilder().setState(ChannelzProtoUtil.toState(s)).build();
    }

    private static ChannelTrace toChannelTrace(InternalChannelz.ChannelTrace channelTrace) {
        return ChannelTrace.newBuilder().setNumEventsLogged(channelTrace.numEventsLogged).setCreationTimestamp(Timestamps.fromNanos((long)channelTrace.creationTimeNanos)).addAllEvents(ChannelzProtoUtil.toChannelTraceEvents(channelTrace.events)).build();
    }

    private static List<ChannelTraceEvent> toChannelTraceEvents(List<InternalChannelz.ChannelTrace.Event> events) {
        ArrayList<ChannelTraceEvent> channelTraceEvents = new ArrayList<ChannelTraceEvent>();
        for (InternalChannelz.ChannelTrace.Event event : events) {
            ChannelTraceEvent.Builder builder = ChannelTraceEvent.newBuilder().setDescription(event.description).setSeverity(ChannelTraceEvent.Severity.valueOf(event.severity.name())).setTimestamp(Timestamps.fromNanos((long)event.timestampNanos));
            if (event.channelRef != null) {
                builder.setChannelRef(ChannelzProtoUtil.toChannelRef(event.channelRef));
            }
            if (event.subchannelRef != null) {
                builder.setSubchannelRef(ChannelzProtoUtil.toSubchannelRef(event.subchannelRef));
            }
            channelTraceEvents.add(builder.build());
        }
        return Collections.unmodifiableList(channelTraceEvents);
    }

    static ChannelConnectivityState.State toState(ConnectivityState state) {
        if (state == null) {
            return ChannelConnectivityState.State.UNKNOWN;
        }
        try {
            return Enum.valueOf(ChannelConnectivityState.State.class, state.name());
        }
        catch (IllegalArgumentException e) {
            return ChannelConnectivityState.State.UNKNOWN;
        }
    }

    static Subchannel toSubchannel(InternalInstrumented<InternalChannelz.ChannelStats> subchannel) {
        InternalChannelz.ChannelStats stats = (InternalChannelz.ChannelStats)ChannelzProtoUtil.getFuture(subchannel.getStats());
        Subchannel.Builder subchannelBuilder = Subchannel.newBuilder().setRef(ChannelzProtoUtil.toSubchannelRef(subchannel)).setData(ChannelzProtoUtil.extractChannelData(stats));
        Preconditions.checkState((stats.sockets.isEmpty() || stats.subchannels.isEmpty() ? 1 : 0) != 0);
        for (InternalWithLogId childSocket : stats.sockets) {
            subchannelBuilder.addSocketRef(ChannelzProtoUtil.toSocketRef(childSocket));
        }
        for (InternalWithLogId childSubchannel : stats.subchannels) {
            subchannelBuilder.addSubchannelRef(ChannelzProtoUtil.toSubchannelRef(childSubchannel));
        }
        return subchannelBuilder.build();
    }

    static GetTopChannelsResponse toGetTopChannelResponse(InternalChannelz.RootChannelList rootChannels) {
        GetTopChannelsResponse.Builder responseBuilder = GetTopChannelsResponse.newBuilder().setEnd(rootChannels.end);
        for (InternalInstrumented c : rootChannels.channels) {
            responseBuilder.addChannel(ChannelzProtoUtil.toChannel((InternalInstrumented<InternalChannelz.ChannelStats>)c));
        }
        return responseBuilder.build();
    }

    static GetServersResponse toGetServersResponse(InternalChannelz.ServerList servers) {
        GetServersResponse.Builder responseBuilder = GetServersResponse.newBuilder().setEnd(servers.end);
        for (InternalInstrumented s : servers.servers) {
            responseBuilder.addServer(ChannelzProtoUtil.toServer((InternalInstrumented<InternalChannelz.ServerStats>)s));
        }
        return responseBuilder.build();
    }

    static GetServerSocketsResponse toGetServerSocketsResponse(InternalChannelz.ServerSocketsList serverSockets) {
        GetServerSocketsResponse.Builder responseBuilder = GetServerSocketsResponse.newBuilder().setEnd(serverSockets.end);
        for (InternalWithLogId s : serverSockets.sockets) {
            responseBuilder.addSocketRef(ChannelzProtoUtil.toSocketRef(s));
        }
        return responseBuilder.build();
    }

    private static <T> T getFuture(ListenableFuture<T> future) {
        try {
            Object ret = future.get();
            if (ret == null) {
                throw Status.UNIMPLEMENTED.withDescription("The entity's stats can not be retrieved. If this is an InProcessTransport this is expected.").asRuntimeException();
            }
            return (T)ret;
        }
        catch (InterruptedException e) {
            throw Status.INTERNAL.withCause((Throwable)e).asRuntimeException();
        }
        catch (ExecutionException e) {
            throw Status.INTERNAL.withCause((Throwable)e).asRuntimeException();
        }
    }
}

