/*
 * Decompiled with CFR 0.152.
 */
package org.apache.rocketmq.tieredstore.file;

import com.google.common.collect.ImmutableList;
import java.util.ArrayList;
import java.util.Random;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import javax.annotation.Nullable;
import org.apache.rocketmq.common.message.MessageQueue;
import org.apache.rocketmq.logging.org.slf4j.Logger;
import org.apache.rocketmq.logging.org.slf4j.LoggerFactory;
import org.apache.rocketmq.tieredstore.common.TieredMessageStoreConfig;
import org.apache.rocketmq.tieredstore.common.TieredStoreExecutor;
import org.apache.rocketmq.tieredstore.file.CompositeFlatFile;
import org.apache.rocketmq.tieredstore.file.CompositeQueueFlatFile;
import org.apache.rocketmq.tieredstore.file.TieredFileAllocator;
import org.apache.rocketmq.tieredstore.file.TieredIndexFile;
import org.apache.rocketmq.tieredstore.metadata.TieredMetadataStore;
import org.apache.rocketmq.tieredstore.util.TieredStoreUtil;

public class TieredFlatFileManager {
    private static final Logger logger = LoggerFactory.getLogger((String)"RocketmqTieredStore");
    private static volatile TieredFlatFileManager instance;
    private static volatile TieredIndexFile indexFile;
    private final TieredMetadataStore metadataStore;
    private final TieredMessageStoreConfig storeConfig;
    private final TieredFileAllocator tieredFileAllocator;
    private final ConcurrentMap<MessageQueue, CompositeQueueFlatFile> queueFlatFileMap;

    public TieredFlatFileManager(TieredMessageStoreConfig storeConfig) throws ClassNotFoundException, NoSuchMethodException {
        this.storeConfig = storeConfig;
        this.metadataStore = TieredStoreUtil.getMetadataStore(storeConfig);
        this.tieredFileAllocator = new TieredFileAllocator(storeConfig);
        this.queueFlatFileMap = new ConcurrentHashMap<MessageQueue, CompositeQueueFlatFile>();
        this.doScheduleTask();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static TieredFlatFileManager getInstance(TieredMessageStoreConfig storeConfig) {
        if (storeConfig == null) {
            return instance;
        }
        if (instance != null) return instance;
        Class<TieredFlatFileManager> clazz = TieredFlatFileManager.class;
        synchronized (TieredFlatFileManager.class) {
            if (instance != null) return instance;
            try {
                instance = new TieredFlatFileManager(storeConfig);
            }
            catch (Exception e) {
                logger.error("TieredFlatFileManager#getInstance: create flat file manager failed", (Throwable)e);
            }
            return instance;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static TieredIndexFile getIndexFile(TieredMessageStoreConfig storeConfig) {
        if (storeConfig == null) {
            return indexFile;
        }
        if (indexFile != null) return indexFile;
        Class<TieredFlatFileManager> clazz = TieredFlatFileManager.class;
        synchronized (TieredFlatFileManager.class) {
            if (indexFile != null) return indexFile;
            try {
                String filePath = TieredStoreUtil.toPath(new MessageQueue("rmq_sys_INDEX", storeConfig.getBrokerName(), 0));
                indexFile = new TieredIndexFile(new TieredFileAllocator(storeConfig), filePath);
            }
            catch (Exception e) {
                logger.error("TieredFlatFileManager#getIndexFile: create index file failed", (Throwable)e);
            }
            return indexFile;
        }
    }

    public void doCommit() {
        Random random = new Random();
        for (CompositeQueueFlatFile flatFile : this.deepCopyFlatFileToList()) {
            int delay = random.nextInt(this.storeConfig.getMaxCommitJitter());
            TieredStoreExecutor.commitExecutor.schedule(() -> {
                try {
                    flatFile.commitCommitLog();
                }
                catch (Throwable e) {
                    MessageQueue mq = flatFile.getMessageQueue();
                    logger.error("commit commitLog periodically failed: topic: {}, queue: {}", new Object[]{mq.getTopic(), mq.getQueueId(), e});
                }
            }, (long)delay, TimeUnit.MILLISECONDS);
            TieredStoreExecutor.commitExecutor.schedule(() -> {
                try {
                    flatFile.commitConsumeQueue();
                }
                catch (Throwable e) {
                    MessageQueue mq = flatFile.getMessageQueue();
                    logger.error("commit consumeQueue periodically failed: topic: {}, queue: {}", new Object[]{mq.getTopic(), mq.getQueueId(), e});
                }
            }, (long)delay, TimeUnit.MILLISECONDS);
        }
        TieredStoreExecutor.commitExecutor.schedule(() -> {
            try {
                if (indexFile != null) {
                    indexFile.commit(true);
                }
            }
            catch (Throwable e) {
                logger.error("commit indexFile periodically failed", e);
            }
        }, 0L, TimeUnit.MILLISECONDS);
    }

    public void doCleanExpiredFile() {
        long expiredTimeStamp = System.currentTimeMillis() - TimeUnit.HOURS.toMillis(this.storeConfig.getTieredStoreFileReservedTime());
        Random random = new Random();
        for (CompositeQueueFlatFile flatFile : this.deepCopyFlatFileToList()) {
            int delay = random.nextInt(this.storeConfig.getMaxCommitJitter());
            TieredStoreExecutor.cleanExpiredFileExecutor.schedule(() -> {
                flatFile.getCompositeFlatFileLock().lock();
                try {
                    flatFile.cleanExpiredFile(expiredTimeStamp);
                    flatFile.destroyExpiredFile();
                    if (flatFile.getConsumeQueueBaseOffset() == -1L) {
                        this.destroyCompositeFile(flatFile.getMessageQueue());
                    }
                }
                finally {
                    flatFile.getCompositeFlatFileLock().unlock();
                }
            }, (long)delay, TimeUnit.MILLISECONDS);
        }
        if (indexFile != null) {
            indexFile.cleanExpiredFile(expiredTimeStamp);
            indexFile.destroyExpiredFile();
        }
    }

    private void doScheduleTask() {
        TieredStoreExecutor.commonScheduledExecutor.scheduleWithFixedDelay(() -> {
            try {
                this.doCommit();
            }
            catch (Throwable e) {
                logger.error("commit flat file periodically failed: ", e);
            }
        }, 60L, 60L, TimeUnit.SECONDS);
        TieredStoreExecutor.commonScheduledExecutor.scheduleWithFixedDelay(() -> {
            try {
                this.doCleanExpiredFile();
            }
            catch (Throwable e) {
                logger.error("clean expired flat file failed: ", e);
            }
        }, 30L, 30L, TimeUnit.SECONDS);
    }

    public boolean load() {
        try {
            AtomicLong topicSequenceNumber = new AtomicLong();
            ArrayList futureList = new ArrayList();
            this.queueFlatFileMap.clear();
            this.metadataStore.iterateTopic(topicMetadata -> {
                topicSequenceNumber.set(Math.max(topicSequenceNumber.get(), topicMetadata.getTopicId()));
                Future<?> future = TieredStoreExecutor.dispatchExecutor.submit(() -> {
                    if (topicMetadata.getStatus() != 0) {
                        return;
                    }
                    try {
                        this.metadataStore.iterateQueue(topicMetadata.getTopic(), queueMetadata -> this.getOrCreateFlatFileIfAbsent(new MessageQueue(topicMetadata.getTopic(), this.storeConfig.getBrokerName(), queueMetadata.getQueue().getQueueId())));
                    }
                    catch (Exception e) {
                        logger.error("load mq composite flat file from metadata failed", (Throwable)e);
                    }
                });
                futureList.add(future);
            });
            for (Future future : futureList) {
                future.get();
            }
            this.metadataStore.setTopicSequenceNumber(topicSequenceNumber.incrementAndGet());
        }
        catch (Exception e) {
            logger.error("load mq composite flat file from metadata failed", (Throwable)e);
            return false;
        }
        return true;
    }

    public void cleanup() {
        this.queueFlatFileMap.clear();
        TieredFlatFileManager.cleanStaticReference();
    }

    private static void cleanStaticReference() {
        instance = null;
        indexFile = null;
    }

    @Nullable
    public CompositeQueueFlatFile getOrCreateFlatFileIfAbsent(MessageQueue messageQueue) {
        return this.queueFlatFileMap.computeIfAbsent(messageQueue, mq -> {
            try {
                logger.info("TieredFlatFileManager#getOrCreateFlatFileIfAbsent: try to create new flat file: topic: {}, queueId: {}", (Object)messageQueue.getTopic(), (Object)messageQueue.getQueueId());
                return new CompositeQueueFlatFile(this.tieredFileAllocator, (MessageQueue)mq);
            }
            catch (Exception e) {
                logger.error("TieredFlatFileManager#getOrCreateFlatFileIfAbsent: create new flat file: topic: {}, queueId: {}", new Object[]{messageQueue.getTopic(), messageQueue.getQueueId(), e});
                return null;
            }
        });
    }

    public CompositeQueueFlatFile getFlatFile(MessageQueue messageQueue) {
        return (CompositeQueueFlatFile)this.queueFlatFileMap.get(messageQueue);
    }

    public ImmutableList<CompositeQueueFlatFile> deepCopyFlatFileToList() {
        return ImmutableList.copyOf(this.queueFlatFileMap.values());
    }

    public void shutdown() {
        if (indexFile != null) {
            indexFile.commit(true);
        }
        for (CompositeFlatFile flatFile : this.deepCopyFlatFileToList()) {
            flatFile.shutdown();
        }
    }

    public void destroy() {
        if (indexFile != null) {
            indexFile.destroy();
        }
        ImmutableList<CompositeQueueFlatFile> flatFileList = this.deepCopyFlatFileToList();
        this.cleanup();
        for (CompositeFlatFile flatFile : flatFileList) {
            flatFile.destroy();
        }
    }

    public void destroyCompositeFile(MessageQueue mq) {
        CompositeQueueFlatFile flatFile = (CompositeQueueFlatFile)this.queueFlatFileMap.remove(mq);
        if (flatFile != null) {
            MessageQueue messageQueue = flatFile.getMessageQueue();
            logger.info("TieredFlatFileManager#destroyCompositeFile: try to destroy composite flat file: topic: {}, queueId: {}", (Object)messageQueue.getTopic(), (Object)messageQueue.getQueueId());
            flatFile.destroy();
        }
    }
}

