/*
 * Decompiled with CFR 0.152.
 */
package org.apache.rocketmq.broker.longpolling;

import io.netty.channel.Channel;
import java.util.Comparator;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.rocketmq.remoting.protocol.RemotingCommand;

public class PopRequest {
    private static final AtomicLong COUNTER = new AtomicLong(Long.MIN_VALUE);
    private RemotingCommand remotingCommand;
    private Channel channel;
    private long expired;
    private AtomicBoolean complete = new AtomicBoolean(false);
    private final long op = COUNTER.getAndIncrement();
    public static final Comparator<PopRequest> COMPARATOR = new Comparator<PopRequest>(){

        @Override
        public int compare(PopRequest o1, PopRequest o2) {
            int ret = (int)(o1.getExpired() - o2.getExpired());
            if (ret != 0) {
                return ret;
            }
            ret = (int)(o1.op - o2.op);
            if (ret != 0) {
                return ret;
            }
            return -1;
        }
    };

    public PopRequest(RemotingCommand remotingCommand, Channel channel, long expired) {
        this.channel = channel;
        this.remotingCommand = remotingCommand;
        this.expired = expired;
    }

    public Channel getChannel() {
        return this.channel;
    }

    public RemotingCommand getRemotingCommand() {
        return this.remotingCommand;
    }

    public boolean isTimeout() {
        return System.currentTimeMillis() > this.expired - 50L;
    }

    public boolean complete() {
        return this.complete.compareAndSet(false, true);
    }

    public long getExpired() {
        return this.expired;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("PopRequest{");
        sb.append("cmd=").append(this.remotingCommand);
        sb.append(", channel=").append(this.channel);
        sb.append(", expired=").append(this.expired);
        sb.append(", complete=").append(this.complete);
        sb.append(", op=").append(this.op);
        sb.append('}');
        return sb.toString();
    }
}

