/*
 * Decompiled with CFR 0.152.
 */
package org.apache.rocketmq.store.index;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.apache.rocketmq.common.AbstractBrokerRunnable;
import org.apache.rocketmq.common.BrokerIdentity;
import org.apache.rocketmq.common.UtilAll;
import org.apache.rocketmq.common.sysflag.MessageSysFlag;
import org.apache.rocketmq.logging.org.slf4j.Logger;
import org.apache.rocketmq.logging.org.slf4j.LoggerFactory;
import org.apache.rocketmq.store.DefaultMessageStore;
import org.apache.rocketmq.store.DispatchRequest;
import org.apache.rocketmq.store.config.StorePathConfigHelper;
import org.apache.rocketmq.store.index.IndexFile;
import org.apache.rocketmq.store.index.QueryOffsetResult;

public class IndexService {
    private static final Logger LOGGER = LoggerFactory.getLogger((String)"RocketmqStore");
    private static final int MAX_TRY_IDX_CREATE = 3;
    private final DefaultMessageStore defaultMessageStore;
    private final int hashSlotNum;
    private final int indexNum;
    private final String storePath;
    private final ArrayList<IndexFile> indexFileList = new ArrayList();
    private final ReadWriteLock readWriteLock = new ReentrantReadWriteLock();

    public IndexService(DefaultMessageStore store) {
        this.defaultMessageStore = store;
        this.hashSlotNum = store.getMessageStoreConfig().getMaxHashSlotNum();
        this.indexNum = store.getMessageStoreConfig().getMaxIndexNum();
        this.storePath = StorePathConfigHelper.getStorePathIndex(this.defaultMessageStore.getMessageStoreConfig().getStorePathRootDir());
    }

    public boolean load(boolean lastExitOK) {
        File dir = new File(this.storePath);
        Object[] files = dir.listFiles();
        if (files != null) {
            Arrays.sort(files);
            for (Object file : files) {
                try {
                    IndexFile f = new IndexFile(((File)file).getPath(), this.hashSlotNum, this.indexNum, 0L, 0L);
                    f.load();
                    if (!lastExitOK && f.getEndTimestamp() > this.defaultMessageStore.getStoreCheckpoint().getIndexMsgTimestamp()) {
                        f.destroy(0L);
                        continue;
                    }
                    LOGGER.info("load index file OK, " + f.getFileName());
                    this.indexFileList.add(f);
                }
                catch (IOException e) {
                    LOGGER.error("load file {} error", file, (Object)e);
                    return false;
                }
                catch (NumberFormatException e) {
                    LOGGER.error("load file {} error", file, (Object)e);
                }
            }
        }
        return true;
    }

    public long getTotalSize() {
        if (this.indexFileList.isEmpty()) {
            return 0L;
        }
        return (long)this.indexFileList.get(0).getFileSize() * (long)this.indexFileList.size();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deleteExpiredFile(long offset) {
        Object[] files = null;
        try {
            this.readWriteLock.readLock().lock();
            if (this.indexFileList.isEmpty()) {
                return;
            }
            long endPhyOffset = this.indexFileList.get(0).getEndPhyOffset();
            if (endPhyOffset < offset) {
                files = this.indexFileList.toArray();
            }
        }
        catch (Exception e) {
            LOGGER.error("destroy exception", (Throwable)e);
        }
        finally {
            this.readWriteLock.readLock().unlock();
        }
        if (files != null) {
            IndexFile f;
            ArrayList<IndexFile> fileList = new ArrayList<IndexFile>();
            for (int i = 0; i < files.length - 1 && (f = (IndexFile)files[i]).getEndPhyOffset() < offset; ++i) {
                fileList.add(f);
            }
            this.deleteExpiredFile(fileList);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void deleteExpiredFile(List<IndexFile> files) {
        if (!files.isEmpty()) {
            try {
                this.readWriteLock.writeLock().lock();
                for (IndexFile file : files) {
                    boolean destroyed = file.destroy(3000L);
                    destroyed = destroyed && this.indexFileList.remove(file);
                    if (destroyed) continue;
                    LOGGER.error("deleteExpiredFile remove failed.");
                    break;
                }
            }
            catch (Exception e) {
                LOGGER.error("deleteExpiredFile has exception.", (Throwable)e);
            }
            finally {
                this.readWriteLock.writeLock().unlock();
            }
        }
    }

    public void destroy() {
        try {
            this.readWriteLock.writeLock().lock();
            for (IndexFile f : this.indexFileList) {
                f.destroy(3000L);
            }
            this.indexFileList.clear();
        }
        catch (Exception e) {
            LOGGER.error("destroy exception", (Throwable)e);
        }
        finally {
            this.readWriteLock.writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public QueryOffsetResult queryOffset(String topic, String key, int maxNum, long begin, long end) {
        long indexLastUpdatePhyoffset;
        long indexLastUpdateTimestamp;
        ArrayList<Long> phyOffsets;
        block10: {
            phyOffsets = new ArrayList<Long>(maxNum);
            indexLastUpdateTimestamp = 0L;
            indexLastUpdatePhyoffset = 0L;
            maxNum = Math.min(maxNum, this.defaultMessageStore.getMessageStoreConfig().getMaxMsgsNumBatch());
            try {
                this.readWriteLock.readLock().lock();
                if (this.indexFileList.isEmpty()) break block10;
                for (int i = this.indexFileList.size(); i > 0; --i) {
                    boolean lastFile;
                    IndexFile f = this.indexFileList.get(i - 1);
                    boolean bl = lastFile = i == this.indexFileList.size();
                    if (lastFile) {
                        indexLastUpdateTimestamp = f.getEndTimestamp();
                        indexLastUpdatePhyoffset = f.getEndPhyOffset();
                    }
                    if (f.isTimeMatched(begin, end)) {
                        f.selectPhyOffset(phyOffsets, this.buildKey(topic, key), maxNum, begin, end);
                    }
                    if (f.getBeginTimestamp() < begin) {
                    } else if (phyOffsets.size() < maxNum) continue;
                    break;
                }
            }
            catch (Exception e) {
                LOGGER.error("queryMsg exception", (Throwable)e);
            }
            finally {
                this.readWriteLock.readLock().unlock();
            }
        }
        return new QueryOffsetResult(phyOffsets, indexLastUpdateTimestamp, indexLastUpdatePhyoffset);
    }

    private String buildKey(String topic, String key) {
        return topic + "#" + key;
    }

    public void buildIndex(DispatchRequest req) {
        IndexFile indexFile = this.retryGetAndCreateIndexFile();
        if (indexFile != null) {
            long endPhyOffset = indexFile.getEndPhyOffset();
            DispatchRequest msg = req;
            String topic = msg.getTopic();
            String keys = msg.getKeys();
            if (msg.getCommitLogOffset() < endPhyOffset) {
                return;
            }
            int tranType = MessageSysFlag.getTransactionValue((int)msg.getSysFlag());
            switch (tranType) {
                case 0: 
                case 4: 
                case 8: {
                    break;
                }
                case 12: {
                    return;
                }
            }
            if (req.getUniqKey() != null && (indexFile = this.putKey(indexFile, msg, this.buildKey(topic, req.getUniqKey()))) == null) {
                LOGGER.error("putKey error commitlog {} uniqkey {}", (Object)req.getCommitLogOffset(), (Object)req.getUniqKey());
                return;
            }
            if (keys != null && keys.length() > 0) {
                String[] keyset = keys.split(" ");
                for (int i = 0; i < keyset.length; ++i) {
                    String key = keyset[i];
                    if (key.length() <= 0 || (indexFile = this.putKey(indexFile, msg, this.buildKey(topic, key))) != null) continue;
                    LOGGER.error("putKey error commitlog {} uniqkey {}", (Object)req.getCommitLogOffset(), (Object)req.getUniqKey());
                    return;
                }
            }
        } else {
            LOGGER.error("build index error, stop building index");
        }
    }

    private IndexFile putKey(IndexFile indexFile, DispatchRequest msg, String idxKey) {
        boolean ok = indexFile.putKey(idxKey, msg.getCommitLogOffset(), msg.getStoreTimestamp());
        while (!ok) {
            LOGGER.warn("Index file [" + indexFile.getFileName() + "] is full, trying to create another one");
            indexFile = this.retryGetAndCreateIndexFile();
            if (null == indexFile) {
                return null;
            }
            ok = indexFile.putKey(idxKey, msg.getCommitLogOffset(), msg.getStoreTimestamp());
        }
        return indexFile;
    }

    public IndexFile retryGetAndCreateIndexFile() {
        IndexFile indexFile = null;
        for (int times = 0; null == indexFile && times < 3 && null == (indexFile = this.getAndCreateLastIndexFile()); ++times) {
            try {
                LOGGER.info("Tried to create index file " + times + " times");
                Thread.sleep(1000L);
                continue;
            }
            catch (InterruptedException e) {
                LOGGER.error("Interrupted", (Throwable)e);
            }
        }
        if (null == indexFile) {
            this.defaultMessageStore.getRunningFlags().makeIndexFileError();
            LOGGER.error("Mark index file cannot build flag");
        }
        return indexFile;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IndexFile getAndCreateLastIndexFile() {
        IndexFile indexFile = null;
        IndexFile prevIndexFile = null;
        long lastUpdateEndPhyOffset = 0L;
        long lastUpdateIndexTimestamp = 0L;
        this.readWriteLock.readLock().lock();
        if (!this.indexFileList.isEmpty()) {
            IndexFile tmp = this.indexFileList.get(this.indexFileList.size() - 1);
            if (!tmp.isWriteFull()) {
                indexFile = tmp;
            } else {
                lastUpdateEndPhyOffset = tmp.getEndPhyOffset();
                lastUpdateIndexTimestamp = tmp.getEndTimestamp();
                prevIndexFile = tmp;
            }
        }
        this.readWriteLock.readLock().unlock();
        if (indexFile == null) {
            try {
                String fileName = this.storePath + File.separator + UtilAll.timeMillisToHumanString((long)System.currentTimeMillis());
                indexFile = new IndexFile(fileName, this.hashSlotNum, this.indexNum, lastUpdateEndPhyOffset, lastUpdateIndexTimestamp);
                this.readWriteLock.writeLock().lock();
                this.indexFileList.add(indexFile);
            }
            catch (Exception e) {
                LOGGER.error("getLastIndexFile exception ", (Throwable)e);
            }
            finally {
                this.readWriteLock.writeLock().unlock();
            }
            if (indexFile != null) {
                final IndexFile flushThisFile = prevIndexFile;
                Thread flushThread = new Thread((Runnable)new AbstractBrokerRunnable((BrokerIdentity)this.defaultMessageStore.getBrokerConfig()){

                    public void run0() {
                        IndexService.this.flush(flushThisFile);
                    }
                }, "FlushIndexFileThread");
                flushThread.setDaemon(true);
                flushThread.start();
            }
        }
        return indexFile;
    }

    public void flush(IndexFile f) {
        if (null == f) {
            return;
        }
        long indexMsgTimestamp = 0L;
        if (f.isWriteFull()) {
            indexMsgTimestamp = f.getEndTimestamp();
        }
        f.flush();
        if (indexMsgTimestamp > 0L) {
            this.defaultMessageStore.getStoreCheckpoint().setIndexMsgTimestamp(indexMsgTimestamp);
            this.defaultMessageStore.getStoreCheckpoint().flush();
        }
    }

    public void start() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void shutdown() {
        try {
            this.readWriteLock.writeLock().lock();
            for (IndexFile f : this.indexFileList) {
                try {
                    f.shutdown();
                }
                catch (Exception e) {
                    LOGGER.error("shutdown " + f.getFileName() + " exception", (Throwable)e);
                }
            }
            this.indexFileList.clear();
        }
        catch (Exception e) {
            LOGGER.error("shutdown exception", (Throwable)e);
        }
        finally {
            this.readWriteLock.writeLock().unlock();
        }
    }
}

