/*
 * Decompiled with CFR 0.152.
 */
package org.apache.rocketmq.proxy.grpc.v2.common;

import apache.rocketmq.v2.Address;
import apache.rocketmq.v2.AddressScheme;
import apache.rocketmq.v2.CustomizedBackoff;
import apache.rocketmq.v2.Endpoints;
import apache.rocketmq.v2.ExponentialBackoff;
import apache.rocketmq.v2.Metric;
import apache.rocketmq.v2.Settings;
import com.google.protobuf.util.Durations;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Collectors;
import org.apache.rocketmq.common.subscription.CustomizedRetryPolicy;
import org.apache.rocketmq.common.subscription.ExponentialRetryPolicy;
import org.apache.rocketmq.common.subscription.GroupRetryPolicy;
import org.apache.rocketmq.common.subscription.GroupRetryPolicyType;
import org.apache.rocketmq.common.subscription.SubscriptionGroupConfig;
import org.apache.rocketmq.proxy.common.ProxyContext;
import org.apache.rocketmq.proxy.config.ConfigurationManager;
import org.apache.rocketmq.proxy.config.MetricCollectorMode;
import org.apache.rocketmq.proxy.config.ProxyConfig;
import org.apache.rocketmq.proxy.grpc.v2.common.GrpcConverter;
import org.apache.rocketmq.proxy.processor.MessagingProcessor;

public class GrpcClientSettingsManager {
    protected static final Map<String, Settings> CLIENT_SETTINGS_MAP = new ConcurrentHashMap<String, Settings>();
    private final MessagingProcessor messagingProcessor;

    public GrpcClientSettingsManager(MessagingProcessor messagingProcessor) {
        this.messagingProcessor = messagingProcessor;
    }

    public Settings getClientSettings(ProxyContext ctx) {
        String clientId = ctx.getClientID();
        Settings settings = CLIENT_SETTINGS_MAP.get(clientId);
        if (settings == null) {
            return null;
        }
        if (settings.hasPublishing()) {
            settings = GrpcClientSettingsManager.mergeProducerData(settings);
        } else if (settings.hasSubscription()) {
            settings = this.mergeSubscriptionData(ctx, settings, GrpcConverter.getInstance().wrapResourceWithNamespace(settings.getSubscription().getGroup()));
        }
        return this.mergeMetric(settings);
    }

    protected static Settings mergeProducerData(Settings settings) {
        ProxyConfig config = ConfigurationManager.getProxyConfig();
        Settings.Builder builder = settings.toBuilder();
        builder.getBackoffPolicyBuilder().setMaxAttempts(config.getGrpcClientProducerMaxAttempts()).setExponentialBackoff(ExponentialBackoff.newBuilder().setInitial(Durations.fromMillis((long)config.getGrpcClientProducerBackoffInitialMillis())).setMax(Durations.fromMillis((long)config.getGrpcClientProducerBackoffMaxMillis())).setMultiplier((float)config.getGrpcClientProducerBackoffMultiplier()).build());
        builder.getPublishingBuilder().setValidateMessageType(config.isEnableTopicMessageTypeCheck()).setMaxBodySize(config.getMaxMessageSize());
        return builder.build();
    }

    protected Settings mergeSubscriptionData(ProxyContext ctx, Settings settings, String consumerGroup) {
        SubscriptionGroupConfig config = this.messagingProcessor.getSubscriptionGroupConfig(ctx, consumerGroup);
        if (config == null) {
            return settings;
        }
        return GrpcClientSettingsManager.mergeSubscriptionData(settings, config);
    }

    protected Settings mergeMetric(Settings settings) {
        ProxyConfig proxyConfig = ConfigurationManager.getProxyConfig();
        MetricCollectorMode metricCollectorMode = MetricCollectorMode.getEnumByString(proxyConfig.getMetricCollectorMode());
        String metricCollectorAddress = proxyConfig.getMetricCollectorAddress();
        Metric.Builder metricBuilder = Metric.newBuilder();
        switch (metricCollectorMode) {
            case ON: {
                String[] split = metricCollectorAddress.split(":");
                String host = split[0];
                int port = Integer.parseInt(split[1]);
                Address address = Address.newBuilder().setHost(host).setPort(port).build();
                Endpoints endpoints = Endpoints.newBuilder().setScheme(AddressScheme.IPv4).addAddresses(address).build();
                metricBuilder.setOn(true).setEndpoints(endpoints);
                break;
            }
            case PROXY: {
                metricBuilder.setOn(true).setEndpoints(settings.getAccessPoint());
                break;
            }
            default: {
                metricBuilder.setOn(false);
            }
        }
        Metric metric = metricBuilder.build();
        return settings.toBuilder().setMetric(metric).build();
    }

    protected static Settings mergeSubscriptionData(Settings settings, SubscriptionGroupConfig groupConfig) {
        Settings.Builder resultSettingsBuilder = settings.toBuilder();
        ProxyConfig config = ConfigurationManager.getProxyConfig();
        resultSettingsBuilder.getSubscriptionBuilder().setReceiveBatchSize(config.getGrpcClientConsumerLongPollingBatchSize()).setLongPollingTimeout(Durations.fromMillis((long)config.getGrpcClientConsumerLongPollingTimeoutMillis())).setFifo(groupConfig.isConsumeMessageOrderly());
        resultSettingsBuilder.getBackoffPolicyBuilder().setMaxAttempts(groupConfig.getRetryMaxTimes() + 1);
        GroupRetryPolicy groupRetryPolicy = groupConfig.getGroupRetryPolicy();
        if (groupRetryPolicy.getType().equals((Object)GroupRetryPolicyType.EXPONENTIAL)) {
            ExponentialRetryPolicy exponentialRetryPolicy = groupRetryPolicy.getExponentialRetryPolicy();
            if (exponentialRetryPolicy == null) {
                exponentialRetryPolicy = new ExponentialRetryPolicy();
            }
            resultSettingsBuilder.getBackoffPolicyBuilder().setExponentialBackoff(GrpcClientSettingsManager.convertToExponentialBackoff(exponentialRetryPolicy));
        } else {
            CustomizedRetryPolicy customizedRetryPolicy = groupRetryPolicy.getCustomizedRetryPolicy();
            if (customizedRetryPolicy == null) {
                customizedRetryPolicy = new CustomizedRetryPolicy();
            }
            resultSettingsBuilder.getBackoffPolicyBuilder().setCustomizedBackoff(GrpcClientSettingsManager.convertToCustomizedRetryPolicy(customizedRetryPolicy));
        }
        return resultSettingsBuilder.build();
    }

    protected static ExponentialBackoff convertToExponentialBackoff(ExponentialRetryPolicy retryPolicy) {
        return ExponentialBackoff.newBuilder().setInitial(Durations.fromMillis((long)retryPolicy.getInitial())).setMax(Durations.fromMillis((long)retryPolicy.getMax())).setMultiplier((float)retryPolicy.getMultiplier()).build();
    }

    protected static CustomizedBackoff convertToCustomizedRetryPolicy(CustomizedRetryPolicy retryPolicy) {
        List durationList = Arrays.stream(retryPolicy.getNext()).mapToObj(Durations::fromMillis).collect(Collectors.toList());
        return CustomizedBackoff.newBuilder().addAllNext(durationList).build();
    }

    public void updateClientSettings(String clientId, Settings settings) {
        if (settings.hasSubscription()) {
            settings = this.createDefaultConsumerSettingsBuilder().mergeFrom(settings).build();
        }
        CLIENT_SETTINGS_MAP.put(clientId, settings);
    }

    protected Settings.Builder createDefaultConsumerSettingsBuilder() {
        return GrpcClientSettingsManager.mergeSubscriptionData(Settings.newBuilder().getDefaultInstanceForType(), new SubscriptionGroupConfig()).toBuilder();
    }

    public void removeClientSettings(String clientId) {
        CLIENT_SETTINGS_MAP.remove(clientId);
    }

    public Settings removeAndGetClientSettings(ProxyContext ctx) {
        String clientId = ctx.getClientID();
        Settings settings = CLIENT_SETTINGS_MAP.remove(clientId);
        if (settings == null) {
            return null;
        }
        if (settings.hasSubscription()) {
            settings = this.mergeSubscriptionData(ctx, settings, GrpcConverter.getInstance().wrapResourceWithNamespace(settings.getSubscription().getGroup()));
        }
        return this.mergeMetric(settings);
    }
}

