/*
 * Decompiled with CFR 0.152.
 */
package org.apache.rocketmq.common.message;

import java.nio.ByteBuffer;

public enum MessageVersion {
    MESSAGE_VERSION_V1(-626843481){

        @Override
        public int getTopicLengthSize() {
            return 1;
        }

        @Override
        public int getTopicLength(ByteBuffer buffer) {
            return buffer.get();
        }

        @Override
        public int getTopicLength(ByteBuffer buffer, int index) {
            return buffer.get(index);
        }

        @Override
        public void putTopicLength(ByteBuffer buffer, int topicLength) {
            buffer.put((byte)topicLength);
        }
    };

    private final int magicCode;

    private MessageVersion(int magicCode) {
        this.magicCode = magicCode;
    }

    public static MessageVersion valueOfMagicCode(int magicCode) {
        for (MessageVersion version : MessageVersion.values()) {
            if (version.getMagicCode() != magicCode) continue;
            return version;
        }
        throw new IllegalArgumentException("Invalid magicCode " + magicCode);
    }

    public int getMagicCode() {
        return this.magicCode;
    }

    public abstract int getTopicLengthSize();

    public abstract int getTopicLength(ByteBuffer var1);

    public abstract int getTopicLength(ByteBuffer var1, int var2);

    public abstract void putTopicLength(ByteBuffer var1, int var2);
}

