/*
 * Decompiled with CFR 0.152.
 */
package org.apache.rocketmq.broker.subscription;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.apache.rocketmq.broker.BrokerController;
import org.apache.rocketmq.broker.BrokerPathConfigHelper;
import org.apache.rocketmq.common.ConfigManager;
import org.apache.rocketmq.common.DataVersion;
import org.apache.rocketmq.common.MixAll;
import org.apache.rocketmq.common.subscription.SubscriptionGroupConfig;
import org.apache.rocketmq.logging.InternalLogger;
import org.apache.rocketmq.logging.InternalLoggerFactory;
import org.apache.rocketmq.remoting.protocol.RemotingSerializable;

public class SubscriptionGroupManager
extends ConfigManager {
    private static final InternalLogger log = InternalLoggerFactory.getLogger((String)"RocketmqBroker");
    private final ConcurrentMap<String, SubscriptionGroupConfig> subscriptionGroupTable = new ConcurrentHashMap<String, SubscriptionGroupConfig>(1024);
    private final ConcurrentMap<String, ConcurrentMap<String, Integer>> forbiddenTable = new ConcurrentHashMap<String, ConcurrentMap<String, Integer>>(4);
    private final DataVersion dataVersion = new DataVersion();
    private transient BrokerController brokerController;

    public SubscriptionGroupManager() {
        this.init();
    }

    public SubscriptionGroupManager(BrokerController brokerController) {
        this.brokerController = brokerController;
        this.init();
    }

    private void init() {
        SubscriptionGroupConfig subscriptionGroupConfig = new SubscriptionGroupConfig();
        subscriptionGroupConfig.setGroupName("TOOLS_CONSUMER");
        this.subscriptionGroupTable.put("TOOLS_CONSUMER", subscriptionGroupConfig);
        subscriptionGroupConfig = new SubscriptionGroupConfig();
        subscriptionGroupConfig.setGroupName("FILTERSRV_CONSUMER");
        this.subscriptionGroupTable.put("FILTERSRV_CONSUMER", subscriptionGroupConfig);
        subscriptionGroupConfig = new SubscriptionGroupConfig();
        subscriptionGroupConfig.setGroupName("SELF_TEST_C_GROUP");
        this.subscriptionGroupTable.put("SELF_TEST_C_GROUP", subscriptionGroupConfig);
        subscriptionGroupConfig = new SubscriptionGroupConfig();
        subscriptionGroupConfig.setGroupName("CID_ONS-HTTP-PROXY");
        subscriptionGroupConfig.setConsumeBroadcastEnable(true);
        this.subscriptionGroupTable.put("CID_ONS-HTTP-PROXY", subscriptionGroupConfig);
        subscriptionGroupConfig = new SubscriptionGroupConfig();
        subscriptionGroupConfig.setGroupName("CID_ONSAPI_PULL");
        subscriptionGroupConfig.setConsumeBroadcastEnable(true);
        this.subscriptionGroupTable.put("CID_ONSAPI_PULL", subscriptionGroupConfig);
        subscriptionGroupConfig = new SubscriptionGroupConfig();
        subscriptionGroupConfig.setGroupName("CID_ONSAPI_PERMISSION");
        subscriptionGroupConfig.setConsumeBroadcastEnable(true);
        this.subscriptionGroupTable.put("CID_ONSAPI_PERMISSION", subscriptionGroupConfig);
        subscriptionGroupConfig = new SubscriptionGroupConfig();
        subscriptionGroupConfig.setGroupName("CID_ONSAPI_OWNER");
        subscriptionGroupConfig.setConsumeBroadcastEnable(true);
        this.subscriptionGroupTable.put("CID_ONSAPI_OWNER", subscriptionGroupConfig);
        subscriptionGroupConfig = new SubscriptionGroupConfig();
        subscriptionGroupConfig.setGroupName("CID_RMQ_SYS_TRANS");
        subscriptionGroupConfig.setConsumeBroadcastEnable(true);
        this.subscriptionGroupTable.put("CID_RMQ_SYS_TRANS", subscriptionGroupConfig);
    }

    public void updateSubscriptionGroupConfig(SubscriptionGroupConfig config) {
        SubscriptionGroupConfig old = this.subscriptionGroupTable.put(config.getGroupName(), config);
        if (old != null) {
            log.info("update subscription group config, old: {} new: {}", (Object)old, (Object)config);
        } else {
            log.info("create new subscription group, {}", (Object)config);
        }
        long stateMachineVersion = this.brokerController.getMessageStore() != null ? this.brokerController.getMessageStore().getStateMachineVersion() : 0L;
        this.dataVersion.nextVersion(stateMachineVersion);
        this.persist();
    }

    public void updateForbidden(String group, String topic, int forbiddenIndex, boolean setOrClear) {
        if (setOrClear) {
            this.setForbidden(group, topic, forbiddenIndex);
        } else {
            this.clearForbidden(group, topic, forbiddenIndex);
        }
    }

    public void setForbidden(String group, String topic, int forbiddenIndex) {
        int topicForbidden = this.getForbidden(group, topic);
        this.updateForbiddenValue(group, topic, topicForbidden |= 1 << forbiddenIndex);
    }

    public void clearForbidden(String group, String topic, int forbiddenIndex) {
        int topicForbidden = this.getForbidden(group, topic);
        this.updateForbiddenValue(group, topic, topicForbidden &= ~(1 << forbiddenIndex));
    }

    public boolean getForbidden(String group, String topic, int forbiddenIndex) {
        int bitForbidden;
        int topicForbidden = this.getForbidden(group, topic);
        return (topicForbidden & (bitForbidden = 1 << forbiddenIndex)) == bitForbidden;
    }

    public int getForbidden(String group, String topic) {
        ConcurrentMap topicForbiddens = (ConcurrentMap)this.forbiddenTable.get(group);
        if (topicForbiddens == null) {
            return 0;
        }
        Integer topicForbidden = (Integer)topicForbiddens.get(topic);
        if (topicForbidden == null || topicForbidden < 0) {
            topicForbidden = 0;
        }
        return topicForbidden;
    }

    private void updateForbiddenValue(String group, String topic, Integer forbidden) {
        Integer old;
        if (forbidden == null || forbidden <= 0) {
            this.forbiddenTable.remove(group);
            log.info("clear group forbidden, {}@{} ", (Object)group, (Object)topic);
            return;
        }
        ConcurrentMap topicsPermMap = (ConcurrentMap)this.forbiddenTable.get(group);
        if (topicsPermMap == null) {
            this.forbiddenTable.putIfAbsent(group, new ConcurrentHashMap());
            topicsPermMap = (ConcurrentMap)this.forbiddenTable.get(group);
        }
        if ((old = topicsPermMap.put(topic, forbidden)) != null) {
            log.info("set group forbidden, {}@{} old: {} new: {}", new Object[]{group, topic, old, forbidden});
        } else {
            log.info("set group forbidden, {}@{} old: {} new: {}", new Object[]{group, topic, 0, forbidden});
        }
        this.dataVersion.nextVersion();
        this.persist();
    }

    public void disableConsume(String groupName) {
        SubscriptionGroupConfig old = (SubscriptionGroupConfig)this.subscriptionGroupTable.get(groupName);
        if (old != null) {
            old.setConsumeEnable(false);
            long stateMachineVersion = this.brokerController.getMessageStore() != null ? this.brokerController.getMessageStore().getStateMachineVersion() : 0L;
            this.dataVersion.nextVersion(stateMachineVersion);
        }
    }

    public SubscriptionGroupConfig findSubscriptionGroupConfig(String group) {
        SubscriptionGroupConfig subscriptionGroupConfig = (SubscriptionGroupConfig)this.subscriptionGroupTable.get(group);
        if (null == subscriptionGroupConfig && (this.brokerController.getBrokerConfig().isAutoCreateSubscriptionGroup() || MixAll.isSysConsumerGroup((String)group))) {
            subscriptionGroupConfig = new SubscriptionGroupConfig();
            subscriptionGroupConfig.setGroupName(group);
            SubscriptionGroupConfig preConfig = this.subscriptionGroupTable.putIfAbsent(group, subscriptionGroupConfig);
            if (null == preConfig) {
                log.info("auto create a subscription group, {}", (Object)subscriptionGroupConfig.toString());
            }
            long stateMachineVersion = this.brokerController.getMessageStore() != null ? this.brokerController.getMessageStore().getStateMachineVersion() : 0L;
            this.dataVersion.nextVersion(stateMachineVersion);
            this.persist();
        }
        return subscriptionGroupConfig;
    }

    public String encode() {
        return this.encode(false);
    }

    public String configFilePath() {
        return BrokerPathConfigHelper.getSubscriptionGroupPath(this.brokerController.getMessageStoreConfig().getStorePathRootDir());
    }

    public void decode(String jsonString) {
        SubscriptionGroupManager obj;
        if (jsonString != null && (obj = (SubscriptionGroupManager)((Object)RemotingSerializable.fromJson((String)jsonString, SubscriptionGroupManager.class))) != null) {
            this.subscriptionGroupTable.putAll(obj.subscriptionGroupTable);
            if (obj.forbiddenTable != null) {
                this.forbiddenTable.putAll(obj.forbiddenTable);
            }
            this.dataVersion.assignNewOne(obj.dataVersion);
            this.printLoadDataWhenFirstBoot(obj);
        }
    }

    public String encode(boolean prettyFormat) {
        return RemotingSerializable.toJson((Object)((Object)this), (boolean)prettyFormat);
    }

    private void printLoadDataWhenFirstBoot(SubscriptionGroupManager sgm) {
        for (Map.Entry next : sgm.getSubscriptionGroupTable().entrySet()) {
            log.info("load exist subscription group, {}", (Object)((SubscriptionGroupConfig)next.getValue()).toString());
        }
    }

    public ConcurrentMap<String, SubscriptionGroupConfig> getSubscriptionGroupTable() {
        return this.subscriptionGroupTable;
    }

    public ConcurrentMap<String, ConcurrentMap<String, Integer>> getForbiddenTable() {
        return this.forbiddenTable;
    }

    public DataVersion getDataVersion() {
        return this.dataVersion;
    }

    public void deleteSubscriptionGroupConfig(String groupName) {
        SubscriptionGroupConfig old = (SubscriptionGroupConfig)this.subscriptionGroupTable.remove(groupName);
        this.forbiddenTable.remove(groupName);
        if (old != null) {
            log.info("delete subscription group OK, subscription group:{}", (Object)old);
            long stateMachineVersion = this.brokerController.getMessageStore() != null ? this.brokerController.getMessageStore().getStateMachineVersion() : 0L;
            this.dataVersion.nextVersion(stateMachineVersion);
            this.persist();
        } else {
            log.warn("delete subscription group failed, subscription groupName: {} not exist", (Object)groupName);
        }
    }

    public void setSubscriptionGroupTable(ConcurrentMap<String, SubscriptionGroupConfig> otherSubscriptionGroupTable) {
        this.subscriptionGroupTable.clear();
        for (String key : otherSubscriptionGroupTable.keySet()) {
            this.subscriptionGroupTable.put(key, (SubscriptionGroupConfig)otherSubscriptionGroupTable.get(key));
        }
    }
}

