/*
 * Decompiled with CFR 0.152.
 */
package org.apache.rocketmq.client.impl;

import com.alibaba.fastjson.JSON;
import io.netty.channel.Channel;
import java.io.UnsupportedEncodingException;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.commons.lang3.StringUtils;
import org.apache.rocketmq.client.ClientConfig;
import org.apache.rocketmq.client.Validators;
import org.apache.rocketmq.client.consumer.AckCallback;
import org.apache.rocketmq.client.consumer.AckResult;
import org.apache.rocketmq.client.consumer.AckStatus;
import org.apache.rocketmq.client.consumer.PopCallback;
import org.apache.rocketmq.client.consumer.PopResult;
import org.apache.rocketmq.client.consumer.PopStatus;
import org.apache.rocketmq.client.consumer.PullCallback;
import org.apache.rocketmq.client.consumer.PullResult;
import org.apache.rocketmq.client.consumer.PullStatus;
import org.apache.rocketmq.client.exception.MQBrokerException;
import org.apache.rocketmq.client.exception.MQClientException;
import org.apache.rocketmq.client.exception.OffsetNotFoundException;
import org.apache.rocketmq.client.hook.SendMessageContext;
import org.apache.rocketmq.client.impl.BaseInvokeCallback;
import org.apache.rocketmq.client.impl.ClientRemotingProcessor;
import org.apache.rocketmq.client.impl.CommunicationMode;
import org.apache.rocketmq.client.impl.consumer.PullResultExt;
import org.apache.rocketmq.client.impl.factory.MQClientInstance;
import org.apache.rocketmq.client.impl.producer.DefaultMQProducerImpl;
import org.apache.rocketmq.client.impl.producer.TopicPublishInfo;
import org.apache.rocketmq.client.log.ClientLogger;
import org.apache.rocketmq.client.producer.SendCallback;
import org.apache.rocketmq.client.producer.SendResult;
import org.apache.rocketmq.client.producer.SendStatus;
import org.apache.rocketmq.common.AclConfig;
import org.apache.rocketmq.common.DataVersion;
import org.apache.rocketmq.common.MQVersion;
import org.apache.rocketmq.common.MixAll;
import org.apache.rocketmq.common.PlainAccessConfig;
import org.apache.rocketmq.common.TopicConfig;
import org.apache.rocketmq.common.UtilAll;
import org.apache.rocketmq.common.admin.ConsumeStats;
import org.apache.rocketmq.common.admin.TopicStatsTable;
import org.apache.rocketmq.common.attribute.AttributeParser;
import org.apache.rocketmq.common.message.Message;
import org.apache.rocketmq.common.message.MessageBatch;
import org.apache.rocketmq.common.message.MessageClientIDSetter;
import org.apache.rocketmq.common.message.MessageDecoder;
import org.apache.rocketmq.common.message.MessageExt;
import org.apache.rocketmq.common.message.MessageQueue;
import org.apache.rocketmq.common.message.MessageQueueAssignment;
import org.apache.rocketmq.common.message.MessageRequestMode;
import org.apache.rocketmq.common.namesrv.DefaultTopAddressing;
import org.apache.rocketmq.common.namesrv.NameServerUpdateCallback;
import org.apache.rocketmq.common.namesrv.TopAddressing;
import org.apache.rocketmq.common.protocol.NamespaceUtil;
import org.apache.rocketmq.common.protocol.body.BrokerMemberGroup;
import org.apache.rocketmq.common.protocol.body.BrokerStatsData;
import org.apache.rocketmq.common.protocol.body.CheckClientRequestBody;
import org.apache.rocketmq.common.protocol.body.ClusterAclVersionInfo;
import org.apache.rocketmq.common.protocol.body.ClusterInfo;
import org.apache.rocketmq.common.protocol.body.ConsumeMessageDirectlyResult;
import org.apache.rocketmq.common.protocol.body.ConsumeStatsList;
import org.apache.rocketmq.common.protocol.body.ConsumerConnection;
import org.apache.rocketmq.common.protocol.body.ConsumerRunningInfo;
import org.apache.rocketmq.common.protocol.body.EpochEntryCache;
import org.apache.rocketmq.common.protocol.body.GetConsumerStatusBody;
import org.apache.rocketmq.common.protocol.body.GroupList;
import org.apache.rocketmq.common.protocol.body.HARuntimeInfo;
import org.apache.rocketmq.common.protocol.body.InSyncStateData;
import org.apache.rocketmq.common.protocol.body.KVTable;
import org.apache.rocketmq.common.protocol.body.LockBatchRequestBody;
import org.apache.rocketmq.common.protocol.body.LockBatchResponseBody;
import org.apache.rocketmq.common.protocol.body.ProducerConnection;
import org.apache.rocketmq.common.protocol.body.ProducerTableInfo;
import org.apache.rocketmq.common.protocol.body.QueryAssignmentRequestBody;
import org.apache.rocketmq.common.protocol.body.QueryAssignmentResponseBody;
import org.apache.rocketmq.common.protocol.body.QueryConsumeQueueResponseBody;
import org.apache.rocketmq.common.protocol.body.QueryConsumeTimeSpanBody;
import org.apache.rocketmq.common.protocol.body.QueryCorrectionOffsetBody;
import org.apache.rocketmq.common.protocol.body.QuerySubscriptionResponseBody;
import org.apache.rocketmq.common.protocol.body.QueueTimeSpan;
import org.apache.rocketmq.common.protocol.body.ResetOffsetBody;
import org.apache.rocketmq.common.protocol.body.SetMessageRequestModeRequestBody;
import org.apache.rocketmq.common.protocol.body.SubscriptionGroupWrapper;
import org.apache.rocketmq.common.protocol.body.TopicConfigSerializeWrapper;
import org.apache.rocketmq.common.protocol.body.TopicList;
import org.apache.rocketmq.common.protocol.body.UnlockBatchRequestBody;
import org.apache.rocketmq.common.protocol.header.AckMessageRequestHeader;
import org.apache.rocketmq.common.protocol.header.AddBrokerRequestHeader;
import org.apache.rocketmq.common.protocol.header.ChangeInvisibleTimeRequestHeader;
import org.apache.rocketmq.common.protocol.header.ChangeInvisibleTimeResponseHeader;
import org.apache.rocketmq.common.protocol.header.CloneGroupOffsetRequestHeader;
import org.apache.rocketmq.common.protocol.header.ConsumeMessageDirectlyResultRequestHeader;
import org.apache.rocketmq.common.protocol.header.ConsumerSendMsgBackRequestHeader;
import org.apache.rocketmq.common.protocol.header.CreateAccessConfigRequestHeader;
import org.apache.rocketmq.common.protocol.header.CreateTopicRequestHeader;
import org.apache.rocketmq.common.protocol.header.DeleteAccessConfigRequestHeader;
import org.apache.rocketmq.common.protocol.header.DeleteSubscriptionGroupRequestHeader;
import org.apache.rocketmq.common.protocol.header.DeleteTopicRequestHeader;
import org.apache.rocketmq.common.protocol.header.EndTransactionRequestHeader;
import org.apache.rocketmq.common.protocol.header.ExtraInfoUtil;
import org.apache.rocketmq.common.protocol.header.GetAllProducerInfoRequestHeader;
import org.apache.rocketmq.common.protocol.header.GetBrokerAclConfigResponseHeader;
import org.apache.rocketmq.common.protocol.header.GetBrokerClusterAclConfigResponseBody;
import org.apache.rocketmq.common.protocol.header.GetConsumeStatsInBrokerHeader;
import org.apache.rocketmq.common.protocol.header.GetConsumeStatsRequestHeader;
import org.apache.rocketmq.common.protocol.header.GetConsumerConnectionListRequestHeader;
import org.apache.rocketmq.common.protocol.header.GetConsumerListByGroupRequestHeader;
import org.apache.rocketmq.common.protocol.header.GetConsumerListByGroupResponseBody;
import org.apache.rocketmq.common.protocol.header.GetConsumerRunningInfoRequestHeader;
import org.apache.rocketmq.common.protocol.header.GetConsumerStatusRequestHeader;
import org.apache.rocketmq.common.protocol.header.GetEarliestMsgStoretimeRequestHeader;
import org.apache.rocketmq.common.protocol.header.GetEarliestMsgStoretimeResponseHeader;
import org.apache.rocketmq.common.protocol.header.GetMaxOffsetRequestHeader;
import org.apache.rocketmq.common.protocol.header.GetMaxOffsetResponseHeader;
import org.apache.rocketmq.common.protocol.header.GetMinOffsetRequestHeader;
import org.apache.rocketmq.common.protocol.header.GetMinOffsetResponseHeader;
import org.apache.rocketmq.common.protocol.header.GetProducerConnectionListRequestHeader;
import org.apache.rocketmq.common.protocol.header.GetSubscriptionGroupConfigRequestHeader;
import org.apache.rocketmq.common.protocol.header.GetTopicConfigRequestHeader;
import org.apache.rocketmq.common.protocol.header.GetTopicStatsInfoRequestHeader;
import org.apache.rocketmq.common.protocol.header.GetTopicsByClusterRequestHeader;
import org.apache.rocketmq.common.protocol.header.PopMessageRequestHeader;
import org.apache.rocketmq.common.protocol.header.PopMessageResponseHeader;
import org.apache.rocketmq.common.protocol.header.PullMessageRequestHeader;
import org.apache.rocketmq.common.protocol.header.PullMessageResponseHeader;
import org.apache.rocketmq.common.protocol.header.QueryConsumeQueueRequestHeader;
import org.apache.rocketmq.common.protocol.header.QueryConsumeTimeSpanRequestHeader;
import org.apache.rocketmq.common.protocol.header.QueryConsumerOffsetRequestHeader;
import org.apache.rocketmq.common.protocol.header.QueryConsumerOffsetResponseHeader;
import org.apache.rocketmq.common.protocol.header.QueryCorrectionOffsetHeader;
import org.apache.rocketmq.common.protocol.header.QueryMessageRequestHeader;
import org.apache.rocketmq.common.protocol.header.QuerySubscriptionByConsumerRequestHeader;
import org.apache.rocketmq.common.protocol.header.QueryTopicConsumeByWhoRequestHeader;
import org.apache.rocketmq.common.protocol.header.QueryTopicsByConsumerRequestHeader;
import org.apache.rocketmq.common.protocol.header.RemoveBrokerRequestHeader;
import org.apache.rocketmq.common.protocol.header.ResetMasterFlushOffsetHeader;
import org.apache.rocketmq.common.protocol.header.ResetOffsetRequestHeader;
import org.apache.rocketmq.common.protocol.header.ResumeCheckHalfMessageRequestHeader;
import org.apache.rocketmq.common.protocol.header.SearchOffsetRequestHeader;
import org.apache.rocketmq.common.protocol.header.SearchOffsetResponseHeader;
import org.apache.rocketmq.common.protocol.header.SendMessageRequestHeader;
import org.apache.rocketmq.common.protocol.header.SendMessageRequestHeaderV2;
import org.apache.rocketmq.common.protocol.header.SendMessageResponseHeader;
import org.apache.rocketmq.common.protocol.header.UnregisterClientRequestHeader;
import org.apache.rocketmq.common.protocol.header.UpdateConsumerOffsetRequestHeader;
import org.apache.rocketmq.common.protocol.header.UpdateGlobalWhiteAddrsConfigRequestHeader;
import org.apache.rocketmq.common.protocol.header.UpdateGroupForbiddenRequestHeader;
import org.apache.rocketmq.common.protocol.header.ViewBrokerStatsDataRequestHeader;
import org.apache.rocketmq.common.protocol.header.ViewMessageRequestHeader;
import org.apache.rocketmq.common.protocol.header.filtersrv.RegisterMessageFilterClassRequestHeader;
import org.apache.rocketmq.common.protocol.header.namesrv.AddWritePermOfBrokerRequestHeader;
import org.apache.rocketmq.common.protocol.header.namesrv.AddWritePermOfBrokerResponseHeader;
import org.apache.rocketmq.common.protocol.header.namesrv.DeleteKVConfigRequestHeader;
import org.apache.rocketmq.common.protocol.header.namesrv.DeleteTopicFromNamesrvRequestHeader;
import org.apache.rocketmq.common.protocol.header.namesrv.GetKVConfigRequestHeader;
import org.apache.rocketmq.common.protocol.header.namesrv.GetKVConfigResponseHeader;
import org.apache.rocketmq.common.protocol.header.namesrv.GetKVListByNamespaceRequestHeader;
import org.apache.rocketmq.common.protocol.header.namesrv.GetRouteInfoRequestHeader;
import org.apache.rocketmq.common.protocol.header.namesrv.PutKVConfigRequestHeader;
import org.apache.rocketmq.common.protocol.header.namesrv.WipeWritePermOfBrokerRequestHeader;
import org.apache.rocketmq.common.protocol.header.namesrv.WipeWritePermOfBrokerResponseHeader;
import org.apache.rocketmq.common.protocol.header.namesrv.controller.CleanControllerBrokerDataRequestHeader;
import org.apache.rocketmq.common.protocol.header.namesrv.controller.ElectMasterRequestHeader;
import org.apache.rocketmq.common.protocol.header.namesrv.controller.ElectMasterResponseHeader;
import org.apache.rocketmq.common.protocol.header.namesrv.controller.GetMetaDataResponseHeader;
import org.apache.rocketmq.common.protocol.heartbeat.HeartbeatData;
import org.apache.rocketmq.common.protocol.heartbeat.MessageModel;
import org.apache.rocketmq.common.protocol.heartbeat.SubscriptionData;
import org.apache.rocketmq.common.protocol.route.TopicRouteData;
import org.apache.rocketmq.common.rpchook.DynamicalExtFieldRPCHook;
import org.apache.rocketmq.common.rpchook.StreamTypeRPCHook;
import org.apache.rocketmq.common.statictopic.TopicConfigAndQueueMapping;
import org.apache.rocketmq.common.statictopic.TopicQueueMappingDetail;
import org.apache.rocketmq.common.subscription.GroupForbidden;
import org.apache.rocketmq.common.subscription.SubscriptionGroupConfig;
import org.apache.rocketmq.common.sysflag.PullSysFlag;
import org.apache.rocketmq.logging.InternalLogger;
import org.apache.rocketmq.remoting.CommandCustomHeader;
import org.apache.rocketmq.remoting.InvokeCallback;
import org.apache.rocketmq.remoting.RPCHook;
import org.apache.rocketmq.remoting.RemotingClient;
import org.apache.rocketmq.remoting.common.RemotingHelper;
import org.apache.rocketmq.remoting.exception.RemotingCommandException;
import org.apache.rocketmq.remoting.exception.RemotingConnectException;
import org.apache.rocketmq.remoting.exception.RemotingException;
import org.apache.rocketmq.remoting.exception.RemotingSendRequestException;
import org.apache.rocketmq.remoting.exception.RemotingTimeoutException;
import org.apache.rocketmq.remoting.exception.RemotingTooMuchRequestException;
import org.apache.rocketmq.remoting.netty.NettyClientConfig;
import org.apache.rocketmq.remoting.netty.NettyRemotingClient;
import org.apache.rocketmq.remoting.netty.NettyRequestProcessor;
import org.apache.rocketmq.remoting.netty.ResponseFuture;
import org.apache.rocketmq.remoting.protocol.LanguageCode;
import org.apache.rocketmq.remoting.protocol.RemotingCommand;
import org.apache.rocketmq.remoting.protocol.RemotingSerializable;

public class MQClientAPIImpl
implements NameServerUpdateCallback {
    private static final InternalLogger log = ClientLogger.getLog();
    private static boolean sendSmartMsg = Boolean.parseBoolean(System.getProperty("org.apache.rocketmq.client.sendSmartMsg", "true"));
    private final RemotingClient remotingClient;
    private final TopAddressing topAddressing;
    private final ClientRemotingProcessor clientRemotingProcessor;
    private String nameSrvAddr = null;
    private ClientConfig clientConfig;

    public MQClientAPIImpl(NettyClientConfig nettyClientConfig, ClientRemotingProcessor clientRemotingProcessor, RPCHook rpcHook, ClientConfig clientConfig) {
        this.clientConfig = clientConfig;
        this.topAddressing = new DefaultTopAddressing(MixAll.getWSAddr(), clientConfig.getUnitName());
        this.topAddressing.registerChangeCallBack((NameServerUpdateCallback)this);
        this.remotingClient = new NettyRemotingClient(nettyClientConfig, null);
        this.clientRemotingProcessor = clientRemotingProcessor;
        if (clientConfig.isEnableStreamRequestType()) {
            this.remotingClient.registerRPCHook((RPCHook)new StreamTypeRPCHook());
        }
        this.remotingClient.registerRPCHook(rpcHook);
        this.remotingClient.registerRPCHook((RPCHook)new DynamicalExtFieldRPCHook());
        this.remotingClient.registerProcessor(39, (NettyRequestProcessor)this.clientRemotingProcessor, null);
        this.remotingClient.registerProcessor(40, (NettyRequestProcessor)this.clientRemotingProcessor, null);
        this.remotingClient.registerProcessor(220, (NettyRequestProcessor)this.clientRemotingProcessor, null);
        this.remotingClient.registerProcessor(221, (NettyRequestProcessor)this.clientRemotingProcessor, null);
        this.remotingClient.registerProcessor(307, (NettyRequestProcessor)this.clientRemotingProcessor, null);
        this.remotingClient.registerProcessor(309, (NettyRequestProcessor)this.clientRemotingProcessor, null);
        this.remotingClient.registerProcessor(326, (NettyRequestProcessor)this.clientRemotingProcessor, null);
    }

    public List<String> getNameServerAddressList() {
        return this.remotingClient.getNameServerAddressList();
    }

    public RemotingClient getRemotingClient() {
        return this.remotingClient;
    }

    public String fetchNameServerAddr() {
        try {
            String addrs = this.topAddressing.fetchNSAddr();
            if (!UtilAll.isBlank((String)addrs) && !addrs.equals(this.nameSrvAddr)) {
                log.info("name server address changed, old=" + this.nameSrvAddr + ", new=" + addrs);
                this.updateNameServerAddressList(addrs);
                this.nameSrvAddr = addrs;
                return this.nameSrvAddr;
            }
        }
        catch (Exception e) {
            log.error("fetchNameServerAddr Exception", (Throwable)e);
        }
        return this.nameSrvAddr;
    }

    public String onNameServerAddressChange(String namesrvAddress) {
        if (namesrvAddress != null && !namesrvAddress.equals(this.nameSrvAddr)) {
            log.info("name server address changed, old=" + this.nameSrvAddr + ", new=" + namesrvAddress);
            this.updateNameServerAddressList(namesrvAddress);
            this.nameSrvAddr = namesrvAddress;
            return this.nameSrvAddr;
        }
        return this.nameSrvAddr;
    }

    public void updateNameServerAddressList(String addrs) {
        String[] addrArray = addrs.split(";");
        List<String> list = Arrays.asList(addrArray);
        this.remotingClient.updateNameServerAddressList(list);
    }

    public void start() {
        this.remotingClient.start();
    }

    public void shutdown() {
        this.remotingClient.shutdown();
    }

    public Set<MessageQueueAssignment> queryAssignment(String addr, String topic, String consumerGroup, String clientId, String strategyName, MessageModel messageModel, long timeoutMillis) throws RemotingException, MQBrokerException, InterruptedException {
        QueryAssignmentRequestBody requestBody = new QueryAssignmentRequestBody();
        requestBody.setTopic(topic);
        requestBody.setConsumerGroup(consumerGroup);
        requestBody.setClientId(clientId);
        requestBody.setMessageModel(messageModel);
        requestBody.setStrategyName(strategyName);
        RemotingCommand request = RemotingCommand.createRequestCommand((int)400, null);
        request.setBody(requestBody.encode());
        RemotingCommand response = this.remotingClient.invokeSync(MixAll.brokerVIPChannel((boolean)this.clientConfig.isVipChannelEnabled(), (String)addr), request, timeoutMillis);
        switch (response.getCode()) {
            case 0: {
                QueryAssignmentResponseBody queryAssignmentResponseBody = (QueryAssignmentResponseBody)QueryAssignmentResponseBody.decode((byte[])response.getBody(), QueryAssignmentResponseBody.class);
                return queryAssignmentResponseBody.getMessageQueueAssignments();
            }
        }
        throw new MQBrokerException(response.getCode(), response.getRemark());
    }

    public void createSubscriptionGroup(String addr, SubscriptionGroupConfig config, long timeoutMillis) throws RemotingException, InterruptedException, MQClientException {
        RemotingCommand request = RemotingCommand.createRequestCommand((int)200, null);
        byte[] body = RemotingSerializable.encode((Object)config);
        request.setBody(body);
        RemotingCommand response = this.remotingClient.invokeSync(MixAll.brokerVIPChannel((boolean)this.clientConfig.isVipChannelEnabled(), (String)addr), request, timeoutMillis);
        assert (response != null);
        switch (response.getCode()) {
            case 0: {
                return;
            }
        }
        throw new MQClientException(response.getCode(), response.getRemark());
    }

    public void createTopic(String addr, String defaultTopic, TopicConfig topicConfig, long timeoutMillis) throws RemotingException, MQBrokerException, InterruptedException, MQClientException {
        Validators.checkTopicConfig(topicConfig);
        CreateTopicRequestHeader requestHeader = new CreateTopicRequestHeader();
        requestHeader.setTopic(topicConfig.getTopicName());
        requestHeader.setDefaultTopic(defaultTopic);
        requestHeader.setReadQueueNums(Integer.valueOf(topicConfig.getReadQueueNums()));
        requestHeader.setWriteQueueNums(Integer.valueOf(topicConfig.getWriteQueueNums()));
        requestHeader.setPerm(Integer.valueOf(topicConfig.getPerm()));
        requestHeader.setTopicFilterType(topicConfig.getTopicFilterType().name());
        requestHeader.setTopicSysFlag(Integer.valueOf(topicConfig.getTopicSysFlag()));
        requestHeader.setOrder(Boolean.valueOf(topicConfig.isOrder()));
        requestHeader.setAttributes(AttributeParser.parseToString((Map)topicConfig.getAttributes()));
        RemotingCommand request = RemotingCommand.createRequestCommand((int)17, (CommandCustomHeader)requestHeader);
        RemotingCommand response = this.remotingClient.invokeSync(MixAll.brokerVIPChannel((boolean)this.clientConfig.isVipChannelEnabled(), (String)addr), request, timeoutMillis);
        assert (response != null);
        switch (response.getCode()) {
            case 0: {
                return;
            }
        }
        throw new MQClientException(response.getCode(), response.getRemark());
    }

    public void createPlainAccessConfig(String addr, PlainAccessConfig plainAccessConfig, long timeoutMillis) throws RemotingException, InterruptedException, MQClientException {
        CreateAccessConfigRequestHeader requestHeader = new CreateAccessConfigRequestHeader();
        requestHeader.setAccessKey(plainAccessConfig.getAccessKey());
        requestHeader.setSecretKey(plainAccessConfig.getSecretKey());
        requestHeader.setAdmin(plainAccessConfig.isAdmin());
        requestHeader.setDefaultGroupPerm(plainAccessConfig.getDefaultGroupPerm());
        requestHeader.setDefaultTopicPerm(plainAccessConfig.getDefaultTopicPerm());
        requestHeader.setWhiteRemoteAddress(plainAccessConfig.getWhiteRemoteAddress());
        requestHeader.setTopicPerms(UtilAll.join((List)plainAccessConfig.getTopicPerms(), (String)","));
        requestHeader.setGroupPerms(UtilAll.join((List)plainAccessConfig.getGroupPerms(), (String)","));
        RemotingCommand request = RemotingCommand.createRequestCommand((int)50, (CommandCustomHeader)requestHeader);
        RemotingCommand response = this.remotingClient.invokeSync(MixAll.brokerVIPChannel((boolean)this.clientConfig.isVipChannelEnabled(), (String)addr), request, timeoutMillis);
        assert (response != null);
        switch (response.getCode()) {
            case 0: {
                return;
            }
        }
        throw new MQClientException(response.getCode(), response.getRemark());
    }

    public void deleteAccessConfig(String addr, String accessKey, long timeoutMillis) throws RemotingException, InterruptedException, MQClientException {
        DeleteAccessConfigRequestHeader requestHeader = new DeleteAccessConfigRequestHeader();
        requestHeader.setAccessKey(accessKey);
        RemotingCommand request = RemotingCommand.createRequestCommand((int)51, (CommandCustomHeader)requestHeader);
        RemotingCommand response = this.remotingClient.invokeSync(MixAll.brokerVIPChannel((boolean)this.clientConfig.isVipChannelEnabled(), (String)addr), request, timeoutMillis);
        assert (response != null);
        switch (response.getCode()) {
            case 0: {
                return;
            }
        }
        throw new MQClientException(response.getCode(), response.getRemark());
    }

    public void updateGlobalWhiteAddrsConfig(String addr, String globalWhiteAddrs, String aclFileFullPath, long timeoutMillis) throws RemotingException, MQBrokerException, InterruptedException, MQClientException {
        UpdateGlobalWhiteAddrsConfigRequestHeader requestHeader = new UpdateGlobalWhiteAddrsConfigRequestHeader();
        requestHeader.setGlobalWhiteAddrs(globalWhiteAddrs);
        requestHeader.setAclFileFullPath(aclFileFullPath);
        RemotingCommand request = RemotingCommand.createRequestCommand((int)53, (CommandCustomHeader)requestHeader);
        RemotingCommand response = this.remotingClient.invokeSync(MixAll.brokerVIPChannel((boolean)this.clientConfig.isVipChannelEnabled(), (String)addr), request, timeoutMillis);
        assert (response != null);
        switch (response.getCode()) {
            case 0: {
                return;
            }
        }
        throw new MQClientException(response.getCode(), response.getRemark());
    }

    public ClusterAclVersionInfo getBrokerClusterAclInfo(String addr, long timeoutMillis) throws RemotingCommandException, InterruptedException, RemotingTimeoutException, RemotingSendRequestException, RemotingConnectException, MQBrokerException {
        RemotingCommand request = RemotingCommand.createRequestCommand((int)52, null);
        RemotingCommand response = this.remotingClient.invokeSync(MixAll.brokerVIPChannel((boolean)this.clientConfig.isVipChannelEnabled(), (String)addr), request, timeoutMillis);
        assert (response != null);
        switch (response.getCode()) {
            case 0: {
                GetBrokerAclConfigResponseHeader responseHeader = (GetBrokerAclConfigResponseHeader)response.decodeCommandCustomHeader(GetBrokerAclConfigResponseHeader.class);
                ClusterAclVersionInfo clusterAclVersionInfo = new ClusterAclVersionInfo();
                clusterAclVersionInfo.setClusterName(responseHeader.getClusterName());
                clusterAclVersionInfo.setBrokerName(responseHeader.getBrokerName());
                clusterAclVersionInfo.setBrokerAddr(responseHeader.getBrokerAddr());
                clusterAclVersionInfo.setAclConfigDataVersion((DataVersion)DataVersion.fromJson((String)responseHeader.getVersion(), DataVersion.class));
                HashMap dataVersionMap = (HashMap)JSON.parseObject((String)responseHeader.getAllAclFileVersion(), HashMap.class);
                HashMap allAclConfigDataVersion = new HashMap(dataVersionMap.size(), 1.0f);
                for (Map.Entry entry : dataVersionMap.entrySet()) {
                    allAclConfigDataVersion.put(entry.getKey(), DataVersion.fromJson((String)JSON.toJSONString(entry.getValue()), DataVersion.class));
                }
                clusterAclVersionInfo.setAllAclConfigDataVersion(allAclConfigDataVersion);
                return clusterAclVersionInfo;
            }
        }
        throw new MQBrokerException(response.getCode(), response.getRemark(), addr);
    }

    public AclConfig getBrokerClusterConfig(String addr, long timeoutMillis) throws InterruptedException, RemotingTimeoutException, RemotingSendRequestException, RemotingConnectException, MQBrokerException {
        RemotingCommand request = RemotingCommand.createRequestCommand((int)54, null);
        RemotingCommand response = this.remotingClient.invokeSync(MixAll.brokerVIPChannel((boolean)this.clientConfig.isVipChannelEnabled(), (String)addr), request, timeoutMillis);
        assert (response != null);
        switch (response.getCode()) {
            case 0: {
                if (response.getBody() == null) break;
                GetBrokerClusterAclConfigResponseBody body = (GetBrokerClusterAclConfigResponseBody)GetBrokerClusterAclConfigResponseBody.decode((byte[])response.getBody(), GetBrokerClusterAclConfigResponseBody.class);
                AclConfig aclConfig = new AclConfig();
                aclConfig.setGlobalWhiteAddrs(body.getGlobalWhiteAddrs());
                aclConfig.setPlainAccessConfigs(body.getPlainAccessConfigs());
                return aclConfig;
            }
        }
        throw new MQBrokerException(response.getCode(), response.getRemark(), addr);
    }

    public SendResult sendMessage(String addr, String brokerName, Message msg, SendMessageRequestHeader requestHeader, long timeoutMillis, CommunicationMode communicationMode, SendMessageContext context, DefaultMQProducerImpl producer) throws RemotingException, MQBrokerException, InterruptedException {
        return this.sendMessage(addr, brokerName, msg, requestHeader, timeoutMillis, communicationMode, null, null, null, 0, context, producer);
    }

    public SendResult sendMessage(String addr, String brokerName, Message msg, SendMessageRequestHeader requestHeader, long timeoutMillis, CommunicationMode communicationMode, SendCallback sendCallback, TopicPublishInfo topicPublishInfo, MQClientInstance instance, int retryTimesWhenSendFailed, SendMessageContext context, DefaultMQProducerImpl producer) throws RemotingException, MQBrokerException, InterruptedException {
        SendMessageRequestHeaderV2 requestHeaderV2;
        boolean isReply;
        long beginStartTime = System.currentTimeMillis();
        RemotingCommand request = null;
        String msgType = msg.getProperty("MSG_TYPE");
        boolean bl = isReply = msgType != null && msgType.equals("reply");
        if (isReply) {
            if (sendSmartMsg) {
                requestHeaderV2 = SendMessageRequestHeaderV2.createSendMessageRequestHeaderV2((SendMessageRequestHeader)requestHeader);
                request = RemotingCommand.createRequestCommand((int)325, (CommandCustomHeader)requestHeaderV2);
            } else {
                request = RemotingCommand.createRequestCommand((int)324, (CommandCustomHeader)requestHeader);
            }
        } else if (sendSmartMsg || msg instanceof MessageBatch) {
            requestHeaderV2 = SendMessageRequestHeaderV2.createSendMessageRequestHeaderV2((SendMessageRequestHeader)requestHeader);
            request = RemotingCommand.createRequestCommand((int)(msg instanceof MessageBatch ? 320 : 310), (CommandCustomHeader)requestHeaderV2);
        } else {
            request = RemotingCommand.createRequestCommand((int)10, (CommandCustomHeader)requestHeader);
        }
        request.setBody(msg.getBody());
        switch (communicationMode) {
            case ONEWAY: {
                this.remotingClient.invokeOneway(addr, request, timeoutMillis);
                return null;
            }
            case ASYNC: {
                AtomicInteger times = new AtomicInteger();
                long costTimeAsync = System.currentTimeMillis() - beginStartTime;
                if (timeoutMillis < costTimeAsync) {
                    throw new RemotingTooMuchRequestException("sendMessage call timeout");
                }
                this.sendMessageAsync(addr, brokerName, msg, timeoutMillis - costTimeAsync, request, sendCallback, topicPublishInfo, instance, retryTimesWhenSendFailed, times, context, producer);
                return null;
            }
            case SYNC: {
                long costTimeSync = System.currentTimeMillis() - beginStartTime;
                if (timeoutMillis < costTimeSync) {
                    throw new RemotingTooMuchRequestException("sendMessage call timeout");
                }
                return this.sendMessageSync(addr, brokerName, msg, timeoutMillis - costTimeSync, request);
            }
        }
        assert (false);
        return null;
    }

    private SendResult sendMessageSync(String addr, String brokerName, Message msg, long timeoutMillis, RemotingCommand request) throws RemotingException, MQBrokerException, InterruptedException {
        RemotingCommand response = this.remotingClient.invokeSync(addr, request, timeoutMillis);
        assert (response != null);
        return this.processSendResponse(brokerName, msg, response, addr);
    }

    void execRpcHooksAfterRequest(ResponseFuture responseFuture) {
        if (this.remotingClient instanceof NettyRemotingClient) {
            NettyRemotingClient remotingClient = (NettyRemotingClient)this.remotingClient;
            RemotingCommand response = responseFuture.getResponseCommand();
            remotingClient.doAfterRpcHooks(RemotingHelper.parseChannelRemoteAddr((Channel)responseFuture.getChannel()), responseFuture.getRequestCommand(), response);
        }
    }

    private void sendMessageAsync(final String addr, final String brokerName, final Message msg, final long timeoutMillis, final RemotingCommand request, final SendCallback sendCallback, final TopicPublishInfo topicPublishInfo, final MQClientInstance instance, final int retryTimesWhenSendFailed, final AtomicInteger times, final SendMessageContext context, final DefaultMQProducerImpl producer) {
        final long beginStartTime = System.currentTimeMillis();
        try {
            this.remotingClient.invokeAsync(addr, request, timeoutMillis, new InvokeCallback(){

                public void operationComplete(ResponseFuture responseFuture) {
                    long cost = System.currentTimeMillis() - beginStartTime;
                    RemotingCommand response = responseFuture.getResponseCommand();
                    if (null == sendCallback && response != null) {
                        try {
                            SendResult sendResult = MQClientAPIImpl.this.processSendResponse(brokerName, msg, response, addr);
                            if (context != null && sendResult != null) {
                                context.setSendResult(sendResult);
                                context.getProducer().executeSendMessageHookAfter(context);
                            }
                        }
                        catch (Throwable sendResult) {
                            // empty catch block
                        }
                        producer.updateFaultItem(brokerName, System.currentTimeMillis() - responseFuture.getBeginTimestamp(), false);
                        return;
                    }
                    if (response != null) {
                        try {
                            SendResult sendResult = MQClientAPIImpl.this.processSendResponse(brokerName, msg, response, addr);
                            assert (sendResult != null);
                            if (context != null) {
                                context.setSendResult(sendResult);
                                context.getProducer().executeSendMessageHookAfter(context);
                            }
                            try {
                                sendCallback.onSuccess(sendResult);
                            }
                            catch (Throwable throwable) {
                                // empty catch block
                            }
                            producer.updateFaultItem(brokerName, System.currentTimeMillis() - responseFuture.getBeginTimestamp(), false);
                        }
                        catch (Exception e) {
                            producer.updateFaultItem(brokerName, System.currentTimeMillis() - responseFuture.getBeginTimestamp(), true);
                            MQClientAPIImpl.this.onExceptionImpl(brokerName, msg, timeoutMillis - cost, request, sendCallback, topicPublishInfo, instance, retryTimesWhenSendFailed, times, e, context, false, producer);
                        }
                    } else {
                        producer.updateFaultItem(brokerName, System.currentTimeMillis() - responseFuture.getBeginTimestamp(), true);
                        if (!responseFuture.isSendRequestOK()) {
                            MQClientException ex = new MQClientException("send request failed", responseFuture.getCause());
                            MQClientAPIImpl.this.onExceptionImpl(brokerName, msg, timeoutMillis - cost, request, sendCallback, topicPublishInfo, instance, retryTimesWhenSendFailed, times, ex, context, true, producer);
                        } else if (responseFuture.isTimeout()) {
                            MQClientException ex = new MQClientException("wait response timeout " + responseFuture.getTimeoutMillis() + "ms", responseFuture.getCause());
                            MQClientAPIImpl.this.onExceptionImpl(brokerName, msg, timeoutMillis - cost, request, sendCallback, topicPublishInfo, instance, retryTimesWhenSendFailed, times, ex, context, true, producer);
                        } else {
                            MQClientException ex = new MQClientException("unknow reseaon", responseFuture.getCause());
                            MQClientAPIImpl.this.onExceptionImpl(brokerName, msg, timeoutMillis - cost, request, sendCallback, topicPublishInfo, instance, retryTimesWhenSendFailed, times, ex, context, true, producer);
                        }
                    }
                }
            });
        }
        catch (Exception ex) {
            long cost = System.currentTimeMillis() - beginStartTime;
            producer.updateFaultItem(brokerName, cost, true);
            this.onExceptionImpl(brokerName, msg, timeoutMillis - cost, request, sendCallback, topicPublishInfo, instance, retryTimesWhenSendFailed, times, ex, context, true, producer);
        }
    }

    private void onExceptionImpl(String brokerName, Message msg, long timeoutMillis, RemotingCommand request, SendCallback sendCallback, TopicPublishInfo topicPublishInfo, MQClientInstance instance, int timesTotal, AtomicInteger curTimes, Exception e, SendMessageContext context, boolean needRetry, DefaultMQProducerImpl producer) {
        int tmp = curTimes.incrementAndGet();
        if (needRetry && tmp <= timesTotal) {
            String retryBrokerName = brokerName;
            if (topicPublishInfo != null) {
                MessageQueue mqChosen = producer.selectOneMessageQueue(topicPublishInfo, brokerName);
                retryBrokerName = instance.getBrokerNameFromMessageQueue(mqChosen);
            }
            String addr = instance.findBrokerAddressInPublish(retryBrokerName);
            log.warn("async send msg by retry {} times. topic={}, brokerAddr={}, brokerName={}", new Object[]{tmp, msg.getTopic(), addr, retryBrokerName, e});
            request.setOpaque(RemotingCommand.createNewRequestId());
            this.sendMessageAsync(addr, retryBrokerName, msg, timeoutMillis, request, sendCallback, topicPublishInfo, instance, timesTotal, curTimes, context, producer);
        } else {
            if (context != null) {
                context.setException(e);
                context.getProducer().executeSendMessageHookAfter(context);
            }
            try {
                sendCallback.onException(e);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    protected SendResult processSendResponse(String brokerName, Message msg, RemotingCommand response, String addr) throws MQBrokerException, RemotingCommandException {
        SendStatus sendStatus;
        switch (response.getCode()) {
            case 10: {
                sendStatus = SendStatus.FLUSH_DISK_TIMEOUT;
                break;
            }
            case 12: {
                sendStatus = SendStatus.FLUSH_SLAVE_TIMEOUT;
                break;
            }
            case 11: {
                sendStatus = SendStatus.SLAVE_NOT_AVAILABLE;
                break;
            }
            case 0: {
                sendStatus = SendStatus.SEND_OK;
                break;
            }
            default: {
                throw new MQBrokerException(response.getCode(), response.getRemark(), addr);
            }
        }
        SendMessageResponseHeader responseHeader = (SendMessageResponseHeader)response.decodeCommandCustomHeader(SendMessageResponseHeader.class);
        String topic = msg.getTopic();
        if (StringUtils.isNotEmpty((CharSequence)this.clientConfig.getNamespace())) {
            topic = NamespaceUtil.withoutNamespace((String)topic, (String)this.clientConfig.getNamespace());
        }
        MessageQueue messageQueue = new MessageQueue(topic, brokerName, responseHeader.getQueueId().intValue());
        String uniqMsgId = MessageClientIDSetter.getUniqID((Message)msg);
        if (msg instanceof MessageBatch && responseHeader.getBatchUniqId() == null) {
            StringBuilder sb = new StringBuilder();
            for (Message message : (MessageBatch)msg) {
                sb.append(sb.length() == 0 ? "" : ",").append(MessageClientIDSetter.getUniqID((Message)message));
            }
            uniqMsgId = sb.toString();
        }
        SendResult sendResult = new SendResult(sendStatus, uniqMsgId, responseHeader.getMsgId(), messageQueue, responseHeader.getQueueOffset());
        sendResult.setTransactionId(responseHeader.getTransactionId());
        String regionId = (String)response.getExtFields().get("MSG_REGION");
        String traceOn = (String)response.getExtFields().get("TRACE_ON");
        if (regionId == null || regionId.isEmpty()) {
            regionId = "DefaultRegion";
        }
        if (traceOn != null && traceOn.equals("false")) {
            sendResult.setTraceOn(false);
        } else {
            sendResult.setTraceOn(true);
        }
        sendResult.setRegionId(regionId);
        return sendResult;
    }

    public PullResult pullMessage(String addr, PullMessageRequestHeader requestHeader, long timeoutMillis, CommunicationMode communicationMode, PullCallback pullCallback) throws RemotingException, MQBrokerException, InterruptedException {
        RemotingCommand request = PullSysFlag.hasLitePullFlag((int)requestHeader.getSysFlag()) ? RemotingCommand.createRequestCommand((int)361, (CommandCustomHeader)requestHeader) : RemotingCommand.createRequestCommand((int)11, (CommandCustomHeader)requestHeader);
        switch (communicationMode) {
            case ONEWAY: {
                assert (false);
                return null;
            }
            case ASYNC: {
                this.pullMessageAsync(addr, request, timeoutMillis, pullCallback);
                return null;
            }
            case SYNC: {
                return this.pullMessageSync(addr, request, timeoutMillis);
            }
        }
        assert (false);
        return null;
    }

    public void popMessageAsync(final String brokerName, final String addr, final PopMessageRequestHeader requestHeader, final long timeoutMillis, final PopCallback popCallback) throws RemotingException, InterruptedException {
        final RemotingCommand request = RemotingCommand.createRequestCommand((int)200050, (CommandCustomHeader)requestHeader);
        this.remotingClient.invokeAsync(addr, request, timeoutMillis, (InvokeCallback)new BaseInvokeCallback(this){

            @Override
            public void onComplete(ResponseFuture responseFuture) {
                RemotingCommand response = responseFuture.getResponseCommand();
                if (response != null) {
                    try {
                        PopResult popResult = MQClientAPIImpl.this.processPopResponse(brokerName, response, requestHeader.getTopic(), (CommandCustomHeader)requestHeader);
                        assert (popResult != null);
                        popCallback.onSuccess(popResult);
                    }
                    catch (Exception e) {
                        popCallback.onException(e);
                    }
                } else if (!responseFuture.isSendRequestOK()) {
                    popCallback.onException(new MQClientException(10001, "send request failed to " + addr + ". Request: " + request, responseFuture.getCause()));
                } else if (responseFuture.isTimeout()) {
                    popCallback.onException(new MQClientException(10002, "wait response from " + addr + " timeout :" + responseFuture.getTimeoutMillis() + "ms. Request: " + request, responseFuture.getCause()));
                } else {
                    popCallback.onException(new MQClientException("unknown reason. addr: " + addr + ", timeoutMillis: " + timeoutMillis + ". Request: " + request, responseFuture.getCause()));
                }
            }
        });
    }

    public void ackMessageAsync(final String addr, final long timeOut, final AckCallback ackCallback, AckMessageRequestHeader requestHeader) throws RemotingException, MQBrokerException, InterruptedException {
        final RemotingCommand request = RemotingCommand.createRequestCommand((int)200051, (CommandCustomHeader)requestHeader);
        this.remotingClient.invokeAsync(addr, request, timeOut, (InvokeCallback)new BaseInvokeCallback(this){

            @Override
            public void onComplete(ResponseFuture responseFuture) {
                RemotingCommand response = responseFuture.getResponseCommand();
                if (response != null) {
                    try {
                        AckResult ackResult = new AckResult();
                        if (0 == response.getCode()) {
                            ackResult.setStatus(AckStatus.OK);
                        } else {
                            ackResult.setStatus(AckStatus.NO_EXIST);
                        }
                        assert (ackResult != null);
                        ackCallback.onSuccess(ackResult);
                    }
                    catch (Exception e) {
                        ackCallback.onException(e);
                    }
                } else if (!responseFuture.isSendRequestOK()) {
                    ackCallback.onException(new MQClientException(10001, "send request failed to " + addr + ". Request: " + request, responseFuture.getCause()));
                } else if (responseFuture.isTimeout()) {
                    ackCallback.onException(new MQClientException(10002, "wait response from " + addr + " timeout :" + responseFuture.getTimeoutMillis() + "ms. Request: " + request, responseFuture.getCause()));
                } else {
                    ackCallback.onException(new MQClientException("unknown reason. addr: " + addr + ", timeoutMillis: " + timeOut + ". Request: " + request, responseFuture.getCause()));
                }
            }
        });
    }

    public void changeInvisibleTimeAsync(final String brokerName, final String addr, final ChangeInvisibleTimeRequestHeader requestHeader, final long timeoutMillis, final AckCallback ackCallback) throws RemotingException, MQBrokerException, InterruptedException {
        final RemotingCommand request = RemotingCommand.createRequestCommand((int)200053, (CommandCustomHeader)requestHeader);
        this.remotingClient.invokeAsync(addr, request, timeoutMillis, (InvokeCallback)new BaseInvokeCallback(this){

            @Override
            public void onComplete(ResponseFuture responseFuture) {
                RemotingCommand response = responseFuture.getResponseCommand();
                if (response != null) {
                    try {
                        ChangeInvisibleTimeResponseHeader responseHeader = (ChangeInvisibleTimeResponseHeader)response.decodeCommandCustomHeader(ChangeInvisibleTimeResponseHeader.class);
                        AckResult ackResult = new AckResult();
                        if (0 == response.getCode()) {
                            ackResult.setStatus(AckStatus.OK);
                            ackResult.setPopTime(responseHeader.getPopTime());
                            ackResult.setExtraInfo(ExtraInfoUtil.buildExtraInfo((long)requestHeader.getOffset(), (long)responseHeader.getPopTime(), (long)responseHeader.getInvisibleTime(), (int)responseHeader.getReviveQid(), (String)requestHeader.getTopic(), (String)brokerName, (int)requestHeader.getQueueId()) + " " + requestHeader.getOffset());
                        } else {
                            ackResult.setStatus(AckStatus.NO_EXIST);
                        }
                        assert (ackResult != null);
                        ackCallback.onSuccess(ackResult);
                    }
                    catch (Exception e) {
                        ackCallback.onException(e);
                    }
                } else if (!responseFuture.isSendRequestOK()) {
                    ackCallback.onException(new MQClientException(10001, "send request failed to " + addr + ". Request: " + request, responseFuture.getCause()));
                } else if (responseFuture.isTimeout()) {
                    ackCallback.onException(new MQClientException(10002, "wait response from " + addr + " timeout :" + responseFuture.getTimeoutMillis() + "ms. Request: " + request, responseFuture.getCause()));
                } else {
                    ackCallback.onException(new MQClientException("unknown reason. addr: " + addr + ", timeoutMillis: " + timeoutMillis + ". Request: " + request, responseFuture.getCause()));
                }
            }
        });
    }

    private void pullMessageAsync(final String addr, final RemotingCommand request, final long timeoutMillis, final PullCallback pullCallback) throws RemotingException, InterruptedException {
        this.remotingClient.invokeAsync(addr, request, timeoutMillis, new InvokeCallback(){

            public void operationComplete(ResponseFuture responseFuture) {
                RemotingCommand response = responseFuture.getResponseCommand();
                if (response != null) {
                    try {
                        PullResult pullResult = MQClientAPIImpl.this.processPullResponse(response, addr);
                        assert (pullResult != null);
                        pullCallback.onSuccess(pullResult);
                    }
                    catch (Exception e) {
                        pullCallback.onException(e);
                    }
                } else if (!responseFuture.isSendRequestOK()) {
                    pullCallback.onException(new MQClientException(10001, "send request failed to " + addr + ". Request: " + request, responseFuture.getCause()));
                } else if (responseFuture.isTimeout()) {
                    pullCallback.onException(new MQClientException(10002, "wait response from " + addr + " timeout :" + responseFuture.getTimeoutMillis() + "ms. Request: " + request, responseFuture.getCause()));
                } else {
                    pullCallback.onException(new MQClientException("unknown reason. addr: " + addr + ", timeoutMillis: " + timeoutMillis + ". Request: " + request, responseFuture.getCause()));
                }
            }
        });
    }

    private PullResult pullMessageSync(String addr, RemotingCommand request, long timeoutMillis) throws RemotingException, InterruptedException, MQBrokerException {
        RemotingCommand response = this.remotingClient.invokeSync(addr, request, timeoutMillis);
        assert (response != null);
        return this.processPullResponse(response, addr);
    }

    private PullResult processPullResponse(RemotingCommand response, String addr) throws MQBrokerException, RemotingCommandException {
        PullStatus pullStatus = PullStatus.NO_NEW_MSG;
        switch (response.getCode()) {
            case 0: {
                pullStatus = PullStatus.FOUND;
                break;
            }
            case 19: {
                pullStatus = PullStatus.NO_NEW_MSG;
                break;
            }
            case 20: {
                pullStatus = PullStatus.NO_MATCHED_MSG;
                break;
            }
            case 21: {
                pullStatus = PullStatus.OFFSET_ILLEGAL;
                break;
            }
            default: {
                throw new MQBrokerException(response.getCode(), response.getRemark(), addr);
            }
        }
        PullMessageResponseHeader responseHeader = (PullMessageResponseHeader)response.decodeCommandCustomHeader(PullMessageResponseHeader.class);
        return new PullResultExt(pullStatus, responseHeader.getNextBeginOffset(), responseHeader.getMinOffset(), responseHeader.getMaxOffset(), null, responseHeader.getSuggestWhichBrokerId(), response.getBody(), responseHeader.getOffsetDelta());
    }

    private PopResult processPopResponse(String brokerName, RemotingCommand response, String topic, CommandCustomHeader requestHeader) throws MQBrokerException, RemotingCommandException {
        PopStatus popStatus = PopStatus.NO_NEW_MSG;
        List msgFoundList = null;
        switch (response.getCode()) {
            case 0: {
                popStatus = PopStatus.FOUND;
                ByteBuffer byteBuffer = ByteBuffer.wrap(response.getBody());
                msgFoundList = MessageDecoder.decodesBatch((ByteBuffer)byteBuffer, (boolean)this.clientConfig.isDecodeReadBody(), (boolean)this.clientConfig.isDecodeDecompressBody(), (boolean)true);
                break;
            }
            case 209: {
                popStatus = PopStatus.POLLING_FULL;
                break;
            }
            case 210: {
                popStatus = PopStatus.POLLING_NOT_FOUND;
                break;
            }
            case 19: {
                popStatus = PopStatus.POLLING_NOT_FOUND;
                break;
            }
            default: {
                throw new MQBrokerException(response.getCode(), response.getRemark());
            }
        }
        PopResult popResult = new PopResult(popStatus, msgFoundList);
        PopMessageResponseHeader responseHeader = (PopMessageResponseHeader)response.decodeCommandCustomHeader(PopMessageResponseHeader.class);
        popResult.setRestNum(responseHeader.getRestNum());
        if (popStatus == PopStatus.FOUND) {
            Map startOffsetInfo = null;
            Map msgOffsetInfo = null;
            Map orderCountInfo = null;
            if (requestHeader instanceof PopMessageRequestHeader) {
                popResult.setInvisibleTime(responseHeader.getInvisibleTime());
                popResult.setPopTime(responseHeader.getPopTime());
                startOffsetInfo = ExtraInfoUtil.parseStartOffsetInfo((String)responseHeader.getStartOffsetInfo());
                msgOffsetInfo = ExtraInfoUtil.parseMsgOffsetInfo((String)responseHeader.getMsgOffsetInfo());
                orderCountInfo = ExtraInfoUtil.parseOrderCountInfo((String)responseHeader.getOrderCountInfo());
            }
            HashMap sortMap = new HashMap(16);
            for (MessageExt messageExt : msgFoundList) {
                String key = ExtraInfoUtil.getStartOffsetInfoMapKey((String)messageExt.getTopic(), (int)messageExt.getQueueId());
                if (!sortMap.containsKey(key)) {
                    sortMap.put(key, new ArrayList(4));
                }
                ((List)sortMap.get(key)).add(messageExt.getQueueOffset());
            }
            HashMap<String, String> map = new HashMap<String, String>(5);
            for (MessageExt messageExt : msgFoundList) {
                if (requestHeader instanceof PopMessageRequestHeader) {
                    String key;
                    if (startOffsetInfo == null) {
                        key = messageExt.getTopic() + messageExt.getQueueId();
                        if (!map.containsKey(messageExt.getTopic() + messageExt.getQueueId())) {
                            map.put(key, ExtraInfoUtil.buildExtraInfo((long)messageExt.getQueueOffset(), (long)responseHeader.getPopTime(), (long)responseHeader.getInvisibleTime(), (int)responseHeader.getReviveQid(), (String)messageExt.getTopic(), (String)brokerName, (int)messageExt.getQueueId()));
                        }
                        messageExt.getProperties().put("POP_CK", (String)map.get(key) + " " + messageExt.getQueueOffset());
                    } else {
                        Integer count;
                        key = ExtraInfoUtil.getStartOffsetInfoMapKey((String)messageExt.getTopic(), (int)messageExt.getQueueId());
                        int index = ((List)sortMap.get(key)).indexOf(messageExt.getQueueOffset());
                        Long msgQueueOffset = (Long)((List)msgOffsetInfo.get(key)).get(index);
                        if (msgQueueOffset.longValue() != messageExt.getQueueOffset()) {
                            log.warn("Queue offset[%d] of msg is strange, not equal to the stored in msg, %s", (Object)msgQueueOffset, (Object)messageExt);
                        }
                        messageExt.getProperties().put("POP_CK", ExtraInfoUtil.buildExtraInfo((long)((Long)startOffsetInfo.get(key)), (long)responseHeader.getPopTime(), (long)responseHeader.getInvisibleTime(), (int)responseHeader.getReviveQid(), (String)messageExt.getTopic(), (String)brokerName, (int)messageExt.getQueueId(), (long)msgQueueOffset));
                        if (((PopMessageRequestHeader)requestHeader).isOrder() && orderCountInfo != null && (count = (Integer)orderCountInfo.get(key)) != null && count > 0) {
                            messageExt.setReconsumeTimes(count.intValue());
                        }
                    }
                    if (messageExt.getProperties().get("1ST_POP_TIME") == null) {
                        messageExt.getProperties().put("1ST_POP_TIME", String.valueOf(responseHeader.getPopTime()));
                    }
                }
                messageExt.setBrokerName(brokerName);
                messageExt.setTopic(NamespaceUtil.withoutNamespace((String)topic, (String)this.clientConfig.getNamespace()));
            }
        }
        return popResult;
    }

    public MessageExt viewMessage(String addr, long phyoffset, long timeoutMillis) throws RemotingException, MQBrokerException, InterruptedException {
        ViewMessageRequestHeader requestHeader = new ViewMessageRequestHeader();
        requestHeader.setOffset(Long.valueOf(phyoffset));
        RemotingCommand request = RemotingCommand.createRequestCommand((int)33, (CommandCustomHeader)requestHeader);
        RemotingCommand response = this.remotingClient.invokeSync(MixAll.brokerVIPChannel((boolean)this.clientConfig.isVipChannelEnabled(), (String)addr), request, timeoutMillis);
        assert (response != null);
        switch (response.getCode()) {
            case 0: {
                ByteBuffer byteBuffer = ByteBuffer.wrap(response.getBody());
                MessageExt messageExt = MessageDecoder.clientDecode((ByteBuffer)byteBuffer, (boolean)true);
                if (StringUtils.isNotEmpty((CharSequence)this.clientConfig.getNamespace())) {
                    messageExt.setTopic(NamespaceUtil.withoutNamespace((String)messageExt.getTopic(), (String)this.clientConfig.getNamespace()));
                }
                return messageExt;
            }
        }
        throw new MQBrokerException(response.getCode(), response.getRemark(), addr);
    }

    @Deprecated
    public long searchOffset(String addr, String topic, int queueId, long timestamp, long timeoutMillis) throws RemotingException, MQBrokerException, InterruptedException {
        SearchOffsetRequestHeader requestHeader = new SearchOffsetRequestHeader();
        requestHeader.setTopic(topic);
        requestHeader.setQueueId(Integer.valueOf(queueId));
        requestHeader.setTimestamp(Long.valueOf(timestamp));
        RemotingCommand request = RemotingCommand.createRequestCommand((int)29, (CommandCustomHeader)requestHeader);
        RemotingCommand response = this.remotingClient.invokeSync(MixAll.brokerVIPChannel((boolean)this.clientConfig.isVipChannelEnabled(), (String)addr), request, timeoutMillis);
        assert (response != null);
        switch (response.getCode()) {
            case 0: {
                SearchOffsetResponseHeader responseHeader = (SearchOffsetResponseHeader)response.decodeCommandCustomHeader(SearchOffsetResponseHeader.class);
                return responseHeader.getOffset();
            }
        }
        throw new MQBrokerException(response.getCode(), response.getRemark(), addr);
    }

    public long searchOffset(String addr, MessageQueue messageQueue, long timestamp, long timeoutMillis) throws RemotingException, MQBrokerException, InterruptedException {
        SearchOffsetRequestHeader requestHeader = new SearchOffsetRequestHeader();
        requestHeader.setTopic(messageQueue.getTopic());
        requestHeader.setQueueId(Integer.valueOf(messageQueue.getQueueId()));
        requestHeader.setBname(messageQueue.getBrokerName());
        requestHeader.setTimestamp(Long.valueOf(timestamp));
        RemotingCommand request = RemotingCommand.createRequestCommand((int)29, (CommandCustomHeader)requestHeader);
        RemotingCommand response = this.remotingClient.invokeSync(MixAll.brokerVIPChannel((boolean)this.clientConfig.isVipChannelEnabled(), (String)addr), request, timeoutMillis);
        assert (response != null);
        switch (response.getCode()) {
            case 0: {
                SearchOffsetResponseHeader responseHeader = (SearchOffsetResponseHeader)response.decodeCommandCustomHeader(SearchOffsetResponseHeader.class);
                return responseHeader.getOffset();
            }
        }
        throw new MQBrokerException(response.getCode(), response.getRemark(), addr);
    }

    public long getMaxOffset(String addr, MessageQueue messageQueue, long timeoutMillis) throws RemotingException, MQBrokerException, InterruptedException {
        GetMaxOffsetRequestHeader requestHeader = new GetMaxOffsetRequestHeader();
        requestHeader.setTopic(messageQueue.getTopic());
        requestHeader.setQueueId(Integer.valueOf(messageQueue.getQueueId()));
        requestHeader.setBname(messageQueue.getBrokerName());
        RemotingCommand request = RemotingCommand.createRequestCommand((int)30, (CommandCustomHeader)requestHeader);
        RemotingCommand response = this.remotingClient.invokeSync(MixAll.brokerVIPChannel((boolean)this.clientConfig.isVipChannelEnabled(), (String)addr), request, timeoutMillis);
        assert (response != null);
        switch (response.getCode()) {
            case 0: {
                GetMaxOffsetResponseHeader responseHeader = (GetMaxOffsetResponseHeader)response.decodeCommandCustomHeader(GetMaxOffsetResponseHeader.class);
                return responseHeader.getOffset();
            }
        }
        throw new MQBrokerException(response.getCode(), response.getRemark(), addr);
    }

    public List<String> getConsumerIdListByGroup(String addr, String consumerGroup, long timeoutMillis) throws RemotingConnectException, RemotingSendRequestException, RemotingTimeoutException, MQBrokerException, InterruptedException {
        GetConsumerListByGroupRequestHeader requestHeader = new GetConsumerListByGroupRequestHeader();
        requestHeader.setConsumerGroup(consumerGroup);
        RemotingCommand request = RemotingCommand.createRequestCommand((int)38, (CommandCustomHeader)requestHeader);
        RemotingCommand response = this.remotingClient.invokeSync(MixAll.brokerVIPChannel((boolean)this.clientConfig.isVipChannelEnabled(), (String)addr), request, timeoutMillis);
        assert (response != null);
        switch (response.getCode()) {
            case 0: {
                if (response.getBody() == null) break;
                GetConsumerListByGroupResponseBody body = (GetConsumerListByGroupResponseBody)GetConsumerListByGroupResponseBody.decode((byte[])response.getBody(), GetConsumerListByGroupResponseBody.class);
                return body.getConsumerIdList();
            }
        }
        throw new MQBrokerException(response.getCode(), response.getRemark(), addr);
    }

    public long getMinOffset(String addr, MessageQueue messageQueue, long timeoutMillis) throws RemotingException, MQBrokerException, InterruptedException {
        GetMinOffsetRequestHeader requestHeader = new GetMinOffsetRequestHeader();
        requestHeader.setTopic(messageQueue.getTopic());
        requestHeader.setQueueId(Integer.valueOf(messageQueue.getQueueId()));
        requestHeader.setBname(messageQueue.getBrokerName());
        RemotingCommand request = RemotingCommand.createRequestCommand((int)31, (CommandCustomHeader)requestHeader);
        RemotingCommand response = this.remotingClient.invokeSync(MixAll.brokerVIPChannel((boolean)this.clientConfig.isVipChannelEnabled(), (String)addr), request, timeoutMillis);
        assert (response != null);
        switch (response.getCode()) {
            case 0: {
                GetMinOffsetResponseHeader responseHeader = (GetMinOffsetResponseHeader)response.decodeCommandCustomHeader(GetMinOffsetResponseHeader.class);
                return responseHeader.getOffset();
            }
        }
        throw new MQBrokerException(response.getCode(), response.getRemark(), addr);
    }

    public long getEarliestMsgStoretime(String addr, MessageQueue mq, long timeoutMillis) throws RemotingException, MQBrokerException, InterruptedException {
        GetEarliestMsgStoretimeRequestHeader requestHeader = new GetEarliestMsgStoretimeRequestHeader();
        requestHeader.setTopic(mq.getTopic());
        requestHeader.setQueueId(Integer.valueOf(mq.getQueueId()));
        requestHeader.setBname(mq.getBrokerName());
        RemotingCommand request = RemotingCommand.createRequestCommand((int)32, (CommandCustomHeader)requestHeader);
        RemotingCommand response = this.remotingClient.invokeSync(MixAll.brokerVIPChannel((boolean)this.clientConfig.isVipChannelEnabled(), (String)addr), request, timeoutMillis);
        assert (response != null);
        switch (response.getCode()) {
            case 0: {
                GetEarliestMsgStoretimeResponseHeader responseHeader = (GetEarliestMsgStoretimeResponseHeader)response.decodeCommandCustomHeader(GetEarliestMsgStoretimeResponseHeader.class);
                return responseHeader.getTimestamp();
            }
        }
        throw new MQBrokerException(response.getCode(), response.getRemark(), addr);
    }

    public long queryConsumerOffset(String addr, QueryConsumerOffsetRequestHeader requestHeader, long timeoutMillis) throws RemotingException, MQBrokerException, InterruptedException {
        RemotingCommand request = RemotingCommand.createRequestCommand((int)14, (CommandCustomHeader)requestHeader);
        RemotingCommand response = this.remotingClient.invokeSync(MixAll.brokerVIPChannel((boolean)this.clientConfig.isVipChannelEnabled(), (String)addr), request, timeoutMillis);
        assert (response != null);
        switch (response.getCode()) {
            case 0: {
                QueryConsumerOffsetResponseHeader responseHeader = (QueryConsumerOffsetResponseHeader)response.decodeCommandCustomHeader(QueryConsumerOffsetResponseHeader.class);
                return responseHeader.getOffset();
            }
            case 22: {
                throw new OffsetNotFoundException(response.getCode(), response.getRemark(), addr);
            }
        }
        throw new MQBrokerException(response.getCode(), response.getRemark(), addr);
    }

    public void updateConsumerOffset(String addr, UpdateConsumerOffsetRequestHeader requestHeader, long timeoutMillis) throws RemotingException, MQBrokerException, InterruptedException {
        RemotingCommand request = RemotingCommand.createRequestCommand((int)15, (CommandCustomHeader)requestHeader);
        RemotingCommand response = this.remotingClient.invokeSync(MixAll.brokerVIPChannel((boolean)this.clientConfig.isVipChannelEnabled(), (String)addr), request, timeoutMillis);
        assert (response != null);
        switch (response.getCode()) {
            case 0: {
                return;
            }
        }
        throw new MQBrokerException(response.getCode(), response.getRemark(), addr);
    }

    public void updateConsumerOffsetOneway(String addr, UpdateConsumerOffsetRequestHeader requestHeader, long timeoutMillis) throws RemotingConnectException, RemotingTooMuchRequestException, RemotingTimeoutException, RemotingSendRequestException, InterruptedException {
        RemotingCommand request = RemotingCommand.createRequestCommand((int)15, (CommandCustomHeader)requestHeader);
        this.remotingClient.invokeOneway(MixAll.brokerVIPChannel((boolean)this.clientConfig.isVipChannelEnabled(), (String)addr), request, timeoutMillis);
    }

    public int sendHeartbeat(String addr, HeartbeatData heartbeatData, long timeoutMillis) throws RemotingException, MQBrokerException, InterruptedException {
        RemotingCommand request = RemotingCommand.createRequestCommand((int)34, null);
        request.setLanguage(this.clientConfig.getLanguage());
        request.setBody(heartbeatData.encode());
        RemotingCommand response = this.remotingClient.invokeSync(addr, request, timeoutMillis);
        assert (response != null);
        switch (response.getCode()) {
            case 0: {
                return response.getVersion();
            }
        }
        throw new MQBrokerException(response.getCode(), response.getRemark(), addr);
    }

    public void unregisterClient(String addr, String clientID, String producerGroup, String consumerGroup, long timeoutMillis) throws RemotingException, MQBrokerException, InterruptedException {
        UnregisterClientRequestHeader requestHeader = new UnregisterClientRequestHeader();
        requestHeader.setClientID(clientID);
        requestHeader.setProducerGroup(producerGroup);
        requestHeader.setConsumerGroup(consumerGroup);
        RemotingCommand request = RemotingCommand.createRequestCommand((int)35, (CommandCustomHeader)requestHeader);
        RemotingCommand response = this.remotingClient.invokeSync(addr, request, timeoutMillis);
        assert (response != null);
        switch (response.getCode()) {
            case 0: {
                return;
            }
        }
        throw new MQBrokerException(response.getCode(), response.getRemark(), addr);
    }

    public void endTransactionOneway(String addr, EndTransactionRequestHeader requestHeader, String remark, long timeoutMillis) throws RemotingException, InterruptedException {
        RemotingCommand request = RemotingCommand.createRequestCommand((int)37, (CommandCustomHeader)requestHeader);
        request.setRemark(remark);
        this.remotingClient.invokeOneway(addr, request, timeoutMillis);
    }

    public void queryMessage(String addr, QueryMessageRequestHeader requestHeader, long timeoutMillis, InvokeCallback invokeCallback, Boolean isUnqiueKey) throws RemotingException, MQBrokerException, InterruptedException {
        RemotingCommand request = RemotingCommand.createRequestCommand((int)12, (CommandCustomHeader)requestHeader);
        request.addExtField("_UNIQUE_KEY_QUERY", isUnqiueKey.toString());
        this.remotingClient.invokeAsync(MixAll.brokerVIPChannel((boolean)this.clientConfig.isVipChannelEnabled(), (String)addr), request, timeoutMillis, invokeCallback);
    }

    public boolean registerClient(String addr, HeartbeatData heartbeat, long timeoutMillis) throws RemotingException, InterruptedException {
        RemotingCommand request = RemotingCommand.createRequestCommand((int)34, null);
        request.setBody(heartbeat.encode());
        RemotingCommand response = this.remotingClient.invokeSync(addr, request, timeoutMillis);
        return response.getCode() == 0;
    }

    public void consumerSendMessageBack(String addr, MessageExt msg, String consumerGroup, int delayLevel, long timeoutMillis, int maxConsumeRetryTimes) throws RemotingException, MQBrokerException, InterruptedException {
        ConsumerSendMsgBackRequestHeader requestHeader = new ConsumerSendMsgBackRequestHeader();
        RemotingCommand request = RemotingCommand.createRequestCommand((int)36, (CommandCustomHeader)requestHeader);
        requestHeader.setGroup(consumerGroup);
        requestHeader.setOriginTopic(msg.getTopic());
        requestHeader.setOffset(Long.valueOf(msg.getCommitLogOffset()));
        requestHeader.setDelayLevel(Integer.valueOf(delayLevel));
        requestHeader.setOriginMsgId(msg.getMsgId());
        requestHeader.setMaxReconsumeTimes(Integer.valueOf(maxConsumeRetryTimes));
        RemotingCommand response = this.remotingClient.invokeSync(MixAll.brokerVIPChannel((boolean)this.clientConfig.isVipChannelEnabled(), (String)addr), request, timeoutMillis);
        assert (response != null);
        switch (response.getCode()) {
            case 0: {
                return;
            }
        }
        throw new MQBrokerException(response.getCode(), response.getRemark(), addr);
    }

    public Set<MessageQueue> lockBatchMQ(String addr, LockBatchRequestBody requestBody, long timeoutMillis) throws RemotingException, MQBrokerException, InterruptedException {
        RemotingCommand request = RemotingCommand.createRequestCommand((int)41, null);
        request.setBody(requestBody.encode());
        RemotingCommand response = this.remotingClient.invokeSync(MixAll.brokerVIPChannel((boolean)this.clientConfig.isVipChannelEnabled(), (String)addr), request, timeoutMillis);
        switch (response.getCode()) {
            case 0: {
                LockBatchResponseBody responseBody = (LockBatchResponseBody)LockBatchResponseBody.decode((byte[])response.getBody(), LockBatchResponseBody.class);
                Set messageQueues = responseBody.getLockOKMQSet();
                return messageQueues;
            }
        }
        throw new MQBrokerException(response.getCode(), response.getRemark(), addr);
    }

    public void unlockBatchMQ(String addr, UnlockBatchRequestBody requestBody, long timeoutMillis, boolean oneway) throws RemotingException, MQBrokerException, InterruptedException {
        RemotingCommand request = RemotingCommand.createRequestCommand((int)42, null);
        request.setBody(requestBody.encode());
        if (!oneway) {
            RemotingCommand response = this.remotingClient.invokeSync(MixAll.brokerVIPChannel((boolean)this.clientConfig.isVipChannelEnabled(), (String)addr), request, timeoutMillis);
            switch (response.getCode()) {
                case 0: {
                    return;
                }
            }
            throw new MQBrokerException(response.getCode(), response.getRemark(), addr);
        }
        this.remotingClient.invokeOneway(addr, request, timeoutMillis);
    }

    public TopicStatsTable getTopicStatsInfo(String addr, String topic, long timeoutMillis) throws InterruptedException, RemotingTimeoutException, RemotingSendRequestException, RemotingConnectException, MQBrokerException {
        GetTopicStatsInfoRequestHeader requestHeader = new GetTopicStatsInfoRequestHeader();
        requestHeader.setTopic(topic);
        RemotingCommand request = RemotingCommand.createRequestCommand((int)202, (CommandCustomHeader)requestHeader);
        RemotingCommand response = this.remotingClient.invokeSync(MixAll.brokerVIPChannel((boolean)this.clientConfig.isVipChannelEnabled(), (String)addr), request, timeoutMillis);
        switch (response.getCode()) {
            case 0: {
                TopicStatsTable topicStatsTable = (TopicStatsTable)TopicStatsTable.decode((byte[])response.getBody(), TopicStatsTable.class);
                return topicStatsTable;
            }
        }
        throw new MQBrokerException(response.getCode(), response.getRemark(), addr);
    }

    public ConsumeStats getConsumeStats(String addr, String consumerGroup, long timeoutMillis) throws InterruptedException, RemotingTimeoutException, RemotingSendRequestException, RemotingConnectException, MQBrokerException {
        return this.getConsumeStats(addr, consumerGroup, null, timeoutMillis);
    }

    public ConsumeStats getConsumeStats(String addr, String consumerGroup, String topic, long timeoutMillis) throws InterruptedException, RemotingTimeoutException, RemotingSendRequestException, RemotingConnectException, MQBrokerException {
        GetConsumeStatsRequestHeader requestHeader = new GetConsumeStatsRequestHeader();
        requestHeader.setConsumerGroup(consumerGroup);
        requestHeader.setTopic(topic);
        RemotingCommand request = RemotingCommand.createRequestCommand((int)208, (CommandCustomHeader)requestHeader);
        RemotingCommand response = this.remotingClient.invokeSync(MixAll.brokerVIPChannel((boolean)this.clientConfig.isVipChannelEnabled(), (String)addr), request, timeoutMillis);
        switch (response.getCode()) {
            case 0: {
                ConsumeStats consumeStats = (ConsumeStats)ConsumeStats.decode((byte[])response.getBody(), ConsumeStats.class);
                return consumeStats;
            }
        }
        throw new MQBrokerException(response.getCode(), response.getRemark(), addr);
    }

    public ProducerConnection getProducerConnectionList(String addr, String producerGroup, long timeoutMillis) throws RemotingConnectException, RemotingSendRequestException, RemotingTimeoutException, InterruptedException, MQBrokerException {
        GetProducerConnectionListRequestHeader requestHeader = new GetProducerConnectionListRequestHeader();
        requestHeader.setProducerGroup(producerGroup);
        RemotingCommand request = RemotingCommand.createRequestCommand((int)204, (CommandCustomHeader)requestHeader);
        RemotingCommand response = this.remotingClient.invokeSync(MixAll.brokerVIPChannel((boolean)this.clientConfig.isVipChannelEnabled(), (String)addr), request, timeoutMillis);
        switch (response.getCode()) {
            case 0: {
                return (ProducerConnection)ProducerConnection.decode((byte[])response.getBody(), ProducerConnection.class);
            }
        }
        throw new MQBrokerException(response.getCode(), response.getRemark(), addr);
    }

    public ProducerTableInfo getAllProducerInfo(String addr, long timeoutMillis) throws RemotingConnectException, RemotingSendRequestException, RemotingTimeoutException, InterruptedException, MQBrokerException {
        GetAllProducerInfoRequestHeader requestHeader = new GetAllProducerInfoRequestHeader();
        RemotingCommand request = RemotingCommand.createRequestCommand((int)328, (CommandCustomHeader)requestHeader);
        RemotingCommand response = this.remotingClient.invokeSync(MixAll.brokerVIPChannel((boolean)this.clientConfig.isVipChannelEnabled(), (String)addr), request, timeoutMillis);
        switch (response.getCode()) {
            case 0: {
                return (ProducerTableInfo)ProducerTableInfo.decode((byte[])response.getBody(), ProducerTableInfo.class);
            }
        }
        throw new MQBrokerException(response.getCode(), response.getRemark(), addr);
    }

    public ConsumerConnection getConsumerConnectionList(String addr, String consumerGroup, long timeoutMillis) throws RemotingConnectException, RemotingSendRequestException, RemotingTimeoutException, InterruptedException, MQBrokerException {
        GetConsumerConnectionListRequestHeader requestHeader = new GetConsumerConnectionListRequestHeader();
        requestHeader.setConsumerGroup(consumerGroup);
        RemotingCommand request = RemotingCommand.createRequestCommand((int)203, (CommandCustomHeader)requestHeader);
        RemotingCommand response = this.remotingClient.invokeSync(MixAll.brokerVIPChannel((boolean)this.clientConfig.isVipChannelEnabled(), (String)addr), request, timeoutMillis);
        switch (response.getCode()) {
            case 0: {
                return (ConsumerConnection)ConsumerConnection.decode((byte[])response.getBody(), ConsumerConnection.class);
            }
        }
        throw new MQBrokerException(response.getCode(), response.getRemark(), addr);
    }

    public KVTable getBrokerRuntimeInfo(String addr, long timeoutMillis) throws RemotingConnectException, RemotingSendRequestException, RemotingTimeoutException, InterruptedException, MQBrokerException {
        RemotingCommand request = RemotingCommand.createRequestCommand((int)28, null);
        RemotingCommand response = this.remotingClient.invokeSync(MixAll.brokerVIPChannel((boolean)this.clientConfig.isVipChannelEnabled(), (String)addr), request, timeoutMillis);
        switch (response.getCode()) {
            case 0: {
                return (KVTable)KVTable.decode((byte[])response.getBody(), KVTable.class);
            }
        }
        throw new MQBrokerException(response.getCode(), response.getRemark(), addr);
    }

    public void addBroker(String addr, String brokerConfigPath, long timeoutMillis) throws InterruptedException, RemotingTimeoutException, RemotingSendRequestException, RemotingConnectException, MQBrokerException {
        AddBrokerRequestHeader requestHeader = new AddBrokerRequestHeader();
        requestHeader.setConfigPath(brokerConfigPath);
        RemotingCommand request = RemotingCommand.createRequestCommand((int)902, (CommandCustomHeader)requestHeader);
        RemotingCommand response = this.remotingClient.invokeSync(addr, request, timeoutMillis);
        assert (response != null);
        switch (response.getCode()) {
            case 0: {
                return;
            }
        }
        throw new MQBrokerException(response.getCode(), response.getRemark());
    }

    public void removeBroker(String addr, String clusterName, String brokerName, long brokerId, long timeoutMillis) throws InterruptedException, RemotingTimeoutException, RemotingSendRequestException, RemotingConnectException, MQBrokerException {
        RemoveBrokerRequestHeader requestHeader = new RemoveBrokerRequestHeader();
        requestHeader.setBrokerClusterName(clusterName);
        requestHeader.setBrokerName(brokerName);
        requestHeader.setBrokerId(Long.valueOf(brokerId));
        RemotingCommand request = RemotingCommand.createRequestCommand((int)903, (CommandCustomHeader)requestHeader);
        RemotingCommand response = this.remotingClient.invokeSync(addr, request, timeoutMillis);
        assert (response != null);
        switch (response.getCode()) {
            case 0: {
                return;
            }
        }
        throw new MQBrokerException(response.getCode(), response.getRemark());
    }

    public void updateBrokerConfig(String addr, Properties properties, long timeoutMillis) throws RemotingConnectException, RemotingSendRequestException, RemotingTimeoutException, InterruptedException, MQBrokerException, MQClientException, UnsupportedEncodingException {
        Validators.checkBrokerConfig(properties);
        RemotingCommand request = RemotingCommand.createRequestCommand((int)25, null);
        String str = MixAll.properties2String((Properties)properties);
        if (str != null && str.length() > 0) {
            request.setBody(str.getBytes("UTF-8"));
            RemotingCommand response = this.remotingClient.invokeSync(MixAll.brokerVIPChannel((boolean)this.clientConfig.isVipChannelEnabled(), (String)addr), request, timeoutMillis);
            switch (response.getCode()) {
                case 0: {
                    return;
                }
            }
            throw new MQBrokerException(response.getCode(), response.getRemark(), addr);
        }
    }

    public Properties getBrokerConfig(String addr, long timeoutMillis) throws RemotingConnectException, RemotingSendRequestException, RemotingTimeoutException, InterruptedException, MQBrokerException, UnsupportedEncodingException {
        RemotingCommand request = RemotingCommand.createRequestCommand((int)26, null);
        RemotingCommand response = this.remotingClient.invokeSync(addr, request, timeoutMillis);
        assert (response != null);
        switch (response.getCode()) {
            case 0: {
                return MixAll.string2Properties((String)new String(response.getBody(), "UTF-8"));
            }
        }
        throw new MQBrokerException(response.getCode(), response.getRemark(), addr);
    }

    public ClusterInfo getBrokerClusterInfo(long timeoutMillis) throws InterruptedException, RemotingTimeoutException, RemotingSendRequestException, RemotingConnectException, MQBrokerException {
        RemotingCommand request = RemotingCommand.createRequestCommand((int)106, null);
        RemotingCommand response = this.remotingClient.invokeSync(null, request, timeoutMillis);
        assert (response != null);
        switch (response.getCode()) {
            case 0: {
                return (ClusterInfo)ClusterInfo.decode((byte[])response.getBody(), ClusterInfo.class);
            }
        }
        throw new MQBrokerException(response.getCode(), response.getRemark());
    }

    public TopicRouteData getDefaultTopicRouteInfoFromNameServer(String topic, long timeoutMillis) throws RemotingException, MQClientException, InterruptedException {
        return this.getTopicRouteInfoFromNameServer(topic, timeoutMillis, false);
    }

    public TopicRouteData getTopicRouteInfoFromNameServer(String topic, long timeoutMillis) throws RemotingException, MQClientException, InterruptedException {
        return this.getTopicRouteInfoFromNameServer(topic, timeoutMillis, true);
    }

    public TopicRouteData getTopicRouteInfoFromNameServer(String topic, long timeoutMillis, boolean allowTopicNotExist) throws MQClientException, InterruptedException, RemotingTimeoutException, RemotingSendRequestException, RemotingConnectException {
        GetRouteInfoRequestHeader requestHeader = new GetRouteInfoRequestHeader();
        requestHeader.setTopic(topic);
        RemotingCommand request = RemotingCommand.createRequestCommand((int)105, (CommandCustomHeader)requestHeader);
        RemotingCommand response = this.remotingClient.invokeSync(null, request, timeoutMillis);
        assert (response != null);
        switch (response.getCode()) {
            case 17: {
                if (!allowTopicNotExist) break;
                log.warn("get Topic [{}] RouteInfoFromNameServer is not exist value", (Object)topic);
                break;
            }
            case 0: {
                byte[] body = response.getBody();
                if (body == null) break;
                return (TopicRouteData)TopicRouteData.decode((byte[])body, TopicRouteData.class);
            }
        }
        throw new MQClientException(response.getCode(), response.getRemark());
    }

    public TopicList getTopicListFromNameServer(long timeoutMillis) throws RemotingException, MQClientException, InterruptedException {
        RemotingCommand request = RemotingCommand.createRequestCommand((int)206, null);
        RemotingCommand response = this.remotingClient.invokeSync(null, request, timeoutMillis);
        assert (response != null);
        switch (response.getCode()) {
            case 0: {
                byte[] body = response.getBody();
                if (body == null) break;
                return (TopicList)TopicList.decode((byte[])body, TopicList.class);
            }
        }
        throw new MQClientException(response.getCode(), response.getRemark());
    }

    public int wipeWritePermOfBroker(String namesrvAddr, String brokerName, long timeoutMillis) throws RemotingCommandException, RemotingConnectException, RemotingSendRequestException, RemotingTimeoutException, InterruptedException, MQClientException {
        WipeWritePermOfBrokerRequestHeader requestHeader = new WipeWritePermOfBrokerRequestHeader();
        requestHeader.setBrokerName(brokerName);
        RemotingCommand request = RemotingCommand.createRequestCommand((int)205, (CommandCustomHeader)requestHeader);
        RemotingCommand response = this.remotingClient.invokeSync(namesrvAddr, request, timeoutMillis);
        assert (response != null);
        switch (response.getCode()) {
            case 0: {
                WipeWritePermOfBrokerResponseHeader responseHeader = (WipeWritePermOfBrokerResponseHeader)response.decodeCommandCustomHeader(WipeWritePermOfBrokerResponseHeader.class);
                return responseHeader.getWipeTopicCount();
            }
        }
        throw new MQClientException(response.getCode(), response.getRemark());
    }

    public int addWritePermOfBroker(String nameSrvAddr, String brokerName, long timeoutMillis) throws RemotingCommandException, RemotingConnectException, RemotingSendRequestException, RemotingTimeoutException, InterruptedException, MQClientException {
        AddWritePermOfBrokerRequestHeader requestHeader = new AddWritePermOfBrokerRequestHeader();
        requestHeader.setBrokerName(brokerName);
        RemotingCommand request = RemotingCommand.createRequestCommand((int)327, (CommandCustomHeader)requestHeader);
        RemotingCommand response = this.remotingClient.invokeSync(nameSrvAddr, request, timeoutMillis);
        assert (response != null);
        switch (response.getCode()) {
            case 0: {
                AddWritePermOfBrokerResponseHeader responseHeader = (AddWritePermOfBrokerResponseHeader)response.decodeCommandCustomHeader(AddWritePermOfBrokerResponseHeader.class);
                return responseHeader.getAddTopicCount();
            }
        }
        throw new MQClientException(response.getCode(), response.getRemark());
    }

    public void deleteTopicInBroker(String addr, String topic, long timeoutMillis) throws RemotingException, InterruptedException, MQClientException {
        DeleteTopicRequestHeader requestHeader = new DeleteTopicRequestHeader();
        requestHeader.setTopic(topic);
        RemotingCommand request = RemotingCommand.createRequestCommand((int)215, (CommandCustomHeader)requestHeader);
        RemotingCommand response = this.remotingClient.invokeSync(MixAll.brokerVIPChannel((boolean)this.clientConfig.isVipChannelEnabled(), (String)addr), request, timeoutMillis);
        assert (response != null);
        switch (response.getCode()) {
            case 0: {
                return;
            }
        }
        throw new MQClientException(response.getCode(), response.getRemark());
    }

    public void deleteTopicInNameServer(String addr, String topic, long timeoutMillis) throws RemotingException, InterruptedException, MQClientException {
        DeleteTopicFromNamesrvRequestHeader requestHeader = new DeleteTopicFromNamesrvRequestHeader();
        requestHeader.setTopic(topic);
        RemotingCommand request = RemotingCommand.createRequestCommand((int)216, (CommandCustomHeader)requestHeader);
        RemotingCommand response = this.remotingClient.invokeSync(addr, request, timeoutMillis);
        assert (response != null);
        switch (response.getCode()) {
            case 0: {
                return;
            }
        }
        throw new MQClientException(response.getCode(), response.getRemark());
    }

    public void deleteTopicInNameServer(String addr, String clusterName, String topic, long timeoutMillis) throws RemotingException, MQBrokerException, InterruptedException, MQClientException {
        DeleteTopicFromNamesrvRequestHeader requestHeader = new DeleteTopicFromNamesrvRequestHeader();
        requestHeader.setTopic(topic);
        requestHeader.setClusterName(clusterName);
        RemotingCommand request = RemotingCommand.createRequestCommand((int)216, (CommandCustomHeader)requestHeader);
        RemotingCommand response = this.remotingClient.invokeSync(addr, request, timeoutMillis);
        assert (response != null);
        switch (response.getCode()) {
            case 0: {
                return;
            }
        }
        throw new MQClientException(response.getCode(), response.getRemark());
    }

    public void deleteSubscriptionGroup(String addr, String groupName, boolean removeOffset, long timeoutMillis) throws RemotingException, InterruptedException, MQClientException {
        DeleteSubscriptionGroupRequestHeader requestHeader = new DeleteSubscriptionGroupRequestHeader();
        requestHeader.setGroupName(groupName);
        requestHeader.setCleanOffset(removeOffset);
        RemotingCommand request = RemotingCommand.createRequestCommand((int)207, (CommandCustomHeader)requestHeader);
        RemotingCommand response = this.remotingClient.invokeSync(MixAll.brokerVIPChannel((boolean)this.clientConfig.isVipChannelEnabled(), (String)addr), request, timeoutMillis);
        assert (response != null);
        switch (response.getCode()) {
            case 0: {
                return;
            }
        }
        throw new MQClientException(response.getCode(), response.getRemark());
    }

    public String getKVConfigValue(String namespace, String key, long timeoutMillis) throws RemotingException, MQClientException, InterruptedException {
        GetKVConfigRequestHeader requestHeader = new GetKVConfigRequestHeader();
        requestHeader.setNamespace(namespace);
        requestHeader.setKey(key);
        RemotingCommand request = RemotingCommand.createRequestCommand((int)101, (CommandCustomHeader)requestHeader);
        RemotingCommand response = this.remotingClient.invokeSync(null, request, timeoutMillis);
        assert (response != null);
        switch (response.getCode()) {
            case 0: {
                GetKVConfigResponseHeader responseHeader = (GetKVConfigResponseHeader)response.decodeCommandCustomHeader(GetKVConfigResponseHeader.class);
                return responseHeader.getValue();
            }
        }
        throw new MQClientException(response.getCode(), response.getRemark());
    }

    public void putKVConfigValue(String namespace, String key, String value, long timeoutMillis) throws RemotingException, MQClientException, InterruptedException {
        PutKVConfigRequestHeader requestHeader = new PutKVConfigRequestHeader();
        requestHeader.setNamespace(namespace);
        requestHeader.setKey(key);
        requestHeader.setValue(value);
        RemotingCommand request = RemotingCommand.createRequestCommand((int)100, (CommandCustomHeader)requestHeader);
        List nameServerAddressList = this.remotingClient.getNameServerAddressList();
        if (nameServerAddressList != null) {
            RemotingCommand errResponse = null;
            block3: for (String namesrvAddr : nameServerAddressList) {
                RemotingCommand response = this.remotingClient.invokeSync(namesrvAddr, request, timeoutMillis);
                assert (response != null);
                switch (response.getCode()) {
                    case 0: {
                        continue block3;
                    }
                }
                errResponse = response;
            }
            if (errResponse != null) {
                throw new MQClientException(errResponse.getCode(), errResponse.getRemark());
            }
        }
    }

    public void deleteKVConfigValue(String namespace, String key, long timeoutMillis) throws RemotingException, MQClientException, InterruptedException {
        DeleteKVConfigRequestHeader requestHeader = new DeleteKVConfigRequestHeader();
        requestHeader.setNamespace(namespace);
        requestHeader.setKey(key);
        RemotingCommand request = RemotingCommand.createRequestCommand((int)102, (CommandCustomHeader)requestHeader);
        List nameServerAddressList = this.remotingClient.getNameServerAddressList();
        if (nameServerAddressList != null) {
            RemotingCommand errResponse = null;
            block3: for (String namesrvAddr : nameServerAddressList) {
                RemotingCommand response = this.remotingClient.invokeSync(namesrvAddr, request, timeoutMillis);
                assert (response != null);
                switch (response.getCode()) {
                    case 0: {
                        continue block3;
                    }
                }
                errResponse = response;
            }
            if (errResponse != null) {
                throw new MQClientException(errResponse.getCode(), errResponse.getRemark());
            }
        }
    }

    public KVTable getKVListByNamespace(String namespace, long timeoutMillis) throws RemotingException, MQClientException, InterruptedException {
        GetKVListByNamespaceRequestHeader requestHeader = new GetKVListByNamespaceRequestHeader();
        requestHeader.setNamespace(namespace);
        RemotingCommand request = RemotingCommand.createRequestCommand((int)219, (CommandCustomHeader)requestHeader);
        RemotingCommand response = this.remotingClient.invokeSync(null, request, timeoutMillis);
        assert (response != null);
        switch (response.getCode()) {
            case 0: {
                return (KVTable)KVTable.decode((byte[])response.getBody(), KVTable.class);
            }
        }
        throw new MQClientException(response.getCode(), response.getRemark());
    }

    public Map<MessageQueue, Long> invokeBrokerToResetOffset(String addr, String topic, String group, long timestamp, boolean isForce, long timeoutMillis) throws RemotingException, MQClientException, InterruptedException {
        return this.invokeBrokerToResetOffset(addr, topic, group, timestamp, isForce, timeoutMillis, false);
    }

    public Map<MessageQueue, Long> invokeBrokerToResetOffset(String addr, String topic, String group, long timestamp, boolean isForce, long timeoutMillis, boolean isC) throws RemotingException, MQClientException, InterruptedException {
        ResetOffsetRequestHeader requestHeader = new ResetOffsetRequestHeader();
        requestHeader.setTopic(topic);
        requestHeader.setGroup(group);
        requestHeader.setTimestamp(timestamp);
        requestHeader.setForce(isForce);
        RemotingCommand request = RemotingCommand.createRequestCommand((int)222, (CommandCustomHeader)requestHeader);
        if (isC) {
            request.setLanguage(LanguageCode.CPP);
        }
        RemotingCommand response = this.remotingClient.invokeSync(MixAll.brokerVIPChannel((boolean)this.clientConfig.isVipChannelEnabled(), (String)addr), request, timeoutMillis);
        assert (response != null);
        switch (response.getCode()) {
            case 0: {
                if (response.getBody() == null) break;
                ResetOffsetBody body = (ResetOffsetBody)ResetOffsetBody.decode((byte[])response.getBody(), ResetOffsetBody.class);
                return body.getOffsetTable();
            }
        }
        throw new MQClientException(response.getCode(), response.getRemark());
    }

    public Map<String, Map<MessageQueue, Long>> invokeBrokerToGetConsumerStatus(String addr, String topic, String group, String clientAddr, long timeoutMillis) throws RemotingException, MQClientException, InterruptedException {
        GetConsumerStatusRequestHeader requestHeader = new GetConsumerStatusRequestHeader();
        requestHeader.setTopic(topic);
        requestHeader.setGroup(group);
        requestHeader.setClientAddr(clientAddr);
        RemotingCommand request = RemotingCommand.createRequestCommand((int)223, (CommandCustomHeader)requestHeader);
        RemotingCommand response = this.remotingClient.invokeSync(MixAll.brokerVIPChannel((boolean)this.clientConfig.isVipChannelEnabled(), (String)addr), request, timeoutMillis);
        assert (response != null);
        switch (response.getCode()) {
            case 0: {
                if (response.getBody() == null) break;
                GetConsumerStatusBody body = (GetConsumerStatusBody)GetConsumerStatusBody.decode((byte[])response.getBody(), GetConsumerStatusBody.class);
                return body.getConsumerTable();
            }
        }
        throw new MQClientException(response.getCode(), response.getRemark());
    }

    public GroupList queryTopicConsumeByWho(String addr, String topic, long timeoutMillis) throws RemotingConnectException, RemotingSendRequestException, RemotingTimeoutException, InterruptedException, MQBrokerException {
        QueryTopicConsumeByWhoRequestHeader requestHeader = new QueryTopicConsumeByWhoRequestHeader();
        requestHeader.setTopic(topic);
        RemotingCommand request = RemotingCommand.createRequestCommand((int)300, (CommandCustomHeader)requestHeader);
        RemotingCommand response = this.remotingClient.invokeSync(MixAll.brokerVIPChannel((boolean)this.clientConfig.isVipChannelEnabled(), (String)addr), request, timeoutMillis);
        switch (response.getCode()) {
            case 0: {
                GroupList groupList = (GroupList)GroupList.decode((byte[])response.getBody(), GroupList.class);
                return groupList;
            }
        }
        throw new MQBrokerException(response.getCode(), response.getRemark(), addr);
    }

    public TopicList queryTopicsByConsumer(String addr, String group, long timeoutMillis) throws RemotingConnectException, RemotingSendRequestException, RemotingTimeoutException, InterruptedException, MQBrokerException {
        QueryTopicsByConsumerRequestHeader requestHeader = new QueryTopicsByConsumerRequestHeader();
        requestHeader.setGroup(group);
        RemotingCommand request = RemotingCommand.createRequestCommand((int)343, (CommandCustomHeader)requestHeader);
        RemotingCommand response = this.remotingClient.invokeSync(MixAll.brokerVIPChannel((boolean)this.clientConfig.isVipChannelEnabled(), (String)addr), request, timeoutMillis);
        switch (response.getCode()) {
            case 0: {
                TopicList topicList = (TopicList)TopicList.decode((byte[])response.getBody(), TopicList.class);
                return topicList;
            }
        }
        throw new MQBrokerException(response.getCode(), response.getRemark());
    }

    public SubscriptionData querySubscriptionByConsumer(String addr, String group, String topic, long timeoutMillis) throws RemotingConnectException, RemotingSendRequestException, RemotingTimeoutException, InterruptedException, MQBrokerException {
        QuerySubscriptionByConsumerRequestHeader requestHeader = new QuerySubscriptionByConsumerRequestHeader();
        requestHeader.setGroup(group);
        requestHeader.setTopic(topic);
        RemotingCommand request = RemotingCommand.createRequestCommand((int)345, (CommandCustomHeader)requestHeader);
        RemotingCommand response = this.remotingClient.invokeSync(MixAll.brokerVIPChannel((boolean)this.clientConfig.isVipChannelEnabled(), (String)addr), request, timeoutMillis);
        switch (response.getCode()) {
            case 0: {
                QuerySubscriptionResponseBody subscriptionResponseBody = (QuerySubscriptionResponseBody)QuerySubscriptionResponseBody.decode((byte[])response.getBody(), QuerySubscriptionResponseBody.class);
                return subscriptionResponseBody.getSubscriptionData();
            }
        }
        throw new MQBrokerException(response.getCode(), response.getRemark());
    }

    public List<QueueTimeSpan> queryConsumeTimeSpan(String addr, String topic, String group, long timeoutMillis) throws RemotingConnectException, RemotingSendRequestException, RemotingTimeoutException, InterruptedException, MQBrokerException {
        QueryConsumeTimeSpanRequestHeader requestHeader = new QueryConsumeTimeSpanRequestHeader();
        requestHeader.setTopic(topic);
        requestHeader.setGroup(group);
        RemotingCommand request = RemotingCommand.createRequestCommand((int)303, (CommandCustomHeader)requestHeader);
        RemotingCommand response = this.remotingClient.invokeSync(MixAll.brokerVIPChannel((boolean)this.clientConfig.isVipChannelEnabled(), (String)addr), request, timeoutMillis);
        switch (response.getCode()) {
            case 0: {
                QueryConsumeTimeSpanBody consumeTimeSpanBody = (QueryConsumeTimeSpanBody)GroupList.decode((byte[])response.getBody(), QueryConsumeTimeSpanBody.class);
                return consumeTimeSpanBody.getConsumeTimeSpanSet();
            }
        }
        throw new MQBrokerException(response.getCode(), response.getRemark(), addr);
    }

    public TopicList getTopicsByCluster(String cluster, long timeoutMillis) throws RemotingException, MQClientException, InterruptedException {
        GetTopicsByClusterRequestHeader requestHeader = new GetTopicsByClusterRequestHeader();
        requestHeader.setCluster(cluster);
        RemotingCommand request = RemotingCommand.createRequestCommand((int)224, (CommandCustomHeader)requestHeader);
        RemotingCommand response = this.remotingClient.invokeSync(null, request, timeoutMillis);
        assert (response != null);
        switch (response.getCode()) {
            case 0: {
                byte[] body = response.getBody();
                if (body == null) break;
                TopicList topicList = (TopicList)TopicList.decode((byte[])body, TopicList.class);
                return topicList;
            }
        }
        throw new MQClientException(response.getCode(), response.getRemark());
    }

    public void registerMessageFilterClass(String addr, String consumerGroup, String topic, String className, int classCRC, byte[] classBody, long timeoutMillis) throws RemotingConnectException, RemotingSendRequestException, RemotingTimeoutException, InterruptedException, MQBrokerException {
        RegisterMessageFilterClassRequestHeader requestHeader = new RegisterMessageFilterClassRequestHeader();
        requestHeader.setConsumerGroup(consumerGroup);
        requestHeader.setClassName(className);
        requestHeader.setTopic(topic);
        requestHeader.setClassCRC(Integer.valueOf(classCRC));
        RemotingCommand request = RemotingCommand.createRequestCommand((int)302, (CommandCustomHeader)requestHeader);
        request.setBody(classBody);
        RemotingCommand response = this.remotingClient.invokeSync(addr, request, timeoutMillis);
        switch (response.getCode()) {
            case 0: {
                return;
            }
        }
        throw new MQBrokerException(response.getCode(), response.getRemark(), addr);
    }

    public TopicList getSystemTopicList(long timeoutMillis) throws RemotingException, MQClientException, InterruptedException {
        RemotingCommand request = RemotingCommand.createRequestCommand((int)304, null);
        RemotingCommand response = this.remotingClient.invokeSync(null, request, timeoutMillis);
        assert (response != null);
        switch (response.getCode()) {
            case 0: {
                TopicList tmp;
                byte[] body = response.getBody();
                if (body == null) break;
                TopicList topicList = (TopicList)TopicList.decode((byte[])response.getBody(), TopicList.class);
                if (!(topicList.getTopicList() == null || topicList.getTopicList().isEmpty() || UtilAll.isBlank((String)topicList.getBrokerAddr()) || (tmp = this.getSystemTopicListFromBroker(topicList.getBrokerAddr(), timeoutMillis)).getTopicList() == null || tmp.getTopicList().isEmpty())) {
                    topicList.getTopicList().addAll(tmp.getTopicList());
                }
                return topicList;
            }
        }
        throw new MQClientException(response.getCode(), response.getRemark());
    }

    public TopicList getSystemTopicListFromBroker(String addr, long timeoutMillis) throws RemotingException, MQClientException, InterruptedException {
        RemotingCommand request = RemotingCommand.createRequestCommand((int)305, null);
        RemotingCommand response = this.remotingClient.invokeSync(MixAll.brokerVIPChannel((boolean)this.clientConfig.isVipChannelEnabled(), (String)addr), request, timeoutMillis);
        assert (response != null);
        switch (response.getCode()) {
            case 0: {
                byte[] body = response.getBody();
                if (body == null) break;
                TopicList topicList = (TopicList)TopicList.decode((byte[])body, TopicList.class);
                return topicList;
            }
        }
        throw new MQClientException(response.getCode(), response.getRemark());
    }

    public boolean cleanExpiredConsumeQueue(String addr, long timeoutMillis) throws MQClientException, RemotingConnectException, RemotingSendRequestException, RemotingTimeoutException, InterruptedException {
        RemotingCommand request = RemotingCommand.createRequestCommand((int)306, null);
        RemotingCommand response = this.remotingClient.invokeSync(MixAll.brokerVIPChannel((boolean)this.clientConfig.isVipChannelEnabled(), (String)addr), request, timeoutMillis);
        switch (response.getCode()) {
            case 0: {
                return true;
            }
        }
        throw new MQClientException(response.getCode(), response.getRemark());
    }

    public boolean deleteExpiredCommitLog(String addr, long timeoutMillis) throws MQClientException, RemotingConnectException, RemotingSendRequestException, RemotingTimeoutException, InterruptedException {
        RemotingCommand request = RemotingCommand.createRequestCommand((int)329, null);
        RemotingCommand response = this.remotingClient.invokeSync(MixAll.brokerVIPChannel((boolean)this.clientConfig.isVipChannelEnabled(), (String)addr), request, timeoutMillis);
        switch (response.getCode()) {
            case 0: {
                return true;
            }
        }
        throw new MQClientException(response.getCode(), response.getRemark());
    }

    public boolean cleanUnusedTopicByAddr(String addr, long timeoutMillis) throws MQClientException, RemotingConnectException, RemotingSendRequestException, RemotingTimeoutException, InterruptedException {
        RemotingCommand request = RemotingCommand.createRequestCommand((int)316, null);
        RemotingCommand response = this.remotingClient.invokeSync(MixAll.brokerVIPChannel((boolean)this.clientConfig.isVipChannelEnabled(), (String)addr), request, timeoutMillis);
        switch (response.getCode()) {
            case 0: {
                return true;
            }
        }
        throw new MQClientException(response.getCode(), response.getRemark());
    }

    public ConsumerRunningInfo getConsumerRunningInfo(String addr, String consumerGroup, String clientId, boolean jstack, long timeoutMillis) throws RemotingException, MQClientException, InterruptedException {
        GetConsumerRunningInfoRequestHeader requestHeader = new GetConsumerRunningInfoRequestHeader();
        requestHeader.setConsumerGroup(consumerGroup);
        requestHeader.setClientId(clientId);
        requestHeader.setJstackEnable(jstack);
        RemotingCommand request = RemotingCommand.createRequestCommand((int)307, (CommandCustomHeader)requestHeader);
        RemotingCommand response = this.remotingClient.invokeSync(MixAll.brokerVIPChannel((boolean)this.clientConfig.isVipChannelEnabled(), (String)addr), request, timeoutMillis);
        assert (response != null);
        switch (response.getCode()) {
            case 0: {
                byte[] body = response.getBody();
                if (body == null) break;
                ConsumerRunningInfo info = (ConsumerRunningInfo)ConsumerRunningInfo.decode((byte[])body, ConsumerRunningInfo.class);
                return info;
            }
        }
        throw new MQClientException(response.getCode(), response.getRemark());
    }

    public ConsumeMessageDirectlyResult consumeMessageDirectly(String addr, String consumerGroup, String clientId, String topic, String msgId, long timeoutMillis) throws RemotingException, MQClientException, InterruptedException {
        ConsumeMessageDirectlyResultRequestHeader requestHeader = new ConsumeMessageDirectlyResultRequestHeader();
        requestHeader.setTopic(topic);
        requestHeader.setConsumerGroup(consumerGroup);
        requestHeader.setClientId(clientId);
        requestHeader.setMsgId(msgId);
        RemotingCommand request = RemotingCommand.createRequestCommand((int)309, (CommandCustomHeader)requestHeader);
        RemotingCommand response = this.remotingClient.invokeSync(MixAll.brokerVIPChannel((boolean)this.clientConfig.isVipChannelEnabled(), (String)addr), request, timeoutMillis);
        assert (response != null);
        switch (response.getCode()) {
            case 0: {
                byte[] body = response.getBody();
                if (body == null) break;
                ConsumeMessageDirectlyResult info = (ConsumeMessageDirectlyResult)ConsumeMessageDirectlyResult.decode((byte[])body, ConsumeMessageDirectlyResult.class);
                return info;
            }
        }
        throw new MQClientException(response.getCode(), response.getRemark());
    }

    public Map<Integer, Long> queryCorrectionOffset(String addr, String topic, String group, Set<String> filterGroup, long timeoutMillis) throws MQClientException, RemotingConnectException, RemotingSendRequestException, RemotingTimeoutException, InterruptedException {
        QueryCorrectionOffsetHeader requestHeader = new QueryCorrectionOffsetHeader();
        requestHeader.setCompareGroup(group);
        requestHeader.setTopic(topic);
        if (filterGroup != null) {
            StringBuilder sb = new StringBuilder();
            String splitor = "";
            for (String s : filterGroup) {
                sb.append(splitor).append(s);
                splitor = ",";
            }
            requestHeader.setFilterGroups(sb.toString());
        }
        RemotingCommand request = RemotingCommand.createRequestCommand((int)308, (CommandCustomHeader)requestHeader);
        RemotingCommand response = this.remotingClient.invokeSync(MixAll.brokerVIPChannel((boolean)this.clientConfig.isVipChannelEnabled(), (String)addr), request, timeoutMillis);
        assert (response != null);
        switch (response.getCode()) {
            case 0: {
                if (response.getBody() == null) break;
                QueryCorrectionOffsetBody body = (QueryCorrectionOffsetBody)QueryCorrectionOffsetBody.decode((byte[])response.getBody(), QueryCorrectionOffsetBody.class);
                return body.getCorrectionOffsets();
            }
        }
        throw new MQClientException(response.getCode(), response.getRemark());
    }

    public TopicList getUnitTopicList(boolean containRetry, long timeoutMillis) throws RemotingException, MQClientException, InterruptedException {
        RemotingCommand request = RemotingCommand.createRequestCommand((int)311, null);
        RemotingCommand response = this.remotingClient.invokeSync(null, request, timeoutMillis);
        assert (response != null);
        switch (response.getCode()) {
            case 0: {
                byte[] body = response.getBody();
                if (body == null) break;
                TopicList topicList = (TopicList)TopicList.decode((byte[])response.getBody(), TopicList.class);
                if (!containRetry) {
                    Iterator it = topicList.getTopicList().iterator();
                    while (it.hasNext()) {
                        String topic = (String)it.next();
                        if (!topic.startsWith("%RETRY%")) continue;
                        it.remove();
                    }
                }
                return topicList;
            }
        }
        throw new MQClientException(response.getCode(), response.getRemark());
    }

    public TopicList getHasUnitSubTopicList(boolean containRetry, long timeoutMillis) throws RemotingException, MQClientException, InterruptedException {
        RemotingCommand request = RemotingCommand.createRequestCommand((int)312, null);
        RemotingCommand response = this.remotingClient.invokeSync(null, request, timeoutMillis);
        assert (response != null);
        switch (response.getCode()) {
            case 0: {
                byte[] body = response.getBody();
                if (body == null) break;
                TopicList topicList = (TopicList)TopicList.decode((byte[])response.getBody(), TopicList.class);
                if (!containRetry) {
                    Iterator it = topicList.getTopicList().iterator();
                    while (it.hasNext()) {
                        String topic = (String)it.next();
                        if (!topic.startsWith("%RETRY%")) continue;
                        it.remove();
                    }
                }
                return topicList;
            }
        }
        throw new MQClientException(response.getCode(), response.getRemark());
    }

    public TopicList getHasUnitSubUnUnitTopicList(boolean containRetry, long timeoutMillis) throws RemotingException, MQClientException, InterruptedException {
        RemotingCommand request = RemotingCommand.createRequestCommand((int)313, null);
        RemotingCommand response = this.remotingClient.invokeSync(null, request, timeoutMillis);
        assert (response != null);
        switch (response.getCode()) {
            case 0: {
                byte[] body = response.getBody();
                if (body == null) break;
                TopicList topicList = (TopicList)TopicList.decode((byte[])response.getBody(), TopicList.class);
                if (!containRetry) {
                    Iterator it = topicList.getTopicList().iterator();
                    while (it.hasNext()) {
                        String topic = (String)it.next();
                        if (!topic.startsWith("%RETRY%")) continue;
                        it.remove();
                    }
                }
                return topicList;
            }
        }
        throw new MQClientException(response.getCode(), response.getRemark());
    }

    public void cloneGroupOffset(String addr, String srcGroup, String destGroup, String topic, boolean isOffline, long timeoutMillis) throws RemotingException, MQClientException, InterruptedException {
        CloneGroupOffsetRequestHeader requestHeader = new CloneGroupOffsetRequestHeader();
        requestHeader.setSrcGroup(srcGroup);
        requestHeader.setDestGroup(destGroup);
        requestHeader.setTopic(topic);
        requestHeader.setOffline(isOffline);
        RemotingCommand request = RemotingCommand.createRequestCommand((int)314, (CommandCustomHeader)requestHeader);
        RemotingCommand response = this.remotingClient.invokeSync(MixAll.brokerVIPChannel((boolean)this.clientConfig.isVipChannelEnabled(), (String)addr), request, timeoutMillis);
        assert (response != null);
        switch (response.getCode()) {
            case 0: {
                return;
            }
        }
        throw new MQClientException(response.getCode(), response.getRemark());
    }

    public BrokerStatsData viewBrokerStatsData(String brokerAddr, String statsName, String statsKey, long timeoutMillis) throws MQClientException, RemotingConnectException, RemotingSendRequestException, RemotingTimeoutException, InterruptedException {
        ViewBrokerStatsDataRequestHeader requestHeader = new ViewBrokerStatsDataRequestHeader();
        requestHeader.setStatsName(statsName);
        requestHeader.setStatsKey(statsKey);
        RemotingCommand request = RemotingCommand.createRequestCommand((int)315, (CommandCustomHeader)requestHeader);
        RemotingCommand response = this.remotingClient.invokeSync(MixAll.brokerVIPChannel((boolean)this.clientConfig.isVipChannelEnabled(), (String)brokerAddr), request, timeoutMillis);
        assert (response != null);
        switch (response.getCode()) {
            case 0: {
                byte[] body = response.getBody();
                if (body == null) break;
                return (BrokerStatsData)BrokerStatsData.decode((byte[])body, BrokerStatsData.class);
            }
        }
        throw new MQClientException(response.getCode(), response.getRemark());
    }

    public Set<String> getClusterList(String topic, long timeoutMillis) {
        return Collections.EMPTY_SET;
    }

    public ConsumeStatsList fetchConsumeStatsInBroker(String brokerAddr, boolean isOrder, long timeoutMillis) throws MQClientException, RemotingConnectException, RemotingSendRequestException, RemotingTimeoutException, InterruptedException {
        GetConsumeStatsInBrokerHeader requestHeader = new GetConsumeStatsInBrokerHeader();
        requestHeader.setIsOrder(isOrder);
        RemotingCommand request = RemotingCommand.createRequestCommand((int)317, (CommandCustomHeader)requestHeader);
        RemotingCommand response = this.remotingClient.invokeSync(MixAll.brokerVIPChannel((boolean)this.clientConfig.isVipChannelEnabled(), (String)brokerAddr), request, timeoutMillis);
        assert (response != null);
        switch (response.getCode()) {
            case 0: {
                byte[] body = response.getBody();
                if (body == null) break;
                return (ConsumeStatsList)ConsumeStatsList.decode((byte[])body, ConsumeStatsList.class);
            }
        }
        throw new MQClientException(response.getCode(), response.getRemark());
    }

    public SubscriptionGroupWrapper getAllSubscriptionGroup(String brokerAddr, long timeoutMillis) throws InterruptedException, RemotingTimeoutException, RemotingSendRequestException, RemotingConnectException, MQBrokerException {
        RemotingCommand request = RemotingCommand.createRequestCommand((int)201, null);
        RemotingCommand response = this.remotingClient.invokeSync(MixAll.brokerVIPChannel((boolean)this.clientConfig.isVipChannelEnabled(), (String)brokerAddr), request, timeoutMillis);
        assert (response != null);
        switch (response.getCode()) {
            case 0: {
                return (SubscriptionGroupWrapper)SubscriptionGroupWrapper.decode((byte[])response.getBody(), SubscriptionGroupWrapper.class);
            }
        }
        throw new MQBrokerException(response.getCode(), response.getRemark(), brokerAddr);
    }

    public SubscriptionGroupConfig getSubscriptionGroupConfig(String brokerAddr, String group, long timeoutMillis) throws InterruptedException, RemotingTimeoutException, RemotingSendRequestException, RemotingConnectException, MQBrokerException {
        GetSubscriptionGroupConfigRequestHeader header = new GetSubscriptionGroupConfigRequestHeader();
        header.setGroup(group);
        RemotingCommand request = RemotingCommand.createRequestCommand((int)352, (CommandCustomHeader)header);
        RemotingCommand response = this.remotingClient.invokeSync(MixAll.brokerVIPChannel((boolean)this.clientConfig.isVipChannelEnabled(), (String)brokerAddr), request, timeoutMillis);
        assert (response != null);
        switch (response.getCode()) {
            case 0: {
                return (SubscriptionGroupConfig)RemotingSerializable.decode((byte[])response.getBody(), SubscriptionGroupConfig.class);
            }
        }
        throw new MQBrokerException(response.getCode(), response.getRemark(), brokerAddr);
    }

    public TopicConfigSerializeWrapper getAllTopicConfig(String addr, long timeoutMillis) throws RemotingConnectException, RemotingSendRequestException, RemotingTimeoutException, InterruptedException, MQBrokerException {
        RemotingCommand request = RemotingCommand.createRequestCommand((int)21, null);
        RemotingCommand response = this.remotingClient.invokeSync(MixAll.brokerVIPChannel((boolean)this.clientConfig.isVipChannelEnabled(), (String)addr), request, timeoutMillis);
        assert (response != null);
        switch (response.getCode()) {
            case 0: {
                return (TopicConfigSerializeWrapper)TopicConfigSerializeWrapper.decode((byte[])response.getBody(), TopicConfigSerializeWrapper.class);
            }
        }
        throw new MQBrokerException(response.getCode(), response.getRemark(), addr);
    }

    public void updateNameServerConfig(Properties properties, List<String> nameServers, long timeoutMillis) throws UnsupportedEncodingException, InterruptedException, RemotingTimeoutException, RemotingSendRequestException, RemotingConnectException, MQClientException {
        List<String> invokeNameServers;
        String str = MixAll.properties2String((Properties)properties);
        if (str == null || str.length() < 1) {
            return;
        }
        List<String> list = invokeNameServers = nameServers == null || nameServers.isEmpty() ? this.remotingClient.getNameServerAddressList() : nameServers;
        if (invokeNameServers == null || invokeNameServers.isEmpty()) {
            return;
        }
        RemotingCommand request = RemotingCommand.createRequestCommand((int)318, null);
        request.setBody(str.getBytes("UTF-8"));
        RemotingCommand errResponse = null;
        block3: for (String nameServer : invokeNameServers) {
            RemotingCommand response = this.remotingClient.invokeSync(nameServer, request, timeoutMillis);
            assert (response != null);
            switch (response.getCode()) {
                case 0: {
                    continue block3;
                }
            }
            errResponse = response;
        }
        if (errResponse != null) {
            throw new MQClientException(errResponse.getCode(), errResponse.getRemark());
        }
    }

    public Map<String, Properties> getNameServerConfig(List<String> nameServers, long timeoutMillis) throws InterruptedException, RemotingTimeoutException, RemotingSendRequestException, RemotingConnectException, MQClientException, UnsupportedEncodingException {
        List<String> invokeNameServers;
        List<String> list = invokeNameServers = nameServers == null || nameServers.isEmpty() ? this.remotingClient.getNameServerAddressList() : nameServers;
        if (invokeNameServers == null || invokeNameServers.isEmpty()) {
            return null;
        }
        RemotingCommand request = RemotingCommand.createRequestCommand((int)319, null);
        HashMap<String, Properties> configMap = new HashMap<String, Properties>(4);
        for (String nameServer : invokeNameServers) {
            RemotingCommand response = this.remotingClient.invokeSync(nameServer, request, timeoutMillis);
            assert (response != null);
            if (0 == response.getCode()) {
                configMap.put(nameServer, MixAll.string2Properties((String)new String(response.getBody(), "UTF-8")));
                continue;
            }
            throw new MQClientException(response.getCode(), response.getRemark());
        }
        return configMap;
    }

    public QueryConsumeQueueResponseBody queryConsumeQueue(String brokerAddr, String topic, int queueId, long index, int count, String consumerGroup, long timeoutMillis) throws InterruptedException, RemotingTimeoutException, RemotingSendRequestException, RemotingConnectException, MQClientException {
        QueryConsumeQueueRequestHeader requestHeader = new QueryConsumeQueueRequestHeader();
        requestHeader.setTopic(topic);
        requestHeader.setQueueId(queueId);
        requestHeader.setIndex(index);
        requestHeader.setCount(count);
        requestHeader.setConsumerGroup(consumerGroup);
        RemotingCommand request = RemotingCommand.createRequestCommand((int)321, (CommandCustomHeader)requestHeader);
        RemotingCommand response = this.remotingClient.invokeSync(MixAll.brokerVIPChannel((boolean)this.clientConfig.isVipChannelEnabled(), (String)brokerAddr), request, timeoutMillis);
        assert (response != null);
        if (0 == response.getCode()) {
            return (QueryConsumeQueueResponseBody)QueryConsumeQueueResponseBody.decode((byte[])response.getBody(), QueryConsumeQueueResponseBody.class);
        }
        throw new MQClientException(response.getCode(), response.getRemark());
    }

    public void checkClientInBroker(String brokerAddr, String consumerGroup, String clientId, SubscriptionData subscriptionData, long timeoutMillis) throws InterruptedException, RemotingTimeoutException, RemotingSendRequestException, RemotingConnectException, MQClientException {
        RemotingCommand request = RemotingCommand.createRequestCommand((int)46, null);
        CheckClientRequestBody requestBody = new CheckClientRequestBody();
        requestBody.setClientId(clientId);
        requestBody.setGroup(consumerGroup);
        requestBody.setSubscriptionData(subscriptionData);
        request.setBody(requestBody.encode());
        RemotingCommand response = this.remotingClient.invokeSync(MixAll.brokerVIPChannel((boolean)this.clientConfig.isVipChannelEnabled(), (String)brokerAddr), request, timeoutMillis);
        assert (response != null);
        if (0 != response.getCode()) {
            throw new MQClientException(response.getCode(), response.getRemark());
        }
    }

    public boolean resumeCheckHalfMessage(String addr, String msgId, long timeoutMillis) throws RemotingException, InterruptedException {
        ResumeCheckHalfMessageRequestHeader requestHeader = new ResumeCheckHalfMessageRequestHeader();
        requestHeader.setMsgId(msgId);
        RemotingCommand request = RemotingCommand.createRequestCommand((int)323, (CommandCustomHeader)requestHeader);
        RemotingCommand response = this.remotingClient.invokeSync(MixAll.brokerVIPChannel((boolean)this.clientConfig.isVipChannelEnabled(), (String)addr), request, timeoutMillis);
        assert (response != null);
        switch (response.getCode()) {
            case 0: {
                return true;
            }
        }
        log.error("Failed to resume half message check logic. Remark={}", (Object)response.getRemark());
        return false;
    }

    public void setMessageRequestMode(String brokerAddr, String topic, String consumerGroup, MessageRequestMode mode, int popShareQueueNum, long timeoutMillis) throws InterruptedException, RemotingTimeoutException, RemotingSendRequestException, RemotingConnectException, MQClientException {
        RemotingCommand request = RemotingCommand.createRequestCommand((int)401, null);
        SetMessageRequestModeRequestBody requestBody = new SetMessageRequestModeRequestBody();
        requestBody.setTopic(topic);
        requestBody.setConsumerGroup(consumerGroup);
        requestBody.setMode(mode);
        requestBody.setPopShareQueueNum(popShareQueueNum);
        request.setBody(requestBody.encode());
        RemotingCommand response = this.remotingClient.invokeSync(MixAll.brokerVIPChannel((boolean)this.clientConfig.isVipChannelEnabled(), (String)brokerAddr), request, timeoutMillis);
        assert (response != null);
        if (0 != response.getCode()) {
            throw new MQClientException(response.getCode(), response.getRemark());
        }
    }

    public TopicConfigAndQueueMapping getTopicConfig(String brokerAddr, String topic, long timeoutMillis) throws InterruptedException, RemotingTimeoutException, RemotingSendRequestException, RemotingConnectException, MQBrokerException {
        GetTopicConfigRequestHeader header = new GetTopicConfigRequestHeader();
        header.setTopic(topic);
        header.setLo(Boolean.valueOf(true));
        RemotingCommand request = RemotingCommand.createRequestCommand((int)351, (CommandCustomHeader)header);
        RemotingCommand response = this.remotingClient.invokeSync(MixAll.brokerVIPChannel((boolean)this.clientConfig.isVipChannelEnabled(), (String)brokerAddr), request, timeoutMillis);
        assert (response != null);
        switch (response.getCode()) {
            case 0: {
                return (TopicConfigAndQueueMapping)RemotingSerializable.decode((byte[])response.getBody(), TopicConfigAndQueueMapping.class);
            }
            case 17: {
                break;
            }
        }
        throw new MQBrokerException(response.getCode(), response.getRemark());
    }

    public void createStaticTopic(String addr, String defaultTopic, TopicConfig topicConfig, TopicQueueMappingDetail topicQueueMappingDetail, boolean force, long timeoutMillis) throws RemotingException, InterruptedException, MQBrokerException {
        CreateTopicRequestHeader requestHeader = new CreateTopicRequestHeader();
        requestHeader.setTopic(topicConfig.getTopicName());
        requestHeader.setDefaultTopic(defaultTopic);
        requestHeader.setReadQueueNums(Integer.valueOf(topicConfig.getReadQueueNums()));
        requestHeader.setWriteQueueNums(Integer.valueOf(topicConfig.getWriteQueueNums()));
        requestHeader.setPerm(Integer.valueOf(topicConfig.getPerm()));
        requestHeader.setTopicFilterType(topicConfig.getTopicFilterType().name());
        requestHeader.setTopicSysFlag(Integer.valueOf(topicConfig.getTopicSysFlag()));
        requestHeader.setOrder(Boolean.valueOf(topicConfig.isOrder()));
        requestHeader.setForce(Boolean.valueOf(force));
        RemotingCommand request = RemotingCommand.createRequestCommand((int)513, (CommandCustomHeader)requestHeader);
        request.setBody(topicQueueMappingDetail.encode());
        RemotingCommand response = this.remotingClient.invokeSync(MixAll.brokerVIPChannel((boolean)this.clientConfig.isVipChannelEnabled(), (String)addr), request, timeoutMillis);
        assert (response != null);
        switch (response.getCode()) {
            case 0: {
                return;
            }
        }
        throw new MQBrokerException(response.getCode(), response.getRemark());
    }

    public GroupForbidden updateAndGetGroupForbidden(String addr, UpdateGroupForbiddenRequestHeader requestHeader, long timeoutMillis) throws RemotingConnectException, RemotingSendRequestException, RemotingTimeoutException, InterruptedException, MQBrokerException {
        RemotingCommand request = RemotingCommand.createRequestCommand((int)353, (CommandCustomHeader)requestHeader);
        RemotingCommand response = this.remotingClient.invokeSync(MixAll.brokerVIPChannel((boolean)this.clientConfig.isVipChannelEnabled(), (String)addr), request, timeoutMillis);
        assert (response != null);
        switch (response.getCode()) {
            case 0: {
                return (GroupForbidden)RemotingSerializable.decode((byte[])response.getBody(), GroupForbidden.class);
            }
        }
        throw new MQBrokerException(response.getCode(), response.getRemark(), addr);
    }

    public void resetMasterFlushOffset(String brokerAddr, long masterFlushOffset) throws InterruptedException, RemotingTimeoutException, RemotingSendRequestException, RemotingConnectException, MQBrokerException {
        ResetMasterFlushOffsetHeader requestHeader = new ResetMasterFlushOffsetHeader();
        requestHeader.setMasterFlushOffset(Long.valueOf(masterFlushOffset));
        RemotingCommand request = RemotingCommand.createRequestCommand((int)908, (CommandCustomHeader)requestHeader);
        RemotingCommand response = this.remotingClient.invokeSync(brokerAddr, request, 3000L);
        assert (response != null);
        switch (response.getCode()) {
            case 0: {
                return;
            }
        }
        throw new MQBrokerException(response.getCode(), response.getRemark(), brokerAddr);
    }

    public HARuntimeInfo getBrokerHAStatus(String brokerAddr, long timeoutMillis) throws RemotingConnectException, RemotingSendRequestException, RemotingTimeoutException, InterruptedException, MQBrokerException {
        RemotingCommand request = RemotingCommand.createRequestCommand((int)907, null);
        RemotingCommand response = this.remotingClient.invokeSync(brokerAddr, request, timeoutMillis);
        assert (response != null);
        switch (response.getCode()) {
            case 0: {
                return (HARuntimeInfo)HARuntimeInfo.decode((byte[])response.getBody(), HARuntimeInfo.class);
            }
        }
        throw new MQBrokerException(response.getCode(), response.getRemark());
    }

    public GetMetaDataResponseHeader getControllerMetaData(String controllerAddress) throws RemotingConnectException, RemotingSendRequestException, RemotingTimeoutException, InterruptedException, RemotingCommandException, MQBrokerException {
        RemotingCommand request = RemotingCommand.createRequestCommand((int)1005, null);
        RemotingCommand response = this.remotingClient.invokeSync(controllerAddress, request, 3000L);
        assert (response != null);
        if (response.getCode() == 0) {
            return (GetMetaDataResponseHeader)response.decodeCommandCustomHeader(GetMetaDataResponseHeader.class);
        }
        throw new MQBrokerException(response.getCode(), response.getRemark());
    }

    public InSyncStateData getInSyncStateData(String controllerAddress, List<String> brokers) throws RemotingConnectException, RemotingSendRequestException, RemotingTimeoutException, InterruptedException, MQBrokerException, RemotingCommandException {
        GetMetaDataResponseHeader controllerMetaData = this.getControllerMetaData(controllerAddress);
        assert (controllerMetaData != null);
        assert (controllerMetaData.getControllerLeaderAddress() != null);
        String leaderAddress = controllerMetaData.getControllerLeaderAddress();
        RemotingCommand request = RemotingCommand.createRequestCommand((int)1006, null);
        byte[] body = RemotingSerializable.encode(brokers);
        request.setBody(body);
        RemotingCommand response = this.remotingClient.invokeSync(leaderAddress, request, 3000L);
        assert (response != null);
        switch (response.getCode()) {
            case 0: {
                return (InSyncStateData)RemotingSerializable.decode((byte[])response.getBody(), InSyncStateData.class);
            }
        }
        throw new MQBrokerException(response.getCode(), response.getRemark());
    }

    public EpochEntryCache getBrokerEpochCache(String brokerAddr) throws RemotingConnectException, RemotingSendRequestException, RemotingTimeoutException, InterruptedException, MQBrokerException {
        RemotingCommand request = RemotingCommand.createRequestCommand((int)1007, null);
        RemotingCommand response = this.remotingClient.invokeSync(brokerAddr, request, 3000L);
        assert (response != null);
        switch (response.getCode()) {
            case 0: {
                return (EpochEntryCache)RemotingSerializable.decode((byte[])response.getBody(), EpochEntryCache.class);
            }
        }
        throw new MQBrokerException(response.getCode(), response.getRemark());
    }

    public Map<String, Properties> getControllerConfig(List<String> controllerServers, long timeoutMillis) throws InterruptedException, RemotingTimeoutException, RemotingSendRequestException, RemotingConnectException, MQClientException, UnsupportedEncodingException {
        List<String> invokeControllerServers;
        List<String> list = invokeControllerServers = controllerServers == null || controllerServers.isEmpty() ? this.remotingClient.getNameServerAddressList() : controllerServers;
        if (invokeControllerServers == null || invokeControllerServers.isEmpty()) {
            return null;
        }
        RemotingCommand request = RemotingCommand.createRequestCommand((int)1010, null);
        HashMap<String, Properties> configMap = new HashMap<String, Properties>(4);
        for (String controller : invokeControllerServers) {
            RemotingCommand response = this.remotingClient.invokeSync(controller, request, timeoutMillis);
            assert (response != null);
            if (0 == response.getCode()) {
                configMap.put(controller, MixAll.string2Properties((String)new String(response.getBody(), "UTF-8")));
                continue;
            }
            throw new MQClientException(response.getCode(), response.getRemark());
        }
        return configMap;
    }

    public void updateControllerConfig(Properties properties, List<String> controllers, long timeoutMillis) throws InterruptedException, RemotingConnectException, UnsupportedEncodingException, RemotingSendRequestException, RemotingTimeoutException, MQClientException {
        String str = MixAll.properties2String((Properties)properties);
        if (str.length() < 1 || controllers == null || controllers.isEmpty()) {
            return;
        }
        RemotingCommand request = RemotingCommand.createRequestCommand((int)1009, null);
        request.setBody(str.getBytes("UTF-8"));
        RemotingCommand errResponse = null;
        block3: for (String controller : controllers) {
            RemotingCommand response = this.remotingClient.invokeSync(controller, request, timeoutMillis);
            assert (response != null);
            switch (response.getCode()) {
                case 0: {
                    continue block3;
                }
            }
            errResponse = response;
        }
        if (errResponse != null) {
            throw new MQClientException(errResponse.getCode(), errResponse.getRemark());
        }
    }

    public ElectMasterResponseHeader electMaster(String controllerAddr, String clusterName, String brokerName, String brokerAddr) throws MQBrokerException, RemotingConnectException, RemotingSendRequestException, RemotingTimeoutException, InterruptedException, RemotingCommandException {
        GetMetaDataResponseHeader controllerMetaData = this.getControllerMetaData(controllerAddr);
        assert (controllerMetaData != null);
        assert (controllerMetaData.getControllerLeaderAddress() != null);
        String leaderAddress = controllerMetaData.getControllerLeaderAddress();
        ElectMasterRequestHeader electRequestHeader = new ElectMasterRequestHeader(clusterName, brokerName, brokerAddr);
        RemotingCommand request = RemotingCommand.createRequestCommand((int)1002, (CommandCustomHeader)electRequestHeader);
        RemotingCommand response = this.remotingClient.invokeSync(leaderAddress, request, 3000L);
        assert (response != null);
        switch (response.getCode()) {
            case 0: {
                BrokerMemberGroup brokerMemberGroup = (BrokerMemberGroup)RemotingSerializable.decode((byte[])response.getBody(), BrokerMemberGroup.class);
                ElectMasterResponseHeader responseHeader = (ElectMasterResponseHeader)response.decodeCommandCustomHeader(ElectMasterResponseHeader.class);
                if (null != responseHeader) {
                    responseHeader.setBrokerMemberGroup(brokerMemberGroup);
                }
                return responseHeader;
            }
        }
        throw new MQBrokerException(response.getCode(), response.getRemark());
    }

    public void cleanControllerBrokerData(String controllerAddr, String clusterName, String brokerName, String brokerAddr, boolean isCleanLivingBroker) throws RemotingException, InterruptedException, MQBrokerException {
        GetMetaDataResponseHeader controllerMetaData = this.getControllerMetaData(controllerAddr);
        assert (controllerMetaData != null);
        assert (controllerMetaData.getControllerLeaderAddress() != null);
        String leaderAddress = controllerMetaData.getControllerLeaderAddress();
        CleanControllerBrokerDataRequestHeader cleanHeader = new CleanControllerBrokerDataRequestHeader(clusterName, brokerName, brokerAddr, isCleanLivingBroker);
        RemotingCommand request = RemotingCommand.createRequestCommand((int)1011, (CommandCustomHeader)cleanHeader);
        RemotingCommand response = this.remotingClient.invokeSync(leaderAddress, request, 3000L);
        assert (response != null);
        switch (response.getCode()) {
            case 0: {
                return;
            }
        }
        throw new MQBrokerException(response.getCode(), response.getRemark());
    }

    static {
        System.setProperty("rocketmq.remoting.version", Integer.toString(MQVersion.CURRENT_VERSION));
    }
}

