/*
 * Decompiled with CFR 0.152.
 */
package org.apache.rocketmq.store.ha.io;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.SocketChannel;
import java.util.ArrayList;
import java.util.List;
import org.apache.rocketmq.logging.InternalLogger;
import org.apache.rocketmq.logging.InternalLoggerFactory;
import org.apache.rocketmq.store.ha.io.HAReadHook;

public abstract class AbstractHAReader {
    private static final InternalLogger LOGGER = InternalLoggerFactory.getLogger((String)"RocketmqStore");
    protected final List<HAReadHook> readHookList = new ArrayList<HAReadHook>();

    public boolean read(SocketChannel socketChannel, ByteBuffer byteBufferRead) {
        int readSizeZeroTimes = 0;
        while (byteBufferRead.hasRemaining()) {
            try {
                int readSize = socketChannel.read(byteBufferRead);
                for (HAReadHook readHook : this.readHookList) {
                    readHook.afterRead(readSize);
                }
                if (readSize > 0) {
                    readSizeZeroTimes = 0;
                    boolean result = this.processReadResult(byteBufferRead);
                    if (result) continue;
                    LOGGER.error("Process read result failed");
                    return false;
                }
                if (readSize == 0) {
                    if (++readSizeZeroTimes < 3) continue;
                    break;
                }
                LOGGER.info("Read socket < 0");
                return false;
            }
            catch (IOException e) {
                LOGGER.info("Read socket exception", (Throwable)e);
                return false;
            }
        }
        return true;
    }

    public void registerHook(HAReadHook readHook) {
        this.readHookList.add(readHook);
    }

    public void clearHook() {
        this.readHookList.clear();
    }

    protected abstract boolean processReadResult(ByteBuffer var1);
}

