/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ratis.server.impl;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.List;
import java.util.Objects;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.apache.ratis.proto.RaftProtos;
import org.apache.ratis.protocol.RaftPeer;
import org.apache.ratis.protocol.RaftPeerId;
import org.apache.ratis.server.RaftConfiguration;
import org.apache.ratis.server.impl.PeerConfiguration;
import org.apache.ratis.util.Preconditions;

final class RaftConfigurationImpl
implements RaftConfiguration {
    private final PeerConfiguration oldConf;
    private final PeerConfiguration conf;
    private final long logEntryIndex;

    static Builder newBuilder() {
        return new Builder();
    }

    private RaftConfigurationImpl(PeerConfiguration conf, PeerConfiguration oldConf, long logEntryIndex) {
        this.conf = Objects.requireNonNull(conf);
        this.oldConf = oldConf;
        this.logEntryIndex = logEntryIndex;
    }

    boolean isTransitional() {
        return this.oldConf != null;
    }

    boolean isStable() {
        return this.oldConf == null;
    }

    boolean containsInConf(RaftPeerId peerId, RaftProtos.RaftPeerRole ... roles) {
        if (roles == null || roles.length == 0) {
            return this.conf.contains(peerId);
        }
        if (roles.length == 1) {
            return this.conf.contains(peerId, roles[0]);
        }
        return this.conf.contains(peerId, EnumSet.of(roles[0], roles)) != null;
    }

    PeerConfiguration getConf() {
        return this.conf;
    }

    PeerConfiguration getOldConf() {
        return this.oldConf;
    }

    boolean isHighestPriority(RaftPeerId peerId) {
        RaftPeer target = this.getPeer(peerId, new RaftProtos.RaftPeerRole[0]);
        if (target == null) {
            return false;
        }
        Collection<RaftPeer> peers = this.getCurrentPeers();
        for (RaftPeer peer : peers) {
            if (peer.getPriority() <= target.getPriority() || peer.equals(target)) continue;
            return false;
        }
        return true;
    }

    boolean containsInOldConf(RaftPeerId peerId) {
        return this.oldConf != null && this.oldConf.contains(peerId);
    }

    boolean containsInBothConfs(RaftPeerId peerId) {
        return this.containsInConf(peerId, new RaftProtos.RaftPeerRole[0]) && (this.oldConf == null || this.containsInOldConf(peerId));
    }

    @Override
    public RaftPeer getPeer(RaftPeerId id, RaftProtos.RaftPeerRole ... roles) {
        if (id == null) {
            return null;
        }
        RaftPeer peer = this.conf.getPeer(id, roles);
        if (peer != null) {
            return peer;
        }
        if (this.oldConf != null) {
            return this.oldConf.getPeer(id, roles);
        }
        return null;
    }

    public List<RaftPeer> getAllPeers(RaftProtos.RaftPeerRole role) {
        ArrayList<RaftPeer> peers = new ArrayList<RaftPeer>(this.conf.getPeers(role));
        if (this.oldConf != null) {
            this.oldConf.getPeers(role).stream().filter(p -> !peers.contains(p)).forEach(peers::add);
        }
        return peers;
    }

    Collection<RaftPeer> getOtherPeers(RaftPeerId selfId) {
        List<RaftPeer> others = this.conf.getOtherPeers(selfId);
        if (this.oldConf != null) {
            this.oldConf.getOtherPeers(selfId).stream().filter(p -> !others.contains(p)).forEach(others::add);
        }
        return others;
    }

    boolean changeMajority(Collection<RaftPeer> newMembers) {
        Preconditions.assertNull((Object)this.oldConf, "oldConf");
        long newPeersCount = newMembers.stream().map(RaftPeer::getId).filter(id -> this.conf.getPeer((RaftPeerId)id, new RaftProtos.RaftPeerRole[0]) == null).count();
        if (this.conf.size() == 1 && newMembers.size() == 2 && newPeersCount == 1L) {
            return false;
        }
        long oldPeersCount = (long)newMembers.size() - newPeersCount;
        return newPeersCount >= oldPeersCount;
    }

    boolean isSingleMode(RaftPeerId selfId) {
        if (this.isStable()) {
            return this.conf.size() == 1;
        }
        return this.oldConf.size() == 1 && this.oldConf.contains(selfId) && this.conf.size() == 2 && this.conf.contains(selfId);
    }

    boolean hasMajority(Collection<RaftPeerId> others, RaftPeerId selfId) {
        Preconditions.assertTrue(!others.contains(selfId));
        return this.conf.hasMajority(others, selfId) && (this.oldConf == null || this.oldConf.hasMajority(others, selfId));
    }

    boolean hasMajority(Predicate<RaftPeerId> followers, RaftPeerId selfId) {
        boolean includeInCurrent = this.containsInConf(selfId, new RaftProtos.RaftPeerRole[0]);
        boolean hasMajorityInNewConf = this.conf.hasMajority(followers, includeInCurrent);
        if (!this.isTransitional()) {
            return hasMajorityInNewConf;
        }
        boolean includeInOldConf = this.containsInOldConf(selfId);
        boolean hasMajorityInOldConf = this.oldConf.hasMajority(followers, includeInOldConf);
        return hasMajorityInOldConf && hasMajorityInNewConf;
    }

    int getMajorityCount() {
        return this.conf.getMajorityCount();
    }

    boolean majorityRejectVotes(Collection<RaftPeerId> rejects) {
        return this.conf.majorityRejectVotes(rejects) || this.oldConf != null && this.oldConf.majorityRejectVotes(rejects);
    }

    boolean isSingleton() {
        return this.getCurrentPeers().size() == 1 && this.getPreviousPeers().size() <= 1;
    }

    public String toString() {
        return "conf: {index: " + this.logEntryIndex + ", cur=" + this.conf + ", old=" + this.oldConf + "}";
    }

    boolean hasNoChange(Collection<RaftPeer> newMembers, Collection<RaftPeer> newListeners) {
        RaftPeer inConf;
        if (!this.isStable() || this.conf.size() != newMembers.size() || this.conf.getPeers(RaftProtos.RaftPeerRole.LISTENER).size() != newListeners.size()) {
            return false;
        }
        for (RaftPeer peer : newMembers) {
            inConf = this.conf.getPeer(peer.getId(), new RaftProtos.RaftPeerRole[0]);
            if (inConf == null) {
                return false;
            }
            if (inConf.getPriority() == peer.getPriority()) continue;
            return false;
        }
        for (RaftPeer peer : newListeners) {
            inConf = this.conf.getPeer(peer.getId(), RaftProtos.RaftPeerRole.LISTENER);
            if (inConf == null) {
                return false;
            }
            if (inConf.getPriority() == peer.getPriority()) continue;
            return false;
        }
        return true;
    }

    @Override
    public long getLogEntryIndex() {
        return this.logEntryIndex;
    }

    Collection<RaftPeer> filterNotContainedInConf(List<RaftPeer> peers) {
        return peers.stream().filter(p -> !this.containsInConf(p.getId(), RaftProtos.RaftPeerRole.FOLLOWER, RaftProtos.RaftPeerRole.LISTENER)).collect(Collectors.toList());
    }

    @Override
    public Collection<RaftPeer> getPreviousPeers(RaftProtos.RaftPeerRole role) {
        return this.oldConf != null ? this.oldConf.getPeers(role) : Collections.emptyList();
    }

    @Override
    public Collection<RaftPeer> getCurrentPeers(RaftProtos.RaftPeerRole role) {
        return this.conf.getPeers(role);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || obj.getClass() != this.getClass()) {
            return false;
        }
        RaftConfigurationImpl that = (RaftConfigurationImpl)obj;
        return this.logEntryIndex == that.logEntryIndex && Objects.equals(this.conf, that.conf) && Objects.equals(this.oldConf, that.oldConf);
    }

    public int hashCode() {
        return Long.hashCode(this.logEntryIndex);
    }

    static final class Builder {
        private PeerConfiguration oldConf;
        private PeerConfiguration conf;
        private long logEntryIndex = -1L;
        private boolean forceStable = false;
        private boolean forceTransitional = false;

        private Builder() {
        }

        Builder setConf(PeerConfiguration conf) {
            Objects.requireNonNull(conf);
            Preconditions.assertTrue(this.conf == null, "conf is already set.");
            this.conf = conf;
            return this;
        }

        Builder setConf(Iterable<RaftPeer> peers) {
            return this.setConf(new PeerConfiguration(peers));
        }

        Builder setConf(Iterable<RaftPeer> peers, Iterable<RaftPeer> listeners) {
            return this.setConf(new PeerConfiguration(peers, listeners));
        }

        Builder setConf(RaftConfigurationImpl transitionalConf) {
            Objects.requireNonNull(transitionalConf);
            Preconditions.assertTrue(transitionalConf.isTransitional());
            Preconditions.assertTrue(!this.forceTransitional);
            this.forceStable = true;
            return this.setConf(transitionalConf.conf);
        }

        Builder setOldConf(PeerConfiguration oldConf) {
            Objects.requireNonNull(oldConf);
            Preconditions.assertTrue(this.oldConf == null, "oldConf is already set.");
            this.oldConf = oldConf;
            return this;
        }

        Builder setOldConf(Iterable<RaftPeer> oldPeers, Iterable<RaftPeer> oldListeners) {
            return this.setOldConf(new PeerConfiguration(oldPeers, oldListeners));
        }

        Builder setOldConf(RaftConfigurationImpl stableConf) {
            Objects.requireNonNull(stableConf);
            Preconditions.assertTrue(stableConf.isStable());
            Preconditions.assertTrue(!this.forceStable);
            this.forceTransitional = true;
            return this.setOldConf(stableConf.conf);
        }

        Builder setLogEntryIndex(long logEntryIndex) {
            Preconditions.assertTrue(logEntryIndex != -1L);
            Preconditions.assertTrue(this.logEntryIndex == -1L, "logEntryIndex is already set.");
            this.logEntryIndex = logEntryIndex;
            return this;
        }

        RaftConfigurationImpl build() {
            if (this.forceTransitional) {
                Preconditions.assertTrue(this.oldConf != null);
            }
            if (this.forceStable) {
                Preconditions.assertTrue(this.oldConf == null);
            }
            return new RaftConfigurationImpl(this.conf, this.oldConf, this.logEntryIndex);
        }
    }
}

