/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ratis.client.retry;

import org.apache.ratis.client.impl.RaftClientImpl;
import org.apache.ratis.protocol.RaftClientRequest;
import org.apache.ratis.retry.RetryPolicy;
import org.apache.ratis.thirdparty.com.google.common.annotations.VisibleForTesting;
import org.apache.ratis.util.JavaUtils;
import org.apache.ratis.util.TimeDuration;

public class ClientRetryEvent
implements RetryPolicy.Event {
    private final int attemptCount;
    private final int causeCount;
    private final RaftClientRequest request;
    private final Throwable cause;
    private RaftClientImpl.PendingClientRequest pending;

    @VisibleForTesting
    public ClientRetryEvent(int attemptCount, RaftClientRequest request, Throwable cause) {
        this(attemptCount, request, attemptCount, cause);
    }

    public ClientRetryEvent(RaftClientRequest request, Throwable t2, RaftClientImpl.PendingClientRequest pending) {
        this(pending.getAttemptCount(), request, pending.getExceptionCount(t2), t2);
        this.pending = pending;
    }

    private ClientRetryEvent(int attemptCount, RaftClientRequest request, int causeCount, Throwable cause) {
        this.attemptCount = attemptCount;
        this.causeCount = causeCount;
        this.request = request;
        this.cause = cause;
    }

    @Override
    public int getAttemptCount() {
        return this.attemptCount;
    }

    @Override
    public int getCauseCount() {
        return this.causeCount;
    }

    public RaftClientRequest getRequest() {
        return this.request;
    }

    @Override
    public Throwable getCause() {
        return this.cause;
    }

    boolean isRequestTimeout(TimeDuration timeout) {
        return this.pending != null && this.pending.isRequestTimeout(timeout);
    }

    public String toString() {
        return JavaUtils.getClassSimpleName(this.getClass()) + ":attempt=" + this.attemptCount + ",request=" + this.request + ",cause=" + this.cause;
    }
}

