/*
 * Decompiled with CFR 0.152.
 */
package net.sf.log4jdbc;

import java.sql.CallableStatement;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.List;
import net.sf.log4jdbc.ConnectionSpy;
import net.sf.log4jdbc.DriverSpy;
import net.sf.log4jdbc.ResultSetSpy;
import net.sf.log4jdbc.Spy;
import net.sf.log4jdbc.SpyLogDelegator;
import net.sf.log4jdbc.SpyLogFactory;
import net.sf.log4jdbc.Utilities;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class StatementSpy
implements Statement,
Spy {
    protected final SpyLogDelegator log;
    protected ConnectionSpy connectionSpy;
    protected Statement realStatement;
    private static final String StatementSqlWarning = "{WARNING: Statement used to run SQL} ";
    protected List currentBatch = new ArrayList();

    public Statement getRealStatement() {
        return this.realStatement;
    }

    public StatementSpy(ConnectionSpy connectionSpy, Statement realStatement) {
        if (realStatement == null) {
            throw new IllegalArgumentException("Must pass in a non null real Statement");
        }
        if (connectionSpy == null) {
            throw new IllegalArgumentException("Must pass in a non null ConnectionSpy");
        }
        this.realStatement = realStatement;
        this.connectionSpy = connectionSpy;
        this.log = SpyLogFactory.getSpyLogDelegator();
        if (realStatement instanceof CallableStatement) {
            this.reportReturn("new CallableStatement");
        } else if (realStatement instanceof PreparedStatement) {
            this.reportReturn("new PreparedStatement");
        } else {
            this.reportReturn("new Statement");
        }
    }

    @Override
    public String getClassType() {
        return "Statement";
    }

    @Override
    public Integer getConnectionNumber() {
        return this.connectionSpy.getConnectionNumber();
    }

    protected void reportException(String methodCall, SQLException exception, String sql, long execTime) {
        this.log.exceptionOccured(this, methodCall, exception, sql, execTime);
    }

    protected void reportException(String methodCall, SQLException exception, String sql) {
        this.log.exceptionOccured(this, methodCall, exception, sql, -1L);
    }

    protected void reportException(String methodCall, SQLException exception) {
        this.log.exceptionOccured(this, methodCall, exception, null, -1L);
    }

    protected void reportAllReturns(String methodCall, String msg) {
        this.log.methodReturned(this, methodCall, msg);
    }

    protected boolean reportReturn(String methodCall, boolean value) {
        this.reportAllReturns(methodCall, "" + value);
        return value;
    }

    protected byte reportReturn(String methodCall, byte value) {
        this.reportAllReturns(methodCall, "" + value);
        return value;
    }

    protected int reportReturn(String methodCall, int value) {
        this.reportAllReturns(methodCall, "" + value);
        return value;
    }

    protected double reportReturn(String methodCall, double value) {
        this.reportAllReturns(methodCall, "" + value);
        return value;
    }

    protected short reportReturn(String methodCall, short value) {
        this.reportAllReturns(methodCall, "" + value);
        return value;
    }

    protected long reportReturn(String methodCall, long value) {
        this.reportAllReturns(methodCall, "" + value);
        return value;
    }

    protected float reportReturn(String methodCall, float value) {
        this.reportAllReturns(methodCall, "" + value);
        return value;
    }

    protected Object reportReturn(String methodCall, Object value) {
        this.reportAllReturns(methodCall, "" + value);
        return value;
    }

    protected void reportReturn(String methodCall) {
        this.reportAllReturns(methodCall, "");
    }

    protected void reportStatementSql(String sql, String methodCall) {
        this._reportSql((DriverSpy.StatementUsageWarn ? StatementSqlWarning : "") + sql, methodCall);
    }

    protected void reportStatementSqlTiming(long execTime, String sql, String methodCall) {
        this._reportSqlTiming(execTime, (DriverSpy.StatementUsageWarn ? StatementSqlWarning : "") + sql, methodCall);
    }

    protected void reportSqlTiming(long execTime, String sql, String methodCall) {
        this._reportSqlTiming(execTime, sql, methodCall);
    }

    protected void reportSql(String sql, String methodCall) {
        this._reportSql(sql, methodCall);
    }

    private void _reportSql(String sql, String methodCall) {
        this.log.sqlOccured(this, methodCall, sql);
    }

    private void _reportSqlTiming(long execTime, String sql, String methodCall) {
        this.log.sqlTimingOccured(this, execTime, methodCall, sql);
    }

    @Override
    public SQLWarning getWarnings() throws SQLException {
        String methodCall = "getWarnings()";
        try {
            return (SQLWarning)this.reportReturn(methodCall, this.realStatement.getWarnings());
        }
        catch (SQLException s) {
            this.reportException(methodCall, s);
            throw s;
        }
    }

    @Override
    public int executeUpdate(String sql, String[] columnNames) throws SQLException {
        String methodCall = "executeUpdate(" + sql + ", " + columnNames + ")";
        this.reportStatementSql(sql, methodCall);
        long tstart = System.currentTimeMillis();
        try {
            int result = this.realStatement.executeUpdate(sql, columnNames);
            this.reportStatementSqlTiming(System.currentTimeMillis() - tstart, sql, methodCall);
            return this.reportReturn(methodCall, result);
        }
        catch (SQLException s) {
            this.reportException(methodCall, s, sql, System.currentTimeMillis() - tstart);
            throw s;
        }
    }

    @Override
    public boolean execute(String sql, String[] columnNames) throws SQLException {
        String methodCall = "execute(" + sql + ", " + columnNames + ")";
        this.reportStatementSql(sql, methodCall);
        long tstart = System.currentTimeMillis();
        try {
            boolean result = this.realStatement.execute(sql, columnNames);
            this.reportStatementSqlTiming(System.currentTimeMillis() - tstart, sql, methodCall);
            return this.reportReturn(methodCall, result);
        }
        catch (SQLException s) {
            this.reportException(methodCall, s, sql, System.currentTimeMillis() - tstart);
            throw s;
        }
    }

    @Override
    public void setMaxRows(int max) throws SQLException {
        String methodCall = "setMaxRows(" + max + ")";
        try {
            this.realStatement.setMaxRows(max);
        }
        catch (SQLException s) {
            this.reportException(methodCall, s);
            throw s;
        }
        this.reportReturn(methodCall);
    }

    @Override
    public boolean getMoreResults() throws SQLException {
        String methodCall = "getMoreResults()";
        try {
            return this.reportReturn(methodCall, this.realStatement.getMoreResults());
        }
        catch (SQLException s) {
            this.reportException(methodCall, s);
            throw s;
        }
    }

    @Override
    public void clearWarnings() throws SQLException {
        String methodCall = "clearWarnings()";
        try {
            this.realStatement.clearWarnings();
        }
        catch (SQLException s) {
            this.reportException(methodCall, s);
            throw s;
        }
        this.reportReturn(methodCall);
    }

    @Override
    public void addBatch(String sql) throws SQLException {
        String methodCall = "addBatch(" + sql + ")";
        this.currentBatch.add(StatementSqlWarning + sql);
        try {
            this.realStatement.addBatch(sql);
        }
        catch (SQLException s) {
            this.reportException(methodCall, s);
            throw s;
        }
        this.reportReturn(methodCall);
    }

    @Override
    public int getResultSetType() throws SQLException {
        String methodCall = "getResultSetType()";
        try {
            return this.reportReturn(methodCall, this.realStatement.getResultSetType());
        }
        catch (SQLException s) {
            this.reportException(methodCall, s);
            throw s;
        }
    }

    @Override
    public void clearBatch() throws SQLException {
        String methodCall = "clearBatch()";
        try {
            this.realStatement.clearBatch();
        }
        catch (SQLException s) {
            this.reportException(methodCall, s);
            throw s;
        }
        this.currentBatch.clear();
        this.reportReturn(methodCall);
    }

    @Override
    public void setFetchDirection(int direction) throws SQLException {
        String methodCall = "setFetchDirection(" + direction + ")";
        try {
            this.realStatement.setFetchDirection(direction);
        }
        catch (SQLException s) {
            this.reportException(methodCall, s);
            throw s;
        }
        this.reportReturn(methodCall);
    }

    @Override
    public int[] executeBatch() throws SQLException {
        int[] updateResults;
        String sql;
        String methodCall = "executeBatch()";
        int j = this.currentBatch.size();
        StringBuffer batchReport = new StringBuffer("batching " + j + " statements:");
        int fieldSize = ("" + j).length();
        int i = 0;
        while (i < j) {
            sql = (String)this.currentBatch.get(i);
            batchReport.append("\n");
            batchReport.append(Utilities.rightJustify(fieldSize, "" + ++i));
            batchReport.append(":  ");
            batchReport.append(sql);
        }
        sql = batchReport.toString();
        this.reportSql(sql, methodCall);
        long tstart = System.currentTimeMillis();
        try {
            updateResults = this.realStatement.executeBatch();
            this.reportSqlTiming(System.currentTimeMillis() - tstart, sql, methodCall);
        }
        catch (SQLException s) {
            this.reportException(methodCall, s, sql, System.currentTimeMillis() - tstart);
            throw s;
        }
        this.currentBatch.clear();
        return (int[])this.reportReturn(methodCall, updateResults);
    }

    @Override
    public void setFetchSize(int rows) throws SQLException {
        String methodCall = "setFetchSize(" + rows + ")";
        try {
            this.realStatement.setFetchSize(rows);
        }
        catch (SQLException s) {
            this.reportException(methodCall, s);
            throw s;
        }
        this.reportReturn(methodCall);
    }

    @Override
    public int getQueryTimeout() throws SQLException {
        String methodCall = "getQueryTimeout()";
        try {
            return this.reportReturn(methodCall, this.realStatement.getQueryTimeout());
        }
        catch (SQLException s) {
            this.reportException(methodCall, s);
            throw s;
        }
    }

    @Override
    public Connection getConnection() throws SQLException {
        String methodCall = "getConnection()";
        return (Connection)this.reportReturn(methodCall, this.connectionSpy);
    }

    @Override
    public ResultSet getGeneratedKeys() throws SQLException {
        String methodCall = "getGeneratedKeys()";
        try {
            ResultSet r = this.realStatement.getGeneratedKeys();
            if (r == null) {
                return (ResultSet)this.reportReturn(methodCall, r);
            }
            return (ResultSet)this.reportReturn(methodCall, new ResultSetSpy(this, r));
        }
        catch (SQLException s) {
            if (!DriverSpy.SuppressGetGeneratedKeysException) {
                this.reportException(methodCall, s);
            }
            throw s;
        }
    }

    @Override
    public void setEscapeProcessing(boolean enable) throws SQLException {
        String methodCall = "setEscapeProcessing(" + enable + ")";
        try {
            this.realStatement.setEscapeProcessing(enable);
        }
        catch (SQLException s) {
            this.reportException(methodCall, s);
            throw s;
        }
        this.reportReturn(methodCall);
    }

    @Override
    public int getFetchDirection() throws SQLException {
        String methodCall = "getFetchDirection()";
        try {
            return this.reportReturn(methodCall, this.realStatement.getFetchDirection());
        }
        catch (SQLException s) {
            this.reportException(methodCall, s);
            throw s;
        }
    }

    @Override
    public void setQueryTimeout(int seconds) throws SQLException {
        String methodCall = "setQueryTimeout(" + seconds + ")";
        try {
            this.realStatement.setQueryTimeout(seconds);
        }
        catch (SQLException s) {
            this.reportException(methodCall, s);
            throw s;
        }
        this.reportReturn(methodCall);
    }

    @Override
    public boolean getMoreResults(int current) throws SQLException {
        String methodCall = "getMoreResults(" + current + ")";
        try {
            return this.reportReturn(methodCall, this.realStatement.getMoreResults(current));
        }
        catch (SQLException s) {
            this.reportException(methodCall, s);
            throw s;
        }
    }

    @Override
    public ResultSet executeQuery(String sql) throws SQLException {
        String methodCall = "executeQuery(" + sql + ")";
        this.reportStatementSql(sql, methodCall);
        long tstart = System.currentTimeMillis();
        try {
            ResultSet result = this.realStatement.executeQuery(sql);
            this.reportStatementSqlTiming(System.currentTimeMillis() - tstart, sql, methodCall);
            ResultSetSpy r = new ResultSetSpy(this, result);
            return (ResultSet)this.reportReturn(methodCall, r);
        }
        catch (SQLException s) {
            this.reportException(methodCall, s, sql, System.currentTimeMillis() - tstart);
            throw s;
        }
    }

    @Override
    public int getMaxFieldSize() throws SQLException {
        String methodCall = "getMaxFieldSize()";
        try {
            return this.reportReturn(methodCall, this.realStatement.getMaxFieldSize());
        }
        catch (SQLException s) {
            this.reportException(methodCall, s);
            throw s;
        }
    }

    @Override
    public int executeUpdate(String sql) throws SQLException {
        String methodCall = "executeUpdate(" + sql + ")";
        this.reportStatementSql(sql, methodCall);
        long tstart = System.currentTimeMillis();
        try {
            int result = this.realStatement.executeUpdate(sql);
            this.reportStatementSqlTiming(System.currentTimeMillis() - tstart, sql, methodCall);
            return this.reportReturn(methodCall, result);
        }
        catch (SQLException s) {
            this.reportException(methodCall, s, sql, System.currentTimeMillis() - tstart);
            throw s;
        }
    }

    @Override
    public void cancel() throws SQLException {
        String methodCall = "cancel()";
        try {
            this.realStatement.cancel();
        }
        catch (SQLException s) {
            this.reportException(methodCall, s);
            throw s;
        }
        this.reportReturn(methodCall);
    }

    @Override
    public void setCursorName(String name) throws SQLException {
        String methodCall = "setCursorName(" + name + ")";
        try {
            this.realStatement.setCursorName(name);
        }
        catch (SQLException s) {
            this.reportException(methodCall, s);
            throw s;
        }
        this.reportReturn(methodCall);
    }

    @Override
    public int getFetchSize() throws SQLException {
        String methodCall = "getFetchSize()";
        try {
            return this.reportReturn(methodCall, this.realStatement.getFetchSize());
        }
        catch (SQLException s) {
            this.reportException(methodCall, s);
            throw s;
        }
    }

    @Override
    public int getResultSetConcurrency() throws SQLException {
        String methodCall = "getResultSetConcurrency()";
        try {
            return this.reportReturn(methodCall, this.realStatement.getResultSetConcurrency());
        }
        catch (SQLException s) {
            this.reportException(methodCall, s);
            throw s;
        }
    }

    @Override
    public int getResultSetHoldability() throws SQLException {
        String methodCall = "getResultSetHoldability()";
        try {
            return this.reportReturn(methodCall, this.realStatement.getResultSetHoldability());
        }
        catch (SQLException s) {
            this.reportException(methodCall, s);
            throw s;
        }
    }

    @Override
    public boolean isClosed() throws SQLException {
        String methodCall = "isClosed()";
        try {
            return this.reportReturn(methodCall, this.realStatement.isClosed());
        }
        catch (SQLException s) {
            this.reportException(methodCall, s);
            throw s;
        }
    }

    @Override
    public void setPoolable(boolean poolable) throws SQLException {
        String methodCall = "setPoolable(" + poolable + ")";
        try {
            this.realStatement.setPoolable(poolable);
        }
        catch (SQLException s) {
            this.reportException(methodCall, s);
            throw s;
        }
        this.reportReturn(methodCall);
    }

    @Override
    public boolean isPoolable() throws SQLException {
        String methodCall = "isPoolable()";
        try {
            return this.reportReturn(methodCall, this.realStatement.isPoolable());
        }
        catch (SQLException s) {
            this.reportException(methodCall, s);
            throw s;
        }
    }

    @Override
    public void setMaxFieldSize(int max) throws SQLException {
        String methodCall = "setMaxFieldSize(" + max + ")";
        try {
            this.realStatement.setMaxFieldSize(max);
        }
        catch (SQLException s) {
            this.reportException(methodCall, s);
            throw s;
        }
        this.reportReturn(methodCall);
    }

    @Override
    public boolean execute(String sql) throws SQLException {
        String methodCall = "execute(" + sql + ")";
        this.reportStatementSql(sql, methodCall);
        long tstart = System.currentTimeMillis();
        try {
            boolean result = this.realStatement.execute(sql);
            this.reportStatementSqlTiming(System.currentTimeMillis() - tstart, sql, methodCall);
            return this.reportReturn(methodCall, result);
        }
        catch (SQLException s) {
            this.reportException(methodCall, s, sql, System.currentTimeMillis() - tstart);
            throw s;
        }
    }

    @Override
    public int executeUpdate(String sql, int autoGeneratedKeys) throws SQLException {
        String methodCall = "executeUpdate(" + sql + ", " + autoGeneratedKeys + ")";
        this.reportStatementSql(sql, methodCall);
        long tstart = System.currentTimeMillis();
        try {
            int result = this.realStatement.executeUpdate(sql, autoGeneratedKeys);
            this.reportStatementSqlTiming(System.currentTimeMillis() - tstart, sql, methodCall);
            return this.reportReturn(methodCall, result);
        }
        catch (SQLException s) {
            this.reportException(methodCall, s, sql, System.currentTimeMillis() - tstart);
            throw s;
        }
    }

    @Override
    public boolean execute(String sql, int autoGeneratedKeys) throws SQLException {
        String methodCall = "execute(" + sql + ", " + autoGeneratedKeys + ")";
        this.reportStatementSql(sql, methodCall);
        long tstart = System.currentTimeMillis();
        try {
            boolean result = this.realStatement.execute(sql, autoGeneratedKeys);
            this.reportStatementSqlTiming(System.currentTimeMillis() - tstart, sql, methodCall);
            return this.reportReturn(methodCall, result);
        }
        catch (SQLException s) {
            this.reportException(methodCall, s, sql, System.currentTimeMillis() - tstart);
            throw s;
        }
    }

    @Override
    public int executeUpdate(String sql, int[] columnIndexes) throws SQLException {
        String methodCall = "executeUpdate(" + sql + ", " + columnIndexes + ")";
        this.reportStatementSql(sql, methodCall);
        long tstart = System.currentTimeMillis();
        try {
            int result = this.realStatement.executeUpdate(sql, columnIndexes);
            this.reportStatementSqlTiming(System.currentTimeMillis() - tstart, sql, methodCall);
            return this.reportReturn(methodCall, result);
        }
        catch (SQLException s) {
            this.reportException(methodCall, s, sql, System.currentTimeMillis() - tstart);
            throw s;
        }
    }

    @Override
    public boolean execute(String sql, int[] columnIndexes) throws SQLException {
        String methodCall = "execute(" + sql + ", " + columnIndexes + ")";
        this.reportStatementSql(sql, methodCall);
        long tstart = System.currentTimeMillis();
        try {
            boolean result = this.realStatement.execute(sql, columnIndexes);
            this.reportStatementSqlTiming(System.currentTimeMillis() - tstart, sql, methodCall);
            return this.reportReturn(methodCall, result);
        }
        catch (SQLException s) {
            this.reportException(methodCall, s, sql, System.currentTimeMillis() - tstart);
            throw s;
        }
    }

    @Override
    public ResultSet getResultSet() throws SQLException {
        String methodCall = "getResultSet()";
        try {
            ResultSet r = this.realStatement.getResultSet();
            if (r == null) {
                return (ResultSet)this.reportReturn(methodCall, r);
            }
            return (ResultSet)this.reportReturn(methodCall, new ResultSetSpy(this, r));
        }
        catch (SQLException s) {
            this.reportException(methodCall, s);
            throw s;
        }
    }

    @Override
    public int getMaxRows() throws SQLException {
        String methodCall = "getMaxRows()";
        try {
            return this.reportReturn(methodCall, this.realStatement.getMaxRows());
        }
        catch (SQLException s) {
            this.reportException(methodCall, s);
            throw s;
        }
    }

    @Override
    public void close() throws SQLException {
        String methodCall = "close()";
        try {
            this.realStatement.close();
        }
        catch (SQLException s) {
            this.reportException(methodCall, s);
            throw s;
        }
        this.reportReturn(methodCall);
    }

    @Override
    public int getUpdateCount() throws SQLException {
        String methodCall = "getUpdateCount()";
        try {
            return this.reportReturn(methodCall, this.realStatement.getUpdateCount());
        }
        catch (SQLException s) {
            this.reportException(methodCall, s);
            throw s;
        }
    }

    @Override
    public <T> T unwrap(Class<T> iface) throws SQLException {
        String methodCall = "unwrap(" + (iface == null ? "null" : iface.getName()) + ")";
        try {
            return (T)this.reportReturn(methodCall, iface != null && (iface == Connection.class || iface == Spy.class) ? this : this.realStatement.unwrap(iface));
        }
        catch (SQLException s) {
            this.reportException(methodCall, s);
            throw s;
        }
    }

    @Override
    public boolean isWrapperFor(Class<?> iface) throws SQLException {
        String methodCall = "isWrapperFor(" + (iface == null ? "null" : iface.getName()) + ")";
        try {
            return this.reportReturn(methodCall, iface != null && (iface == Statement.class || iface == Spy.class) || this.realStatement.isWrapperFor(iface));
        }
        catch (SQLException s) {
            this.reportException(methodCall, s);
            throw s;
        }
    }
}

