/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.management.network.implementation;

import com.microsoft.azure.management.apigeneration.LangDefinition;
import com.microsoft.azure.management.network.ApplicationGatewayBackend;
import com.microsoft.azure.management.network.IPAllocationMethod;
import com.microsoft.azure.management.network.IPVersion;
import com.microsoft.azure.management.network.LoadBalancer;
import com.microsoft.azure.management.network.LoadBalancerBackend;
import com.microsoft.azure.management.network.LoadBalancerInboundNatRule;
import com.microsoft.azure.management.network.Network;
import com.microsoft.azure.management.network.NetworkSecurityGroup;
import com.microsoft.azure.management.network.NicIPConfigurationBase;
import com.microsoft.azure.management.network.Subnet;
import com.microsoft.azure.management.network.implementation.BackendAddressPoolInner;
import com.microsoft.azure.management.network.implementation.InboundNatRuleInner;
import com.microsoft.azure.management.network.implementation.NetworkInterfaceIPConfigurationInner;
import com.microsoft.azure.management.network.implementation.NetworkManager;
import com.microsoft.azure.management.network.implementation.SubnetInner;
import com.microsoft.azure.management.resources.fluentcore.arm.ResourceUtils;
import com.microsoft.azure.management.resources.fluentcore.arm.models.HasManager;
import com.microsoft.azure.management.resources.fluentcore.arm.models.implementation.ChildResourceImpl;
import com.microsoft.azure.management.resources.fluentcore.utils.Utils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;

@LangDefinition
abstract class NicIPConfigurationBaseImpl<ParentImplT extends ParentT, ParentT extends HasManager<NetworkManager>>
extends ChildResourceImpl<NetworkInterfaceIPConfigurationInner, ParentImplT, ParentT>
implements NicIPConfigurationBase {
    private final NetworkManager networkManager;

    protected NicIPConfigurationBaseImpl(NetworkInterfaceIPConfigurationInner inner, ParentImplT parent, NetworkManager networkManager) {
        super((Object)inner, parent);
        this.networkManager = networkManager;
    }

    public String name() {
        return ((NetworkInterfaceIPConfigurationInner)((Object)this.inner())).name();
    }

    @Override
    public boolean isPrimary() {
        return Utils.toPrimitiveBoolean((Boolean)((NetworkInterfaceIPConfigurationInner)((Object)this.inner())).primary());
    }

    @Override
    public NetworkSecurityGroup getNetworkSecurityGroup() {
        Network network = this.getNetwork();
        if (network == null) {
            return null;
        }
        String subnetName = this.subnetName();
        if (subnetName == null) {
            return null;
        }
        Subnet subnet = network.subnets().get(subnetName);
        if (subnet == null) {
            return null;
        }
        return subnet.getNetworkSecurityGroup();
    }

    @Override
    public String privateIPAddress() {
        return ((NetworkInterfaceIPConfigurationInner)((Object)this.inner())).privateIPAddress();
    }

    @Override
    public IPAllocationMethod privateIPAllocationMethod() {
        return ((NetworkInterfaceIPConfigurationInner)((Object)this.inner())).privateIPAllocationMethod();
    }

    @Override
    public IPVersion privateIPAddressVersion() {
        return ((NetworkInterfaceIPConfigurationInner)((Object)this.inner())).privateIPAddressVersion();
    }

    public String networkId() {
        SubnetInner subnetRef = ((NetworkInterfaceIPConfigurationInner)((Object)this.inner())).subnet();
        if (subnetRef == null) {
            return null;
        }
        return ResourceUtils.parentResourceIdFromResourceId((String)subnetRef.id());
    }

    @Override
    public Network getNetwork() {
        String id = this.networkId();
        if (id == null) {
            return null;
        }
        return (Network)this.networkManager.networks().getById(id);
    }

    public String subnetName() {
        SubnetInner subnetRef = ((NetworkInterfaceIPConfigurationInner)((Object)this.inner())).subnet();
        if (subnetRef == null) {
            return null;
        }
        return ResourceUtils.nameFromResourceId((String)subnetRef.id());
    }

    @Override
    public Collection<ApplicationGatewayBackend> listAssociatedApplicationGatewayBackends() {
        return ((NetworkManager)((Object)((HasManager)this.parent()).manager())).listAssociatedApplicationGatewayBackends(((NetworkInterfaceIPConfigurationInner)((Object)this.inner())).applicationGatewayBackendAddressPools());
    }

    @Override
    public List<LoadBalancerBackend> listAssociatedLoadBalancerBackends() {
        List<BackendAddressPoolInner> backendRefs = ((NetworkInterfaceIPConfigurationInner)((Object)this.inner())).loadBalancerBackendAddressPools();
        if (backendRefs == null) {
            return Collections.unmodifiableList(new ArrayList());
        }
        HashMap<String, LoadBalancer> loadBalancers = new HashMap<String, LoadBalancer>();
        ArrayList<LoadBalancerBackend> backends = new ArrayList<LoadBalancerBackend>();
        for (BackendAddressPoolInner backendRef : backendRefs) {
            String loadBalancerId = ResourceUtils.parentResourceIdFromResourceId((String)backendRef.id());
            LoadBalancer loadBalancer = (LoadBalancer)loadBalancers.get(loadBalancerId.toLowerCase());
            if (loadBalancer == null) {
                loadBalancer = (LoadBalancer)this.networkManager.loadBalancers().getById(loadBalancerId);
                loadBalancers.put(loadBalancerId.toLowerCase(), loadBalancer);
            }
            String backendName = ResourceUtils.nameFromResourceId((String)backendRef.id());
            backends.add(loadBalancer.backends().get(backendName));
        }
        return Collections.unmodifiableList(backends);
    }

    @Override
    public List<LoadBalancerInboundNatRule> listAssociatedLoadBalancerInboundNatRules() {
        List<InboundNatRuleInner> inboundNatPoolRefs = ((NetworkInterfaceIPConfigurationInner)((Object)this.inner())).loadBalancerInboundNatRules();
        if (inboundNatPoolRefs == null) {
            return Collections.unmodifiableList(new ArrayList());
        }
        HashMap<String, LoadBalancer> loadBalancers = new HashMap<String, LoadBalancer>();
        ArrayList<LoadBalancerInboundNatRule> rules = new ArrayList<LoadBalancerInboundNatRule>();
        for (InboundNatRuleInner ref : inboundNatPoolRefs) {
            String loadBalancerId = ResourceUtils.parentResourceIdFromResourceId((String)ref.id());
            LoadBalancer loadBalancer = (LoadBalancer)loadBalancers.get(loadBalancerId.toLowerCase());
            if (loadBalancer == null) {
                loadBalancer = (LoadBalancer)this.networkManager.loadBalancers().getById(loadBalancerId);
                loadBalancers.put(loadBalancerId.toLowerCase(), loadBalancer);
            }
            String ruleName = ResourceUtils.nameFromResourceId((String)ref.id());
            rules.add(loadBalancer.inboundNatRules().get(ruleName));
        }
        return Collections.unmodifiableList(rules);
    }
}

