/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.management.eventhub.implementation;

import com.microsoft.azure.Page;
import com.microsoft.azure.PagedList;
import com.microsoft.azure.management.apigeneration.LangDefinition;
import com.microsoft.azure.management.eventhub.EventHubAuthorizationRule;
import com.microsoft.azure.management.eventhub.EventHubAuthorizationRules;
import com.microsoft.azure.management.eventhub.implementation.AuthorizationRuleInner;
import com.microsoft.azure.management.eventhub.implementation.AuthorizationRulesBaseImpl;
import com.microsoft.azure.management.eventhub.implementation.EventHubAuthorizationRuleImpl;
import com.microsoft.azure.management.eventhub.implementation.EventHubManagementClientImpl;
import com.microsoft.azure.management.eventhub.implementation.EventHubManager;
import com.microsoft.azure.management.eventhub.implementation.EventHubsInner;
import com.microsoft.azure.management.resources.fluentcore.arm.ResourceId;
import com.microsoft.azure.management.resources.fluentcore.utils.PagedListConverter;
import java.util.Objects;
import rx.Completable;
import rx.Observable;
import rx.functions.Func1;

@LangDefinition
class EventHubAuthorizationRulesImpl
extends AuthorizationRulesBaseImpl<EventHubsInner, EventHubAuthorizationRule, EventHubAuthorizationRuleImpl>
implements EventHubAuthorizationRules {
    EventHubAuthorizationRulesImpl(EventHubManager manager) {
        super(manager, ((EventHubManagementClientImpl)((Object)manager.inner())).eventHubs());
    }

    public EventHubAuthorizationRuleImpl define(String name) {
        return new EventHubAuthorizationRuleImpl(name, this.manager);
    }

    @Override
    public Observable<EventHubAuthorizationRule> getByIdAsync(String id) {
        Objects.requireNonNull(id);
        ResourceId resourceId = ResourceId.fromString((String)id);
        return this.getByNameAsync(resourceId.resourceGroupName(), resourceId.parent().parent().name(), resourceId.parent().name(), resourceId.name());
    }

    @Override
    public EventHubAuthorizationRule getByName(String resourceGroupName, String namespaceName, String eventHubName, String name) {
        return (EventHubAuthorizationRule)this.getByNameAsync(resourceGroupName, namespaceName, eventHubName, name).toBlocking().last();
    }

    @Override
    public Observable<EventHubAuthorizationRule> getByNameAsync(String resourceGroupName, String namespaceName, String eventHubName, String name) {
        return ((EventHubsInner)this.inner()).getAuthorizationRuleAsync(resourceGroupName, namespaceName, eventHubName, name).map((Func1)new Func1<AuthorizationRuleInner, EventHubAuthorizationRule>(){

            public EventHubAuthorizationRule call(AuthorizationRuleInner inner) {
                if (inner == null) {
                    return null;
                }
                return EventHubAuthorizationRulesImpl.this.wrapModel(inner);
            }
        });
    }

    @Override
    public PagedList<EventHubAuthorizationRule> listByEventHub(String resourceGroupName, String namespaceName, String eventHubName) {
        return new PagedListConverter<AuthorizationRuleInner, EventHubAuthorizationRule>(){

            public Observable<EventHubAuthorizationRule> typeConvertAsync(AuthorizationRuleInner inner) {
                return Observable.just((Object)EventHubAuthorizationRulesImpl.this.wrapModel(inner));
            }
        }.convert(((EventHubsInner)this.inner()).listAuthorizationRules(resourceGroupName, namespaceName, eventHubName));
    }

    @Override
    public Observable<EventHubAuthorizationRule> listByEventHubAsync(String resourceGroupName, String namespaceName, String eventHubName) {
        return ((EventHubsInner)this.inner()).listAuthorizationRulesAsync(resourceGroupName, namespaceName, eventHubName).flatMapIterable((Func1)new Func1<Page<AuthorizationRuleInner>, Iterable<AuthorizationRuleInner>>(){

            public Iterable<AuthorizationRuleInner> call(Page<AuthorizationRuleInner> page) {
                return page.items();
            }
        }).map((Func1)new Func1<AuthorizationRuleInner, EventHubAuthorizationRule>(){

            public EventHubAuthorizationRule call(AuthorizationRuleInner inner) {
                return EventHubAuthorizationRulesImpl.this.wrapModel(inner);
            }
        });
    }

    @Override
    public Completable deleteByIdAsync(String id) {
        Objects.requireNonNull(id);
        ResourceId resourceId = ResourceId.fromString((String)id);
        return this.deleteByNameAsync(resourceId.resourceGroupName(), resourceId.parent().parent().name(), resourceId.parent().name(), resourceId.name());
    }

    @Override
    public Completable deleteByNameAsync(String resourceGroupName, String namespaceName, String eventHubName, String name) {
        return ((EventHubsInner)this.inner()).deleteAuthorizationRuleAsync(resourceGroupName, namespaceName, eventHubName, name).toCompletable();
    }

    @Override
    public void deleteByName(String resourceGroupName, String namespaceName, String eventHubName, String name) {
        this.deleteByNameAsync(resourceGroupName, namespaceName, eventHubName, name).await();
    }

    @Override
    protected EventHubAuthorizationRuleImpl wrapModel(AuthorizationRuleInner innerModel) {
        return new EventHubAuthorizationRuleImpl(innerModel.name(), innerModel, this.manager);
    }
}

