/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.management.redis.implementation;

import com.microsoft.azure.PagedList;
import com.microsoft.azure.Resource;
import com.microsoft.azure.management.apigeneration.LangDefinition;
import com.microsoft.azure.management.apigeneration.Method;
import com.microsoft.azure.management.redis.DayOfWeek;
import com.microsoft.azure.management.redis.ExportRDBParameters;
import com.microsoft.azure.management.redis.ImportRDBParameters;
import com.microsoft.azure.management.redis.ProvisioningState;
import com.microsoft.azure.management.redis.RebootType;
import com.microsoft.azure.management.redis.RedisAccessKeys;
import com.microsoft.azure.management.redis.RedisCache;
import com.microsoft.azure.management.redis.RedisCachePremium;
import com.microsoft.azure.management.redis.RedisCreateParameters;
import com.microsoft.azure.management.redis.RedisFirewallRule;
import com.microsoft.azure.management.redis.RedisKeyType;
import com.microsoft.azure.management.redis.RedisLinkedServerCreateParameters;
import com.microsoft.azure.management.redis.RedisRebootParameters;
import com.microsoft.azure.management.redis.RedisUpdateParameters;
import com.microsoft.azure.management.redis.ReplicationRole;
import com.microsoft.azure.management.redis.ScheduleEntry;
import com.microsoft.azure.management.redis.Sku;
import com.microsoft.azure.management.redis.SkuFamily;
import com.microsoft.azure.management.redis.SkuName;
import com.microsoft.azure.management.redis.TlsVersion;
import com.microsoft.azure.management.redis.implementation.RedisAccessKeysImpl;
import com.microsoft.azure.management.redis.implementation.RedisAccessKeysInner;
import com.microsoft.azure.management.redis.implementation.RedisFirewallRuleImpl;
import com.microsoft.azure.management.redis.implementation.RedisFirewallRuleInner;
import com.microsoft.azure.management.redis.implementation.RedisFirewallRulesImpl;
import com.microsoft.azure.management.redis.implementation.RedisLinkedServerWithPropertiesInner;
import com.microsoft.azure.management.redis.implementation.RedisManagementClientImpl;
import com.microsoft.azure.management.redis.implementation.RedisManager;
import com.microsoft.azure.management.redis.implementation.RedisPatchScheduleImpl;
import com.microsoft.azure.management.redis.implementation.RedisPatchScheduleInner;
import com.microsoft.azure.management.redis.implementation.RedisPatchSchedulesImpl;
import com.microsoft.azure.management.redis.implementation.RedisResourceInner;
import com.microsoft.azure.management.resources.fluentcore.arm.ResourceUtils;
import com.microsoft.azure.management.resources.fluentcore.arm.implementation.ManagerBase;
import com.microsoft.azure.management.resources.fluentcore.arm.models.HasId;
import com.microsoft.azure.management.resources.fluentcore.arm.models.implementation.GroupableResourceImpl;
import com.microsoft.azure.management.resources.fluentcore.model.implementation.IndexableRefreshableWrapperImpl;
import com.microsoft.azure.management.resources.fluentcore.utils.SdkContext;
import com.microsoft.azure.management.resources.fluentcore.utils.Utils;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import org.joda.time.Period;
import rx.Completable;
import rx.Observable;
import rx.functions.Action1;
import rx.functions.Func1;

@LangDefinition
class RedisCacheImpl
extends GroupableResourceImpl<RedisCache, RedisResourceInner, RedisCacheImpl, RedisManager>
implements RedisCache,
RedisCachePremium,
RedisCache.Definition,
RedisCache.Update {
    private RedisAccessKeys cachedAccessKeys;
    private RedisCreateParameters createParameters = new RedisCreateParameters();
    private RedisUpdateParameters updateParameters;
    private RedisPatchSchedulesImpl patchSchedules = new RedisPatchSchedulesImpl(this);
    private RedisFirewallRulesImpl firewallRules = new RedisFirewallRulesImpl(this);
    private boolean patchScheduleAdded;

    RedisCacheImpl(String name, RedisResourceInner innerModel, RedisManager redisManager) {
        super(name, (Resource)innerModel, (ManagerBase)redisManager);
        this.patchSchedules.enablePostRunMode();
        this.firewallRules.enablePostRunMode();
        this.patchScheduleAdded = false;
    }

    @Override
    public Map<String, RedisFirewallRule> firewallRules() {
        return this.firewallRules.rulesAsMap();
    }

    @Override
    public List<ScheduleEntry> patchSchedules() {
        List<ScheduleEntry> patchSchedules = this.listPatchSchedules();
        if (patchSchedules == null) {
            return new ArrayList<ScheduleEntry>();
        }
        return patchSchedules;
    }

    @Override
    public List<ScheduleEntry> listPatchSchedules() {
        RedisPatchScheduleImpl patchSchedule = this.patchSchedules.getPatchSchedule();
        if (patchSchedule == null) {
            return null;
        }
        return patchSchedule.scheduleEntries();
    }

    @Override
    public String provisioningState() {
        return ((RedisResourceInner)((Object)this.inner())).provisioningState().toString();
    }

    @Override
    public String hostName() {
        return ((RedisResourceInner)((Object)this.inner())).hostName();
    }

    @Override
    public int port() {
        return Utils.toPrimitiveInt((Integer)((RedisResourceInner)((Object)this.inner())).port());
    }

    @Override
    public int sslPort() {
        return Utils.toPrimitiveInt((Integer)((RedisResourceInner)((Object)this.inner())).sslPort());
    }

    @Override
    public String redisVersion() {
        return ((RedisResourceInner)((Object)this.inner())).redisVersion();
    }

    @Override
    public Sku sku() {
        return ((RedisResourceInner)((Object)this.inner())).sku();
    }

    @Override
    public boolean nonSslPort() {
        return ((RedisResourceInner)((Object)this.inner())).enableNonSslPort();
    }

    @Override
    public int shardCount() {
        return Utils.toPrimitiveInt((Integer)((RedisResourceInner)((Object)this.inner())).shardCount());
    }

    @Override
    public String subnetId() {
        return ((RedisResourceInner)((Object)this.inner())).subnetId();
    }

    @Override
    public String staticIP() {
        return ((RedisResourceInner)((Object)this.inner())).staticIP();
    }

    @Override
    public TlsVersion minimumTlsVersion() {
        return ((RedisResourceInner)((Object)this.inner())).minimumTlsVersion();
    }

    @Override
    public Map<String, String> redisConfiguration() {
        return Collections.unmodifiableMap(((RedisResourceInner)((Object)this.inner())).redisConfiguration());
    }

    @Override
    @Method
    public RedisCachePremium asPremium() {
        if (this.isPremium()) {
            return this;
        }
        return null;
    }

    @Override
    public boolean isPremium() {
        return this.sku().name().equals((Object)SkuName.PREMIUM);
    }

    @Override
    public RedisAccessKeys keys() {
        if (this.cachedAccessKeys == null) {
            this.cachedAccessKeys = this.refreshKeys();
        }
        return this.cachedAccessKeys;
    }

    @Override
    public RedisAccessKeys getKeys() {
        return this.refreshKeys();
    }

    @Override
    public RedisAccessKeys refreshKeys() {
        RedisAccessKeysInner response = ((RedisManagementClientImpl)((Object)((RedisManager)this.manager()).inner())).redis().listKeys(this.resourceGroupName(), this.name());
        this.cachedAccessKeys = new RedisAccessKeysImpl(response);
        return this.cachedAccessKeys;
    }

    @Override
    public RedisAccessKeys regenerateKey(RedisKeyType keyType) {
        RedisAccessKeysInner response = ((RedisManagementClientImpl)((Object)((RedisManager)this.manager()).inner())).redis().regenerateKey(this.resourceGroupName(), this.name(), keyType);
        this.cachedAccessKeys = new RedisAccessKeysImpl(response);
        return this.cachedAccessKeys;
    }

    @Override
    public void forceReboot(RebootType rebootType) {
        RedisRebootParameters parameters = new RedisRebootParameters().withRebootType(rebootType);
        ((RedisManagementClientImpl)((Object)((RedisManager)this.manager()).inner())).redis().forceReboot(this.resourceGroupName(), this.name(), parameters);
    }

    @Override
    public void forceReboot(RebootType rebootType, int shardId) {
        RedisRebootParameters parameters = new RedisRebootParameters().withRebootType(rebootType).withShardId(shardId);
        ((RedisManagementClientImpl)((Object)((RedisManager)this.manager()).inner())).redis().forceReboot(this.resourceGroupName(), this.name(), parameters);
    }

    @Override
    public void importData(List<String> files) {
        ImportRDBParameters parameters = new ImportRDBParameters().withFiles(files);
        ((RedisManagementClientImpl)((Object)((RedisManager)this.manager()).inner())).redis().importData(this.resourceGroupName(), this.name(), parameters);
    }

    @Override
    public void importData(List<String> files, String fileFormat) {
        ImportRDBParameters parameters = new ImportRDBParameters().withFiles(files).withFormat(fileFormat);
        ((RedisManagementClientImpl)((Object)((RedisManager)this.manager()).inner())).redis().importData(this.resourceGroupName(), this.name(), parameters);
    }

    @Override
    public void exportData(String containerSASUrl, String prefix) {
        ExportRDBParameters parameters = new ExportRDBParameters().withContainer(containerSASUrl).withPrefix(prefix);
        ((RedisManagementClientImpl)((Object)((RedisManager)this.manager()).inner())).redis().exportData(this.resourceGroupName(), this.name(), parameters);
    }

    @Override
    public void exportData(String containerSASUrl, String prefix, String fileFormat) {
        ExportRDBParameters parameters = new ExportRDBParameters().withContainer(containerSASUrl).withPrefix(prefix).withFormat(fileFormat);
        ((RedisManagementClientImpl)((Object)((RedisManager)this.manager()).inner())).redis().exportData(this.resourceGroupName(), this.name(), parameters);
    }

    @Override
    public RedisCacheImpl withNonSslPort() {
        if (this.isInCreateMode()) {
            this.createParameters.withEnableNonSslPort(true);
        } else {
            this.updateParameters.withEnableNonSslPort(true);
        }
        return this;
    }

    @Override
    public RedisCacheImpl withoutNonSslPort() {
        if (!this.isInCreateMode()) {
            this.updateParameters.withEnableNonSslPort(false);
        }
        return this;
    }

    @Override
    public RedisCacheImpl withRedisConfiguration(Map<String, String> redisConfiguration) {
        if (this.isInCreateMode()) {
            this.createParameters.withRedisConfiguration(redisConfiguration);
        } else {
            this.updateParameters.withRedisConfiguration(redisConfiguration);
        }
        return this;
    }

    @Override
    public RedisCacheImpl withRedisConfiguration(String key, String value) {
        if (this.isInCreateMode()) {
            if (this.createParameters.redisConfiguration() == null) {
                this.createParameters.withRedisConfiguration(new TreeMap<String, String>());
            }
            this.createParameters.redisConfiguration().put(key, value);
        } else {
            if (this.updateParameters.redisConfiguration() == null) {
                this.updateParameters.withRedisConfiguration(new TreeMap<String, String>());
            }
            this.updateParameters.redisConfiguration().put(key, value);
        }
        return this;
    }

    @Override
    public RedisCacheImpl withFirewallRule(String name, String lowestIp, String highestIp) {
        RedisFirewallRuleImpl rule = this.firewallRules.defineInlineFirewallRule(name);
        ((RedisFirewallRuleInner)rule.inner()).withStartIP(lowestIp);
        ((RedisFirewallRuleInner)rule.inner()).withEndIP(highestIp);
        return this.withFirewallRule(rule);
    }

    @Override
    public RedisCacheImpl withFirewallRule(RedisFirewallRule rule) {
        this.firewallRules.addRule((RedisFirewallRuleImpl)rule);
        return this;
    }

    @Override
    public RedisCacheImpl withMinimumTlsVersion(TlsVersion tlsVersion) {
        if (this.isInCreateMode()) {
            this.createParameters.withMinimumTlsVersion(tlsVersion);
        } else {
            this.updateParameters.withMinimumTlsVersion(tlsVersion);
        }
        return this;
    }

    @Override
    public RedisCacheImpl withoutMinimumTlsVersion() {
        this.updateParameters.withMinimumTlsVersion(null);
        return this;
    }

    @Override
    public RedisCacheImpl withoutFirewallRule(String name) {
        this.firewallRules.removeRule(name);
        return this;
    }

    @Override
    public RedisCacheImpl withoutRedisConfiguration() {
        if (this.updateParameters.redisConfiguration() != null) {
            this.updateParameters.redisConfiguration().clear();
        }
        return this;
    }

    @Override
    public RedisCacheImpl withoutRedisConfiguration(String key) {
        if (this.updateParameters.redisConfiguration() != null && this.updateParameters.redisConfiguration().containsKey(key)) {
            this.updateParameters.redisConfiguration().remove(key);
        }
        return this;
    }

    @Override
    public RedisCacheImpl withSubnet(HasId networkResource, String subnetName) {
        if (networkResource != null) {
            String subnetId = networkResource.id() + "/subnets/" + subnetName;
            return this.withSubnet(subnetId);
        }
        this.createParameters.withSubnetId(null);
        return this;
    }

    @Override
    public RedisCacheImpl withSubnet(String subnetId) {
        if (subnetId != null) {
            if (this.isInCreateMode()) {
                this.createParameters.withSubnetId(subnetId);
            } else {
                throw new UnsupportedOperationException("Subnet cannot be modified during update operation.");
            }
        }
        return this;
    }

    @Override
    public RedisCacheImpl withStaticIP(String staticIP) {
        if (!this.isInCreateMode()) {
            throw new UnsupportedOperationException("Static IP cannot be modified during update operation.");
        }
        this.createParameters.withStaticIP(staticIP);
        return this;
    }

    @Override
    public RedisCacheImpl withBasicSku() {
        if (this.isInCreateMode()) {
            this.createParameters.withSku(new Sku().withName(SkuName.BASIC).withFamily(SkuFamily.C));
        } else {
            this.updateParameters.withSku(new Sku().withName(SkuName.BASIC).withFamily(SkuFamily.C));
        }
        return this;
    }

    @Override
    public RedisCacheImpl withBasicSku(int capacity) {
        if (this.isInCreateMode()) {
            this.createParameters.withSku(new Sku().withName(SkuName.BASIC).withFamily(SkuFamily.C).withCapacity(capacity));
        } else {
            this.updateParameters.withSku(new Sku().withName(SkuName.BASIC).withFamily(SkuFamily.C).withCapacity(capacity));
        }
        return this;
    }

    @Override
    public RedisCacheImpl withStandardSku() {
        if (this.isInCreateMode()) {
            this.createParameters.withSku(new Sku().withName(SkuName.STANDARD).withFamily(SkuFamily.C));
        } else {
            this.updateParameters.withSku(new Sku().withName(SkuName.STANDARD).withFamily(SkuFamily.C));
        }
        return this;
    }

    @Override
    public RedisCacheImpl withStandardSku(int capacity) {
        if (this.isInCreateMode()) {
            this.createParameters.withSku(new Sku().withName(SkuName.STANDARD).withFamily(SkuFamily.C).withCapacity(capacity));
        } else {
            this.updateParameters.withSku(new Sku().withName(SkuName.STANDARD).withFamily(SkuFamily.C).withCapacity(capacity));
        }
        return this;
    }

    @Override
    public RedisCacheImpl withPremiumSku() {
        if (this.isInCreateMode()) {
            this.createParameters.withSku(new Sku().withName(SkuName.PREMIUM).withFamily(SkuFamily.P).withCapacity(1));
        } else {
            this.updateParameters.withSku(new Sku().withName(SkuName.PREMIUM).withFamily(SkuFamily.P).withCapacity(1));
        }
        return this;
    }

    @Override
    public RedisCacheImpl withPremiumSku(int capacity) {
        if (this.isInCreateMode()) {
            this.createParameters.withSku(new Sku().withName(SkuName.PREMIUM).withFamily(SkuFamily.P).withCapacity(capacity));
        } else {
            this.updateParameters.withSku(new Sku().withName(SkuName.PREMIUM).withFamily(SkuFamily.P).withCapacity(capacity));
        }
        return this;
    }

    @Override
    public RedisCacheImpl withShardCount(int shardCount) {
        if (this.isInCreateMode()) {
            this.createParameters.withShardCount(shardCount);
        } else {
            this.updateParameters.withShardCount(shardCount);
        }
        return this;
    }

    @Override
    public RedisCacheImpl withPatchSchedule(DayOfWeek dayOfWeek, int startHourUtc) {
        return this.withPatchSchedule(new ScheduleEntry().withDayOfWeek(dayOfWeek).withStartHourUtc(startHourUtc));
    }

    @Override
    public RedisCacheImpl withPatchSchedule(DayOfWeek dayOfWeek, int startHourUtc, Period maintenanceWindow) {
        return this.withPatchSchedule(new ScheduleEntry().withDayOfWeek(dayOfWeek).withStartHourUtc(startHourUtc).withMaintenanceWindow(maintenanceWindow));
    }

    @Override
    public RedisCacheImpl withPatchSchedule(List<ScheduleEntry> scheduleEntries) {
        this.patchSchedules.clear();
        for (ScheduleEntry entry : scheduleEntries) {
            this.withPatchSchedule(entry);
        }
        return this;
    }

    @Override
    public RedisCacheImpl withPatchSchedule(ScheduleEntry scheduleEntry) {
        RedisPatchScheduleImpl psch = null;
        if (this.patchSchedules.patchSchedulesAsMap().isEmpty()) {
            psch = this.patchSchedules.defineInlinePatchSchedule();
            this.patchScheduleAdded = true;
            ((RedisPatchScheduleInner)psch.inner()).withScheduleEntries(new ArrayList<ScheduleEntry>());
            this.patchSchedules.addPatchSchedule(psch);
        } else {
            psch = !this.patchScheduleAdded ? this.patchSchedules.updateInlinePatchSchedule() : this.patchSchedules.getPatchSchedule();
        }
        ((RedisPatchScheduleInner)psch.inner()).scheduleEntries().add(scheduleEntry);
        return this;
    }

    @Override
    public RedisCacheImpl withoutPatchSchedule() {
        if (this.patchSchedules.patchSchedulesAsMap().isEmpty()) {
            return this;
        }
        this.patchSchedules.deleteInlinePatchSchedule();
        return this;
    }

    @Override
    public void deletePatchSchedule() {
        this.patchSchedules.removePatchSchedule();
        this.patchSchedules.refresh();
    }

    public Observable<RedisCache> refreshAsync() {
        return super.refreshAsync().map((Func1)new Func1<RedisCache, RedisCache>(){

            public RedisCache call(RedisCache redisCache) {
                RedisCacheImpl impl = (RedisCacheImpl)redisCache;
                impl.firewallRules.refresh();
                impl.patchSchedules.refresh();
                return impl;
            }
        });
    }

    protected Observable<RedisResourceInner> getInnerAsync() {
        return ((RedisManagementClientImpl)((Object)((RedisManager)this.manager()).inner())).redis().getByResourceGroupAsync(this.resourceGroupName(), this.name());
    }

    public Completable afterPostRunAsync(boolean isGroupFaulted) {
        this.firewallRules.clear();
        this.patchSchedules.clear();
        this.patchScheduleAdded = false;
        if (isGroupFaulted) {
            return Completable.complete();
        }
        return this.refreshAsync().toCompletable();
    }

    public RedisCacheImpl update() {
        this.updateParameters = new RedisUpdateParameters();
        this.patchSchedules.enableCommitMode();
        this.firewallRules.enableCommitMode();
        return (RedisCacheImpl)super.update();
    }

    public Observable<RedisCache> updateResourceAsync() {
        final RedisCacheImpl self = this;
        return ((RedisManagementClientImpl)((Object)((RedisManager)this.manager()).inner())).redis().updateAsync(this.resourceGroupName(), this.name(), this.updateParameters).map(this.innerToFluentMap((IndexableRefreshableWrapperImpl)this)).doOnNext((Action1)new Action1<RedisCache>(){

            public void call(RedisCache redisCache) {
                while (!redisCache.provisioningState().equalsIgnoreCase("Succeeded")) {
                    SdkContext.sleep((int)30000);
                    RedisResourceInner innerResource = ((RedisManagementClientImpl)((Object)((RedisManager)self.manager()).inner())).redis().getByResourceGroup(RedisCacheImpl.this.resourceGroupName(), RedisCacheImpl.this.name());
                    ((RedisCacheImpl)redisCache).setInner((Object)innerResource);
                    self.setInner((Object)innerResource);
                    self.patchScheduleAdded = false;
                }
            }
        }).flatMap((Func1)new Func1<RedisCache, Observable<RedisCache>>(){

            public Observable<RedisCache> call(RedisCache redisCache) {
                return self.patchSchedules.commitAndGetAllAsync().map((Func1)new Func1<List<RedisPatchScheduleImpl>, RedisCache>(){

                    public RedisCache call(List<RedisPatchScheduleImpl> redisPatchSchedules) {
                        return self;
                    }
                });
            }
        }).flatMap((Func1)new Func1<RedisCache, Observable<RedisCache>>(){

            public Observable<RedisCache> call(RedisCache redisCache) {
                return self.firewallRules.commitAndGetAllAsync().map((Func1)new Func1<List<RedisFirewallRuleImpl>, RedisCache>(){

                    public RedisCache call(List<RedisFirewallRuleImpl> redisFirewallRules) {
                        return self;
                    }
                });
            }
        });
    }

    public Observable<RedisCache> createResourceAsync() {
        this.createParameters.withLocation(this.regionName());
        this.createParameters.withTags(((RedisResourceInner)((Object)this.inner())).getTags());
        this.patchScheduleAdded = false;
        return ((RedisManagementClientImpl)((Object)((RedisManager)this.manager()).inner())).redis().createAsync(this.resourceGroupName(), this.name(), this.createParameters).map(this.innerToFluentMap((IndexableRefreshableWrapperImpl)this));
    }

    @Override
    public String addLinkedServer(String linkedRedisCacheId, String linkedServerLocation, ReplicationRole role) {
        String linkedRedisName = ResourceUtils.nameFromResourceId((String)linkedRedisCacheId);
        RedisLinkedServerCreateParameters params = new RedisLinkedServerCreateParameters().withLinkedRedisCacheId(linkedRedisCacheId).withLinkedRedisCacheLocation(linkedServerLocation).withServerRole(role);
        RedisLinkedServerWithPropertiesInner linkedServerInner = ((RedisManagementClientImpl)((Object)((RedisManager)this.manager()).inner())).linkedServers().create(this.resourceGroupName(), this.name(), linkedRedisName, params);
        return linkedServerInner.name();
    }

    @Override
    public void removeLinkedServer(String linkedServerName) {
        RedisLinkedServerWithPropertiesInner linkedServer = ((RedisManagementClientImpl)((Object)((RedisManager)this.manager()).inner())).linkedServers().get(this.resourceGroupName(), this.name(), linkedServerName);
        ((RedisManagementClientImpl)((Object)((RedisManager)this.manager()).inner())).linkedServers().delete(this.resourceGroupName(), this.name(), linkedServerName);
        RedisResourceInner innerLinkedResource = null;
        RedisResourceInner innerResource = null;
        while (innerLinkedResource == null || innerLinkedResource.provisioningState() != ProvisioningState.SUCCEEDED || innerResource == null || innerResource.provisioningState() != ProvisioningState.SUCCEEDED) {
            SdkContext.sleep((int)30000);
            innerLinkedResource = ((RedisManagementClientImpl)((Object)((RedisManager)this.manager()).inner())).redis().getByResourceGroup(ResourceUtils.groupFromResourceId((String)linkedServer.id()), ResourceUtils.nameFromResourceId((String)linkedServer.id()));
            innerResource = ((RedisManagementClientImpl)((Object)((RedisManager)this.manager()).inner())).redis().getByResourceGroup(this.resourceGroupName(), this.name());
        }
    }

    @Override
    public ReplicationRole getLinkedServerRole(String linkedServerName) {
        RedisLinkedServerWithPropertiesInner linkedServer = ((RedisManagementClientImpl)((Object)((RedisManager)this.manager()).inner())).linkedServers().get(this.resourceGroupName(), this.name(), linkedServerName);
        if (linkedServer == null) {
            throw new IllegalArgumentException("Server returned `null` value for Linked Server '" + linkedServerName + "' for Redis Cache '" + this.name() + "' in Resource Group '" + this.resourceGroupName() + "'.");
        }
        return linkedServer.serverRole();
    }

    @Override
    public Map<String, ReplicationRole> listLinkedServers() {
        TreeMap<String, ReplicationRole> result = new TreeMap<String, ReplicationRole>();
        PagedList<RedisLinkedServerWithPropertiesInner> paginatedResponse = ((RedisManagementClientImpl)((Object)((RedisManager)this.manager()).inner())).linkedServers().list(this.resourceGroupName(), this.name());
        for (RedisLinkedServerWithPropertiesInner linkedServer : paginatedResponse) {
            result.put(linkedServer.name(), linkedServer.serverRole());
        }
        return result;
    }
}

