/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.management.servicebus.implementation;

import com.microsoft.azure.management.servicebus.implementation.Token;
import rx.functions.Func0;

class TokenParser {
    private final String str;
    private final int startIndex;
    private Func0<Token> nextTokenProvider;

    TokenParser(String str, int startIndex) {
        this.str = str;
        this.startIndex = startIndex;
        this.nextTokenProvider = this.nextTokenProvider();
    }

    Token nextToken() {
        return (Token)this.nextTokenProvider.call();
    }

    static void throwParseError() {
        throw new IllegalArgumentException("String was not recognized as a valid TimeSpan");
    }

    static void throwOutOfRange() {
        throw new IllegalArgumentException("The TimeSpan could not be parsed because at least one of the numeric components is out of range or contains too many digits");
    }

    private Func0<Token> nextTokenProvider() {
        return new Func0<Token>(){
            int currentIndex;
            int length;
            {
                this.currentIndex = TokenParser.this.startIndex;
                this.length = TokenParser.this.str.length();
            }

            public Token call() {
                if (this.currentIndex >= this.length) {
                    return new Token(null, null);
                }
                StringBuilder builder = new StringBuilder();
                while (this.currentIndex < this.length && Character.isDigit(TokenParser.this.str.charAt(this.currentIndex))) {
                    builder.append(TokenParser.this.str.charAt(this.currentIndex));
                    ++this.currentIndex;
                }
                String val = builder.toString();
                if (val == null) {
                    TokenParser.throwParseError();
                }
                try {
                    Integer.parseInt(val);
                }
                catch (Exception ex) {
                    TokenParser.throwOutOfRange();
                }
                if (this.currentIndex < this.length) {
                    return new Token(val, Character.valueOf(TokenParser.this.str.charAt(this.currentIndex++)));
                }
                return new Token(val, null);
            }
        };
    }
}

