/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.management.sql;

import com.microsoft.azure.PagedList;
import com.microsoft.azure.management.apigeneration.Beta;
import com.microsoft.azure.management.apigeneration.Fluent;
import com.microsoft.azure.management.apigeneration.Method;
import com.microsoft.azure.management.resources.fluentcore.arm.models.ExternalChildResource;
import com.microsoft.azure.management.resources.fluentcore.arm.models.HasResourceGroup;
import com.microsoft.azure.management.resources.fluentcore.model.Appliable;
import com.microsoft.azure.management.resources.fluentcore.model.HasInner;
import com.microsoft.azure.management.resources.fluentcore.model.Refreshable;
import com.microsoft.azure.management.resources.fluentcore.model.Updatable;
import com.microsoft.azure.management.sql.SqlSyncFullSchemaProperty;
import com.microsoft.azure.management.sql.SqlSyncGroup;
import com.microsoft.azure.management.sql.SyncDirection;
import com.microsoft.azure.management.sql.SyncMemberDbType;
import com.microsoft.azure.management.sql.SyncMemberState;
import com.microsoft.azure.management.sql.implementation.SyncMemberInner;
import rx.Completable;
import rx.Observable;

@Fluent
@Beta(value=Beta.SinceVersion.V1_9_0)
public interface SqlSyncMember
extends ExternalChildResource<SqlSyncMember, SqlSyncGroup>,
HasInner<SyncMemberInner>,
HasResourceGroup,
Refreshable<SqlSyncMember>,
Updatable<Update> {
    public String sqlServerName();

    public String sqlDatabaseName();

    public String sqlSyncGroupName();

    public String parentId();

    public SyncMemberDbType databaseType();

    public String syncAgentId();

    public String sqlServerDatabaseId();

    public String memberServerName();

    public String memberDatabaseName();

    public String userName();

    public SyncDirection syncDirection();

    public SyncMemberState syncState();

    @Method
    public void delete();

    @Method
    public Completable deleteAsync();

    @Method
    public PagedList<SqlSyncFullSchemaProperty> listMemberSchemas();

    @Method
    public Observable<SqlSyncFullSchemaProperty> listMemberSchemasAsync();

    @Method
    public void refreshMemberSchema();

    @Method
    public Completable refreshMemberSchemaAsync();

    @Beta(value=Beta.SinceVersion.V1_9_0)
    public static interface UpdateStages {

        @Beta(value=Beta.SinceVersion.V1_9_0)
        public static interface WithSyncDirection {
            public Update withDatabaseType(SyncDirection var1);
        }

        @Beta(value=Beta.SinceVersion.V1_9_0)
        public static interface WithMemberDatabaseType {
            public Update withMemberDatabaseType(SyncMemberDbType var1);
        }

        @Beta(value=Beta.SinceVersion.V1_9_0)
        public static interface WithMemberPassword {
            public Update withMemberPassword(String var1);
        }

        @Beta(value=Beta.SinceVersion.V1_9_0)
        public static interface WithMemberUserName {
            public Update withMemberUserName(String var1);
        }
    }

    @Beta(value=Beta.SinceVersion.V1_9_0)
    public static interface Update
    extends UpdateStages.WithMemberUserName,
    UpdateStages.WithMemberPassword,
    UpdateStages.WithMemberDatabaseType,
    UpdateStages.WithSyncDirection,
    Appliable<SqlSyncMember> {
    }
}

