/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.management.storage.implementation;

import com.microsoft.azure.management.apigeneration.LangDefinition;
import com.microsoft.azure.management.resources.fluentcore.model.implementation.CreatableUpdatableImpl;
import com.microsoft.azure.management.resources.fluentcore.model.implementation.IndexableRefreshableWrapperImpl;
import com.microsoft.azure.management.storage.BlobServiceProperties;
import com.microsoft.azure.management.storage.CorsRule;
import com.microsoft.azure.management.storage.CorsRules;
import com.microsoft.azure.management.storage.DeleteRetentionPolicy;
import com.microsoft.azure.management.storage.implementation.BlobServicePropertiesInner;
import com.microsoft.azure.management.storage.implementation.BlobServicesInner;
import com.microsoft.azure.management.storage.implementation.IdParsingUtils;
import com.microsoft.azure.management.storage.implementation.StorageManagementClientImpl;
import com.microsoft.azure.management.storage.implementation.StorageManager;
import java.util.ArrayList;
import java.util.List;
import rx.Observable;

@LangDefinition
class BlobServicePropertiesImpl
extends CreatableUpdatableImpl<BlobServiceProperties, BlobServicePropertiesInner, BlobServicePropertiesImpl>
implements BlobServiceProperties,
BlobServiceProperties.Definition,
BlobServiceProperties.Update {
    private final StorageManager manager;
    private String resourceGroupName;
    private String accountName;

    BlobServicePropertiesImpl(String name, StorageManager manager) {
        super(name, (Object)new BlobServicePropertiesInner());
        this.manager = manager;
        this.accountName = name;
    }

    BlobServicePropertiesImpl(BlobServicePropertiesInner inner, StorageManager manager) {
        super(inner.name(), (Object)inner);
        this.manager = manager;
        this.accountName = inner.name();
        this.resourceGroupName = IdParsingUtils.getValueFromIdByName(inner.id(), "resourceGroups");
        this.accountName = IdParsingUtils.getValueFromIdByName(inner.id(), "storageAccounts");
    }

    public StorageManager manager() {
        return this.manager;
    }

    public Observable<BlobServiceProperties> createResourceAsync() {
        BlobServicesInner client = ((StorageManagementClientImpl)((Object)this.manager().inner())).blobServices();
        return client.setServicePropertiesAsync(this.resourceGroupName, this.accountName, (BlobServicePropertiesInner)((Object)this.inner())).map(this.innerToFluentMap((IndexableRefreshableWrapperImpl)this));
    }

    public Observable<BlobServiceProperties> updateResourceAsync() {
        BlobServicesInner client = ((StorageManagementClientImpl)((Object)this.manager().inner())).blobServices();
        return client.setServicePropertiesAsync(this.resourceGroupName, this.accountName, (BlobServicePropertiesInner)((Object)this.inner())).map(this.innerToFluentMap((IndexableRefreshableWrapperImpl)this));
    }

    protected Observable<BlobServicePropertiesInner> getInnerAsync() {
        BlobServicesInner client = ((StorageManagementClientImpl)((Object)this.manager().inner())).blobServices();
        return client.getServicePropertiesAsync(this.resourceGroupName, this.accountName);
    }

    public boolean isInCreateMode() {
        return ((BlobServicePropertiesInner)((Object)this.inner())).id() == null;
    }

    @Override
    public CorsRules cors() {
        return ((BlobServicePropertiesInner)((Object)this.inner())).cors();
    }

    @Override
    public String defaultServiceVersion() {
        return ((BlobServicePropertiesInner)((Object)this.inner())).defaultServiceVersion();
    }

    @Override
    public DeleteRetentionPolicy deleteRetentionPolicy() {
        return ((BlobServicePropertiesInner)((Object)this.inner())).deleteRetentionPolicy();
    }

    @Override
    public String id() {
        return ((BlobServicePropertiesInner)((Object)this.inner())).id();
    }

    @Override
    public String name() {
        return ((BlobServicePropertiesInner)((Object)this.inner())).name();
    }

    @Override
    public String type() {
        return ((BlobServicePropertiesInner)((Object)this.inner())).type();
    }

    @Override
    public BlobServicePropertiesImpl withExistingStorageAccount(String resourceGroupName, String accountName) {
        this.resourceGroupName = resourceGroupName;
        this.accountName = accountName;
        return this;
    }

    @Override
    public BlobServicePropertiesImpl withCORSRules(List<CorsRule> corsRules) {
        ((BlobServicePropertiesInner)((Object)this.inner())).withCors(new CorsRules().withCorsRules(corsRules));
        return this;
    }

    @Override
    public BlobServicePropertiesImpl withCORSRule(CorsRule corsRule) {
        CorsRules corsRules = ((BlobServicePropertiesInner)((Object)this.inner())).cors();
        if (corsRules == null) {
            ArrayList<CorsRule> firstCorsRule = new ArrayList<CorsRule>();
            firstCorsRule.add(corsRule);
            ((BlobServicePropertiesInner)((Object)this.inner())).withCors(new CorsRules().withCorsRules(firstCorsRule));
        } else {
            List<CorsRule> currentCorsRules = corsRules.corsRules();
            currentCorsRules.add(corsRule);
            ((BlobServicePropertiesInner)((Object)this.inner())).withCors(corsRules.withCorsRules(currentCorsRules));
        }
        return this;
    }

    @Override
    public BlobServicePropertiesImpl withDefaultServiceVersion(String defaultServiceVersion) {
        ((BlobServicePropertiesInner)((Object)this.inner())).withDefaultServiceVersion(defaultServiceVersion);
        return this;
    }

    @Override
    public BlobServicePropertiesImpl withDeleteRetentionPolicy(DeleteRetentionPolicy deleteRetentionPolicy) {
        ((BlobServicePropertiesInner)((Object)this.inner())).withDeleteRetentionPolicy(deleteRetentionPolicy);
        return this;
    }

    @Override
    public BlobServicePropertiesImpl withDeleteRetentionPolicyEnabled(int numDaysEnabled) {
        ((BlobServicePropertiesInner)((Object)this.inner())).withDeleteRetentionPolicy(new DeleteRetentionPolicy().withEnabled(true).withDays(numDaysEnabled));
        return this;
    }

    @Override
    public BlobServicePropertiesImpl withDeleteRetentionPolicyDisabled() {
        ((BlobServicePropertiesInner)((Object)this.inner())).withDeleteRetentionPolicy(new DeleteRetentionPolicy().withEnabled(false));
        return this;
    }
}

