/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.keyvault.cryptography.algorithms;

import com.microsoft.azure.keyvault.cryptography.ByteExtensions;
import com.microsoft.azure.keyvault.cryptography.ISignatureTransform;
import com.microsoft.azure.keyvault.cryptography.algorithms.RsaSignature;
import java.math.BigInteger;
import java.security.KeyPair;
import java.security.NoSuchAlgorithmException;
import java.security.interfaces.RSAPrivateKey;
import java.security.interfaces.RSAPublicKey;

public class Rs256
extends RsaSignature {
    static final String RSA_NONE = "RSA/ECB/PKCS1Padding";
    public static final String ALGORITHM_NAME = "RS256";

    public Rs256() {
        super(ALGORITHM_NAME);
    }

    @Override
    public ISignatureTransform createSignatureTransform(KeyPair keyPair) {
        return new Rs256SignatureTransform(keyPair);
    }

    class Rs256SignatureTransform
    implements ISignatureTransform {
        private final KeyPair keyPair;
        private final int emLen;

        Rs256SignatureTransform(KeyPair keyPair) {
            this.keyPair = keyPair;
            BigInteger modulus = ((RSAPublicKey)keyPair.getPublic()).getModulus();
            this.emLen = Rs256.this.getOctetLength(modulus.bitLength());
        }

        @Override
        public byte[] sign(byte[] digest) throws NoSuchAlgorithmException {
            byte[] em = Rs256.this.EMSA_PKCS1_V1_5_ENCODE_HASH(digest, this.emLen, "SHA-256");
            BigInteger s = Rs256.this.OS2IP(em);
            s = Rs256.this.RSASP1((RSAPrivateKey)this.keyPair.getPrivate(), s);
            return Rs256.this.I2OSP(s, this.emLen);
        }

        @Override
        public boolean verify(byte[] digest, byte[] signature) throws NoSuchAlgorithmException {
            if (signature.length != this.emLen) {
                throw new IllegalArgumentException("invalid signature length");
            }
            BigInteger s = Rs256.this.OS2IP(signature);
            BigInteger m = Rs256.this.RSAVP1((RSAPublicKey)this.keyPair.getPublic(), s);
            byte[] em = Rs256.this.I2OSP(m, this.emLen);
            byte[] em2 = Rs256.this.EMSA_PKCS1_V1_5_ENCODE_HASH(digest, this.emLen, "SHA-256");
            return ByteExtensions.sequenceEqualConstantTime(em, em2);
        }
    }
}

