/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.io.serializer.avro;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.apache.avro.Schema;
import org.apache.avro.io.BinaryDecoder;
import org.apache.avro.io.BinaryEncoder;
import org.apache.avro.io.DatumReader;
import org.apache.avro.io.DatumWriter;
import org.apache.avro.io.Decoder;
import org.apache.avro.io.DecoderFactory;
import org.apache.avro.io.Encoder;
import org.apache.avro.io.EncoderFactory;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.hadoop.conf.Configured;
import org.apache.hadoop.io.serializer.Deserializer;
import org.apache.hadoop.io.serializer.Serialization;
import org.apache.hadoop.io.serializer.Serializer;

@InterfaceAudience.Public
@InterfaceStability.Evolving
public abstract class AvroSerialization<T>
extends Configured
implements Serialization<T> {
    @InterfaceAudience.Private
    public static final String AVRO_SCHEMA_KEY = "Avro-Schema";

    @Override
    @InterfaceAudience.Private
    public Deserializer<T> getDeserializer(Class<T> c) {
        return new AvroDeserializer(c);
    }

    @Override
    @InterfaceAudience.Private
    public Serializer<T> getSerializer(Class<T> c) {
        return new AvroSerializer(c);
    }

    @InterfaceAudience.Private
    public abstract Schema getSchema(T var1);

    @InterfaceAudience.Private
    public abstract DatumWriter<T> getWriter(Class<T> var1);

    @InterfaceAudience.Private
    public abstract DatumReader<T> getReader(Class<T> var1);

    class AvroDeserializer
    implements Deserializer<T> {
        private DatumReader<T> reader;
        private BinaryDecoder decoder;
        private InputStream inStream;

        AvroDeserializer(Class<T> clazz) {
            this.reader = AvroSerialization.this.getReader(clazz);
        }

        @Override
        public void close() throws IOException {
            this.inStream.close();
        }

        @Override
        public T deserialize(T t) throws IOException {
            return this.reader.read(t, (Decoder)this.decoder);
        }

        @Override
        public void open(InputStream in) throws IOException {
            this.inStream = in;
            this.decoder = DecoderFactory.get().binaryDecoder(in, this.decoder);
        }
    }

    class AvroSerializer
    implements Serializer<T> {
        private DatumWriter<T> writer;
        private BinaryEncoder encoder;
        private OutputStream outStream;

        AvroSerializer(Class<T> clazz) {
            this.writer = AvroSerialization.this.getWriter(clazz);
        }

        @Override
        public void close() throws IOException {
            this.encoder.flush();
            this.outStream.close();
        }

        @Override
        public void open(OutputStream out) throws IOException {
            this.outStream = out;
            this.encoder = EncoderFactory.get().binaryEncoder(out, this.encoder);
        }

        @Override
        public void serialize(T t) throws IOException {
            this.writer.setSchema(AvroSerialization.this.getSchema(t));
            this.writer.write(t, (Encoder)this.encoder);
        }
    }
}

