/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.management.compute.implementation;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.MissingNode;
import com.microsoft.azure.management.apigeneration.LangDefinition;
import com.microsoft.azure.management.compute.DiskVolumeEncryptionMonitor;
import com.microsoft.azure.management.compute.EncryptionStatus;
import com.microsoft.azure.management.compute.InstanceViewStatus;
import com.microsoft.azure.management.compute.OperatingSystemTypes;
import com.microsoft.azure.management.compute.VirtualMachineExtensionInstanceView;
import com.microsoft.azure.management.compute.implementation.ComputeManagementClientImpl;
import com.microsoft.azure.management.compute.implementation.ComputeManager;
import com.microsoft.azure.management.compute.implementation.VirtualMachineExtensionInner;
import com.microsoft.azure.management.compute.implementation.VirtualMachineInner;
import com.microsoft.azure.management.resources.fluentcore.arm.ResourceUtils;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import rx.Observable;
import rx.functions.Func1;

@LangDefinition
class LinuxDiskVolumeEncryptionMonitorImpl
implements DiskVolumeEncryptionMonitor {
    private final String rgName;
    private final String vmName;
    private final ComputeManager computeManager;
    private VirtualMachineExtensionInner encryptionExtension;

    LinuxDiskVolumeEncryptionMonitorImpl(String virtualMachineId, ComputeManager computeManager) {
        this.rgName = ResourceUtils.groupFromResourceId((String)virtualMachineId);
        this.vmName = ResourceUtils.nameFromResourceId((String)virtualMachineId);
        this.computeManager = computeManager;
    }

    @Override
    public OperatingSystemTypes osType() {
        return OperatingSystemTypes.LINUX;
    }

    @Override
    public String progressMessage() {
        if (!this.hasEncryptionExtension()) {
            return null;
        }
        List<InstanceViewStatus> statuses = this.instanceViewStatuses();
        if (statuses.size() == 0) {
            return null;
        }
        return statuses.get(0).message();
    }

    @Override
    public EncryptionStatus osDiskStatus() {
        if (!this.hasEncryptionExtension()) {
            return EncryptionStatus.NOT_ENCRYPTED;
        }
        JsonNode subStatusNode = this.instanceViewFirstSubStatus();
        if (subStatusNode == null) {
            return EncryptionStatus.UNKNOWN;
        }
        JsonNode diskNode = subStatusNode.path("os");
        if (diskNode instanceof MissingNode) {
            return EncryptionStatus.UNKNOWN;
        }
        return EncryptionStatus.fromString(diskNode.asText());
    }

    @Override
    public EncryptionStatus dataDiskStatus() {
        if (!this.hasEncryptionExtension()) {
            return EncryptionStatus.NOT_ENCRYPTED;
        }
        JsonNode subStatusNode = this.instanceViewFirstSubStatus();
        if (subStatusNode == null) {
            return EncryptionStatus.UNKNOWN;
        }
        JsonNode diskNode = subStatusNode.path("data");
        if (diskNode instanceof MissingNode) {
            return EncryptionStatus.UNKNOWN;
        }
        return EncryptionStatus.fromString(diskNode.asText());
    }

    public DiskVolumeEncryptionMonitor refresh() {
        return (DiskVolumeEncryptionMonitor)this.refreshAsync().toBlocking().last();
    }

    @Override
    public Observable<DiskVolumeEncryptionMonitor> refreshAsync() {
        final LinuxDiskVolumeEncryptionMonitorImpl self = this;
        return this.retrieveEncryptExtensionWithInstanceViewAsync().flatMap((Func1)new Func1<VirtualMachineExtensionInner, Observable<DiskVolumeEncryptionMonitor>>(){

            public Observable<DiskVolumeEncryptionMonitor> call(VirtualMachineExtensionInner virtualMachineExtensionInner) {
                LinuxDiskVolumeEncryptionMonitorImpl.this.encryptionExtension = virtualMachineExtensionInner;
                return Observable.just((Object)self);
            }
        }).switchIfEmpty(Observable.just((Object)self));
    }

    private Observable<VirtualMachineExtensionInner> retrieveEncryptExtensionWithInstanceViewAsync() {
        if (this.encryptionExtension != null) {
            return this.retrieveExtensionWithInstanceViewAsync(this.encryptionExtension);
        }
        return this.retrieveEncryptExtensionWithInstanceViewFromVMAsync();
    }

    private Observable<VirtualMachineExtensionInner> retrieveExtensionWithInstanceViewAsync(VirtualMachineExtensionInner extension) {
        return ((ComputeManagementClientImpl)((Object)this.computeManager.inner())).virtualMachineExtensions().getAsync(this.rgName, this.vmName, extension.name(), "instanceView").flatMap((Func1)new Func1<VirtualMachineExtensionInner, Observable<VirtualMachineExtensionInner>>(){

            public Observable<VirtualMachineExtensionInner> call(VirtualMachineExtensionInner virtualMachineExtensionInner) {
                if (virtualMachineExtensionInner == null) {
                    return Observable.empty();
                }
                return Observable.just((Object)((Object)virtualMachineExtensionInner));
            }
        });
    }

    private Observable<VirtualMachineExtensionInner> retrieveEncryptExtensionWithInstanceViewFromVMAsync() {
        return ((ComputeManagementClientImpl)((Object)this.computeManager.inner())).virtualMachines().getByResourceGroupAsync(this.rgName, this.vmName).flatMap((Func1)new Func1<VirtualMachineInner, Observable<VirtualMachineExtensionInner>>(){

            public Observable<VirtualMachineExtensionInner> call(VirtualMachineInner virtualMachine) {
                if (virtualMachine == null) {
                    return Observable.error((Throwable)new Exception(String.format("VM with name '%s' not found (resource group '%s')", LinuxDiskVolumeEncryptionMonitorImpl.this.vmName, LinuxDiskVolumeEncryptionMonitorImpl.this.rgName)));
                }
                if (virtualMachine.resources() != null) {
                    for (VirtualMachineExtensionInner extension : virtualMachine.resources()) {
                        if (!extension.publisher().equalsIgnoreCase("Microsoft.Azure.Security") || !extension.virtualMachineExtensionType().equalsIgnoreCase("AzureDiskEncryptionForLinux")) continue;
                        return LinuxDiskVolumeEncryptionMonitorImpl.this.retrieveExtensionWithInstanceViewAsync(extension);
                    }
                }
                return Observable.empty();
            }
        });
    }

    private List<InstanceViewStatus> instanceViewStatuses() {
        if (!this.hasEncryptionExtension()) {
            return new ArrayList<InstanceViewStatus>();
        }
        VirtualMachineExtensionInstanceView instanceView = this.encryptionExtension.instanceView();
        if (instanceView == null || instanceView.statuses() == null) {
            return new ArrayList<InstanceViewStatus>();
        }
        return instanceView.statuses();
    }

    private JsonNode instanceViewFirstSubStatus() {
        JsonNode rootNode;
        if (!this.hasEncryptionExtension()) {
            return null;
        }
        VirtualMachineExtensionInstanceView instanceView = this.encryptionExtension.instanceView();
        if (instanceView == null || instanceView.substatuses() == null) {
            return null;
        }
        List<InstanceViewStatus> instanceViewSubStatuses = instanceView.substatuses();
        if (instanceViewSubStatuses.size() == 0) {
            return null;
        }
        ObjectMapper mapper = new ObjectMapper();
        try {
            rootNode = mapper.readTree(instanceViewSubStatuses.get(0).message());
        }
        catch (IOException exception) {
            return null;
        }
        return rootNode;
    }

    private boolean hasEncryptionExtension() {
        return this.encryptionExtension != null;
    }
}

