/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ranger.audit.provider.hdfs;

import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.UnsupportedEncodingException;
import java.net.URI;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.ranger.audit.model.AuditEventBase;
import org.apache.ranger.audit.provider.DebugTracer;
import org.apache.ranger.audit.provider.LogDestination;
import org.apache.ranger.audit.provider.MiscUtil;

public class HdfsLogDestination<T>
implements LogDestination<T> {
    public static final String EXCP_MSG_FILESYSTEM_CLOSED = "Filesystem closed";
    private String name = this.getClass().getName();
    private String mDirectory = null;
    private String mFile = null;
    private int mFlushIntervalSeconds = 60;
    private String mEncoding = null;
    private boolean mIsAppend = false;
    private int mRolloverIntervalSeconds = 86400;
    private int mOpenRetryIntervalSeconds = 60;
    private DebugTracer mLogger = null;
    private FSDataOutputStream mFsDataOutStream = null;
    private OutputStreamWriter mWriter = null;
    private String mHdfsFilename = null;
    private long mNextRolloverTime = 0L;
    private long mNextFlushTime = 0L;
    private long mLastOpenFailedTime = 0L;
    private boolean mIsStopInProgress = false;
    private Map<String, String> configProps = null;

    public HdfsLogDestination(DebugTracer tracer) {
        this.mLogger = tracer;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    public String getDirectory() {
        return this.mDirectory;
    }

    public void setDirectory(String directory) {
        this.mDirectory = directory;
    }

    public String getFile() {
        return this.mFile;
    }

    public void setFile(String file) {
        this.mFile = file;
    }

    public int getFlushIntervalSeconds() {
        return this.mFlushIntervalSeconds;
    }

    public void setFlushIntervalSeconds(int flushIntervalSeconds) {
        this.mFlushIntervalSeconds = flushIntervalSeconds;
    }

    public String getEncoding() {
        return this.mEncoding;
    }

    public void setEncoding(String encoding) {
        this.mEncoding = encoding;
    }

    public int getRolloverIntervalSeconds() {
        return this.mRolloverIntervalSeconds;
    }

    public void setRolloverIntervalSeconds(int rolloverIntervalSeconds) {
        this.mRolloverIntervalSeconds = rolloverIntervalSeconds;
    }

    public int getOpenRetryIntervalSeconds() {
        return this.mOpenRetryIntervalSeconds;
    }

    public void setOpenRetryIntervalSeconds(int minIntervalOpenRetrySeconds) {
        this.mOpenRetryIntervalSeconds = minIntervalOpenRetrySeconds;
    }

    public void start() {
        this.mLogger.debug("==> HdfsLogDestination.start()");
        this.openFile();
        this.mLogger.debug("<== HdfsLogDestination.start()");
    }

    public void stop() {
        this.mLogger.debug("==> HdfsLogDestination.stop()");
        this.mIsStopInProgress = true;
        this.closeFile();
        this.mIsStopInProgress = false;
        this.mLogger.debug("<== HdfsLogDestination.stop()");
    }

    public boolean isAvailable() {
        return this.mWriter != null;
    }

    public boolean send(AuditEventBase log) {
        boolean ret = true;
        if (log != null) {
            String msg = MiscUtil.stringify((Object)log);
            ret = this.sendStringified(msg);
        }
        return ret;
    }

    public boolean send(AuditEventBase[] logs) {
        for (AuditEventBase log : logs) {
            boolean ret = this.send(log);
            if (ret) continue;
            return ret;
        }
        return true;
    }

    public boolean sendStringified(String log) {
        boolean ret = false;
        this.checkFileStatus();
        OutputStreamWriter writer = this.mWriter;
        if (writer != null) {
            try {
                writer.write(log + MiscUtil.LINE_SEPARATOR);
                ret = true;
            }
            catch (IOException excp) {
                this.mLogger.warn("HdfsLogDestination.sendStringified(): write failed", (Throwable)excp);
                this.closeFile();
            }
        }
        return ret;
    }

    public boolean sendStringified(String[] logs) {
        for (String log : logs) {
            boolean ret = this.sendStringified(log);
            if (ret) continue;
            return ret;
        }
        return true;
    }

    public boolean flush() {
        FSDataOutputStream ostream;
        this.mLogger.debug("==> HdfsLogDestination.flush()");
        boolean ret = false;
        OutputStreamWriter writer = this.mWriter;
        if (writer != null) {
            try {
                writer.flush();
                ret = true;
            }
            catch (IOException excp) {
                this.logException("HdfsLogDestination: flush() failed", excp);
            }
        }
        if ((ostream = this.mFsDataOutStream) != null) {
            try {
                ostream.hflush();
                ret = true;
            }
            catch (IOException excp) {
                this.logException("HdfsLogDestination: hflush() failed", excp);
            }
        }
        if (ret) {
            this.mNextFlushTime = System.currentTimeMillis() + (long)this.mFlushIntervalSeconds * 1000L;
        }
        this.mLogger.debug("<== HdfsLogDestination.flush()");
        return ret;
    }

    private void openFile() {
        this.mLogger.debug("==> HdfsLogDestination.openFile()");
        this.closeFile();
        this.mNextRolloverTime = MiscUtil.getNextRolloverTime((long)this.mNextRolloverTime, (long)((long)this.mRolloverIntervalSeconds * 1000L));
        long startTime = MiscUtil.getRolloverStartTime((long)this.mNextRolloverTime, (long)((long)this.mRolloverIntervalSeconds * 1000L));
        this.mHdfsFilename = MiscUtil.replaceTokens((String)(this.mDirectory + "/" + this.mFile), (long)startTime);
        FSDataOutputStream ostream = null;
        FileSystem fileSystem = null;
        Path pathLogfile = null;
        Configuration conf = null;
        boolean bOverwrite = false;
        try {
            this.mLogger.debug("HdfsLogDestination.openFile(): opening file " + this.mHdfsFilename);
            URI uri = URI.create(this.mHdfsFilename);
            conf = this.createConfiguration();
            pathLogfile = new Path(this.mHdfsFilename);
            fileSystem = FileSystem.get((URI)uri, (Configuration)conf);
            try {
                if (fileSystem.exists(pathLogfile)) {
                    if (this.mIsAppend) {
                        this.mLogger.info("HdfsLogDestination.openFile(): opening file for append " + this.mHdfsFilename);
                        ostream = fileSystem.append(pathLogfile);
                    } else {
                        this.mHdfsFilename = this.getNewFilename(this.mHdfsFilename, fileSystem);
                        pathLogfile = new Path(this.mHdfsFilename);
                    }
                }
                if (ostream == null) {
                    this.mLogger.info("HdfsLogDestination.openFile(): opening file for write " + this.mHdfsFilename);
                    this.createParents(pathLogfile, fileSystem);
                    ostream = fileSystem.create(pathLogfile, bOverwrite);
                }
            }
            catch (IOException excp) {
                String failedFilename = this.mHdfsFilename;
                this.mHdfsFilename = this.getNewFilename(this.mHdfsFilename, fileSystem);
                pathLogfile = new Path(this.mHdfsFilename);
                this.mLogger.info("HdfsLogDestination.openFile(): failed in opening file " + failedFilename + ". Will try opening " + this.mHdfsFilename);
            }
            if (ostream == null) {
                this.mLogger.info("HdfsLogDestination.openFile(): opening file for write " + this.mHdfsFilename);
                this.createParents(pathLogfile, fileSystem);
                ostream = fileSystem.create(pathLogfile, bOverwrite);
            }
        }
        catch (Throwable ex) {
            this.mLogger.warn("HdfsLogDestination.openFile() failed", ex);
        }
        this.mWriter = this.createWriter((OutputStream)ostream);
        if (this.mWriter != null) {
            this.mLogger.debug("HdfsLogDestination.openFile(): opened file " + this.mHdfsFilename);
            this.mFsDataOutStream = ostream;
            this.mNextFlushTime = System.currentTimeMillis() + (long)this.mFlushIntervalSeconds * 1000L;
            this.mLastOpenFailedTime = 0L;
        } else {
            this.mLogger.warn("HdfsLogDestination.openFile(): failed to open file for write " + this.mHdfsFilename);
            this.mHdfsFilename = null;
            this.mLastOpenFailedTime = System.currentTimeMillis();
        }
        this.mLogger.debug("<== HdfsLogDestination.openFile(" + this.mHdfsFilename + ")");
    }

    private void closeFile() {
        this.mLogger.debug("==> HdfsLogDestination.closeFile()");
        this.flush();
        OutputStreamWriter writer = this.mWriter;
        this.mWriter = null;
        this.mFsDataOutStream = null;
        if (writer != null) {
            try {
                this.mLogger.info("HdfsLogDestination.closeFile(): closing file " + this.mHdfsFilename);
                writer.close();
            }
            catch (IOException excp) {
                this.logException("HdfsLogDestination: failed to close file " + this.mHdfsFilename, excp);
            }
        }
        this.mLogger.debug("<== HdfsLogDestination.closeFile()");
    }

    private void rollover() {
        this.mLogger.debug("==> HdfsLogDestination.rollover()");
        this.closeFile();
        this.openFile();
        this.mLogger.debug("<== HdfsLogDestination.rollover()");
    }

    private void checkFileStatus() {
        long now = System.currentTimeMillis();
        if (this.mWriter == null) {
            if (now > this.mLastOpenFailedTime + (long)this.mOpenRetryIntervalSeconds * 1000L) {
                this.openFile();
            }
        } else if (now > this.mNextRolloverTime) {
            this.rollover();
        } else if (now > this.mNextFlushTime) {
            this.flush();
        }
    }

    private OutputStreamWriter createWriter(OutputStream os) {
        OutputStreamWriter writer = null;
        if (os != null) {
            if (this.mEncoding != null) {
                try {
                    writer = new OutputStreamWriter(os, this.mEncoding);
                }
                catch (UnsupportedEncodingException excp) {
                    this.mLogger.warn("HdfsLogDestination.createWriter(): failed to create output writer.", (Throwable)excp);
                }
            }
            if (writer == null) {
                writer = new OutputStreamWriter(os);
            }
        }
        return writer;
    }

    private void createParents(Path pathLogfile, FileSystem fileSystem) {
        try {
            Path parentPath;
            Path path = parentPath = pathLogfile != null ? pathLogfile.getParent() : null;
            if (parentPath != null && fileSystem != null && !fileSystem.exists(parentPath)) {
                fileSystem.mkdirs(parentPath);
            }
        }
        catch (IOException e) {
            this.logException("HdfsLogDestination.createParents() failed", e);
        }
        catch (Throwable e) {
            this.mLogger.warn("HdfsLogDestination.createParents() failed", e);
        }
    }

    private String getNewFilename(String fileName, FileSystem fileSystem) {
        if (fileName == null) {
            return "";
        }
        int i = 1;
        while (true) {
            String ret = fileName;
            String strToAppend = "-" + Integer.toString(i);
            int extnPos = ret.lastIndexOf(".");
            if (extnPos < 0) {
                ret = ret + strToAppend;
            } else {
                String extn = ret.substring(extnPos);
                ret = ret.substring(0, extnPos) + strToAppend + extn;
            }
            if (fileSystem == null || !this.fileExists(ret, fileSystem)) {
                return ret;
            }
            ++i;
        }
    }

    private boolean fileExists(String fileName, FileSystem fileSystem) {
        boolean ret = false;
        if (fileName != null && fileSystem != null) {
            Path path = new Path(fileName);
            try {
                ret = fileSystem.exists(path);
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        return ret;
    }

    private void logException(String msg, IOException excp) {
        boolean excpExcludeLogging;
        if (this.mIsStopInProgress) {
            return;
        }
        String excpMsgToExclude = EXCP_MSG_FILESYSTEM_CLOSED;
        String excpMsg = excp != null ? excp.getMessage() : null;
        boolean bl = excpExcludeLogging = excpMsg != null && excpMsg.contains(excpMsgToExclude);
        if (!excpExcludeLogging) {
            this.mLogger.warn(msg, (Throwable)excp);
        }
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("HdfsLogDestination {");
        sb.append("Directory=").append(this.mDirectory).append("; ");
        sb.append("File=").append(this.mFile).append("; ");
        sb.append("RolloverIntervalSeconds=").append(this.mRolloverIntervalSeconds);
        sb.append("}");
        return sb.toString();
    }

    public void setConfigProps(Map<String, String> configProps) {
        this.configProps = configProps;
    }

    Configuration createConfiguration() {
        Configuration conf = new Configuration();
        if (this.configProps != null) {
            for (Map.Entry<String, String> entry : this.configProps.entrySet()) {
                String key = entry.getKey();
                String value = entry.getValue();
                if (StringUtils.isNotEmpty((String)value)) {
                    conf.set(key, value);
                }
                this.mLogger.info("Adding property to HDFS config: " + key + " => " + value);
            }
        }
        this.mLogger.info("Returning HDFS Filesystem Config: " + conf.toString());
        return conf;
    }
}

